/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.util.concurrent.AbstractFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

public final class VoidChannelPromise
extends AbstractFuture<Void>
implements ChannelPromise {
    private final Channel channel;
    private final ChannelFutureListener fireExceptionListener;

    public VoidChannelPromise(Channel channel, boolean bl) {
        ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        this.channel = channel;
        if (bl) {
            this.fireExceptionListener = new ChannelFutureListener(){

                public void operationComplete(ChannelFuture object) {
                    if ((object = object.cause()) != null) {
                        VoidChannelPromise.this.fireException0((Throwable)object);
                    }
                }
            };
            return;
        }
        this.fireExceptionListener = null;
    }

    @Override
    public final VoidChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public final VoidChannelPromise addListeners(GenericFutureListener<? extends Future<? super Void>> ... genericFutureListenerArray) {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public final VoidChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        return this;
    }

    @Override
    public final VoidChannelPromise removeListeners(GenericFutureListener<? extends Future<? super Void>> ... genericFutureListenerArray) {
        return this;
    }

    @Override
    public final VoidChannelPromise await() {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this;
    }

    public final boolean await(long l, TimeUnit timeUnit) {
        VoidChannelPromise.fail();
        return false;
    }

    public final boolean await(long l) {
        VoidChannelPromise.fail();
        return false;
    }

    @Override
    public final VoidChannelPromise awaitUninterruptibly() {
        VoidChannelPromise.fail();
        return this;
    }

    public final boolean awaitUninterruptibly(long l, TimeUnit timeUnit) {
        VoidChannelPromise.fail();
        return false;
    }

    public final boolean awaitUninterruptibly(long l) {
        VoidChannelPromise.fail();
        return false;
    }

    @Override
    public final Channel channel() {
        return this.channel;
    }

    public final boolean isDone() {
        return false;
    }

    public final boolean isSuccess() {
        return false;
    }

    public final boolean setUncancellable() {
        return true;
    }

    public final boolean isCancellable() {
        return false;
    }

    public final boolean isCancelled() {
        return false;
    }

    public final Throwable cause() {
        return null;
    }

    @Override
    public final VoidChannelPromise sync() {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public final VoidChannelPromise syncUninterruptibly() {
        VoidChannelPromise.fail();
        return this;
    }

    @Override
    public final VoidChannelPromise setFailure(Throwable throwable) {
        this.fireException0(throwable);
        return this;
    }

    @Override
    public final VoidChannelPromise setSuccess() {
        return this;
    }

    public final boolean tryFailure(Throwable throwable) {
        this.fireException0(throwable);
        return false;
    }

    public final boolean cancel(boolean bl) {
        return false;
    }

    @Override
    public final boolean trySuccess() {
        return false;
    }

    private static void fail() {
        throw new IllegalStateException("void future");
    }

    @Override
    public final VoidChannelPromise setSuccess(Void void_) {
        return this;
    }

    public final boolean trySuccess(Void void_) {
        return false;
    }

    public final Void getNow() {
        return null;
    }

    @Override
    public final ChannelPromise unvoid() {
        DefaultChannelPromise defaultChannelPromise = new DefaultChannelPromise(this.channel);
        if (this.fireExceptionListener != null) {
            defaultChannelPromise.addListener(this.fireExceptionListener);
        }
        return defaultChannelPromise;
    }

    @Override
    public final boolean isVoid() {
        return true;
    }

    private void fireException0(Throwable throwable) {
        if (this.fireExceptionListener != null && this.channel.isRegistered()) {
            this.channel.pipeline().fireExceptionCaught(throwable);
        }
    }
}

