/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.sql.ResultSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.RangesKt;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0001\"B+\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b\u0012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u000bJ&\u0010\u0016\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00170\u00010\u0001H\u0016J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bH\u0096\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0014\u0010 \u001a\u00020\u0004*\u00020!2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0015\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lorg/jetbrains/exposed/sql/statements/ReturningStatement;", "", "Lorg/jetbrains/exposed/sql/ResultRow;", "Lorg/jetbrains/exposed/sql/statements/Statement;", "Ljava/sql/ResultSet;", "table", "Lorg/jetbrains/exposed/sql/Table;", "returningExpressions", "", "Lorg/jetbrains/exposed/sql/Expression;", "mainStatement", "(Lorg/jetbrains/exposed/sql/Table;Ljava/util/List;Lorg/jetbrains/exposed/sql/statements/Statement;)V", "getMainStatement", "()Lorg/jetbrains/exposed/sql/statements/Statement;", "getReturningExpressions", "()Ljava/util/List;", "getTable", "()Lorg/jetbrains/exposed/sql/Table;", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "getTransaction", "()Lorg/jetbrains/exposed/sql/Transaction;", "arguments", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/IColumnType;", "", "iterator", "", "prepareSQL", "", "prepared", "", "executeInternal", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "ResultIterator", "exposed-core"})
public class ReturningStatement
extends Statement<ResultSet>
implements Iterable<ResultRow>,
KMappedMarker {
    private final Table table;
    private final List<Expression<?>> returningExpressions;
    private final Statement<?> mainStatement;

    public ReturningStatement(Table table, List<? extends Expression<?>> list, Statement<?> statement) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter(statement, (String)"");
        super(statement.getType(), CollectionsKt.listOf((Object)table));
        this.table = table;
        this.returningExpressions = list;
        this.mainStatement = statement;
    }

    public final Table getTable() {
        return this.table;
    }

    public final List<Expression<?>> getReturningExpressions() {
        return this.returningExpressions;
    }

    public final Statement<?> getMainStatement() {
        return this.mainStatement;
    }

    protected final Transaction getTransaction() {
        return TransactionManager.Companion.current();
    }

    @Override
    public ResultSet executeInternal(PreparedStatementApi preparedStatementApi, Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)preparedStatementApi, (String)"");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        return preparedStatementApi.executeQuery();
    }

    @Override
    public Iterable<Iterable<Pair<IColumnType<?>, Object>>> arguments() {
        return this.mainStatement.arguments();
    }

    @Override
    public String prepareSQL(Transaction transaction2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        String string = this.mainStatement.prepareSQL(transaction2, bl);
        return transaction2.getDb().getDialect().getFunctionProvider().returning(string, this.returningExpressions, transaction2);
    }

    @Override
    public Iterator<ResultRow> iterator() {
        ReturningStatement returningStatement = this;
        Object t = returningStatement.getTransaction().exec(this);
        Intrinsics.checkNotNull(t);
        ResultIterator resultIterator = returningStatement.new ResultIterator((ResultSet)t);
        return ((Iterable)new Iterable<ResultRow>(resultIterator){
            final /* synthetic */ ResultIterator $resultIterator$inlined;
            {
                this.$resultIterator$inlined = resultIterator;
            }

            public final Iterator<ResultRow> iterator() {
                return this.$resultIterator$inlined;
            }
        }).iterator();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000e\u001a\u00020\rH\u0096\u0002J\t\u0010\u0013\u001a\u00020\u0002H\u0096\u0002R!\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/exposed/sql/statements/ReturningStatement$ResultIterator;", "", "Lorg/jetbrains/exposed/sql/ResultRow;", "rs", "Ljava/sql/ResultSet;", "(Lorg/jetbrains/exposed/sql/statements/ReturningStatement;Ljava/sql/ResultSet;)V", "fieldIndex", "", "Lorg/jetbrains/exposed/sql/Expression;", "", "getFieldIndex", "()Ljava/util/Map;", "value", "", "hasNext", "setHasNext", "(Z)V", "getRs", "()Ljava/sql/ResultSet;", "next", "exposed-core"})
    private final class ResultIterator
    implements Iterator<ResultRow>,
    KMappedMarker {
        private final ResultSet rs;
        private final Map<Expression<?>, Integer> fieldIndex;
        private boolean hasNext;

        public ResultIterator(ResultSet resultSet) {
            Intrinsics.checkNotNullParameter((Object)resultSet, (String)"");
            this.rs = resultSet;
            ResultIterator resultIterator = this;
            ReturningStatement.this = CollectionsKt.withIndex((Iterable)resultIterator.ReturningStatement.this.getReturningExpressions());
            ResultIterator resultIterator2 = resultIterator;
            int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)ReturningStatement.this, (int)10)), (int)16);
            Map map = new LinkedHashMap(n);
            ReturningStatement.this = ReturningStatement.this.iterator();
            while (ReturningStatement.this.hasNext()) {
                Object object2 = ReturningStatement.this.next();
                Object object3 = (IndexedValue)object2;
                Map map2 = map;
                object3 = (IndexedValue)object2;
                object2 = (Expression)object3.getValue();
                object3 = object3.getIndex();
                map2.put(object2, object3);
            }
            resultIterator2.fieldIndex = map;
            ResultIterator resultIterator3 = this;
            resultIterator3.setHasNext(resultIterator3.rs.next());
        }

        public final ResultSet getRs() {
            return this.rs;
        }

        public final Map<Expression<?>, Integer> getFieldIndex() {
            return this.fieldIndex;
        }

        private final void setHasNext(boolean bl) {
            this.hasNext = bl;
            if (!this.hasNext) {
                java.sql.Statement statement = this.rs.getStatement();
                if (statement != null) {
                    statement.close();
                }
                Transaction transaction2 = ReturningStatement.this.getTransaction();
                int n = transaction2.getOpenResultSetsCount$exposed_core();
                transaction2.setOpenResultSetsCount$exposed_core(n + -1);
            }
        }

        @Override
        public final boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public final ResultRow next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            ResultRow resultRow = ResultRow.Companion.create(this.rs, this.fieldIndex);
            ResultIterator resultIterator = this;
            resultIterator.setHasNext(resultIterator.rs.next());
            return resultRow;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

