/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.DefaultValueMarker;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2FunctionProvider;
import org.jetbrains.exposed.sql.vendors.MysqlFunctionProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003Bq\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001a\u0010\u0006\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\"\u0006\u0012\u0002\b\u00030\b\u0012\"\u0010\t\u001a\u001e\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b\u0018\u00010\n\u0012\u0012\u0010\r\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0018\u00010\n\u0012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0011J&\u0010\u001a\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000b0\u001b0\nH\u0016J\u001e\u0010\u001d\u001a\u00020\u00102\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0002H\u0014J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0010H\u0016R\u001f\u0010\u0006\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R-\u0010\t\u001a\u001e\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\r\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0019\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lorg/jetbrains/exposed/sql/statements/UpsertStatement;", "Key", "", "Lorg/jetbrains/exposed/sql/statements/InsertStatement;", "table", "Lorg/jetbrains/exposed/sql/Table;", "keys", "", "Lorg/jetbrains/exposed/sql/Column;", "onUpdate", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/Expression;", "onUpdateExclude", "where", "Lorg/jetbrains/exposed/sql/Op;", "", "(Lorg/jetbrains/exposed/sql/Table;[Lorg/jetbrains/exposed/sql/Column;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/exposed/sql/Op;)V", "getKeys", "()[Lorg/jetbrains/exposed/sql/Column;", "[Lorg/jetbrains/exposed/sql/Column;", "getOnUpdate", "()Ljava/util/List;", "getOnUpdateExclude", "getWhere", "()Lorg/jetbrains/exposed/sql/Op;", "arguments", "", "Lorg/jetbrains/exposed/sql/IColumnType;", "isColumnValuePreferredFromResultSet", "column", "value", "prepareSQL", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "prepared", "exposed-core"})
public class UpsertStatement<Key>
extends InsertStatement<Key> {
    private final Column<?>[] keys;
    private final List<Pair<Column<?>, Expression<?>>> onUpdate;
    private final List<Column<?>> onUpdateExclude;
    private final Op<Boolean> where;

    public UpsertStatement(Table table, Column<?>[] columnArray, List<? extends Pair<? extends Column<?>, ? extends Expression<?>>> list, List<? extends Column<?>> list2, Op<Boolean> op) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"");
        Intrinsics.checkNotNullParameter(columnArray, (String)"");
        super(table, false, 2, null);
        this.keys = columnArray;
        this.onUpdate = list;
        this.onUpdateExclude = list2;
        this.where = op;
    }

    public final Column<?>[] getKeys() {
        return this.keys;
    }

    public final List<Pair<Column<?>, Expression<?>>> getOnUpdate() {
        return this.onUpdate;
    }

    public final List<Column<?>> getOnUpdateExclude() {
        return this.onUpdateExclude;
    }

    public final Op<Boolean> getWhere() {
        return this.where;
    }

    @Override
    public String prepareSQL(Transaction transaction2, boolean bl) {
        FunctionProvider functionProvider2;
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        Column<?>[] columnArray = transaction2.getDb().getDialect();
        if (columnArray instanceof H2Dialect) {
            H2Dialect.H2CompatibilityMode h2CompatibilityMode = ((H2Dialect)columnArray).getH2Mode();
            switch (h2CompatibilityMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[h2CompatibilityMode.ordinal()]) {
                case 1: 
                case 2: {
                    functionProvider2 = new MysqlFunctionProvider();
                    break;
                }
                default: {
                    functionProvider2 = H2FunctionProvider.INSTANCE;
                    break;
                }
            }
        } else {
            functionProvider2 = columnArray.getFunctionProvider();
        }
        columnArray = functionProvider2;
        Table table = this.getTable();
        List<List<Pair<Column<?>, Object>>> list = this.getArguments();
        Intrinsics.checkNotNull(list);
        columnArray = this.keys;
        return functionProvider2.upsert(table, (List)CollectionsKt.first(list), this.onUpdate, this.onUpdateExclude, this.where, transaction2, Arrays.copyOf(this.keys, columnArray.length));
    }

    @Override
    public List<Iterable<Pair<IColumnType<?>, Object>>> arguments() {
        List<List<Pair<Column<?>, Object>>> list = this.getArguments();
        if (list != null) {
            Iterable iterable = list;
            Object object = iterable;
            iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            object = object.iterator();
            while (object.hasNext()) {
                Object object2;
                Object object3;
                Object object4 = object.next();
                object4 = (List)object4;
                Iterable iterable2 = iterable;
                QueryBuilder queryBuilder = new QueryBuilder(true);
                object4 = (Iterable)object4;
                Collection collection = new ArrayList();
                object4 = object4.iterator();
                while (object4.hasNext()) {
                    object3 = object4.next();
                    object2 = (Pair)object3;
                    if (!(!Intrinsics.areEqual((Object)(object2 = object2.component2()), (Object)DefaultValueMarker.INSTANCE))) continue;
                    collection.add(object3);
                }
                object4 = (List)collection;
                object4 = object4.iterator();
                while (object4.hasNext()) {
                    collection = object4.next();
                    collection = (Pair)collection;
                    object3 = (Column)collection.component1();
                    object2 = collection.component2();
                    queryBuilder.registerArgument((Column<?>)object3, object2);
                }
                Op<Boolean> op = this.where;
                if (op != null) {
                    op.toQueryBuilder(queryBuilder);
                }
                iterable2.add(queryBuilder.getArgs());
            }
            return (List)iterable;
        }
        return CollectionsKt.emptyList();
    }

    @Override
    protected boolean isColumnValuePreferredFromResultSet(Column<?> column, Object object) {
        Intrinsics.checkNotNullParameter(column, (String)"");
        return this.isEntityIdClientSideGeneratedUUID(column) || super.isColumnValuePreferredFromResultSet(column, object);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[H2Dialect.H2CompatibilityMode.values().length];
            try {
                nArray[H2Dialect.H2CompatibilityMode.MariaDB.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[H2Dialect.H2CompatibilityMode.MySQL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

