/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.blocking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.e.a.i;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.blocking.AllJidsUnblockedListener;
import org.jivesoftware.smackx.blocking.JidsBlockedListener;
import org.jivesoftware.smackx.blocking.JidsUnblockedListener;
import org.jivesoftware.smackx.blocking.element.BlockContactsIQ;
import org.jivesoftware.smackx.blocking.element.BlockListIQ;
import org.jivesoftware.smackx.blocking.element.UnblockContactsIQ;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;

public final class BlockingCommandManager
extends Manager {
    public static final String NAMESPACE = "urn:xmpp:blocking";
    private volatile List<i> blockListCached;
    private static final Map<XMPPConnection, BlockingCommandManager> INSTANCES;
    private final Set<AllJidsUnblockedListener> allJidsUnblockedListeners = new CopyOnWriteArraySet<AllJidsUnblockedListener>();
    private final Set<JidsBlockedListener> jidsBlockedListeners = new CopyOnWriteArraySet<JidsBlockedListener>();
    private final Set<JidsUnblockedListener> jidsUnblockedListeners = new CopyOnWriteArraySet<JidsUnblockedListener>();

    public static synchronized BlockingCommandManager getInstanceFor(XMPPConnection xMPPConnection) {
        BlockingCommandManager blockingCommandManager = INSTANCES.get(xMPPConnection);
        if (blockingCommandManager == null) {
            blockingCommandManager = new BlockingCommandManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, blockingCommandManager);
        }
        return blockingCommandManager;
    }

    private BlockingCommandManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("block", NAMESPACE, IQ.Type.set, IQRequestHandler.Mode.sync){

            public IQ handleIQRequest(IQ iQ) {
                iQ = (BlockContactsIQ)iQ;
                if (BlockingCommandManager.this.blockListCached == null) {
                    BlockingCommandManager.this.blockListCached = new ArrayList();
                }
                List<i> list = iQ.getJids();
                BlockingCommandManager.this.blockListCached.addAll(list);
                for (JidsBlockedListener jidsBlockedListener : BlockingCommandManager.this.jidsBlockedListeners) {
                    jidsBlockedListener.onJidsBlocked(list);
                }
                return IQ.createResultIQ((IQ)iQ);
            }
        });
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("unblock", NAMESPACE, IQ.Type.set, IQRequestHandler.Mode.sync){

            public IQ handleIQRequest(IQ iQ) {
                List<i> list;
                iQ = (UnblockContactsIQ)iQ;
                if (BlockingCommandManager.this.blockListCached == null) {
                    BlockingCommandManager.this.blockListCached = new ArrayList();
                }
                if ((list = iQ.getJids()) == null) {
                    BlockingCommandManager.this.blockListCached.clear();
                    for (AllJidsUnblockedListener allJidsUnblockedListener : BlockingCommandManager.this.allJidsUnblockedListeners) {
                        allJidsUnblockedListener.onAllJidsUnblocked();
                    }
                } else {
                    BlockingCommandManager.this.blockListCached.removeAll(list);
                    for (JidsUnblockedListener jidsUnblockedListener : BlockingCommandManager.this.jidsUnblockedListeners) {
                        jidsUnblockedListener.onJidsUnblocked(list);
                    }
                }
                return IQ.createResultIQ((IQ)iQ);
            }
        });
        xMPPConnection.addConnectionListener(new ConnectionListener(){

            public void authenticated(XMPPConnection xMPPConnection, boolean bl) {
                if (bl) {
                    return;
                }
                BlockingCommandManager.this.blockListCached = null;
            }
        });
    }

    public final boolean isSupportedByServer() {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).serverSupportsFeature(NAMESPACE);
    }

    public final List<i> getBlockList() {
        if (this.blockListCached == null) {
            BlockListIQ blockListIQ = new BlockListIQ();
            blockListIQ = (BlockListIQ)this.connection().createStanzaCollectorAndSend((IQ)blockListIQ).nextResultOrThrow();
            this.blockListCached = blockListIQ.getBlockedJidsCopy();
        }
        return Collections.unmodifiableList(this.blockListCached);
    }

    public final void blockContacts(List<i> object) {
        object = new BlockContactsIQ((List<i>)object);
        this.connection().createStanzaCollectorAndSend(object).nextResultOrThrow();
    }

    public final void unblockContacts(List<i> object) {
        object = new UnblockContactsIQ((List<i>)object);
        this.connection().createStanzaCollectorAndSend(object).nextResultOrThrow();
    }

    public final void unblockAll() {
        UnblockContactsIQ unblockContactsIQ = new UnblockContactsIQ();
        this.connection().createStanzaCollectorAndSend((IQ)unblockContactsIQ).nextResultOrThrow();
    }

    public final void addJidsBlockedListener(JidsBlockedListener jidsBlockedListener) {
        this.jidsBlockedListeners.add(jidsBlockedListener);
    }

    public final void removeJidsBlockedListener(JidsBlockedListener jidsBlockedListener) {
        this.jidsBlockedListeners.remove(jidsBlockedListener);
    }

    public final void addJidsUnblockedListener(JidsUnblockedListener jidsUnblockedListener) {
        this.jidsUnblockedListeners.add(jidsUnblockedListener);
    }

    public final void removeJidsUnblockedListener(JidsUnblockedListener jidsUnblockedListener) {
        this.jidsUnblockedListeners.remove(jidsUnblockedListener);
    }

    public final void addAllJidsUnblockedListener(AllJidsUnblockedListener allJidsUnblockedListener) {
        this.allJidsUnblockedListeners.add(allJidsUnblockedListener);
    }

    public final void removeAllJidsUnblockedListener(AllJidsUnblockedListener allJidsUnblockedListener) {
        this.allJidsUnblockedListeners.remove(allJidsUnblockedListener);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                BlockingCommandManager.getInstanceFor(xMPPConnection);
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, BlockingCommandManager>();
    }
}

