/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.caps;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.e.a.h;
import org.e.a.i;
import org.e.c.a.c;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PresenceTypeFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.AbstractPresenceEventListener;
import org.jivesoftware.smack.roster.PresenceEventListener;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.caps.CapsVersionAndHash;
import org.jivesoftware.smackx.caps.cache.EntityCapsPersistentCache;
import org.jivesoftware.smackx.caps.packet.CapsExtension;
import org.jivesoftware.smackx.disco.AbstractNodeInformationProvider;
import org.jivesoftware.smackx.disco.DiscoInfoLookupShortcutMechanism;
import org.jivesoftware.smackx.disco.EntityCapabilitiesChangedListener;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoView;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public final class EntityCapsManager
extends Manager {
    public static final String NAMESPACE = "http://jabber.org/protocol/caps";
    public static final String ELEMENT = "c";
    private static final Map<String, MessageDigest> SUPPORTED_HASHES = new HashMap<String, MessageDigest>();
    private static final String DEFAULT_HASH = "SHA-1";
    private static String DEFAULT_ENTITY_NODE = "https://igniterealtime.org/projects/smack";
    protected static EntityCapsPersistentCache persistentCache;
    private static boolean autoEnableEntityCaps;
    private static final Map<XMPPConnection, EntityCapsManager> instances;
    private static final StanzaFilter PRESENCES_WITH_CAPS;
    static final c<String, DiscoverInfo> CAPS_CACHE;
    static final c<i, NodeVerHash> JID_TO_NODEVER_CACHE;
    private final Queue<CapsVersionAndHash> lastLocalCapsVersions = new ConcurrentLinkedQueue<CapsVersionAndHash>();
    private final ServiceDiscoveryManager sdm;
    private boolean entityCapsEnabled;
    private CapsVersionAndHash currentCapsVersion;
    private String entityNode = DEFAULT_ENTITY_NODE;

    public static void setDefaultEntityNode(String string) {
        DEFAULT_ENTITY_NODE = string;
    }

    static void addDiscoverInfoByNode(String string, DiscoverInfo discoverInfo) {
        CAPS_CACHE.put((Object)string, (Object)discoverInfo);
        if (persistentCache != null) {
            persistentCache.addDiscoverInfoByNodePersistent(string, discoverInfo);
        }
    }

    public static String getNodeVersionByJid(i object) {
        c<i, NodeVerHash> c2 = object;
        object = JID_TO_NODEVER_CACHE;
        if ((object = (NodeVerHash)object.get(c2)) != null) {
            return ((NodeVerHash)object).nodeVer;
        }
        return null;
    }

    public static NodeVerHash getNodeVerHashByJid(i c2) {
        c<i, NodeVerHash> c3 = c2;
        c2 = JID_TO_NODEVER_CACHE;
        return (NodeVerHash)c2.get(c3);
    }

    public static DiscoverInfo getDiscoverInfoByUser(i object) {
        c<i, NodeVerHash> c2 = object;
        object = JID_TO_NODEVER_CACHE;
        if ((object = (NodeVerHash)object.get(c2)) == null) {
            return null;
        }
        return EntityCapsManager.getDiscoveryInfoByNodeVer(((NodeVerHash)object).nodeVer);
    }

    public static DiscoverInfo getDiscoveryInfoByNodeVer(String string) {
        String string2 = string;
        Object object = CAPS_CACHE;
        if ((object = (DiscoverInfo)object.get((Object)string2)) == null && persistentCache != null && (object = persistentCache.lookup(string)) != null) {
            CAPS_CACHE.put((Object)string, object);
        }
        if (object != null) {
            object = new DiscoverInfo((DiscoverInfo)object);
        }
        return object;
    }

    public static void setPersistentCache(EntityCapsPersistentCache entityCapsPersistentCache) {
        persistentCache = entityCapsPersistentCache;
    }

    public static void setMaxsCacheSizes(int n, int n2) {
        JID_TO_NODEVER_CACHE.a(n);
        CAPS_CACHE.a(n2);
    }

    public static void clearMemoryCache() {
        JID_TO_NODEVER_CACHE.clear();
        CAPS_CACHE.clear();
    }

    private static void addCapsExtensionInfo(i i2, CapsExtension object) {
        String string = ((CapsExtension)object).getHash();
        String string2 = string.toUpperCase(Locale.US);
        if (!SUPPORTED_HASHES.containsKey(string2)) {
            return;
        }
        string = string.toLowerCase(Locale.US);
        string2 = ((CapsExtension)object).getNode();
        object = ((CapsExtension)object).getVer();
        JID_TO_NODEVER_CACHE.put((Object)i2, (Object)new NodeVerHash(string2, (String)object, string));
    }

    private void addCapsExtension(PresenceBuilder presenceBuilder) {
        Object object = this.getCapsVersionAndHash();
        if (object == null) {
            return;
        }
        object = new CapsExtension(this.entityNode, ((CapsVersionAndHash)object).version, ((CapsVersionAndHash)object).hash);
        presenceBuilder.overrideExtension((ExtensionElement)object);
    }

    private EntityCapsManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.sdm = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        instances.put(xMPPConnection, this);
        xMPPConnection.addConnectionListener(new ConnectionListener(){

            public void connected(XMPPConnection xMPPConnection) {
                this.processCapsStreamFeatureIfAvailable(xMPPConnection);
            }

            public void authenticated(XMPPConnection xMPPConnection, boolean bl) {
                this.processCapsStreamFeatureIfAvailable(xMPPConnection);
            }

            private void processCapsStreamFeatureIfAvailable(XMPPConnection xMPPConnection) {
                CapsExtension capsExtension = (CapsExtension)xMPPConnection.getFeature(CapsExtension.class);
                if (capsExtension == null) {
                    return;
                }
                xMPPConnection = xMPPConnection.getXMPPServiceDomain();
                EntityCapsManager.addCapsExtensionInfo((i)xMPPConnection, capsExtension);
            }
        });
        if (autoEnableEntityCaps) {
            this.enableEntityCaps();
        }
        xMPPConnection.addStanzaListener(new StanzaListener(){

            public void processStanza(Stanza stanza) {
                if (!EntityCapsManager.this.entityCapsEnabled()) {
                    return;
                }
                CapsExtension capsExtension = CapsExtension.from(stanza);
                stanza = stanza.getFrom();
                EntityCapsManager.addCapsExtensionInfo((i)stanza, capsExtension);
            }
        }, PRESENCES_WITH_CAPS);
        Roster.getInstanceFor((XMPPConnection)xMPPConnection).addPresenceEventListener((PresenceEventListener)new AbstractPresenceEventListener(){

            public void presenceUnavailable(h h2, Presence presence) {
                JID_TO_NODEVER_CACHE.remove((Object)h2);
            }
        });
        this.sdm.addEntityCapabilitiesChangedListener(new EntityCapabilitiesChangedListener(){

            @Override
            public void onEntityCapabilitiesChanged(DiscoverInfo discoverInfo) {
                if (!EntityCapsManager.this.entityCapsEnabled()) {
                    return;
                }
                EntityCapsManager.this.updateLocalEntityCaps(discoverInfo);
            }
        });
    }

    public static synchronized EntityCapsManager getInstanceFor(XMPPConnection xMPPConnection) {
        if (SUPPORTED_HASHES.size() <= 0) {
            throw new IllegalStateException("No supported hashes for EntityCapsManager");
        }
        EntityCapsManager entityCapsManager = instances.get(xMPPConnection);
        if (entityCapsManager == null) {
            entityCapsManager = new EntityCapsManager(xMPPConnection);
        }
        return entityCapsManager;
    }

    public final synchronized void enableEntityCaps() {
        this.connection().addPresenceInterceptor(this::addCapsExtension, presence -> PresenceTypeFilter.AVAILABLE.accept((Stanza)presence));
        this.sdm.addFeature(NAMESPACE);
        this.entityCapsEnabled = true;
    }

    public final synchronized void disableEntityCaps() {
        this.entityCapsEnabled = false;
        this.sdm.removeFeature(NAMESPACE);
        this.connection().removePresenceInterceptor(this::addCapsExtension);
    }

    public final boolean entityCapsEnabled() {
        return this.entityCapsEnabled;
    }

    public static void removeUserCapsNode(i i2) {
        JID_TO_NODEVER_CACHE.remove((Object)i2);
    }

    public final CapsVersionAndHash getCapsVersionAndHash() {
        return this.currentCapsVersion;
    }

    public final String getLocalNodeVer() {
        CapsVersionAndHash capsVersionAndHash = this.getCapsVersionAndHash();
        if (capsVersionAndHash == null) {
            return null;
        }
        return this.entityNode + '#' + capsVersionAndHash.version;
    }

    public final boolean areEntityCapsSupported(i i2) {
        return this.sdm.supportsFeature(i2, NAMESPACE);
    }

    public final boolean areEntityCapsSupportedByServer() {
        EntityCapsManager entityCapsManager = this;
        return entityCapsManager.areEntityCapsSupported((i)entityCapsManager.connection().getXMPPServiceDomain());
    }

    private void updateLocalEntityCaps(final DiscoverInfo linkedList) {
        XMPPConnection xMPPConnection = this.connection();
        linkedList = ((DiscoverInfo)((Object)linkedList)).asBuilder("synthesized-disco-info-result");
        this.currentCapsVersion = EntityCapsManager.generateVerificationString((DiscoverInfoView)((Object)linkedList));
        String string = this.getLocalNodeVer();
        ((DiscoverInfoBuilder)((Object)linkedList)).setNode(string);
        linkedList = ((DiscoverInfoBuilder)((Object)linkedList)).build();
        EntityCapsManager.addDiscoverInfoByNode(string, (DiscoverInfo)((Object)linkedList));
        if (this.lastLocalCapsVersions.size() > 10) {
            linkedList = this.lastLocalCapsVersions.poll();
            this.sdm.removeNodeInformationProvider(this.entityNode + '#' + ((CapsVersionAndHash)((Object)linkedList)).version);
        }
        this.lastLocalCapsVersions.add(this.currentCapsVersion);
        if (xMPPConnection != null) {
            JID_TO_NODEVER_CACHE.put((Object)xMPPConnection.getUser(), (Object)new NodeVerHash(this.entityNode, this.currentCapsVersion));
        }
        linkedList = new LinkedList<DiscoverInfo.Identity>(ServiceDiscoveryManager.getInstanceFor(xMPPConnection).getIdentities());
        this.sdm.setNodeInformationProvider(string, new AbstractNodeInformationProvider(){
            List<String> features;
            List<DataForm> packetExtensions;
            {
                this.features = EntityCapsManager.this.sdm.getFeatures();
                this.packetExtensions = EntityCapsManager.this.sdm.getExtendedInfo();
            }

            @Override
            public List<String> getNodeFeatures() {
                return this.features;
            }

            @Override
            public List<DiscoverInfo.Identity> getNodeIdentities() {
                return linkedList;
            }

            public List<DataForm> getNodePacketExtensions() {
                return this.packetExtensions;
            }
        });
    }

    public static boolean verifyDiscoverInfoVersion(String string, String string2, DiscoverInfo discoverInfo) {
        if (discoverInfo.containsDuplicateIdentities()) {
            return false;
        }
        if (discoverInfo.containsDuplicateFeatures()) {
            return false;
        }
        if (!EntityCapsManager.verifyPacketExtensions(discoverInfo)) {
            return false;
        }
        string2 = EntityCapsManager.generateVerificationString((DiscoverInfoView)discoverInfo, (String)string2).version;
        return string.equals(string2);
    }

    private static boolean verifyPacketExtensions(DiscoverInfo iterator) {
        HashSet<Object> hashSet = new HashSet<Object>();
        iterator = iterator.getExtensions(DataForm.class);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Object object = (DataForm)iterator.next();
            if ((object = ((DataForm)object).getHiddenFormTypeField()) == null || (bl = hashSet.add(object = ((FormField)object).getFirstValue()))) continue;
            return false;
        }
        return true;
    }

    protected static CapsVersionAndHash generateVerificationString(DiscoverInfoView discoverInfoView) {
        return EntityCapsManager.generateVerificationString(discoverInfoView, null);
    }

    protected static CapsVersionAndHash generateVerificationString(DiscoverInfoView object, String string) {
        Iterator<FormField> iterator;
        MessageDigest messageDigest;
        if (string == null) {
            string = DEFAULT_HASH;
        }
        if ((messageDigest = SUPPORTED_HASHES.get(string.toUpperCase(Locale.US))) == null) {
            return null;
        }
        string = string.toLowerCase(Locale.US);
        StringBuilder stringBuilder = new StringBuilder();
        Object object3 = new TreeSet<DiscoverInfo.Identity>();
        object3.addAll(object.getIdentities());
        object3 = object3.iterator();
        while (object3.hasNext()) {
            iterator = (DiscoverInfo.Identity)object3.next();
            stringBuilder.append(((DiscoverInfo.Identity)((Object)iterator)).getCategory());
            stringBuilder.append('/');
            stringBuilder.append(((DiscoverInfo.Identity)((Object)iterator)).getType());
            stringBuilder.append('/');
            stringBuilder.append(((DiscoverInfo.Identity)((Object)iterator)).getLanguage() == null ? "" : ((DiscoverInfo.Identity)((Object)iterator)).getLanguage());
            stringBuilder.append('/');
            stringBuilder.append(((DiscoverInfo.Identity)((Object)iterator)).getName() == null ? "" : ((DiscoverInfo.Identity)((Object)iterator)).getName());
            stringBuilder.append('<');
        }
        object3 = new TreeSet<String>();
        for (DiscoverInfo.Feature object22 : object.getFeatures()) {
            object3.add(object22.getVar());
        }
        iterator = object3.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            stringBuilder.append(string2);
            stringBuilder.append('<');
        }
        iterator = object.getExtensions(DataForm.class);
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            object = (DataForm)iterator2.next();
            if (!((DataForm)object).hasHiddenFormTypeField()) continue;
            object3 = new TreeSet<FormField>(new Comparator<FormField>(){

                @Override
                public int compare(FormField formField, FormField formField2) {
                    return formField.getFieldName().compareTo(formField2.getFieldName());
                }
            });
            for (FormField formField : ((DataForm)object).getFields()) {
                if (formField.getFieldName().equals("FORM_TYPE")) continue;
                object3.add(formField);
            }
            EntityCapsManager.formFieldValuesToCaps(Collections.singletonList(((DataForm)object).getFormType()), stringBuilder);
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                FormField formField;
                formField = iterator.next();
                stringBuilder.append(formField.getFieldName());
                stringBuilder.append('<');
                EntityCapsManager.formFieldValuesToCaps(formField.getRawValueCharSequences(), stringBuilder);
            }
        }
        byte[] byArray = stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
        object3 = messageDigest;
        synchronized (object3) {
            object = messageDigest.digest(byArray);
        }
        object3 = Base64.encodeToString((byte[])object);
        return new CapsVersionAndHash((String)object3, string);
    }

    private static void formFieldValuesToCaps(List<? extends CharSequence> object, StringBuilder stringBuilder) {
        Object object2 = new TreeSet<CharSequence>();
        object2.addAll(object);
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (CharSequence)object.next();
            stringBuilder.append((CharSequence)object2);
            stringBuilder.append('<');
        }
    }

    static {
        autoEnableEntityCaps = true;
        instances = new WeakHashMap<XMPPConnection, EntityCapsManager>();
        PRESENCES_WITH_CAPS = new AndFilter(new StanzaFilter[]{new StanzaTypeFilter(Presence.class), new StanzaExtensionFilter(ELEMENT, NAMESPACE)});
        CAPS_CACHE = new c(1000);
        JID_TO_NODEVER_CACHE = new c(10000);
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                EntityCapsManager.getInstanceFor(xMPPConnection);
            }
        });
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(DEFAULT_HASH);
            SUPPORTED_HASHES.put(DEFAULT_HASH, messageDigest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        ServiceDiscoveryManager.addDiscoInfoLookupShortcutMechanism(new DiscoInfoLookupShortcutMechanism("XEP-0115: Entity Capabilities", 100){

            @Override
            public DiscoverInfo getDiscoverInfoByUser(ServiceDiscoveryManager serviceDiscoveryManager, i i2) {
                DiscoverInfo discoverInfo = EntityCapsManager.getDiscoverInfoByUser(i2);
                if (discoverInfo != null) {
                    return discoverInfo;
                }
                NodeVerHash nodeVerHash = EntityCapsManager.getNodeVerHashByJid(i2);
                if (nodeVerHash == null) {
                    return null;
                }
                try {
                    discoverInfo = serviceDiscoveryManager.discoverInfo(i2, nodeVerHash.getNodeVer());
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException throwable) {
                    return null;
                }
                if (EntityCapsManager.verifyDiscoverInfoVersion(nodeVerHash.getVer(), nodeVerHash.getHash(), discoverInfo)) {
                    EntityCapsManager.addDiscoverInfoByNode(nodeVerHash.getNodeVer(), discoverInfo);
                }
                return discoverInfo;
            }
        });
    }

    public static class NodeVerHash {
        private String node;
        private String hash;
        private String ver;
        private String nodeVer;

        NodeVerHash(String string, CapsVersionAndHash capsVersionAndHash) {
            this(string, capsVersionAndHash.version, capsVersionAndHash.hash);
        }

        NodeVerHash(String string, String string2, String string3) {
            this.node = string;
            this.ver = string2;
            this.hash = string3;
            this.nodeVer = string + "#" + string2;
        }

        public String getNodeVer() {
            return this.nodeVer;
        }

        public String getNode() {
            return this.node;
        }

        public String getHash() {
            return this.hash;
        }

        public String getVer() {
            return this.ver;
        }
    }
}

