/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.b;
import org.e.a.e;
import org.e.a.i;
import org.e.c.a.a;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.ScheduledAction;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PresenceTypeFilter;
import org.jivesoftware.smack.internal.AbstractStats;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.ExtendedAppendable;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.DiscoInfoLookupShortcutMechanism;
import org.jivesoftware.smackx.disco.EntityCapabilitiesChangedListener;
import org.jivesoftware.smackx.disco.NodeInformationProvider;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoView;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public final class ServiceDiscoveryManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(ServiceDiscoveryManager.class.getName());
    private static final String DEFAULT_IDENTITY_NAME = "Smack";
    private static final String DEFAULT_IDENTITY_CATEGORY = "client";
    private static final String DEFAULT_IDENTITY_TYPE = "pc";
    private static final List<DiscoInfoLookupShortcutMechanism> discoInfoLookupShortcutMechanisms = new ArrayList<DiscoInfoLookupShortcutMechanism>(2);
    private static DiscoverInfo.Identity defaultIdentity = new DiscoverInfo.Identity("client", "Smack", "pc");
    private final Set<DiscoverInfo.Identity> identities = new HashSet<DiscoverInfo.Identity>();
    private DiscoverInfo.Identity identity = defaultIdentity;
    private final Set<EntityCapabilitiesChangedListener> entityCapabilitiesChangedListeners = new CopyOnWriteArraySet<EntityCapabilitiesChangedListener>();
    private static final Map<XMPPConnection, ServiceDiscoveryManager> instances = new WeakHashMap<XMPPConnection, ServiceDiscoveryManager>();
    private final Set<String> features = new HashSet<String>();
    private List<DataForm> extendedInfos = new ArrayList<DataForm>(2);
    private final Map<String, NodeInformationProvider> nodeInformationProviders = new ConcurrentHashMap<String, NodeInformationProvider>();
    private volatile Presence presenceSend;
    private final a<String, List<DiscoverInfo>> services = new org.e.c.a.b(25, 86400000L);
    private static final int RENEW_ENTITY_CAPS_DELAY_MILLIS = 25;
    private ScheduledAction renewEntityCapsScheduledAction;
    private final AtomicInteger renewEntityCapsPerformed = new AtomicInteger();
    private int renewEntityCapsRequested = 0;
    private int scheduledRenewEntityCapsAvoided = 0;

    public static void setDefaultIdentity(DiscoverInfo.Identity identity) {
        defaultIdentity = identity;
    }

    private ServiceDiscoveryManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.addFeature("http://jabber.org/protocol/disco#info");
        this.addFeature("http://jabber.org/protocol/disco#items");
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("query", "http://jabber.org/protocol/disco#items", IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iQ) {
                iQ = (DiscoverItems)iQ;
                DiscoverItems discoverItems = new DiscoverItems();
                discoverItems.setType(IQ.Type.result);
                discoverItems.setTo(iQ.getFrom());
                discoverItems.setStanzaId(iQ.getStanzaId());
                discoverItems.setNode(iQ.getNode());
                NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(iQ.getNode());
                if (nodeInformationProvider != null) {
                    discoverItems.addItems(nodeInformationProvider.getNodeItems());
                    discoverItems.addExtensions(nodeInformationProvider.getNodePacketExtensions());
                } else if (iQ.getNode() != null) {
                    discoverItems.setType(IQ.Type.error);
                    discoverItems.setError(StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.item_not_found).build());
                }
                return discoverItems;
            }
        });
        xMPPConnection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("query", "http://jabber.org/protocol/disco#info", IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ object) {
                object = (DiscoverInfo)object;
                DiscoverInfoBuilder discoverInfoBuilder = DiscoverInfoBuilder.buildResponseFor((DiscoverInfo)object, IQ.ResponseType.result);
                if (((DiscoverInfo)object).getNode() == null) {
                    ServiceDiscoveryManager.this.addDiscoverInfoTo(discoverInfoBuilder);
                } else if ((object = ServiceDiscoveryManager.this.getNodeInformationProvider(((DiscoverInfo)object).getNode())) != null) {
                    discoverInfoBuilder.addFeatures(object.getNodeFeatures());
                    discoverInfoBuilder.addIdentities(object.getNodeIdentities());
                    discoverInfoBuilder.addOptExtensions(object.getNodePacketExtensions());
                } else {
                    discoverInfoBuilder.ofType(IQ.Type.error);
                    discoverInfoBuilder.setError(StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.item_not_found).build());
                }
                object = discoverInfoBuilder.build();
                return object;
            }
        });
        xMPPConnection.addConnectionListener(new ConnectionListener(){

            public void authenticated(XMPPConnection xMPPConnection, boolean bl) {
                if (!bl) {
                    ServiceDiscoveryManager.this.presenceSend = null;
                }
            }
        });
        xMPPConnection.addStanzaSendingListener(stanza -> {
            this.presenceSend = (Presence)stanza;
        }, PresenceTypeFilter.OUTGOING_PRESENCE_BROADCAST);
    }

    public final String getIdentityName() {
        return this.identity.getName();
    }

    public final synchronized void setIdentity(DiscoverInfo.Identity identity) {
        this.identity = (DiscoverInfo.Identity)Objects.requireNonNull((Object)identity, (String)"Identity can not be null");
        this.renewEntityCapsVersion();
    }

    public final DiscoverInfo.Identity getIdentity() {
        return this.identity;
    }

    public final String getIdentityType() {
        return this.identity.getType();
    }

    public final synchronized void addIdentity(DiscoverInfo.Identity identity) {
        this.identities.add(identity);
        this.renewEntityCapsVersion();
    }

    public final synchronized boolean removeIdentity(DiscoverInfo.Identity identity) {
        if (identity.equals(this.identity)) {
            return false;
        }
        this.identities.remove(identity);
        this.renewEntityCapsVersion();
        return true;
    }

    public final Set<DiscoverInfo.Identity> getIdentities() {
        HashSet<DiscoverInfo.Identity> hashSet = new HashSet<DiscoverInfo.Identity>(this.identities);
        hashSet.add(this.identity);
        return Collections.unmodifiableSet(hashSet);
    }

    public static synchronized ServiceDiscoveryManager getInstanceFor(XMPPConnection xMPPConnection) {
        ServiceDiscoveryManager serviceDiscoveryManager = instances.get(xMPPConnection);
        if (serviceDiscoveryManager == null) {
            serviceDiscoveryManager = new ServiceDiscoveryManager(xMPPConnection);
            instances.put(xMPPConnection, serviceDiscoveryManager);
        }
        return serviceDiscoveryManager;
    }

    public final synchronized void addDiscoverInfoTo(DiscoverInfoBuilder discoverInfoBuilder) {
        discoverInfoBuilder.addIdentities(this.getIdentities());
        for (String string : this.getFeatures()) {
            discoverInfoBuilder.addFeature(string);
        }
        discoverInfoBuilder.addExtensions(this.extendedInfos);
    }

    private NodeInformationProvider getNodeInformationProvider(String string) {
        if (string == null) {
            return null;
        }
        return this.nodeInformationProviders.get(string);
    }

    public final void setNodeInformationProvider(String string, NodeInformationProvider nodeInformationProvider) {
        this.nodeInformationProviders.put(string, nodeInformationProvider);
    }

    public final void removeNodeInformationProvider(String string) {
        this.nodeInformationProviders.remove(string);
    }

    public final synchronized List<String> getFeatures() {
        return new ArrayList<String>(this.features);
    }

    public final synchronized void addFeature(String string) {
        this.features.add(string);
        this.renewEntityCapsVersion();
    }

    public final synchronized void removeFeature(String string) {
        this.features.remove(string);
        this.renewEntityCapsVersion();
    }

    public final synchronized boolean includesFeature(String string) {
        return this.features.contains(string);
    }

    @Deprecated
    public final synchronized void setExtendedInfo(DataForm dataForm) {
        this.addExtendedInfo(dataForm);
    }

    public final DataForm addExtendedInfo(DataForm dataForm) {
        Object object = dataForm.getFormType();
        StringUtils.requireNotNullNorEmpty((CharSequence)object, (String)"The data form must have a form type set");
        ServiceDiscoveryManager serviceDiscoveryManager = this;
        synchronized (serviceDiscoveryManager) {
            object = DataForm.remove(this.extendedInfos, (String)object);
            this.extendedInfos.add(dataForm);
            this.renewEntityCapsVersion();
        }
        return object;
    }

    public final synchronized void removeExtendedInfo(String object) {
        if ((object = DataForm.remove(this.extendedInfos, (String)object)) != null) {
            this.renewEntityCapsVersion();
        }
    }

    public final synchronized List<DataForm> getExtendedInfo() {
        return CollectionUtil.newListWith(this.extendedInfos);
    }

    @Deprecated
    public final List<DataForm> getExtendedInfoAsList() {
        return this.getExtendedInfo();
    }

    public final synchronized void removeExtendedInfo() {
        int n = this.extendedInfos.size();
        this.extendedInfos.clear();
        if (n > 0) {
            this.renewEntityCapsVersion();
        }
    }

    public final DiscoverInfo discoverInfo(i i2) {
        if (i2 == null) {
            return this.discoverInfo(null, null);
        }
        List<DiscoInfoLookupShortcutMechanism> list = discoInfoLookupShortcutMechanisms;
        synchronized (list) {
            for (DiscoInfoLookupShortcutMechanism discoInfoLookupShortcutMechanism : discoInfoLookupShortcutMechanisms) {
                DiscoverInfo object = discoInfoLookupShortcutMechanism.getDiscoverInfoByUser(this, i2);
                if (object == null) continue;
                return object;
            }
        }
        return this.discoverInfo(i2, null);
    }

    public final DiscoverInfo discoverInfo(i object, String string) {
        XMPPConnection xMPPConnection = this.connection();
        object = ((DiscoverInfoBuilder)DiscoverInfo.builder(xMPPConnection).to((i)object)).setNode(string).build();
        object = xMPPConnection.createStanzaCollectorAndSend((IQ)object).nextResultOrThrow();
        return (DiscoverInfo)object;
    }

    public final DiscoverItems discoverItems(i i2) {
        return this.discoverItems(i2, null);
    }

    public final DiscoverItems discoverItems(i i2, String string) {
        DiscoverItems discoverItems = new DiscoverItems();
        discoverItems.setType(IQ.Type.get);
        discoverItems.setTo(i2);
        discoverItems.setNode(string);
        i2 = this.connection().createStanzaCollectorAndSend((IQ)discoverItems).nextResultOrThrow();
        return (DiscoverItems)i2;
    }

    public final boolean serverSupportsFeature(CharSequence charSequence) {
        return this.serverSupportsFeatures(charSequence);
    }

    public final boolean serverSupportsFeatures(CharSequence ... charSequenceArray) {
        return this.serverSupportsFeatures(Arrays.asList(charSequenceArray));
    }

    public final boolean serverSupportsFeatures(Collection<? extends CharSequence> collection) {
        ServiceDiscoveryManager serviceDiscoveryManager = this;
        return serviceDiscoveryManager.supportsFeatures((i)serviceDiscoveryManager.connection().getXMPPServiceDomain(), collection);
    }

    public final boolean accountSupportsFeatures(CharSequence ... charSequenceArray) {
        return this.accountSupportsFeatures(Arrays.asList(charSequenceArray));
    }

    public final boolean accountSupportsFeatures(Collection<? extends CharSequence> collection) {
        e e2 = this.connection().getUser().b();
        return this.supportsFeatures((i)e2, collection);
    }

    public final boolean supportsFeature(i i2, CharSequence charSequence) {
        return this.supportsFeatures(i2, charSequence);
    }

    public final boolean supportsFeatures(i i2, CharSequence ... charSequenceArray) {
        return this.supportsFeatures(i2, Arrays.asList(charSequenceArray));
    }

    public final boolean supportsFeatures(i object, Collection<? extends CharSequence> object2) {
        object = this.discoverInfo((i)object);
        object2 = object2.iterator();
        while (object2.hasNext()) {
            CharSequence charSequence = (CharSequence)object2.next();
            if (((DiscoverInfo)object).containsFeature(charSequence)) continue;
            return false;
        }
        return true;
    }

    public final List<DiscoverInfo> findServicesDiscoverInfo(String string, boolean bl, boolean bl2) {
        return this.findServicesDiscoverInfo(string, bl, bl2, null);
    }

    public final List<DiscoverInfo> findServicesDiscoverInfo(String string, boolean bl, boolean bl2, Map<? super i, Exception> map) {
        b b2 = this.connection().getXMPPServiceDomain();
        return this.findServicesDiscoverInfo(b2, string, bl, bl2, map);
    }

    /*
     * WARNING - void declaration
     */
    public final List<DiscoverInfo> findServicesDiscoverInfo(b object2, String string, boolean bl, boolean bl2, Map<? super i, Exception> map) {
        void var3_6;
        void var5_8;
        IQ iQ;
        void var2_5;
        LinkedList<DiscoverInfo> linkedList;
        void var4_7;
        if (var4_7 != false && (linkedList = (List)this.services.a((Object)var2_5)) != null) {
            return linkedList;
        }
        linkedList = new LinkedList();
        try {
            iQ = this.discoverInfo((i)object2);
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            if (var5_8 != null) {
                var5_8.put(object2, xMPPErrorException);
            }
            return linkedList;
        }
        if (iQ.containsFeature((CharSequence)var2_5)) {
            linkedList.add((DiscoverInfo)iQ);
            if (var3_6 != false) {
                if (var4_7 != false) {
                    this.services.put((Object)var2_5, linkedList);
                }
                return linkedList;
            }
        }
        try {
            iQ = this.discoverItems((i)object2);
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            if (var5_8 != null) {
                var5_8.put(object2, xMPPErrorException);
            }
            return linkedList;
        }
        for (DiscoverItems.Item item : iQ.getItems()) {
            i i2 = item.getEntityID();
            try {
                iQ = this.discoverInfo(i2);
            }
            catch (SmackException.NoResponseException | XMPPException.XMPPErrorException throwable) {
                if (var5_8 == null) continue;
                var5_8.put(i2, throwable);
                continue;
            }
            if (!iQ.containsFeature((CharSequence)var2_5)) continue;
            linkedList.add((DiscoverInfo)iQ);
            if (var3_6 == false) continue;
        }
        if (var4_7 != false) {
            this.services.put((Object)var2_5, linkedList);
        }
        return linkedList;
    }

    public final List<b> findServices(String iterator, boolean bl, boolean bl2) {
        iterator = this.findServicesDiscoverInfo((String)((Object)iterator), bl, bl2);
        ArrayList<b> arrayList = new ArrayList<b>(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            DiscoverInfo discoverInfo = (DiscoverInfo)iterator.next();
            arrayList.add(discoverInfo.getFrom().v());
        }
        return arrayList;
    }

    public final b findService(String object, boolean bl, String string, String string2) {
        boolean bl2 = StringUtils.isNullOrEmpty((CharSequence)string);
        boolean bl3 = StringUtils.isNullOrEmpty((CharSequence)string2);
        if (bl3 != bl2) {
            throw new IllegalArgumentException("Must specify either both, category and type, or none");
        }
        if ((object = this.findServicesDiscoverInfo((String)object, false, bl)).isEmpty()) {
            return null;
        }
        if (!bl2 && !bl3) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                DiscoverInfo discoverInfo = (DiscoverInfo)iterator.next();
                if (!discoverInfo.hasIdentity(string, string2)) continue;
                return discoverInfo.getFrom().v();
            }
        }
        return ((DiscoverInfo)object.get(0)).getFrom().v();
    }

    public final b findService(String string, boolean bl) {
        return this.findService(string, bl, null, null);
    }

    public final boolean addEntityCapabilitiesChangedListener(EntityCapabilitiesChangedListener entityCapabilitiesChangedListener) {
        return this.entityCapabilitiesChangedListeners.add(entityCapabilitiesChangedListener);
    }

    private synchronized void renewEntityCapsVersion() {
        boolean bl;
        if (this.entityCapabilitiesChangedListeners.isEmpty()) {
            return;
        }
        ++this.renewEntityCapsRequested;
        if (this.renewEntityCapsScheduledAction != null && (bl = this.renewEntityCapsScheduledAction.cancel())) {
            ++this.scheduledRenewEntityCapsAvoided;
        }
        this.renewEntityCapsScheduledAction = ServiceDiscoveryManager.scheduleBlocking(() -> {
            XMPPConnection xMPPConnection = this.connection();
            if (xMPPConnection == null) {
                return;
            }
            this.renewEntityCapsPerformed.incrementAndGet();
            DiscoverInfoView discoverInfoView = (DiscoverInfoBuilder)DiscoverInfo.builder("synthetized-disco-info-response").ofType(IQ.Type.result);
            this.addDiscoverInfoTo((DiscoverInfoBuilder)discoverInfoView);
            discoverInfoView = discoverInfoView.build();
            for (EntityCapabilitiesChangedListener entityCapabilitiesChangedListener : this.entityCapabilitiesChangedListeners) {
                entityCapabilitiesChangedListener.onEntityCapabilitiesChanged((DiscoverInfo)discoverInfoView);
            }
            Presence presence = this.presenceSend;
            if (xMPPConnection.isAuthenticated() && presence != null) {
                EntityCapabilitiesChangedListener entityCapabilitiesChangedListener;
                entityCapabilitiesChangedListener = presence.asBuilder(xMPPConnection).build();
                try {
                    xMPPConnection.sendStanza((Stanza)entityCapabilitiesChangedListener);
                    return;
                }
                catch (InterruptedException | SmackException.NotConnectedException throwable) {
                    LOGGER.log(Level.WARNING, "Could could not update presence with caps info", throwable);
                }
            }
        }, (long)25L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public static void addDiscoInfoLookupShortcutMechanism(DiscoInfoLookupShortcutMechanism discoInfoLookupShortcutMechanism) {
        List<DiscoInfoLookupShortcutMechanism> list = discoInfoLookupShortcutMechanisms;
        synchronized (list) {
            discoInfoLookupShortcutMechanisms.add(discoInfoLookupShortcutMechanism);
            Collections.sort(discoInfoLookupShortcutMechanisms);
            return;
        }
    }

    public static void removeDiscoInfoLookupShortcutMechanism(DiscoInfoLookupShortcutMechanism discoInfoLookupShortcutMechanism) {
        List<DiscoInfoLookupShortcutMechanism> list = discoInfoLookupShortcutMechanisms;
        synchronized (list) {
            discoInfoLookupShortcutMechanisms.remove(discoInfoLookupShortcutMechanism);
            return;
        }
    }

    public final synchronized Stats getStats() {
        return new Stats(this);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
            }
        });
    }

    public static final class Stats
    extends AbstractStats {
        public final int renewEntityCapsRequested;
        public final int renewEntityCapsPerformed;
        public final int scheduledRenewEntityCapsAvoided;

        private Stats(ServiceDiscoveryManager serviceDiscoveryManager) {
            this.renewEntityCapsRequested = serviceDiscoveryManager.renewEntityCapsRequested;
            this.renewEntityCapsPerformed = serviceDiscoveryManager.renewEntityCapsPerformed.get();
            this.scheduledRenewEntityCapsAvoided = serviceDiscoveryManager.scheduledRenewEntityCapsAvoided;
        }

        public final void appendStatsTo(ExtendedAppendable extendedAppendable) {
            StringUtils.appendHeading((Appendable)extendedAppendable, (String)"ServiceDiscoveryManager stats", (char)'#').append('\n');
            extendedAppendable.append((CharSequence)"renew-entitycaps-requested: ").append(this.renewEntityCapsRequested).append('\n');
            extendedAppendable.append((CharSequence)"renew-entitycaps-performed: ").append(this.renewEntityCapsPerformed).append('\n');
            extendedAppendable.append((CharSequence)"scheduled-renew-entitycaps-avoided: ").append(this.scheduledRenewEntityCapsAvoided).append('\n');
        }
    }
}

