/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import org.e.a.i;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.filetransfer.FileTransferException;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IBBTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.Socks5TransferNegotiator;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.formtypes.FormFieldRegistry;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.ListSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public final class FileTransferNegotiator
extends Manager {
    public static final String SI_NAMESPACE = "http://jabber.org/protocol/si";
    public static final String SI_PROFILE_FILE_TRANSFER_NAMESPACE = "http://jabber.org/protocol/si/profile/file-transfer";
    private static final String[] NAMESPACE = new String[]{"http://jabber.org/protocol/si", "http://jabber.org/protocol/si/profile/file-transfer"};
    private static final Map<XMPPConnection, FileTransferNegotiator> INSTANCES = new WeakHashMap<XMPPConnection, FileTransferNegotiator>();
    private static final String STREAM_INIT_PREFIX = "jsi_";
    protected static final String STREAM_DATA_FIELD_NAME = "stream-method";
    private static final Random randomGenerator;
    public static boolean IBB_ONLY;
    private final StreamNegotiator byteStreamTransferManager;
    private final StreamNegotiator inbandTransferManager;

    public static synchronized FileTransferNegotiator getInstanceFor(XMPPConnection xMPPConnection) {
        FileTransferNegotiator fileTransferNegotiator = INSTANCES.get(xMPPConnection);
        if (fileTransferNegotiator == null) {
            fileTransferNegotiator = new FileTransferNegotiator(xMPPConnection);
            INSTANCES.put(xMPPConnection, fileTransferNegotiator);
        }
        return fileTransferNegotiator;
    }

    private static void setServiceEnabled(XMPPConnection object, boolean bl) {
        object = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)object);
        Object object2 = new ArrayList<String>();
        object2.addAll(Arrays.asList(NAMESPACE));
        object2.add("http://jabber.org/protocol/ibb");
        if (!IBB_ONLY) {
            object2.add("http://jabber.org/protocol/bytestreams");
        }
        object2 = object2.iterator();
        while (object2.hasNext()) {
            String string = (String)object2.next();
            if (bl) {
                ((ServiceDiscoveryManager)((Object)object)).addFeature(string);
                continue;
            }
            ((ServiceDiscoveryManager)((Object)object)).removeFeature(string);
        }
    }

    public static boolean isServiceEnabled(XMPPConnection object) {
        object = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)object);
        Object object2 = new ArrayList<String>();
        object2.addAll(Arrays.asList(NAMESPACE));
        object2.add("http://jabber.org/protocol/ibb");
        if (!IBB_ONLY) {
            object2.add("http://jabber.org/protocol/bytestreams");
        }
        object2 = object2.iterator();
        while (object2.hasNext()) {
            String string = (String)object2.next();
            if (((ServiceDiscoveryManager)((Object)object)).includesFeature(string)) continue;
            return false;
        }
        return true;
    }

    public static Collection<String> getSupportedProtocols() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("http://jabber.org/protocol/ibb");
        if (!IBB_ONLY) {
            arrayList.add("http://jabber.org/protocol/bytestreams");
        }
        return Collections.unmodifiableList(arrayList);
    }

    private FileTransferNegotiator(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.byteStreamTransferManager = new Socks5TransferNegotiator(xMPPConnection);
        this.inbandTransferManager = new IBBTransferNegotiator(xMPPConnection);
        FileTransferNegotiator.setServiceEnabled(xMPPConnection, true);
    }

    public final StreamNegotiator selectStreamNegotiator(FileTransferRequest object) {
        Object object2 = FileTransferNegotiator.getStreamMethodField(((StreamInitiation)((Object)(object = object.getStreamInitiation()))).getFeatureNegotiationForm());
        if (object2 == null) {
            object2 = "No stream methods contained in stanza.";
            object2 = StanzaError.from((StanzaError.Condition)StanzaError.Condition.bad_request, (String)object2).build();
            object = IQ.createErrorResponse((IQ)object, (StanzaError)object2);
            this.connection().sendStanza((Stanza)object);
            throw new FileTransferException.NoStreamMethodsOfferedException();
        }
        try {
            object2 = this.getNegotiator((ListSingleFormField)object2);
        }
        catch (FileTransferException.NoAcceptableTransferMechanisms noAcceptableTransferMechanisms) {
            object = IQ.createErrorResponse((IQ)object, (StanzaError)StanzaError.from((StanzaError.Condition)StanzaError.Condition.bad_request, (String)"No acceptable transfer mechanism").build());
            this.connection().sendStanza((Stanza)object);
            throw noAcceptableTransferMechanisms;
        }
        return object2;
    }

    private static ListSingleFormField getStreamMethodField(DataForm dataForm) {
        return (ListSingleFormField)dataForm.getField(STREAM_DATA_FIELD_NAME);
    }

    private StreamNegotiator getNegotiator(ListSingleFormField object2) {
        boolean bl = false;
        boolean bl2 = false;
        for (FormField.Option option : ((ListSingleFormField)object2).getOptions()) {
            String string = option.getValueString();
            if (string.equals("http://jabber.org/protocol/bytestreams") && !IBB_ONLY) {
                bl = true;
                continue;
            }
            if (!string.equals("http://jabber.org/protocol/ibb")) continue;
            bl2 = true;
        }
        if (!bl && !bl2) {
            throw new FileTransferException.NoAcceptableTransferMechanisms();
        }
        if (bl) {
            return this.byteStreamTransferManager;
        }
        return this.inbandTransferManager;
    }

    public static String getNextStreamID() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(STREAM_INIT_PREFIX);
        stringBuilder.append(randomGenerator.nextInt(Integer.MAX_VALUE) + randomGenerator.nextInt(Integer.MAX_VALUE));
        return stringBuilder.toString();
    }

    public final StreamNegotiator negotiateOutgoingTransfer(i object, String object2, String string, long l, String string2, int n) {
        StreamInitiation streamInitiation = new StreamInitiation();
        streamInitiation.setSessionID((String)object2);
        streamInitiation.setMimeType(URLConnection.guessContentTypeFromName(string));
        object2 = new StreamInitiation.File(string, l);
        ((StreamInitiation.File)object2).setDesc(string2);
        streamInitiation.setFile((StreamInitiation.File)object2);
        streamInitiation.setFeatureNegotiationForm(FileTransferNegotiator.createDefaultInitiationForm());
        streamInitiation.setFrom((i)this.connection().getUser());
        streamInitiation.setTo((i)object);
        streamInitiation.setType(IQ.Type.set);
        object = this.connection().createStanzaCollectorAndSend((IQ)streamInitiation).nextResultOrThrow((long)n);
        if (object instanceof IQ) {
            object2 = (IQ)object;
            if (object2.getType().equals((Object)IQ.Type.result)) {
                object = (StreamInitiation)((Object)object);
                return this.getOutgoingNegotiator(FileTransferNegotiator.getStreamMethodField(((StreamInitiation)((Object)object)).getFeatureNegotiationForm()));
            }
            Object object3 = object2;
            throw new XMPPException.XMPPErrorException((Stanza)object3, object3.getError());
        }
        return null;
    }

    private StreamNegotiator getOutgoingNegotiator(FormField object) {
        boolean bl = false;
        boolean bl2 = false;
        for (CharSequence charSequence : ((FormField)((Object)object)).getValues()) {
            String charSequence2 = charSequence.toString();
            if (charSequence2.equals("http://jabber.org/protocol/bytestreams") && !IBB_ONLY) {
                bl = true;
                continue;
            }
            if (!charSequence2.equals("http://jabber.org/protocol/ibb")) continue;
            bl2 = true;
        }
        if (!bl && !bl2) {
            throw new FileTransferException.NoAcceptableTransferMechanisms();
        }
        if (bl) {
            return this.byteStreamTransferManager;
        }
        return this.inbandTransferManager;
    }

    private static DataForm createDefaultInitiationForm() {
        DataForm.Builder builder = DataForm.builder(DataForm.Type.form);
        ListSingleFormField.Builder builder2 = FormField.listSingleBuilder(STREAM_DATA_FIELD_NAME);
        if (!IBB_ONLY) {
            builder2.addOption("http://jabber.org/protocol/bytestreams");
        }
        builder2.addOption("http://jabber.org/protocol/ibb");
        builder.addField(builder2.build());
        return builder.build();
    }

    static {
        FormFieldRegistry.addLookasideFieldRegistryEntry(STREAM_DATA_FIELD_NAME, FormField.Type.list_single);
        randomGenerator = new Random();
        IBB_ONLY = System.getProperty("ibb") != null;
    }
}

