/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mediaelement.provider;

import java.net.URI;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.mediaelement.element.MediaElement;
import org.jivesoftware.smackx.xdata.provider.FormFieldChildElementProvider;

public class MediaElementProvider
extends FormFieldChildElementProvider<MediaElement> {
    private static final Logger LOGGER = Logger.getLogger(MediaElementProvider.class.getName());

    @Override
    public QName getQName() {
        return MediaElement.QNAME;
    }

    /*
     * Enabled aggressive block sorting
     */
    public MediaElement parse(XmlPullParser xmlPullParser, int n, XmlEnvironment object) {
        UInt16 uInt16 = ParserUtils.getUInt16Attribute((XmlPullParser)xmlPullParser, (String)"height");
        UInt16 uInt162 = ParserUtils.getUInt16Attribute((XmlPullParser)xmlPullParser, (String)"width");
        MediaElement.Builder builder = MediaElement.builder();
        if (uInt16 != null && uInt162 != null) {
            builder.setHeightAndWidth(uInt16, uInt162);
        } else if (uInt16 != null || uInt162 != null) {
            LOGGER.warning("Only one of height and width set while parsing media element");
        }
        block4: while (true) {
            XmlPullParser.TagEvent tagEvent = xmlPullParser.nextTag();
            switch (tagEvent) {
                case START_ELEMENT: {
                    QName qName = xmlPullParser.getQName();
                    if (!qName.equals(MediaElement.Uri.QNAME)) break;
                    MediaElement.Uri uri = MediaElementProvider.parseUri(xmlPullParser);
                    builder.addUri(uri);
                    continue block4;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() == n) break block4;
                }
            }
        }
        return builder.build();
    }

    private static MediaElement.Uri parseUri(XmlPullParser object) {
        String string = object.getAttributeValue("type");
        object = ParserUtils.getUriFromNextText((XmlPullParser)object);
        return new MediaElement.Uri((URI)object, string);
    }
}

