/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.e.a.a.d;
import org.e.a.c.a;
import org.e.a.i;
import org.e.b.c;
import org.e.c.b;
import org.jivesoftware.smackx.xdata.AbstractMultiFormField;
import org.jivesoftware.smackx.xdata.AbstractSingleStringValueFormField;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;
import org.jivesoftware.smackx.xdata.ListMultiFormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.form.FilledForm;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class FillableForm
extends FilledForm {
    private final Set<String> requiredFields;
    private final Set<String> filledRequiredFields = new HashSet<String>();
    private final Set<String> missingRequiredFields = new HashSet<String>();
    private final Map<String, FormField> filledFields = new HashMap<String, FormField>();

    public FillableForm(DataForm iterator) {
        super((DataForm)((Object)iterator));
        if (((DataForm)((Object)iterator)).getType() != DataForm.Type.form) {
            throw new IllegalArgumentException();
        }
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<FormField> arrayList = new ArrayList<FormField>();
        for (FormField formField : ((DataForm)((Object)iterator)).getFields()) {
            if (!formField.isRequired()) continue;
            String string = formField.getFieldName();
            hashSet.add(string);
            if (formField.hasValueSet()) {
                arrayList.add(formField);
                continue;
            }
            this.missingRequiredFields.add(string);
        }
        this.requiredFields = Collections.unmodifiableSet(hashSet);
        for (FormField formField : arrayList) {
            this.write(formField);
        }
    }

    protected void writeListMulti(String object, List<? extends CharSequence> list) {
        object = ((ListMultiFormField.Builder)FormField.listMultiBuilder((String)object).addValues(list)).build();
        this.write((FormField)object);
    }

    protected void writeTextSingle(String object, CharSequence charSequence) {
        object = ((TextSingleFormField.Builder)FormField.textSingleBuilder((String)object).setValue(charSequence)).build();
        this.write((FormField)object);
    }

    protected void writeBoolean(String object, boolean bl) {
        object = FormField.booleanBuilder((String)object).setValue(bl).build();
        this.write((FormField)object);
    }

    protected void write(String string, int n) {
        this.writeTextSingle(string, Integer.toString(n));
    }

    protected void write(String string, Date date) {
        this.writeTextSingle(string, b.a((Date)date));
    }

    public void setAnswer(String object, Collection<? extends CharSequence> collection) {
        Object object2 = this.getFieldOrThrow((String)object);
        object2 = ((FormField)object2).getType();
        switch (1.$SwitchMap$org$jivesoftware$smackx$xdata$FormField$Type[((Enum)object2).ordinal()]) {
            case 1: 
            case 2: {
                object = ((FormField.Builder)FillableForm.createMultiKindFieldbuilder((String)object, (FormField.Type)((Object)object2)).addValues(collection)).build();
                break;
            }
            case 3: {
                object2 = new ArrayList(collection.size());
                ArrayList arrayList = new ArrayList();
                a.a(collection, (Collection)object2, arrayList);
                if (!arrayList.isEmpty()) {
                    throw new IllegalArgumentException((Throwable)arrayList.get(0));
                }
                object = FormField.jidMultiBuilder((String)object).addValues((Collection<? extends i>)object2).build();
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
        this.write((FormField)object);
    }

    private static AbstractMultiFormField.Builder<?, ?> createMultiKindFieldbuilder(String string, FormField.Type type) {
        switch (type) {
            case list_multi: {
                return FormField.listMultiBuilder(string);
            }
            case text_multi: {
                return FormField.textMultiBuilder(string);
            }
        }
        throw new IllegalArgumentException();
    }

    public void setAnswer(String string, int n) {
        this.setAnswer(string, Integer.toString(n));
    }

    public void setAnswer(String object, CharSequence charSequence) {
        Object object2 = this.getFieldOrThrow((String)object);
        object2 = ((FormField)object2).getType();
        switch (1.$SwitchMap$org$jivesoftware$smackx$xdata$FormField$Type[((Enum)object2).ordinal()]) {
            case 1: 
            case 3: {
                throw new IllegalArgumentException("Can not answer fields of type '" + object2 + "' with a CharSequence");
            }
            case 4: {
                throw new IllegalArgumentException("Fields of type 'fixed' are not answerable");
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                object = ((FormField.Builder)FillableForm.createSingleKindFieldBuilder((String)object, (FormField.Type)((Object)object2)).setValue(charSequence)).build();
                break;
            }
            case 9: {
                object = FormField.booleanBuilder((String)object).setValue(charSequence).build();
                break;
            }
            case 10: {
                try {
                    charSequence = d.a((CharSequence)charSequence);
                }
                catch (c c2) {
                    throw new IllegalArgumentException(c2);
                }
                object = FormField.jidSingleBuilder((String)object).setValue((i)charSequence).build();
                break;
            }
            case 2: {
                object = ((FormField.Builder)FillableForm.createMultiKindFieldbuilder((String)object, (FormField.Type)((Object)object2)).addValue(charSequence)).build();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.write((FormField)object);
    }

    private static AbstractSingleStringValueFormField.Builder<?, ?> createSingleKindFieldBuilder(String string, FormField.Type type) {
        switch (type) {
            case text_private: {
                return FormField.textPrivateBuilder(string);
            }
            case text_single: {
                return FormField.textSingleBuilder(string);
            }
            case hidden: {
                return FormField.hiddenBuilder(string);
            }
            case list_single: {
                return FormField.listSingleBuilder(string);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
    }

    public void setAnswer(String object, boolean bl) {
        FormField formField = this.getFieldOrThrow((String)object);
        if (formField.getType() != FormField.Type.bool) {
            throw new IllegalArgumentException();
        }
        object = FormField.booleanBuilder((String)object).setValue(bl).build();
        this.write((FormField)object);
    }

    public final void write(FormField formField) {
        if (formField.getType() == FormField.Type.fixed) {
            throw new IllegalArgumentException();
        }
        if (!formField.hasValueSet()) {
            throw new IllegalArgumentException();
        }
        String string = formField.getFieldName();
        if (!this.getDataForm().hasField(string)) {
            throw new IllegalArgumentException();
        }
        FormField formField2 = this.getDataForm().getField(string);
        for (FormFieldChildElement formFieldChildElement : formField2.getFormFieldChildElements()) {
            formFieldChildElement.validate(formField);
        }
        this.filledFields.put(string, formField);
        if (this.requiredFields.contains(string)) {
            this.filledRequiredFields.add(string);
            this.missingRequiredFields.remove(string);
        }
    }

    @Override
    public FormField getField(String string) {
        FormField formField = this.filledFields.get(string);
        if (formField != null) {
            return formField;
        }
        return super.getField(string);
    }

    public DataForm getDataFormToSubmit() {
        if (!this.missingRequiredFields.isEmpty()) {
            throw new IllegalStateException("Not all required fields filled. Missing: " + this.missingRequiredFields);
        }
        DataForm.Builder builder = DataForm.builder();
        if (this.formTypeFormField != null) {
            builder.addField(this.formTypeFormField);
        }
        builder.addFields(this.filledFields.values());
        return builder.build();
    }
}

