/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public final class Version {
    private static final String PROP_VERSION = ".version";
    private static final String PROP_BUILD_DATE = ".buildDate";
    private static final String PROP_COMMIT_DATE = ".commitDate";
    private static final String PROP_SHORT_COMMIT_HASH = ".shortCommitHash";
    private static final String PROP_LONG_COMMIT_HASH = ".longCommitHash";
    private static final String PROP_REPO_STATUS = ".repoStatus";
    private final String artifactId;
    private final String artifactVersion;
    private final long buildTimeMillis;
    private final long commitTimeMillis;
    private final String shortCommitHash;
    private final String longCommitHash;
    private final String repositoryStatus;

    public static Map<String, Version> identify() {
        return Version.identify(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Version> identify(ClassLoader object) {
        Object object22;
        TreeMap<String, Version> treeMap;
        if (object == null) {
            object = PlatformDependent.getContextClassLoader();
        }
        Properties properties = new Properties();
        try {
            object = ((ClassLoader)object).getResources("META-INF/io.netty.versions.properties");
            while (object.hasMoreElements()) {
                treeMap = (URL)object.nextElement();
                object22 = ((URL)((Object)treeMap)).openStream();
                try {
                    properties.load((InputStream)object22);
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)object22).close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    ((InputStream)object22).close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        object = new HashSet();
        for (Object object22 : properties.keySet()) {
            String string = (String)object22;
            int n = string.indexOf(46);
            if (n <= 0 || !properties.containsKey((String)(object22 = string.substring(0, n)) + PROP_VERSION) || !properties.containsKey((String)object22 + PROP_BUILD_DATE) || !properties.containsKey((String)object22 + PROP_COMMIT_DATE) || !properties.containsKey((String)object22 + PROP_SHORT_COMMIT_HASH) || !properties.containsKey((String)object22 + PROP_LONG_COMMIT_HASH) || !properties.containsKey((String)object22 + PROP_REPO_STATUS)) continue;
            object.add(object22);
        }
        treeMap = new TreeMap<String, Version>();
        object22 = object.iterator();
        while (object22.hasNext()) {
            String string = (String)object22.next();
            treeMap.put(string, new Version(string, properties.getProperty(string + PROP_VERSION), Version.parseIso8601(properties.getProperty(string + PROP_BUILD_DATE)), Version.parseIso8601(properties.getProperty(string + PROP_COMMIT_DATE)), properties.getProperty(string + PROP_SHORT_COMMIT_HASH), properties.getProperty(string + PROP_LONG_COMMIT_HASH), properties.getProperty(string + PROP_REPO_STATUS)));
        }
        return treeMap;
    }

    private static long parseIso8601(String string) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").parse(string).getTime();
        }
        catch (ParseException parseException) {
            return 0L;
        }
    }

    public static void main(String[] object) {
        for (Version version : Version.identify().values()) {
            System.err.println(version);
        }
    }

    private Version(String string, String string2, long l, long l2, String string3, String string4, String string5) {
        this.artifactId = string;
        this.artifactVersion = string2;
        this.buildTimeMillis = l;
        this.commitTimeMillis = l2;
        this.shortCommitHash = string3;
        this.longCommitHash = string4;
        this.repositoryStatus = string5;
    }

    public final String artifactId() {
        return this.artifactId;
    }

    public final String artifactVersion() {
        return this.artifactVersion;
    }

    public final long buildTimeMillis() {
        return this.buildTimeMillis;
    }

    public final long commitTimeMillis() {
        return this.commitTimeMillis;
    }

    public final String shortCommitHash() {
        return this.shortCommitHash;
    }

    public final String longCommitHash() {
        return this.longCommitHash;
    }

    public final String repositoryStatus() {
        return this.repositoryStatus;
    }

    public final String toString() {
        return this.artifactId + '-' + this.artifactVersion + '.' + this.shortCommitHash + ("clean".equals(this.repositoryStatus) ? "" : " (repository: " + this.repositoryStatus + ')');
    }
}

