/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class DefaultEventExecutorChooserFactory
implements EventExecutorChooserFactory {
    public static final DefaultEventExecutorChooserFactory INSTANCE = new DefaultEventExecutorChooserFactory();

    private DefaultEventExecutorChooserFactory() {
    }

    @Override
    public final EventExecutorChooserFactory.EventExecutorChooser newChooser(EventExecutor[] eventExecutorArray) {
        if (DefaultEventExecutorChooserFactory.isPowerOfTwo(eventExecutorArray.length)) {
            return new PowerOfTwoEventExecutorChooser(eventExecutorArray);
        }
        return new GenericEventExecutorChooser(eventExecutorArray);
    }

    private static boolean isPowerOfTwo(int n) {
        int n2 = n;
        return (n2 & -n2) == n;
    }

    private static final class GenericEventExecutorChooser
    implements EventExecutorChooserFactory.EventExecutorChooser {
        private final AtomicLong idx = new AtomicLong();
        private final EventExecutor[] executors;

        GenericEventExecutorChooser(EventExecutor[] eventExecutorArray) {
            this.executors = eventExecutorArray;
        }

        @Override
        public final EventExecutor next() {
            return this.executors[(int)Math.abs(this.idx.getAndIncrement() % (long)this.executors.length)];
        }
    }

    private static final class PowerOfTwoEventExecutorChooser
    implements EventExecutorChooserFactory.EventExecutorChooser {
        private final AtomicInteger idx = new AtomicInteger();
        private final EventExecutor[] executors;

        PowerOfTwoEventExecutorChooser(EventExecutor[] eventExecutorArray) {
            this.executors = eventExecutorArray;
        }

        @Override
        public final EventExecutor next() {
            return this.executors[this.idx.getAndIncrement() & this.executors.length - 1];
        }
    }
}

