/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.handler.codec.CodecOutputList;
import io.netty.handler.codec.DecoderException;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.List;

public abstract class ByteToMessageDecoder
extends ChannelInboundHandlerAdapter {
    public static final Cumulator MERGE_CUMULATOR = new Cumulator(){

        @Override
        public final ByteBuf cumulate(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, ByteBuf byteBuf2) {
            if (byteBuf == byteBuf2) {
                byteBuf2.release();
                return byteBuf;
            }
            if (!byteBuf.isReadable() && byteBuf2.isContiguous()) {
                byteBuf.release();
                return byteBuf2;
            }
            try {
                int n = byteBuf2.readableBytes();
                if (n > byteBuf.maxWritableBytes() || n > byteBuf.maxFastWritableBytes() && byteBuf.refCnt() > 1 || byteBuf.isReadOnly()) {
                    byteBufAllocator = ByteToMessageDecoder.expandCumulation(byteBufAllocator, byteBuf, byteBuf2);
                    return byteBufAllocator;
                }
                ByteBuf byteBuf3 = byteBuf2;
                byteBuf.writeBytes(byteBuf3, byteBuf3.readerIndex(), n);
                ByteBuf byteBuf4 = byteBuf2;
                byteBuf4.readerIndex(byteBuf4.writerIndex());
                byteBufAllocator = byteBuf;
                return byteBufAllocator;
            }
            finally {
                byteBuf2.release();
            }
        }
    };
    public static final Cumulator COMPOSITE_CUMULATOR = new Cumulator(){

        @Override
        public final ByteBuf cumulate(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, ByteBuf byteBuf2) {
            if (byteBuf == byteBuf2) {
                byteBuf2.release();
                return byteBuf;
            }
            if (!byteBuf.isReadable()) {
                byteBuf.release();
                return byteBuf2;
            }
            CompositeByteBuf compositeByteBuf = null;
            try {
                if (byteBuf instanceof CompositeByteBuf && byteBuf.refCnt() == 1) {
                    compositeByteBuf = (CompositeByteBuf)byteBuf;
                    if (compositeByteBuf.writerIndex() != compositeByteBuf.capacity()) {
                        CompositeByteBuf compositeByteBuf2 = compositeByteBuf;
                        compositeByteBuf2.capacity(compositeByteBuf2.writerIndex());
                    }
                } else {
                    compositeByteBuf = byteBufAllocator.compositeBuffer(Integer.MAX_VALUE).addFlattenedComponents(true, byteBuf);
                }
                compositeByteBuf.addFlattenedComponents(true, byteBuf2);
                byteBuf2 = null;
                byteBufAllocator = compositeByteBuf;
                return byteBufAllocator;
            }
            catch (Throwable throwable) {
                if (byteBuf2 != null) {
                    byteBuf2.release();
                    if (compositeByteBuf != null && compositeByteBuf != byteBuf) {
                        compositeByteBuf.release();
                    }
                }
                throw throwable;
            }
        }
    };
    private static final byte STATE_INIT = 0;
    private static final byte STATE_CALLING_CHILD_DECODE = 1;
    private static final byte STATE_HANDLER_REMOVED_PENDING = 2;
    ByteBuf cumulation;
    private Cumulator cumulator = MERGE_CUMULATOR;
    private boolean singleDecode;
    private boolean first;
    private boolean firedChannelRead;
    private boolean selfFiredChannelRead;
    private byte decodeState = 0;
    private int discardAfterReads = 16;
    private int numReads;

    protected ByteToMessageDecoder() {
        this.ensureNotSharable();
    }

    public void setSingleDecode(boolean bl) {
        this.singleDecode = bl;
    }

    public boolean isSingleDecode() {
        return this.singleDecode;
    }

    public void setCumulator(Cumulator cumulator) {
        this.cumulator = (Cumulator)ObjectUtil.checkNotNull((Object)cumulator, (String)"cumulator");
    }

    public void setDiscardAfterReads(int n) {
        ObjectUtil.checkPositive((int)n, (String)"discardAfterReads");
        this.discardAfterReads = n;
    }

    protected int actualReadableBytes() {
        return this.internalBuffer().readableBytes();
    }

    protected ByteBuf internalBuffer() {
        if (this.cumulation != null) {
            return this.cumulation;
        }
        return Unpooled.EMPTY_BUFFER;
    }

    public final void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        if (this.decodeState == 1) {
            this.decodeState = (byte)2;
            return;
        }
        ByteBuf byteBuf = this.cumulation;
        if (byteBuf != null) {
            this.cumulation = null;
            this.numReads = 0;
            int n = byteBuf.readableBytes();
            if (n > 0) {
                channelHandlerContext.fireChannelRead((Object)byteBuf);
                channelHandlerContext.fireChannelReadComplete();
            } else {
                byteBuf.release();
            }
        }
        this.handlerRemoved0(channelHandlerContext);
    }

    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof ByteBuf) {
            this.selfFiredChannelRead = true;
            CodecOutputList codecOutputList = CodecOutputList.newInstance();
            try {
                this.first = this.cumulation == null;
                this.cumulation = this.cumulator.cumulate(channelHandlerContext.alloc(), this.first ? Unpooled.EMPTY_BUFFER : this.cumulation, (ByteBuf)object);
                this.callDecode(channelHandlerContext, this.cumulation, codecOutputList);
            }
            catch (DecoderException decoderException) {
                object = decoderException;
                throw decoderException;
            }
            catch (Exception exception) {
                throw new DecoderException(exception);
            }
            finally {
                try {
                    if (this.cumulation != null && !this.cumulation.isReadable()) {
                        this.numReads = 0;
                        try {
                            this.cumulation.release();
                        }
                        catch (IllegalReferenceCountException illegalReferenceCountException) {
                            throw new IllegalReferenceCountException(((Object)((Object)this)).getClass().getSimpleName() + "#decode() might have released its input buffer, or passed it down the pipeline without a retain() call, which is not allowed.", (Throwable)illegalReferenceCountException);
                        }
                        this.cumulation = null;
                    } else if (++this.numReads >= this.discardAfterReads) {
                        this.numReads = 0;
                        this.discardSomeReadBytes();
                    }
                    int n = codecOutputList.size();
                    this.firedChannelRead |= codecOutputList.insertSinceRecycled();
                    ByteToMessageDecoder.fireChannelRead(channelHandlerContext, codecOutputList, n);
                }
                finally {
                    codecOutputList.recycle();
                }
            }
            return;
        }
        channelHandlerContext.fireChannelRead(object);
    }

    static void fireChannelRead(ChannelHandlerContext channelHandlerContext, List<Object> list, int n) {
        if (list instanceof CodecOutputList) {
            ByteToMessageDecoder.fireChannelRead(channelHandlerContext, (CodecOutputList)list, n);
            return;
        }
        for (int i = 0; i < n; ++i) {
            channelHandlerContext.fireChannelRead(list.get(i));
        }
    }

    static void fireChannelRead(ChannelHandlerContext channelHandlerContext, CodecOutputList codecOutputList, int n) {
        for (int i = 0; i < n; ++i) {
            channelHandlerContext.fireChannelRead(codecOutputList.getUnsafe(i));
        }
    }

    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.numReads = 0;
        this.discardSomeReadBytes();
        if (this.selfFiredChannelRead && !this.firedChannelRead && !channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
        this.firedChannelRead = false;
        this.selfFiredChannelRead = false;
        channelHandlerContext.fireChannelReadComplete();
    }

    protected final void discardSomeReadBytes() {
        if (this.cumulation != null && !this.first && this.cumulation.refCnt() == 1) {
            this.cumulation.discardSomeReadBytes();
        }
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.channelInputClosed(channelHandlerContext, true);
    }

    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof ChannelInputShutdownEvent) {
            this.channelInputClosed(channelHandlerContext, false);
        }
        super.userEventTriggered(channelHandlerContext, object);
    }

    private void channelInputClosed(ChannelHandlerContext channelHandlerContext, boolean bl) {
        CodecOutputList codecOutputList = CodecOutputList.newInstance();
        try {
            this.channelInputClosed(channelHandlerContext, codecOutputList);
        }
        catch (DecoderException decoderException) {
            DecoderException decoderException2 = decoderException;
            throw decoderException;
        }
        catch (Exception exception) {
            throw new DecoderException(exception);
        }
        finally {
            try {
                if (this.cumulation != null) {
                    this.cumulation.release();
                    this.cumulation = null;
                }
                int n = codecOutputList.size();
                ByteToMessageDecoder.fireChannelRead(channelHandlerContext, codecOutputList, n);
                if (n > 0) {
                    channelHandlerContext.fireChannelReadComplete();
                }
                if (bl) {
                    channelHandlerContext.fireChannelInactive();
                }
            }
            finally {
                codecOutputList.recycle();
            }
        }
    }

    void channelInputClosed(ChannelHandlerContext channelHandlerContext, List<Object> list) {
        if (this.cumulation != null) {
            this.callDecode(channelHandlerContext, this.cumulation, list);
            if (!channelHandlerContext.isRemoved()) {
                ByteBuf byteBuf = this.cumulation == null ? Unpooled.EMPTY_BUFFER : this.cumulation;
                this.decodeLast(channelHandlerContext, byteBuf, list);
                return;
            }
        } else {
            this.decodeLast(channelHandlerContext, Unpooled.EMPTY_BUFFER, list);
        }
    }

    protected void callDecode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        block7: {
            try {
                while (byteBuf.isReadable()) {
                    int n = list.size();
                    if (n > 0) {
                        ByteToMessageDecoder.fireChannelRead(channelHandlerContext, list, n);
                        list.clear();
                        if (channelHandlerContext.isRemoved()) break;
                    }
                    n = byteBuf.readableBytes();
                    this.decodeRemovalReentryProtection(channelHandlerContext, byteBuf, list);
                    if (channelHandlerContext.isRemoved()) break;
                    if (list.isEmpty()) {
                        if (n != byteBuf.readableBytes()) continue;
                        break block7;
                    }
                    if (n == byteBuf.readableBytes()) {
                        throw new DecoderException(StringUtil.simpleClassName(((Object)((Object)this)).getClass()) + ".decode() did not read anything but decoded a message.");
                    }
                    if (!this.isSingleDecode()) continue;
                }
                return;
            }
            catch (DecoderException decoderException) {
                DecoderException decoderException2 = decoderException;
                throw decoderException;
            }
            catch (Exception exception) {
                throw new DecoderException(exception);
            }
        }
    }

    protected abstract void decode(ChannelHandlerContext var1, ByteBuf var2, List<Object> var3);

    final void decodeRemovalReentryProtection(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        boolean bl;
        this.decodeState = 1;
        try {
            this.decode(channelHandlerContext, byteBuf, list);
            bl = this.decodeState == 2;
        }
        catch (Throwable throwable) {
            boolean bl2 = this.decodeState == 2;
            this.decodeState = 0;
            if (bl2) {
                List<Object> list2 = list;
                ByteToMessageDecoder.fireChannelRead(channelHandlerContext, list2, list2.size());
                list.clear();
                this.handlerRemoved(channelHandlerContext);
            }
            throw throwable;
        }
        this.decodeState = 0;
        if (bl) {
            List<Object> list3 = list;
            ByteToMessageDecoder.fireChannelRead(channelHandlerContext, list3, list3.size());
            list.clear();
            this.handlerRemoved(channelHandlerContext);
        }
    }

    protected void decodeLast(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (byteBuf.isReadable()) {
            this.decodeRemovalReentryProtection(channelHandlerContext, byteBuf, list);
        }
    }

    static ByteBuf expandCumulation(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n = byteBuf.readableBytes();
        int n2 = byteBuf2.readableBytes();
        int n3 = n + n2;
        ByteBufAllocator byteBufAllocator2 = byteBufAllocator;
        byteBufAllocator = byteBufAllocator2.buffer(byteBufAllocator2.calculateNewCapacity(n3, Integer.MAX_VALUE));
        ByteBuf byteBuf3 = byteBufAllocator;
        try {
            ByteBuf byteBuf4 = byteBuf;
            ByteBuf byteBuf5 = byteBuf2;
            byteBufAllocator.setBytes(0, byteBuf4, byteBuf4.readerIndex(), n).setBytes(n, byteBuf5, byteBuf5.readerIndex(), n2).writerIndex(n3);
            ByteBuf byteBuf6 = byteBuf2;
            byteBuf6.readerIndex(byteBuf6.writerIndex());
            byteBuf3 = byteBuf;
            return byteBufAllocator;
        }
        finally {
            byteBuf3.release();
        }
    }

    public static interface Cumulator {
        public ByteBuf cumulate(ByteBufAllocator var1, ByteBuf var2, ByteBuf var3);
    }
}

