/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.DecoderResultProvider;
import io.netty.handler.codec.MessageAggregationException;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public abstract class MessageAggregator<I, S, C extends ByteBufHolder, O extends ByteBufHolder>
extends MessageToMessageDecoder<I> {
    private static final int DEFAULT_MAX_COMPOSITEBUFFER_COMPONENTS = 1024;
    private final int maxContentLength;
    private O currentMessage;
    private boolean handlingOversizedMessage;
    private int maxCumulationBufferComponents = 1024;
    private ChannelHandlerContext ctx;
    private ChannelFutureListener continueResponseWriteListener;
    private boolean aggregating;
    private boolean handleIncompleteAggregateDuringClose = true;

    protected MessageAggregator(int n) {
        MessageAggregator.validateMaxContentLength(n);
        this.maxContentLength = n;
    }

    protected MessageAggregator(int n, Class<? extends I> clazz) {
        super(clazz);
        MessageAggregator.validateMaxContentLength(n);
        this.maxContentLength = n;
    }

    private static void validateMaxContentLength(int n) {
        ObjectUtil.checkPositiveOrZero((int)n, (String)"maxContentLength");
    }

    @Override
    public boolean acceptInboundMessage(Object object) {
        if (!super.acceptInboundMessage(object)) {
            return false;
        }
        if (this.isAggregated(object)) {
            return false;
        }
        if (this.isStartMessage(object)) {
            return true;
        }
        return this.aggregating && this.isContentMessage(object);
    }

    protected abstract boolean isStartMessage(I var1);

    protected abstract boolean isContentMessage(I var1);

    protected abstract boolean isLastContentMessage(C var1);

    protected abstract boolean isAggregated(I var1);

    public final int maxContentLength() {
        return this.maxContentLength;
    }

    public final int maxCumulationBufferComponents() {
        return this.maxCumulationBufferComponents;
    }

    public final void setMaxCumulationBufferComponents(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("maxCumulationBufferComponents: " + n + " (expected: >= 2)");
        }
        if (this.ctx == null) {
            this.maxCumulationBufferComponents = n;
            return;
        }
        throw new IllegalStateException("decoder properties cannot be changed once the decoder is added to a pipeline.");
    }

    @Deprecated
    public final boolean isHandlingOversizedMessage() {
        return this.handlingOversizedMessage;
    }

    protected final ChannelHandlerContext ctx() {
        if (this.ctx == null) {
            throw new IllegalStateException("not added to a pipeline yet");
        }
        return this.ctx;
    }

    @Override
    protected void decode(final ChannelHandlerContext channelHandlerContext, I object, List<Object> list) {
        if (this.isStartMessage(object)) {
            Object object2;
            this.aggregating = true;
            this.handlingOversizedMessage = false;
            if (this.currentMessage != null) {
                this.currentMessage.release();
                this.currentMessage = null;
                throw new MessageAggregationException();
            }
            I i = object;
            if ((object = this.newContinueResponse(i, this.maxContentLength, channelHandlerContext.pipeline())) != null) {
                object2 = this.continueResponseWriteListener;
                if (object2 == null) {
                    this.continueResponseWriteListener = object2 = new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture channelFuture) {
                            if (!channelFuture.isSuccess()) {
                                channelHandlerContext.fireExceptionCaught(channelFuture.cause());
                            }
                        }
                    };
                }
                boolean bl = this.closeAfterContinueResponse(object);
                this.handlingOversizedMessage = this.ignoreContentAfterContinueResponse(object);
                object = channelHandlerContext.writeAndFlush(object).addListener((GenericFutureListener)object2);
                if (bl) {
                    this.handleIncompleteAggregateDuringClose = false;
                    object.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    return;
                }
                if (this.handlingOversizedMessage) {
                    return;
                }
            } else if (this.isContentLengthInvalid(i, this.maxContentLength)) {
                this.invokeHandleOversizedMessage(channelHandlerContext, i);
                return;
            }
            if (i instanceof DecoderResultProvider && !((DecoderResultProvider)i).decoderResult().isSuccess()) {
                if (i instanceof ByteBufHolder) {
                    I i2 = i;
                    object2 = this.beginAggregation(i2, ((ByteBufHolder)i2).content().retain());
                } else {
                    object2 = this.beginAggregation(i, Unpooled.EMPTY_BUFFER);
                }
                this.finishAggregation0(object2);
                list.add(object2);
                return;
            }
            object2 = channelHandlerContext.alloc().compositeBuffer(this.maxCumulationBufferComponents);
            if (i instanceof ByteBufHolder) {
                MessageAggregator.appendPartialContent((CompositeByteBuf)object2, ((ByteBufHolder)i).content());
            }
            this.currentMessage = this.beginAggregation(i, (ByteBuf)object2);
            return;
        }
        if (this.isContentMessage(object)) {
            boolean bl;
            if (this.currentMessage == null) {
                return;
            }
            CompositeByteBuf compositeByteBuf = (CompositeByteBuf)this.currentMessage.content();
            object = (ByteBufHolder)object;
            if (compositeByteBuf.readableBytes() > this.maxContentLength - object.content().readableBytes()) {
                O o = this.currentMessage;
                this.invokeHandleOversizedMessage(channelHandlerContext, o);
                return;
            }
            MessageAggregator.appendPartialContent(compositeByteBuf, object.content());
            MessageAggregator messageAggregator = this;
            messageAggregator.aggregate(messageAggregator.currentMessage, object);
            if (object instanceof DecoderResultProvider) {
                DecoderResult decoderResult = ((DecoderResultProvider)object).decoderResult();
                if (!decoderResult.isSuccess()) {
                    if (this.currentMessage instanceof DecoderResultProvider) {
                        ((DecoderResultProvider)this.currentMessage).setDecoderResult(DecoderResult.failure(decoderResult.cause()));
                    }
                    bl = true;
                } else {
                    bl = this.isLastContentMessage(object);
                }
            } else {
                bl = this.isLastContentMessage(object);
            }
            if (bl) {
                MessageAggregator messageAggregator2 = this;
                messageAggregator2.finishAggregation0(messageAggregator2.currentMessage);
                list.add(this.currentMessage);
                this.currentMessage = null;
            }
            return;
        }
        throw new MessageAggregationException();
    }

    private static void appendPartialContent(CompositeByteBuf compositeByteBuf, ByteBuf byteBuf) {
        if (byteBuf.isReadable()) {
            compositeByteBuf.addComponent(true, byteBuf.retain());
        }
    }

    protected abstract boolean isContentLengthInvalid(S var1, int var2);

    protected abstract Object newContinueResponse(S var1, int var2, ChannelPipeline var3);

    protected abstract boolean closeAfterContinueResponse(Object var1);

    protected abstract boolean ignoreContentAfterContinueResponse(Object var1);

    protected abstract O beginAggregation(S var1, ByteBuf var2);

    protected void aggregate(O o, C c) {
    }

    private void finishAggregation0(O o) {
        this.aggregating = false;
        this.finishAggregation(o);
    }

    protected void finishAggregation(O o) {
    }

    private void invokeHandleOversizedMessage(ChannelHandlerContext channelHandlerContext, S s) {
        this.handlingOversizedMessage = true;
        this.currentMessage = null;
        this.handleIncompleteAggregateDuringClose = false;
        try {
            this.handleOversizedMessage(channelHandlerContext, s);
            return;
        }
        finally {
            ReferenceCountUtil.release(s);
        }
    }

    protected void handleOversizedMessage(ChannelHandlerContext channelHandlerContext, S s) {
        channelHandlerContext.fireExceptionCaught((Throwable)new TooLongFrameException("content length exceeded " + this.maxContentLength() + " bytes."));
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        if (this.currentMessage != null && !channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        if (this.aggregating && this.handleIncompleteAggregateDuringClose) {
            channelHandlerContext.fireExceptionCaught((Throwable)new PrematureChannelClosureException("Channel closed while still aggregating message"));
        }
        try {
            super.channelInactive(channelHandlerContext);
            return;
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        try {
            super.handlerRemoved(channelHandlerContext);
            return;
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    private void releaseCurrentMessage() {
        if (this.currentMessage != null) {
            this.currentMessage.release();
            this.currentMessage = null;
            this.handlingOversizedMessage = false;
            this.aggregating = false;
        }
    }
}

