/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.JZlib;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.compression.ZlibEncoder;
import io.netty.handler.codec.compression.ZlibUtil;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

public class JZlibEncoder
extends ZlibEncoder {
    private final int wrapperOverhead;
    private final Deflater z = new Deflater();
    private volatile boolean finished;
    private volatile ChannelHandlerContext ctx;
    private static final int THREAD_POOL_DELAY_SECONDS = 10;

    public JZlibEncoder() {
        this(6);
    }

    public JZlibEncoder(int n) {
        this(ZlibWrapper.ZLIB, n);
    }

    public JZlibEncoder(ZlibWrapper zlibWrapper) {
        this(zlibWrapper, 6);
    }

    public JZlibEncoder(ZlibWrapper zlibWrapper, int n) {
        this(zlibWrapper, n, 15, 8);
    }

    public JZlibEncoder(ZlibWrapper zlibWrapper, int n, int n2, int n3) {
        ObjectUtil.checkInRange((int)n, (int)0, (int)9, (String)"compressionLevel");
        ObjectUtil.checkInRange((int)n2, (int)9, (int)15, (String)"windowBits");
        ObjectUtil.checkInRange((int)n3, (int)1, (int)9, (String)"memLevel");
        ObjectUtil.checkNotNull((Object)((Object)zlibWrapper), (String)"wrapper");
        if (zlibWrapper == ZlibWrapper.ZLIB_OR_NONE) {
            throw new IllegalArgumentException("wrapper '" + (Object)((Object)ZlibWrapper.ZLIB_OR_NONE) + "' is not allowed for compression.");
        }
        if ((n = this.z.init(n, n2, n3, ZlibUtil.convertWrapperType(zlibWrapper))) != 0) {
            ZlibUtil.fail(this.z, "initialization failure", n);
        }
        this.wrapperOverhead = ZlibUtil.wrapperOverhead(zlibWrapper);
    }

    public JZlibEncoder(byte[] byArray) {
        this(6, byArray);
    }

    public JZlibEncoder(int n, byte[] byArray) {
        this(n, 15, 8, byArray);
    }

    public JZlibEncoder(int n, int n2, int n3, byte[] byArray) {
        ObjectUtil.checkInRange((int)n, (int)0, (int)9, (String)"compressionLevel");
        ObjectUtil.checkInRange((int)n2, (int)9, (int)15, (String)"windowBits");
        ObjectUtil.checkInRange((int)n3, (int)1, (int)9, (String)"memLevel");
        ObjectUtil.checkNotNull((Object)byArray, (String)"dictionary");
        n = this.z.deflateInit(n, n2, n3, JZlib.W_ZLIB);
        if (n != 0) {
            ZlibUtil.fail(this.z, "initialization failure", n);
        } else {
            n = this.z.deflateSetDictionary(byArray, byArray.length);
            if (n != 0) {
                ZlibUtil.fail(this.z, "failed to set the dictionary", n);
            }
        }
        this.wrapperOverhead = ZlibUtil.wrapperOverhead(ZlibWrapper.ZLIB);
    }

    @Override
    public ChannelFuture close() {
        JZlibEncoder jZlibEncoder = this;
        return ((ZlibEncoder)jZlibEncoder).close(jZlibEncoder.ctx().channel().newPromise());
    }

    @Override
    public ChannelFuture close(ChannelPromise channelPromise) {
        ChannelHandlerContext channelHandlerContext = this.ctx();
        EventExecutor eventExecutor = channelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            return this.finishEncode(channelHandlerContext, channelPromise);
        }
        channelHandlerContext = channelHandlerContext.newPromise();
        eventExecutor.execute(new Runnable((ChannelPromise)channelHandlerContext, channelPromise){
            final /* synthetic */ ChannelPromise val$p;
            final /* synthetic */ ChannelPromise val$promise;
            {
                this.val$p = channelPromise;
                this.val$promise = channelPromise2;
            }

            @Override
            public void run() {
                ChannelFuture channelFuture = JZlibEncoder.this.finishEncode(JZlibEncoder.this.ctx(), this.val$p);
                PromiseNotifier.cascade((Future)channelFuture, (Promise)this.val$promise);
            }
        });
        return channelHandlerContext;
    }

    private ChannelHandlerContext ctx() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException("not added to a pipeline");
        }
        return channelHandlerContext;
    }

    @Override
    public boolean isClosed() {
        return this.finished;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        if (this.finished) {
            byteBuf2.writeBytes(byteBuf);
            return;
        }
        int n = byteBuf.readableBytes();
        if (n == 0) {
            return;
        }
        try {
            int n2;
            int n3 = byteBuf.hasArray();
            this.z.avail_in = n;
            if (n3 != 0) {
                this.z.next_in = byteBuf.array();
                this.z.next_in_index = byteBuf.arrayOffset() + byteBuf.readerIndex();
            } else {
                byte[] byArray = new byte[n];
                ByteBuf byteBuf3 = byteBuf;
                byteBuf3.getBytes(byteBuf3.readerIndex(), byArray);
                this.z.next_in = byArray;
                this.z.next_in_index = 0;
            }
            n3 = this.z.next_in_index;
            n = (int)Math.ceil((double)n * 1.001) + 12 + this.wrapperOverhead;
            byteBuf2.ensureWritable(n);
            this.z.avail_out = n;
            this.z.next_out = byteBuf2.array();
            n = this.z.next_out_index = byteBuf2.arrayOffset() + byteBuf2.writerIndex();
            try {
                n2 = this.z.deflate(2);
            }
            finally {
                byteBuf.skipBytes(this.z.next_in_index - n3);
            }
            if (n2 != 0) {
                ZlibUtil.fail(this.z, "compression failure", n2);
            }
            if ((n = this.z.next_out_index - n) > 0) {
                ByteBuf byteBuf4 = byteBuf2;
                byteBuf4.writerIndex(byteBuf4.writerIndex() + n);
            }
            return;
        }
        finally {
            this.z.next_in = null;
            this.z.next_out = null;
        }
    }

    public void close(final ChannelHandlerContext channelHandlerContext, final ChannelPromise channelPromise) {
        ChannelHandlerContext channelHandlerContext2 = channelHandlerContext;
        ChannelFuture channelFuture = this.finishEncode(channelHandlerContext2, channelHandlerContext2.newPromise());
        if (!channelFuture.isDone()) {
            ScheduledFuture scheduledFuture = channelHandlerContext.executor().schedule(new Runnable(){

                @Override
                public void run() {
                    if (!channelPromise.isDone()) {
                        channelHandlerContext.close(channelPromise);
                    }
                }
            }, 10L, TimeUnit.SECONDS);
            channelFuture.addListener((GenericFutureListener)new ChannelFutureListener((Future)scheduledFuture, channelPromise, channelHandlerContext){
                final /* synthetic */ Future val$future;
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ ChannelHandlerContext val$ctx;
                {
                    this.val$future = future;
                    this.val$promise = channelPromise;
                    this.val$ctx = channelHandlerContext;
                }

                public void operationComplete(ChannelFuture channelFuture) {
                    this.val$future.cancel(true);
                    if (!this.val$promise.isDone()) {
                        this.val$ctx.close(this.val$promise);
                    }
                }
            });
            return;
        }
        channelHandlerContext.close(channelPromise);
    }

    private ChannelFuture finishEncode(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        Object object;
        if (this.finished) {
            channelPromise.setSuccess();
            return channelPromise;
        }
        this.finished = true;
        try {
            this.z.next_in = EmptyArrays.EMPTY_BYTES;
            this.z.next_in_index = 0;
            this.z.avail_in = 0;
            object = new byte[32];
            this.z.next_out = object;
            this.z.next_out_index = 0;
            this.z.avail_out = ((byte[])object).length;
            int n = this.z.deflate(4);
            if (n != 0 && n != 1) {
                channelPromise.setFailure((Throwable)ZlibUtil.deflaterException(this.z, "compression failure", n));
                channelHandlerContext = channelPromise;
                return channelHandlerContext;
            }
            object = this.z.next_out_index != 0 ? (Object)Unpooled.wrappedBuffer((byte[])object, (int)0, (int)this.z.next_out_index) : (Object)Unpooled.EMPTY_BUFFER;
        }
        finally {
            this.z.deflateEnd();
            this.z.next_in = null;
            this.z.next_out = null;
        }
        return channelHandlerContext.writeAndFlush(object, channelPromise);
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }
}

