/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;

public class DefaultHttp2LocalFlowController
implements Http2LocalFlowController {
    public static final float DEFAULT_WINDOW_UPDATE_RATIO = 0.5f;
    private final Http2Connection connection;
    private final Http2Connection.PropertyKey stateKey;
    private Http2FrameWriter frameWriter;
    private ChannelHandlerContext ctx;
    private float windowUpdateRatio;
    private int initialWindowSize = 65535;
    private static final FlowState REDUCED_FLOW_STATE = new FlowState(){

        @Override
        public final int windowSize() {
            return 0;
        }

        @Override
        public final int initialWindowSize() {
            return 0;
        }

        @Override
        public final void window(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void incrementInitialStreamWindow(int n) {
        }

        @Override
        public final boolean writeWindowUpdateIfNeeded() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean consumeBytes(int n) {
            return false;
        }

        @Override
        public final int unconsumedBytes() {
            return 0;
        }

        @Override
        public final float windowUpdateRatio() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void windowUpdateRatio(float f) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void receiveFlowControlledFrame(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void incrementFlowControlWindows(int n) {
        }

        @Override
        public final void endOfStream(boolean bl) {
            throw new UnsupportedOperationException();
        }
    };

    public DefaultHttp2LocalFlowController(Http2Connection http2Connection) {
        this(http2Connection, 0.5f, false);
    }

    public DefaultHttp2LocalFlowController(Http2Connection http2Connection, float f, boolean bl) {
        this.connection = (Http2Connection)ObjectUtil.checkNotNull((Object)http2Connection, (String)"connection");
        this.windowUpdateRatio(f);
        this.stateKey = http2Connection.newKey();
        DefaultState defaultState = bl ? new AutoRefillState(http2Connection.connectionStream(), this.initialWindowSize) : new DefaultState(http2Connection.connectionStream(), this.initialWindowSize);
        http2Connection.connectionStream().setProperty(this.stateKey, defaultState);
        http2Connection.addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamAdded(Http2Stream http2Stream) {
                http2Stream.setProperty(DefaultHttp2LocalFlowController.this.stateKey, REDUCED_FLOW_STATE);
            }

            @Override
            public void onStreamActive(Http2Stream http2Stream) {
                http2Stream.setProperty(DefaultHttp2LocalFlowController.this.stateKey, new DefaultState(http2Stream, DefaultHttp2LocalFlowController.this.initialWindowSize));
            }

            @Override
            public void onStreamClosed(Http2Stream http2Stream) {
                try {
                    FlowState flowState = DefaultHttp2LocalFlowController.this.state(http2Stream);
                    int n = flowState.unconsumedBytes();
                    if (DefaultHttp2LocalFlowController.this.ctx != null && n > 0 && DefaultHttp2LocalFlowController.this.consumeAllBytes(flowState, n)) {
                        DefaultHttp2LocalFlowController.this.ctx.flush();
                    }
                    return;
                }
                catch (Http2Exception http2Exception) {
                    Http2Exception http2Exception2 = http2Exception;
                    PlatformDependent.throwException((Throwable)http2Exception);
                    return;
                }
                finally {
                    http2Stream.setProperty(DefaultHttp2LocalFlowController.this.stateKey, REDUCED_FLOW_STATE);
                }
            }
        });
    }

    @Override
    public DefaultHttp2LocalFlowController frameWriter(Http2FrameWriter http2FrameWriter) {
        this.frameWriter = (Http2FrameWriter)ObjectUtil.checkNotNull((Object)http2FrameWriter, (String)"frameWriter");
        return this;
    }

    @Override
    public void channelHandlerContext(ChannelHandlerContext channelHandlerContext) {
        this.ctx = (ChannelHandlerContext)ObjectUtil.checkNotNull((Object)channelHandlerContext, (String)"ctx");
    }

    @Override
    public void initialWindowSize(int n) {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        int n2 = n - this.initialWindowSize;
        this.initialWindowSize = n;
        WindowUpdateVisitor windowUpdateVisitor = new WindowUpdateVisitor(n2);
        this.connection.forEachActiveStream(windowUpdateVisitor);
        windowUpdateVisitor.throwIfError();
    }

    @Override
    public int initialWindowSize() {
        return this.initialWindowSize;
    }

    @Override
    public int windowSize(Http2Stream http2Stream) {
        return this.state(http2Stream).windowSize();
    }

    @Override
    public int initialWindowSize(Http2Stream http2Stream) {
        return this.state(http2Stream).initialWindowSize();
    }

    @Override
    public void incrementWindowSize(Http2Stream object, int n) {
        assert (this.ctx != null && this.ctx.executor().inEventLoop());
        object = this.state((Http2Stream)object);
        object.incrementInitialStreamWindow(n);
        object.writeWindowUpdateIfNeeded();
    }

    @Override
    public boolean consumeBytes(Http2Stream http2Stream, int n) {
        assert (this.ctx != null && this.ctx.executor().inEventLoop());
        ObjectUtil.checkPositiveOrZero((int)n, (String)"numBytes");
        if (n == 0) {
            return false;
        }
        if (http2Stream != null && !DefaultHttp2LocalFlowController.isClosed(http2Stream)) {
            if (http2Stream.id() == 0) {
                throw new UnsupportedOperationException("Returning bytes for the connection window is not supported");
            }
            DefaultHttp2LocalFlowController defaultHttp2LocalFlowController = this;
            return defaultHttp2LocalFlowController.consumeAllBytes(defaultHttp2LocalFlowController.state(http2Stream), n);
        }
        return false;
    }

    private boolean consumeAllBytes(FlowState flowState, int n) {
        return this.connectionState().consumeBytes(n) | flowState.consumeBytes(n);
    }

    @Override
    public int unconsumedBytes(Http2Stream http2Stream) {
        return this.state(http2Stream).unconsumedBytes();
    }

    private static void checkValidRatio(float f) {
        if (Double.compare(f, 0.0) <= 0 || Double.compare(f, 1.0) >= 0) {
            throw new IllegalArgumentException("Invalid ratio: " + f);
        }
    }

    public void windowUpdateRatio(float f) {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        DefaultHttp2LocalFlowController.checkValidRatio(f);
        this.windowUpdateRatio = f;
    }

    public float windowUpdateRatio() {
        return this.windowUpdateRatio;
    }

    public void windowUpdateRatio(Http2Stream object, float f) {
        assert (this.ctx != null && this.ctx.executor().inEventLoop());
        DefaultHttp2LocalFlowController.checkValidRatio(f);
        object = this.state((Http2Stream)object);
        object.windowUpdateRatio(f);
        object.writeWindowUpdateIfNeeded();
    }

    public float windowUpdateRatio(Http2Stream http2Stream) {
        return this.state(http2Stream).windowUpdateRatio();
    }

    @Override
    public void receiveFlowControlledFrame(Http2Stream object, ByteBuf byteBuf, int n, boolean bl) {
        assert (this.ctx != null && this.ctx.executor().inEventLoop());
        int n2 = byteBuf.readableBytes() + n;
        FlowState flowState = this.connectionState();
        flowState.receiveFlowControlledFrame(n2);
        if (object != null && !DefaultHttp2LocalFlowController.isClosed((Http2Stream)object)) {
            object = this.state((Http2Stream)object);
            object.endOfStream(bl);
            object.receiveFlowControlledFrame(n2);
            return;
        }
        if (n2 > 0) {
            flowState.consumeBytes(n2);
        }
    }

    private FlowState connectionState() {
        return (FlowState)this.connection.connectionStream().getProperty(this.stateKey);
    }

    private FlowState state(Http2Stream http2Stream) {
        return (FlowState)http2Stream.getProperty(this.stateKey);
    }

    private static boolean isClosed(Http2Stream http2Stream) {
        return http2Stream.state() == Http2Stream.State.CLOSED;
    }

    private final class WindowUpdateVisitor
    implements Http2StreamVisitor {
        private Http2Exception.CompositeStreamException compositeException;
        private final int delta;

        WindowUpdateVisitor(int n) {
            this.delta = n;
        }

        @Override
        public final boolean visit(Http2Stream object) {
            try {
                object = DefaultHttp2LocalFlowController.this.state((Http2Stream)object);
                object.incrementFlowControlWindows(this.delta);
                object.incrementInitialStreamWindow(this.delta);
            }
            catch (Http2Exception.StreamException streamException) {
                if (this.compositeException == null) {
                    this.compositeException = new Http2Exception.CompositeStreamException(streamException.error(), 4);
                }
                this.compositeException.add(streamException);
            }
            return true;
        }

        public final void throwIfError() {
            if (this.compositeException != null) {
                throw this.compositeException;
            }
        }
    }

    private static interface FlowState {
        public int windowSize();

        public int initialWindowSize();

        public void window(int var1);

        public void incrementInitialStreamWindow(int var1);

        public boolean writeWindowUpdateIfNeeded();

        public boolean consumeBytes(int var1);

        public int unconsumedBytes();

        public float windowUpdateRatio();

        public void windowUpdateRatio(float var1);

        public void receiveFlowControlledFrame(int var1);

        public void incrementFlowControlWindows(int var1);

        public void endOfStream(boolean var1);
    }

    private class DefaultState
    implements FlowState {
        private final Http2Stream stream;
        private int window;
        private int processedWindow;
        private int initialStreamWindowSize;
        private float streamWindowUpdateRatio;
        private int lowerBound;
        private boolean endOfStream;

        DefaultState(Http2Stream http2Stream, int n) {
            this.stream = http2Stream;
            this.window(n);
            this.streamWindowUpdateRatio = DefaultHttp2LocalFlowController.this.windowUpdateRatio;
        }

        @Override
        public void window(int n) {
            assert (DefaultHttp2LocalFlowController.this.ctx == null || DefaultHttp2LocalFlowController.this.ctx.executor().inEventLoop());
            DefaultState defaultState = this;
            defaultState.processedWindow = this.initialStreamWindowSize = n;
            defaultState.window = this.initialStreamWindowSize;
        }

        @Override
        public int windowSize() {
            return this.window;
        }

        @Override
        public int initialWindowSize() {
            return this.initialStreamWindowSize;
        }

        @Override
        public void endOfStream(boolean bl) {
            this.endOfStream = bl;
        }

        @Override
        public float windowUpdateRatio() {
            return this.streamWindowUpdateRatio;
        }

        @Override
        public void windowUpdateRatio(float f) {
            assert (DefaultHttp2LocalFlowController.this.ctx == null || DefaultHttp2LocalFlowController.this.ctx.executor().inEventLoop());
            this.streamWindowUpdateRatio = f;
        }

        @Override
        public void incrementInitialStreamWindow(int n) {
            n = (int)Math.min(Integer.MAX_VALUE, Math.max(0L, (long)this.initialStreamWindowSize + (long)n));
            this.initialStreamWindowSize += (n -= this.initialStreamWindowSize);
        }

        @Override
        public void incrementFlowControlWindows(int n) {
            if (n > 0 && this.window > Integer.MAX_VALUE - n) {
                throw Http2Exception.streamError(this.stream.id(), Http2Error.FLOW_CONTROL_ERROR, "Flow control window overflowed for stream: %d", this.stream.id());
            }
            this.window += n;
            this.processedWindow += n;
            this.lowerBound = Math.min(n, 0);
        }

        @Override
        public void receiveFlowControlledFrame(int n) {
            assert (n >= 0);
            this.window -= n;
            if (this.window < this.lowerBound) {
                throw Http2Exception.streamError(this.stream.id(), Http2Error.FLOW_CONTROL_ERROR, "Flow control window exceeded for stream: %d", this.stream.id());
            }
        }

        private void returnProcessedBytes(int n) {
            if (this.processedWindow - n < this.window) {
                throw Http2Exception.streamError(this.stream.id(), Http2Error.INTERNAL_ERROR, "Attempting to return too many bytes for stream %d", this.stream.id());
            }
            this.processedWindow -= n;
        }

        @Override
        public boolean consumeBytes(int n) {
            this.returnProcessedBytes(n);
            return this.writeWindowUpdateIfNeeded();
        }

        @Override
        public int unconsumedBytes() {
            return this.processedWindow - this.window;
        }

        @Override
        public boolean writeWindowUpdateIfNeeded() {
            if (this.endOfStream || this.initialStreamWindowSize <= 0 || DefaultHttp2LocalFlowController.isClosed(this.stream)) {
                return false;
            }
            int n = (int)((float)this.initialStreamWindowSize * this.streamWindowUpdateRatio);
            if (this.processedWindow <= n) {
                this.writeWindowUpdate();
                return true;
            }
            return false;
        }

        private void writeWindowUpdate() {
            int n = this.initialStreamWindowSize - this.processedWindow;
            try {
                this.incrementFlowControlWindows(n);
            }
            catch (Throwable throwable) {
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, throwable, "Attempting to return too many bytes for stream %d", this.stream.id());
            }
            DefaultHttp2LocalFlowController.this.frameWriter.writeWindowUpdate(DefaultHttp2LocalFlowController.this.ctx, this.stream.id(), n, DefaultHttp2LocalFlowController.this.ctx.newPromise());
        }
    }

    private final class AutoRefillState
    extends DefaultState {
        AutoRefillState(Http2Stream http2Stream, int n) {
            super(http2Stream, n);
        }

        @Override
        public final void receiveFlowControlledFrame(int n) {
            super.receiveFlowControlledFrame(n);
            super.consumeBytes(n);
        }

        @Override
        public final boolean consumeBytes(int n) {
            return false;
        }
    }
}

