/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2Error;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ThrowableUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Http2Exception
extends Exception {
    private static final long serialVersionUID = -6941186345430164209L;
    private final Http2Error error;
    private final ShutdownHint shutdownHint;

    public Http2Exception(Http2Error http2Error) {
        this(http2Error, ShutdownHint.HARD_SHUTDOWN);
    }

    public Http2Exception(Http2Error http2Error, ShutdownHint shutdownHint) {
        this.error = (Http2Error)((Object)ObjectUtil.checkNotNull((Object)((Object)http2Error), (String)"error"));
        this.shutdownHint = (ShutdownHint)((Object)ObjectUtil.checkNotNull((Object)((Object)shutdownHint), (String)"shutdownHint"));
    }

    public Http2Exception(Http2Error http2Error, String string) {
        this(http2Error, string, ShutdownHint.HARD_SHUTDOWN);
    }

    public Http2Exception(Http2Error http2Error, String string, ShutdownHint shutdownHint) {
        super(string);
        this.error = (Http2Error)((Object)ObjectUtil.checkNotNull((Object)((Object)http2Error), (String)"error"));
        this.shutdownHint = (ShutdownHint)((Object)ObjectUtil.checkNotNull((Object)((Object)shutdownHint), (String)"shutdownHint"));
    }

    public Http2Exception(Http2Error http2Error, String string, Throwable throwable) {
        this(http2Error, string, throwable, ShutdownHint.HARD_SHUTDOWN);
    }

    public Http2Exception(Http2Error http2Error, String string, Throwable throwable, ShutdownHint shutdownHint) {
        super(string, throwable);
        this.error = (Http2Error)((Object)ObjectUtil.checkNotNull((Object)((Object)http2Error), (String)"error"));
        this.shutdownHint = (ShutdownHint)((Object)ObjectUtil.checkNotNull((Object)((Object)shutdownHint), (String)"shutdownHint"));
    }

    static Http2Exception newStatic(Http2Error object, String string, ShutdownHint shutdownHint, Class<?> clazz, String string2) {
        object = PlatformDependent.javaVersion() >= 7 ? new StacklessHttp2Exception((Http2Error)((Object)object), string, shutdownHint, true) : new StacklessHttp2Exception((Http2Error)((Object)object), string, shutdownHint);
        return (Http2Exception)ThrowableUtil.unknownStackTrace((Throwable)object, clazz, (String)string2);
    }

    private Http2Exception(Http2Error http2Error, String string, ShutdownHint shutdownHint, boolean bl) {
        super(string, null, false, true);
        assert (bl);
        this.error = (Http2Error)((Object)ObjectUtil.checkNotNull((Object)((Object)http2Error), (String)"error"));
        this.shutdownHint = (ShutdownHint)((Object)ObjectUtil.checkNotNull((Object)((Object)shutdownHint), (String)"shutdownHint"));
    }

    public Http2Error error() {
        return this.error;
    }

    public ShutdownHint shutdownHint() {
        return this.shutdownHint;
    }

    public static Http2Exception connectionError(Http2Error http2Error, String string, Object ... objectArray) {
        return new Http2Exception(http2Error, Http2Exception.formatErrorMessage(string, objectArray));
    }

    public static Http2Exception connectionError(Http2Error http2Error, Throwable throwable, String string, Object ... objectArray) {
        return new Http2Exception(http2Error, Http2Exception.formatErrorMessage(string, objectArray), throwable);
    }

    public static Http2Exception closedStreamError(Http2Error http2Error, String string, Object ... objectArray) {
        return new ClosedStreamCreationException(http2Error, Http2Exception.formatErrorMessage(string, objectArray));
    }

    public static Http2Exception streamError(int n, Http2Error http2Error, String string, Object ... objectArray) {
        if (n == 0) {
            return Http2Exception.connectionError(http2Error, string, objectArray);
        }
        return new StreamException(n, http2Error, Http2Exception.formatErrorMessage(string, objectArray));
    }

    public static Http2Exception streamError(int n, Http2Error http2Error, Throwable throwable, String string, Object ... objectArray) {
        if (n == 0) {
            return Http2Exception.connectionError(http2Error, throwable, string, objectArray);
        }
        return new StreamException(n, http2Error, Http2Exception.formatErrorMessage(string, objectArray), throwable);
    }

    public static Http2Exception headerListSizeError(int n, Http2Error http2Error, boolean bl, String string, Object ... objectArray) {
        if (n == 0) {
            return Http2Exception.connectionError(http2Error, string, objectArray);
        }
        return new HeaderListSizeException(n, http2Error, Http2Exception.formatErrorMessage(string, objectArray), bl);
    }

    private static String formatErrorMessage(String string, Object[] objectArray) {
        if (string == null) {
            if (objectArray == null || objectArray.length == 0) {
                return "Unexpected error";
            }
            return "Unexpected error: " + Arrays.toString(objectArray);
        }
        return String.format(string, objectArray);
    }

    public static boolean isStreamError(Http2Exception http2Exception) {
        return http2Exception instanceof StreamException;
    }

    public static int streamId(Http2Exception http2Exception) {
        if (Http2Exception.isStreamError(http2Exception)) {
            return ((StreamException)http2Exception).streamId();
        }
        return 0;
    }

    private static final class StacklessHttp2Exception
    extends Http2Exception {
        private static final long serialVersionUID = 1077888485687219443L;

        StacklessHttp2Exception(Http2Error http2Error, String string, ShutdownHint shutdownHint) {
            super(http2Error, string, shutdownHint);
        }

        StacklessHttp2Exception(Http2Error http2Error, String string, ShutdownHint shutdownHint, boolean bl) {
            super(http2Error, string, shutdownHint, bl);
        }

        @Override
        public final Throwable fillInStackTrace() {
            return this;
        }
    }

    public static final class CompositeStreamException
    extends Http2Exception
    implements Iterable<StreamException> {
        private static final long serialVersionUID = 7091134858213711015L;
        private final List<StreamException> exceptions;

        public CompositeStreamException(Http2Error http2Error, int n) {
            super(http2Error, ShutdownHint.NO_SHUTDOWN);
            this.exceptions = new ArrayList<StreamException>(n);
        }

        public final void add(StreamException streamException) {
            this.exceptions.add(streamException);
        }

        @Override
        public final Iterator<StreamException> iterator() {
            return this.exceptions.iterator();
        }
    }

    public static final class HeaderListSizeException
    extends StreamException {
        private static final long serialVersionUID = -8807603212183882637L;
        private final boolean decode;

        HeaderListSizeException(int n, Http2Error http2Error, String string, boolean bl) {
            super(n, http2Error, string);
            this.decode = bl;
        }

        public final boolean duringDecode() {
            return this.decode;
        }
    }

    public static class StreamException
    extends Http2Exception {
        private static final long serialVersionUID = 602472544416984384L;
        private final int streamId;

        StreamException(int n, Http2Error http2Error, String string) {
            super(http2Error, string, ShutdownHint.NO_SHUTDOWN);
            this.streamId = n;
        }

        StreamException(int n, Http2Error http2Error, String string, Throwable throwable) {
            super(http2Error, string, throwable, ShutdownHint.NO_SHUTDOWN);
            this.streamId = n;
        }

        public int streamId() {
            return this.streamId;
        }
    }

    public static final class ClosedStreamCreationException
    extends Http2Exception {
        private static final long serialVersionUID = -6746542974372246206L;

        public ClosedStreamCreationException(Http2Error http2Error) {
            super(http2Error);
        }

        public ClosedStreamCreationException(Http2Error http2Error, String string) {
            super(http2Error, string);
        }

        public ClosedStreamCreationException(Http2Error http2Error, String string, Throwable throwable) {
            super(http2Error, string, throwable);
        }
    }

    public static enum ShutdownHint {
        NO_SHUTDOWN,
        GRACEFUL_SHUTDOWN,
        HARD_SHUTDOWN;

    }
}

