/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.joran.spi.SaxEventInterpreter;
import ch.qos.logback.core.joran.spi.SimpleRuleStore;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ConfigurationEvent;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.StatusUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.xml.sax.InputSource;

public abstract class GenericXMLConfigurator
extends ContextAwareBase {
    protected SaxEventInterpreter saxEventInterpreter;
    protected ModelInterpretationContext modelInterpretationContext;
    private RuleStore ruleStore;

    public ModelInterpretationContext getModelInterpretationContext() {
        return this.modelInterpretationContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void doConfigure(URL object) {
        Object object2 = null;
        try {
            GenericXMLConfigurator.informContextOfURLUsedForConfiguration(this.getContext(), (URL)object);
            URLConnection uRLConnection = ((URL)object).openConnection();
            uRLConnection.setUseCaches(false);
            object2 = uRLConnection.getInputStream();
            this.doConfigure((InputStream)object2, ((URL)object).toExternalForm());
            if (object2 == null) return;
        }
        catch (IOException iOException) {
            try {
                object = "Could not open URL [" + String.valueOf(object) + "].";
                this.addError((String)object, iOException);
                throw new JoranException((String)object, iOException);
            }
            catch (Throwable throwable) {
                if (object2 == null) throw throwable;
                try {
                    ((InputStream)object2).close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    object2 = "Could not close input stream";
                    this.addError((String)object2, iOException2);
                    throw new JoranException((String)object2, iOException2);
                }
            }
        }
        try {
            ((InputStream)object2).close();
            return;
        }
        catch (IOException iOException) {
            object = "Could not close input stream";
            this.addError((String)object, iOException);
            throw new JoranException((String)object, iOException);
        }
    }

    public final void doConfigure(String string) {
        this.doConfigure(new File(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void doConfigure(File object) {
        FileInputStream fileInputStream = null;
        try {
            URL uRL = ((File)object).toURI().toURL();
            GenericXMLConfigurator.informContextOfURLUsedForConfiguration(this.getContext(), uRL);
            fileInputStream = new FileInputStream((File)object);
            this.doConfigure(fileInputStream, uRL.toExternalForm());
        }
        catch (IOException iOException) {
            try {
                String string = "Could not open [" + ((File)object).getPath() + "].";
                this.addError(string, iOException);
                throw new JoranException(string, iOException);
            }
            catch (Throwable throwable) {
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    object = "Could not close [" + ((File)object).getName() + "].";
                    this.addError((String)object, iOException2);
                    throw new JoranException((String)object, iOException2);
                }
            }
        }
        try {
            fileInputStream.close();
            return;
        }
        catch (IOException iOException) {
            String string = "Could not close [" + ((File)object).getName() + "].";
            this.addError(string, iOException);
            throw new JoranException(string, iOException);
        }
    }

    public static void informContextOfURLUsedForConfiguration(Context context, URL uRL) {
        ConfigurationWatchListUtil.setMainWatchURL(context, uRL);
    }

    public final void doConfigure(InputStream inputStream) {
        this.doConfigure(new InputSource(inputStream));
    }

    public final void doConfigure(InputStream object, String string) {
        object = new InputSource((InputStream)object);
        ((InputSource)object).setSystemId(string);
        this.doConfigure((InputSource)object);
    }

    protected abstract void addElementSelectorAndActionAssociations(RuleStore var1);

    protected abstract void setImplicitRuleSupplier(SaxEventInterpreter var1);

    protected void addDefaultNestedComponentRegistryRules(DefaultNestedComponentRegistry defaultNestedComponentRegistry) {
    }

    protected ElementPath initialElementPath() {
        return new ElementPath();
    }

    protected void buildSaxEventInterpreter(List<SaxEvent> object) {
        RuleStore ruleStore = this.getRuleStore();
        this.addElementSelectorAndActionAssociations(ruleStore);
        this.saxEventInterpreter = new SaxEventInterpreter(this.context, ruleStore, this.initialElementPath(), (List<SaxEvent>)object);
        object = this.saxEventInterpreter.getSaxEventInterpretationContext();
        ((ContextAwareBase)object).setContext(this.context);
        GenericXMLConfigurator genericXMLConfigurator = this;
        genericXMLConfigurator.setImplicitRuleSupplier(genericXMLConfigurator.saxEventInterpreter);
    }

    public RuleStore getRuleStore() {
        if (this.ruleStore == null) {
            this.ruleStore = new SimpleRuleStore(this.context);
        }
        return this.ruleStore;
    }

    protected void buildModelInterpretationContext() {
        this.modelInterpretationContext = new ModelInterpretationContext(this.context);
        GenericXMLConfigurator genericXMLConfigurator = this;
        genericXMLConfigurator.addDefaultNestedComponentRegistryRules(genericXMLConfigurator.modelInterpretationContext.getDefaultNestedComponentRegistry());
    }

    public final void doConfigure(InputSource object) {
        this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationStartedEvent(this));
        long l = System.currentTimeMillis();
        object = this.populateSaxEventRecorder((InputSource)object);
        Object object2 = ((SaxEventRecorder)object).getSaxEventList();
        if (object2.isEmpty()) {
            this.addWarn("Empty sax event list");
            return;
        }
        if ((object = this.buildModelFromSaxEventList(((SaxEventRecorder)object).getSaxEventList())) == null) {
            this.addError("Could not find valid configuration instructions. Exiting.");
            return;
        }
        this.sanityCheck((Model)object);
        this.processModel((Model)object);
        object2 = new StatusUtil(this.context);
        if (((StatusUtil)object2).noXMLParsingErrorsOccurred(l)) {
            this.addInfo("Registering current configuration as safe fallback point");
            this.registerSafeConfiguration((Model)object);
        }
        this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationEndedEvent(this));
    }

    public SaxEventRecorder populateSaxEventRecorder(InputSource inputSource) {
        SaxEventRecorder saxEventRecorder = new SaxEventRecorder(this.context);
        saxEventRecorder.recordEvents(inputSource);
        return saxEventRecorder;
    }

    public Model buildModelFromSaxEventList(List<SaxEvent> object) {
        this.buildSaxEventInterpreter((List<SaxEvent>)object);
        this.playSaxEvents();
        object = this.saxEventInterpreter.getSaxEventInterpretationContext().peekModel();
        return object;
    }

    private void playSaxEvents() {
        this.saxEventInterpreter.getEventPlayer().play();
    }

    public void processModel(Model model) {
        this.buildModelInterpretationContext();
        this.modelInterpretationContext.setTopModel(model);
        this.modelInterpretationContext.setConfiguratorHint(this);
        DefaultProcessor defaultProcessor = new DefaultProcessor(this.context, this.modelInterpretationContext);
        this.addModelHandlerAssociations(defaultProcessor);
        Object object = this.context.getConfigurationLock();
        synchronized (object) {
            defaultProcessor.process(model);
            return;
        }
    }

    protected void sanityCheck(Model model) {
    }

    protected void addModelHandlerAssociations(DefaultProcessor defaultProcessor) {
    }

    public void registerSafeConfiguration(Model model) {
        this.context.putObject("SAFE_JORAN_CONFIGURATION", model);
    }

    public Model recallSafeConfiguration() {
        return (Model)this.context.getObject("SAFE_JORAN_CONFIGURATION");
    }
}

