/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.joran.spi.DefaultClass;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.util.StringToObjectConverter;
import ch.qos.logback.core.joran.util.beans.BeanDescription;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.joran.util.beans.BeanUtil;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.AggregationType;
import ch.qos.logback.core.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AggregationAssessor
extends ContextAwareBase {
    protected final Class<?> objClass;
    protected final BeanDescription beanDescription;

    public AggregationAssessor(BeanDescriptionCache beanDescriptionCache, Class clazz) {
        this.objClass = clazz;
        this.beanDescription = beanDescriptionCache.getBeanDescription(clazz);
    }

    public AggregationType computeAggregationType(String string) {
        Object object = StringUtil.capitalizeFirstLetter(string);
        if ((object = this.findAdderMethod((String)object)) != null) {
            object = this.computeRawAggregationType((Method)object);
            switch (1.$SwitchMap$ch$qos$logback$core$util$AggregationType[((Enum)object).ordinal()]) {
                case 1: {
                    return AggregationType.NOT_FOUND;
                }
                case 2: {
                    return AggregationType.AS_BASIC_PROPERTY_COLLECTION;
                }
                case 3: {
                    return AggregationType.AS_COMPLEX_PROPERTY_COLLECTION;
                }
                case 4: 
                case 5: {
                    this.addError("Unexpected AggregationType " + String.valueOf(object));
                }
            }
        }
        if ((object = this.findSetterMethod(string)) != null) {
            return this.computeRawAggregationType((Method)object);
        }
        return AggregationType.NOT_FOUND;
    }

    public Method findAdderMethod(String string) {
        string = BeanUtil.toLowerCamelCase(string);
        return this.beanDescription.getAdder(string);
    }

    public Method findSetterMethod(String string) {
        string = BeanUtil.toLowerCamelCase(string);
        return this.beanDescription.getSetter(string);
    }

    private AggregationType computeRawAggregationType(Method genericDeclaration) {
        if ((genericDeclaration = this.getParameterClassForMethod((Method)genericDeclaration)) == null) {
            return AggregationType.NOT_FOUND;
        }
        if (StringToObjectConverter.canBeBuiltFromSimpleString(genericDeclaration)) {
            return AggregationType.AS_BASIC_PROPERTY;
        }
        return AggregationType.AS_COMPLEX_PROPERTY;
    }

    private Class<?> getParameterClassForMethod(Method classArray) {
        if (classArray == null) {
            return null;
        }
        if ((classArray = classArray.getParameterTypes()).length != 1) {
            return null;
        }
        return classArray[0];
    }

    public Class<?> getClassNameViaImplicitRules(String string, AggregationType object, DefaultNestedComponentRegistry clazz) {
        if ((clazz = ((DefaultNestedComponentRegistry)((Object)clazz)).findDefaultComponentType(this.objClass, string)) != null) {
            return clazz;
        }
        if ((object = this.getRelevantMethod(string, (AggregationType)((Object)object))) == null) {
            return null;
        }
        clazz = this.getDefaultClassNameByAnnonation(string, (Method)object);
        if (clazz != null) {
            return clazz;
        }
        return this.getByConcreteType(string, (Method)object);
    }

    <T extends Annotation> T getAnnotation(String string, Class<T> clazz, Method method) {
        if (method != null) {
            return method.getAnnotation(clazz);
        }
        return null;
    }

    Class<?> getDefaultClassNameByAnnonation(String object, Method method) {
        if ((object = this.getAnnotation((String)object, DefaultClass.class, method)) != null) {
            return object.value();
        }
        return null;
    }

    Method getRelevantMethod(String object, AggregationType aggregationType) {
        if (aggregationType == AggregationType.AS_COMPLEX_PROPERTY_COLLECTION) {
            object = this.findAdderMethod((String)object);
        } else if (aggregationType == AggregationType.AS_COMPLEX_PROPERTY) {
            object = this.findSetterMethod((String)object);
        } else {
            throw new IllegalStateException(String.valueOf((Object)aggregationType) + " not allowed here");
        }
        return object;
    }

    Class<?> getByConcreteType(String clazz, Method method) {
        clazz = this.getParameterClassForMethod(method);
        if (clazz == null) {
            return null;
        }
        boolean bl = this.isUnequivocallyInstantiable(clazz);
        if (bl) {
            return clazz;
        }
        return null;
    }

    private boolean isUnequivocallyInstantiable(Class<?> clazz) {
        if (clazz.isInterface()) {
            return false;
        }
        try {
            clazz = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return clazz != null;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
    }
}

