/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.model.ComponentModel;
import ch.qos.logback.core.model.EventEvaluatorModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.NamedComponentModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Map;

public class EventEvaluatorModelHandler
extends ModelHandlerBase {
    EventEvaluator<?> evaluator;
    boolean inError = false;

    public EventEvaluatorModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new EventEvaluatorModelHandler(context);
    }

    protected Class<EventEvaluatorModel> getSupportedModelClass() {
        return EventEvaluatorModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        String string;
        String string2 = ((ComponentModel)(model = (EventEvaluatorModel)model)).getClassName();
        if (OptionHelper.isNullOrEmptyOrAllSpaces(string2)) {
            string = this.defaultClassName(modelInterpretationContext, (EventEvaluatorModel)model);
            if (OptionHelper.isNullOrEmptyOrAllSpaces(string)) {
                this.inError = true;
                this.addError("Mandatory \"class\" attribute missing for <evaluator>");
                this.addError("No default classname could be found.");
                return;
            }
            this.addInfo("Assuming default evaluator class [" + string + "]");
            string2 = string;
        } else {
            string2 = modelInterpretationContext.getImport(string2);
        }
        string = modelInterpretationContext.subst(((NamedComponentModel)model).getName());
        try {
            this.evaluator = (EventEvaluator)OptionHelper.instantiateByClassName(string2, EventEvaluator.class, this.context);
            this.evaluator.setContext(this.context);
            this.evaluator.setName(string);
            modelInterpretationContext.pushObject(this.evaluator);
            return;
        }
        catch (Exception exception) {
            this.inError = true;
            this.addError("Could not create evaluator of type " + string2 + "].", exception);
            return;
        }
    }

    private String defaultClassName(ModelInterpretationContext object, EventEvaluatorModel eventEvaluatorModel) {
        object = ((ModelInterpretationContext)object).getDefaultNestedComponentRegistry();
        return ((DefaultNestedComponentRegistry)object).findDefaultComponentTypeByTag(eventEvaluatorModel.getTag());
    }

    @Override
    public void postHandle(ModelInterpretationContext object, Model object2) {
        if (this.inError) {
            return;
        }
        if (this.evaluator instanceof LifeCycle) {
            this.evaluator.start();
            EventEvaluatorModelHandler eventEvaluatorModelHandler = this;
            eventEvaluatorModelHandler.addInfo("Starting evaluator named [" + eventEvaluatorModelHandler.evaluator.getName() + "]");
        }
        if ((object2 = ((ModelInterpretationContext)object).peekObject()) != this.evaluator) {
            this.addWarn("The object on the top the of the stack is not the evaluator pushed earlier.");
            return;
        }
        ((ModelInterpretationContext)object).popObject();
        try {
            object = (Map)this.context.getObject("EVALUATOR_MAP");
            if (object != null) {
                object.put(this.evaluator.getName(), this.evaluator);
                return;
            }
            this.addError("Could not find EvaluatorMap");
        }
        catch (Exception exception) {
            EventEvaluatorModelHandler eventEvaluatorModelHandler = this;
            eventEvaluatorModelHandler.addError("Could not set evaluator named [" + String.valueOf(eventEvaluatorModelHandler.evaluator) + "].", exception);
        }
    }
}

