/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.InetNameResolver;
import io.netty.resolver.NameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RoundRobinInetAddressResolver
extends InetNameResolver {
    private final NameResolver<InetAddress> nameResolver;

    public RoundRobinInetAddressResolver(EventExecutor eventExecutor, NameResolver<InetAddress> nameResolver) {
        super(eventExecutor);
        this.nameResolver = nameResolver;
    }

    @Override
    protected void doResolve(final String string, final Promise<InetAddress> promise) {
        this.nameResolver.resolveAll(string).addListener((GenericFutureListener)new FutureListener<List<InetAddress>>(){

            /*
             * Enabled aggressive block sorting
             */
            public void operationComplete(Future<List<InetAddress>> object) {
                if (!object.isSuccess()) {
                    promise.setFailure(object.cause());
                    return;
                }
                int n = (object = (List)object.getNow()).size();
                if (n > 0) {
                    promise.setSuccess(object.get(RoundRobinInetAddressResolver.randomIndex(n)));
                    return;
                }
                promise.setFailure((Throwable)new UnknownHostException(string));
            }
        });
    }

    @Override
    protected void doResolveAll(String string, final Promise<List<InetAddress>> promise) {
        this.nameResolver.resolveAll(string).addListener((GenericFutureListener)new FutureListener<List<InetAddress>>(){

            /*
             * Enabled aggressive block sorting
             */
            public void operationComplete(Future<List<InetAddress>> object) {
                if (!object.isSuccess()) {
                    promise.setFailure(object.cause());
                    return;
                }
                if (!(object = (List)object.getNow()).isEmpty()) {
                    ArrayList arrayList = new ArrayList(object);
                    Collections.rotate(arrayList, RoundRobinInetAddressResolver.randomIndex(object.size()));
                    promise.setSuccess(arrayList);
                    return;
                }
                promise.setSuccess(object);
            }
        });
    }

    private static int randomIndex(int n) {
        if (n == 1) {
            return 0;
        }
        return PlatformDependent.threadLocalRandom().nextInt(n);
    }

    @Override
    public void close() {
        this.nameResolver.close();
    }
}

