/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.SlotTableKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0086\u0002J\u0019\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000eH\u0086\u0002J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nJ%\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0017H\u0082\bJ\u0016\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nJ\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Landroidx/compose/runtime/BitVector;", "", "<init>", "()V", "first", "", "second", "others", "", "size", "", "getSize", "()I", "get", "", "index", "set", "", "value", "nextSet", "nextClear", "nextBit", "valueSelector", "Lkotlin/Function1;", "setRange", "start", "end", "toString", "", "runtime"})
public final class BitVector {
    private long first;
    private long second;
    private long[] others = SlotTableKt.access$getEmptyLongArray$p();
    public static final int $stable = 8;

    public final int getSize() {
        return this.others.length + 2 << 6;
    }

    public final boolean get(int n) {
        if (n < 64) {
            return (this.first & 1L << n) != 0L;
        }
        if (n < 128) {
            return (this.second & 1L << n - 64) != 0L;
        }
        long[] lArray = this.others;
        int n2 = this.others.length;
        if (n2 == 0) {
            return false;
        }
        int n3 = n / 64 - 2;
        if (n3 >= n2) {
            return false;
        }
        return (lArray[n3] & 1L << (n %= 64)) != 0L;
    }

    public final void set(int n, boolean bl) {
        if (n < 64) {
            long l = 1L << n;
            this.first = this.first & (l ^ 0xFFFFFFFFFFFFFFFFL) | (long)(bl ? 1 : 0) << n;
            return;
        }
        if (n < 128) {
            long l = 1L << n - 64;
            this.second = this.second & (l ^ 0xFFFFFFFFFFFFFFFFL) | (long)(bl ? 1 : 0) << n;
            return;
        }
        int n2 = n / 64 - 2;
        int n3 = n % 64;
        long l = 1L << n3;
        long[] lArray = this.others;
        if (n2 >= lArray.length) {
            long[] lArray2 = Arrays.copyOf(lArray, n2 + 1);
            Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"");
            this.others = lArray = lArray2;
        }
        long l2 = lArray[n2];
        lArray[n2] = l2 & (l ^ 0xFFFFFFFFFFFFFFFFL) | (long)(bl ? 1 : 0) << n3;
    }

    public final int nextSet(int n) {
        long l;
        int n2;
        long l2;
        long l3;
        int n3;
        BitVector bitVector = this;
        if (n < 64 && (n3 = Long.numberOfTrailingZeros(l3 = (l2 = bitVector.first) >>> n << n)) < 64) {
            return n3;
        }
        if (n < 128 && (n2 = Long.numberOfTrailingZeros(l = (l2 = bitVector.second) >>> (n3 = n - 64) << n3)) < 64) {
            return n2 + 64;
        }
        n3 = Math.max(n, 128);
        n2 = n3 / 64 - 2;
        long[] lArray = bitVector.others;
        int n4 = lArray.length;
        for (n = n2; n < n4; ++n) {
            long l4;
            int n5;
            long l5 = l2 = lArray[n];
            if (n == n2) {
                int n6 = n3 % 64;
                l5 = l5 >>> n6 << n6;
            }
            if ((n5 = Long.numberOfTrailingZeros(l4 = l5)) >= 64) continue;
            return 128 + (n << 6) + n5;
        }
        return Integer.MAX_VALUE;
    }

    public final int nextClear(int n) {
        long l;
        int n2;
        long l2;
        long l3;
        int n3;
        BitVector bitVector = this;
        if (n < 64 && (n3 = Long.numberOfTrailingZeros(l3 = ((l2 = bitVector.first) ^ 0xFFFFFFFFFFFFFFFFL) >>> n << n)) < 64) {
            return n3;
        }
        if (n < 128 && (n2 = Long.numberOfTrailingZeros(l = ((l2 = bitVector.second) ^ 0xFFFFFFFFFFFFFFFFL) >>> (n3 = n - 64) << n3)) < 64) {
            return n2 + 64;
        }
        n3 = Math.max(n, 128);
        n2 = n3 / 64 - 2;
        long[] lArray = bitVector.others;
        int n4 = lArray.length;
        for (n = n2; n < n4; ++n) {
            long l4;
            int n5;
            l2 = lArray[n];
            long l5 = l2 ^ 0xFFFFFFFFFFFFFFFFL;
            if (n == n2) {
                int n6 = n3 % 64;
                l5 = l5 >>> n6 << n6;
            }
            if ((n5 = Long.numberOfTrailingZeros(l4 = l5)) >= 64) continue;
            return 128 + (n << 6) + n5;
        }
        return Integer.MAX_VALUE;
    }

    private final int nextBit(int n, Function1<? super Long, Long> function1) {
        long l;
        int n2;
        if (n < 64 && (n2 = Long.numberOfTrailingZeros(l = ((Number)function1.invoke((Object)this.first)).longValue() >>> n << n)) < 64) {
            return n2;
        }
        if (n < 128) {
            n2 = n - 64;
            long l2 = ((Number)function1.invoke((Object)this.second)).longValue() >>> n2 << n2;
            int n3 = Long.numberOfTrailingZeros(l2);
            if (n3 < 64) {
                return n3 + 64;
            }
        }
        n2 = Math.max(n, 128);
        int n4 = n2 / 64 - 2;
        long[] lArray = this.others;
        n = lArray.length;
        for (int i = n4; i < n; ++i) {
            long l3;
            int n5;
            long l4 = ((Number)function1.invoke((Object)lArray[i])).longValue();
            if (i == n4) {
                n5 = n2 % 64;
                l4 = l4 >>> n5 << n5;
            }
            if ((n5 = Long.numberOfTrailingZeros(l3 = l4)) >= 64) continue;
            return 128 + (i << 6) + n5;
        }
        return Integer.MAX_VALUE;
    }

    public final void setRange(int n, int n2) {
        long l = n < n2 ? -1L : 0L;
        boolean bl = n < 64;
        long l2 = l * (long)(bl ? 1 : 0);
        long l3 = l2 >>> 64 - (Math.min(64, n2) - n) << n;
        this.first |= l3;
        if (n2 <= 64) {
            return;
        }
        n = Math.max(n, 64);
        boolean bl2 = n < 128;
        l2 = l * (long)(bl2 ? 1 : 0);
        long l4 = l2 >>> 128 - (Math.min(128, n2) - n) << n;
        this.second |= l4;
        if (n2 > 128) {
            n = Math.max(n, 128);
        } else {
            return;
        }
        while (n < n2) {
            this.set(n, true);
            ++n;
        }
    }

    public final String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = true;
        stringBuilder2.append("BitVector [");
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            if (!this.get(i)) continue;
            if (!bl) {
                stringBuilder2.append(", ");
            }
            bl = false;
            stringBuilder2.append(i);
        }
        stringBuilder2.append(']');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }
}

