/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.ui.FlatTableUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.function.Function;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FlatTableCellBorder
extends FlatLineBorder {
    protected boolean showCellFocusIndicator = UIManager.getBoolean("Table.showCellFocusIndicator");
    private Component c;

    protected FlatTableCellBorder() {
        super(UIManager.getInsets("Table.cellMargins"), UIManager.getColor("Table.cellFocusColor"));
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        Insets insets2 = FlatTableCellBorder.getStyleFromTableUI(component, flatTableUI -> flatTableUI.cellMargins);
        if (insets2 != null) {
            return FlatTableCellBorder.scaleInsets(component, insets, insets2.top, insets2.left, insets2.bottom, insets2.right);
        }
        return super.getBorderInsets(component, insets);
    }

    @Override
    public Color getLineColor() {
        Color color;
        if (this.c != null && (color = FlatTableCellBorder.getStyleFromTableUI(this.c, flatTableUI -> flatTableUI.cellFocusColor)) != null) {
            return color;
        }
        return super.getLineColor();
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        this.c = component;
        super.paintBorder(component, graphics, n, n2, n3, n4);
        this.c = null;
    }

    static <T> T getStyleFromTableUI(Component object, Function<FlatTableUI, T> function) {
        if ((object = (JTable)SwingUtilities.getAncestorOfClass(JTable.class, (Component)object)) != null && (object = ((JTable)object).getUI()) instanceof FlatTableUI) {
            return function.apply((FlatTableUI)object);
        }
        return null;
    }

    public static class Selected
    extends FlatTableCellBorder {
        public int maxCheckCellsEditable = 50;

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JTable jTable;
            Boolean bl = Selected.getStyleFromTableUI(component, flatTableUI -> flatTableUI.showCellFocusIndicator);
            boolean bl2 = bl != null ? bl : this.showCellFocusIndicator;
            if (!bl2 && (jTable = (JTable)SwingUtilities.getAncestorOfClass(JTable.class, component)) != null && !this.shouldShowCellFocusIndicator(jTable)) {
                return;
            }
            super.paintBorder(component, graphics, n, n2, n3, n4);
        }

        protected boolean shouldShowCellFocusIndicator(JTable jTable) {
            block8: {
                int n;
                int n2;
                block7: {
                    n2 = jTable.getRowSelectionAllowed();
                    n = jTable.getColumnSelectionAllowed();
                    if (n2 != 0 && n != 0) {
                        return false;
                    }
                    if (n2 == 0) break block7;
                    if (jTable.getSelectedRowCount() != 1) {
                        return false;
                    }
                    n2 = jTable.getColumnCount();
                    if (n2 > this.maxCheckCellsEditable) {
                        return true;
                    }
                    n = jTable.getSelectedRow();
                    for (int i = 0; i < n2; ++i) {
                        if (!jTable.isCellEditable(n, i)) continue;
                        return true;
                    }
                    break block8;
                }
                if (n == 0) break block8;
                if (jTable.getSelectedColumnCount() != 1) {
                    return false;
                }
                n2 = jTable.getRowCount();
                if (n2 > this.maxCheckCellsEditable) {
                    return true;
                }
                n = jTable.getSelectedColumn();
                for (int i = 0; i < n2; ++i) {
                    if (!jTable.isCellEditable(i, n)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class Focused
    extends FlatTableCellBorder {
        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Object object;
            if (component != null && component.getClass().getName().equals("javax.swing.JTable$BooleanRenderer") && (object = (JTable)SwingUtilities.getAncestorOfClass(JTable.class, component)) != null && component.getForeground() == ((JTable)object).getSelectionForeground() && component.getBackground() == ((JTable)object).getSelectionBackground() && (object = UIManager.getBorder("Table.focusSelectedCellHighlightBorder")) != null) {
                object.paintBorder(component, graphics, n, n2, n3, n4);
                return;
            }
            super.paintBorder(component, graphics, n, n2, n3, n4);
        }
    }

    public static class Default
    extends FlatTableCellBorder {
        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }
    }
}

