/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.staggeredgrid;

import androidx.compose.foundation.internal.InlineClassHelperKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0011\b\u0001\u0018\u0000 !2\u00020\u0001:\u0002 !B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u0006\u0010\u0013\u001a\u00020\u0005J\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u0015\u001a\u00020\fJ\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u0016\u0010\u0017\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0005J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0005J\u001a\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u00052\b\b\u0002\u0010\u001f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo;", "", "<init>", "()V", "anchor", "", "lanes", "", "spannedItems", "Lkotlin/collections/ArrayDeque;", "Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo$SpannedItem;", "setLane", "", "itemIndex", "lane", "getLane", "assignedToLane", "", "targetLane", "upperBound", "lowerBound", "reset", "findPreviousItemIndex", "findNextItemIndex", "ensureValidIndex", "requestedIndex", "setGaps", "gaps", "getGaps", "ensureCapacity", "capacity", "newOffset", "SpannedItem", "Companion", "foundation"})
public final class LazyStaggeredGridLaneInfo {
    public static final Companion Companion = new Companion(null);
    private int anchor;
    private int[] lanes = new int[16];
    private final ArrayDeque<SpannedItem> spannedItems = new ArrayDeque();
    public static final int $stable = 8;
    private static final int MaxCapacity = 131072;
    public static final int LaneUnset = -1;
    public static final int LaneFullSpan = -2;

    public final void setLane(int n2, int n3) {
        boolean bl = n2 >= 0;
        if (!bl) {
            InlineClassHelperKt.throwIllegalArgumentException("Negative lanes are not supported");
        }
        this.ensureValidIndex(n2);
        this.lanes[n2 - this.anchor] = n3 + 1;
    }

    public final int getLane(int n2) {
        if (n2 < this.lowerBound() || n2 >= this.upperBound()) {
            return -1;
        }
        return this.lanes[n2 - this.anchor] - 1;
    }

    public final boolean assignedToLane(int n2, int n3) {
        return (n2 = this.getLane(n2)) == n3 || n2 == -1 || n2 == -2;
    }

    public final int upperBound() {
        return this.anchor + this.lanes.length;
    }

    public final int lowerBound() {
        return this.anchor;
    }

    public final void reset() {
        ArraysKt.fill$default((int[])this.lanes, (int)0, (int)0, (int)0, (int)6, null);
        this.spannedItems.clear();
    }

    public final int findPreviousItemIndex(int n2, int n3) {
        --n2;
        while (n2 >= 0) {
            if (this.assignedToLane(n2, n3)) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public final int findNextItemIndex(int n2, int n3) {
        ++n2;
        int n4 = this.upperBound();
        while (n2 < n4) {
            if (this.assignedToLane(n2, n3)) {
                return n2;
            }
            ++n2;
        }
        return this.upperBound();
    }

    public final void ensureValidIndex(int n2) {
        int n3 = n2 - this.anchor;
        boolean bl = n3 >= 0 ? n3 < 131072 : false;
        if (bl) {
            LazyStaggeredGridLaneInfo.ensureCapacity$default(this, n3 + 1, 0, 2, null);
        } else {
            n3 = this.anchor;
            this.anchor = Math.max(n2 - this.lanes.length / 2, 0);
            n2 = this.anchor - n3;
            if (n2 >= 0) {
                if (n2 < this.lanes.length) {
                    ArraysKt.copyInto((int[])this.lanes, (int[])this.lanes, (int)0, (int)n2, (int)this.lanes.length);
                }
                ArraysKt.fill((int[])this.lanes, (int)0, (int)Math.max(0, this.lanes.length - n2), (int)this.lanes.length);
            } else if (this.lanes.length + (n2 = -n2) < 131072) {
                LazyStaggeredGridLaneInfo lazyStaggeredGridLaneInfo = this;
                lazyStaggeredGridLaneInfo.ensureCapacity(lazyStaggeredGridLaneInfo.lanes.length + n2 + 1, n2);
            } else {
                if (n2 < this.lanes.length) {
                    ArraysKt.copyInto((int[])this.lanes, (int[])this.lanes, (int)n2, (int)0, (int)(this.lanes.length - n2));
                }
                ArraysKt.fill((int[])this.lanes, (int)0, (int)0, (int)Math.min(this.lanes.length, n2));
            }
        }
        while (!((Collection)this.spannedItems).isEmpty() && ((SpannedItem)this.spannedItems.first()).getIndex() < this.lowerBound()) {
            this.spannedItems.removeFirst();
        }
        while (!((Collection)this.spannedItems).isEmpty() && ((SpannedItem)this.spannedItems.last()).getIndex() > this.upperBound()) {
            this.spannedItems.removeLast();
        }
    }

    public final void setGaps(int n2, int[] nArray) {
        List list = (List)this.spannedItems;
        Comparable comparable = Integer.valueOf(n2);
        int n3 = list.size();
        int n4 = CollectionsKt.binarySearch((List)list, (int)0, (int)n3, (Function1)((Function1)new Function1<SpannedItem, Integer>(comparable){
            final /* synthetic */ Comparable $key;
            {
                this.$key = comparable;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Integer invoke(Object object) {
                object = (SpannedItem)object;
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(((SpannedItem)object).getIndex()), (Comparable)this.$key);
            }
        }));
        if (n4 < 0) {
            if (nArray == null) {
                return;
            }
            n4 = -(n4 + 1);
            this.spannedItems.add(n4, (Object)new SpannedItem(n2, nArray));
            return;
        }
        if (nArray == null) {
            this.spannedItems.remove(n4);
            return;
        }
        ((SpannedItem)this.spannedItems.get(n4)).setGaps(nArray);
    }

    public final int[] getGaps(int n2) {
        List list = (List)this.spannedItems;
        Comparable comparable = Integer.valueOf(n2);
        int n3 = list.size();
        int n4 = CollectionsKt.binarySearch((List)list, (int)0, (int)n3, (Function1)((Function1)new Function1<SpannedItem, Integer>(comparable){
            final /* synthetic */ Comparable $key;
            {
                this.$key = comparable;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Integer invoke(Object object) {
                object = (SpannedItem)object;
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(((SpannedItem)object).getIndex()), (Comparable)this.$key);
            }
        }));
        SpannedItem spannedItem = (SpannedItem)CollectionsKt.getOrNull((List)((List)this.spannedItems), (int)n4);
        if (spannedItem != null) {
            return spannedItem.getGaps();
        }
        return null;
    }

    private final void ensureCapacity(int n2, int n3) {
        int n4 = n2 <= 131072 ? 1 : 0;
        if (n4 == 0) {
            InlineClassHelperKt.throwIllegalArgumentException("Requested item capacity " + n2 + " is larger than max supported: 131072!");
        }
        if (this.lanes.length < n2) {
            for (n4 = this.lanes.length; n4 < n2; n4 <<= 1) {
            }
            this.lanes = ArraysKt.copyInto$default((int[])this.lanes, (int[])new int[n4], (int)n3, (int)0, (int)0, (int)12, null);
        }
    }

    static /* synthetic */ void ensureCapacity$default(LazyStaggeredGridLaneInfo lazyStaggeredGridLaneInfo, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n3 = 0;
        }
        lazyStaggeredGridLaneInfo.ensureCapacity(n2, n3);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo$Companion;", "", "<init>", "()V", "MaxCapacity", "", "LaneUnset", "LaneFullSpan", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridLaneInfo$SpannedItem;", "", "index", "", "gaps", "", "<init>", "(I[I)V", "getIndex", "()I", "getGaps", "()[I", "setGaps", "([I)V", "foundation"})
    private static final class SpannedItem {
        private final int index;
        private int[] gaps;

        public SpannedItem(int n2, int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
            this.index = n2;
            this.gaps = nArray;
        }

        public final int getIndex() {
            return this.index;
        }

        public final int[] getGaps() {
            return this.gaps;
        }

        public final void setGaps(int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
            this.gaps = nArray;
        }
    }
}

