/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextOption;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.KeyManagerFactoryWrapper;
import io.netty.handler.ssl.util.TrustManagerFactoryWrapper;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import java.io.File;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public final class SslContextBuilder {
    private static final Map.Entry[] EMPTY_ENTRIES = new Map.Entry[0];
    private final boolean forServer;
    private SslProvider provider;
    private Provider sslContextProvider;
    private X509Certificate[] trustCertCollection;
    private TrustManagerFactory trustManagerFactory;
    private X509Certificate[] keyCertChain;
    private PrivateKey key;
    private String keyPassword;
    private KeyManagerFactory keyManagerFactory;
    private Iterable<String> ciphers;
    private CipherSuiteFilter cipherFilter = IdentityCipherSuiteFilter.INSTANCE;
    private ApplicationProtocolConfig apn;
    private long sessionCacheSize;
    private long sessionTimeout;
    private ClientAuth clientAuth = ClientAuth.NONE;
    private String[] protocols;
    private boolean startTls;
    private boolean enableOcsp;
    private SecureRandom secureRandom;
    private String keyStoreType = KeyStore.getDefaultType();
    private String endpointIdentificationAlgorithm;
    private final Map<SslContextOption<?>, Object> options = new HashMap();

    public static SslContextBuilder forClient() {
        return new SslContextBuilder(false);
    }

    public static SslContextBuilder forServer(File file, File file2) {
        return new SslContextBuilder(true).keyManager(file, file2);
    }

    public static SslContextBuilder forServer(InputStream inputStream, InputStream inputStream2) {
        return new SslContextBuilder(true).keyManager(inputStream, inputStream2);
    }

    public static SslContextBuilder forServer(PrivateKey privateKey, X509Certificate ... x509CertificateArray) {
        return new SslContextBuilder(true).keyManager(privateKey, x509CertificateArray);
    }

    public static SslContextBuilder forServer(PrivateKey privateKey, Iterable<? extends X509Certificate> iterable) {
        return SslContextBuilder.forServer(privateKey, SslContextBuilder.toArray(iterable, EmptyArrays.EMPTY_X509_CERTIFICATES));
    }

    public static SslContextBuilder forServer(File file, File file2, String string) {
        return new SslContextBuilder(true).keyManager(file, file2, string);
    }

    public static SslContextBuilder forServer(InputStream inputStream, InputStream inputStream2, String string) {
        return new SslContextBuilder(true).keyManager(inputStream, inputStream2, string);
    }

    public static SslContextBuilder forServer(PrivateKey privateKey, String string, X509Certificate ... x509CertificateArray) {
        return new SslContextBuilder(true).keyManager(privateKey, string, x509CertificateArray);
    }

    public static SslContextBuilder forServer(PrivateKey privateKey, String string, Iterable<? extends X509Certificate> iterable) {
        return SslContextBuilder.forServer(privateKey, string, SslContextBuilder.toArray(iterable, EmptyArrays.EMPTY_X509_CERTIFICATES));
    }

    public static SslContextBuilder forServer(KeyManagerFactory keyManagerFactory) {
        return new SslContextBuilder(true).keyManager(keyManagerFactory);
    }

    public static SslContextBuilder forServer(KeyManager keyManager) {
        return new SslContextBuilder(true).keyManager(keyManager);
    }

    private SslContextBuilder(boolean bl) {
        this.forServer = bl;
    }

    public final <T> SslContextBuilder option(SslContextOption<T> sslContextOption, T t) {
        if (t == null) {
            this.options.remove(sslContextOption);
        } else {
            this.options.put(sslContextOption, t);
        }
        return this;
    }

    public final SslContextBuilder sslProvider(SslProvider sslProvider) {
        this.provider = sslProvider;
        return this;
    }

    public final SslContextBuilder keyStoreType(String string) {
        this.keyStoreType = string;
        return this;
    }

    public final SslContextBuilder sslContextProvider(Provider provider) {
        this.sslContextProvider = provider;
        return this;
    }

    public final SslContextBuilder trustManager(File file) {
        try {
            return this.trustManager(SslContext.toX509Certificates(file));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("File does not contain valid certificates: " + file, exception);
        }
    }

    public final SslContextBuilder trustManager(InputStream inputStream) {
        try {
            return this.trustManager(SslContext.toX509Certificates(inputStream));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Input stream does not contain valid certificates.", exception);
        }
    }

    public final SslContextBuilder trustManager(X509Certificate ... x509CertificateArray) {
        this.trustCertCollection = x509CertificateArray != null ? (X509Certificate[])x509CertificateArray.clone() : null;
        this.trustManagerFactory = null;
        return this;
    }

    public final SslContextBuilder trustManager(Iterable<? extends X509Certificate> iterable) {
        return this.trustManager(SslContextBuilder.toArray(iterable, EmptyArrays.EMPTY_X509_CERTIFICATES));
    }

    public final SslContextBuilder trustManager(TrustManagerFactory trustManagerFactory) {
        this.trustCertCollection = null;
        this.trustManagerFactory = trustManagerFactory;
        return this;
    }

    public final SslContextBuilder trustManager(TrustManager trustManager) {
        this.trustManagerFactory = trustManager != null ? new TrustManagerFactoryWrapper(trustManager) : null;
        this.trustCertCollection = null;
        return this;
    }

    public final SslContextBuilder keyManager(File file, File file2) {
        return this.keyManager(file, file2, null);
    }

    public final SslContextBuilder keyManager(InputStream inputStream, InputStream inputStream2) {
        return this.keyManager(inputStream, inputStream2, null);
    }

    public final SslContextBuilder keyManager(PrivateKey privateKey, X509Certificate ... x509CertificateArray) {
        return this.keyManager(privateKey, (String)null, x509CertificateArray);
    }

    public final SslContextBuilder keyManager(PrivateKey privateKey, Iterable<? extends X509Certificate> iterable) {
        return this.keyManager(privateKey, SslContextBuilder.toArray(iterable, EmptyArrays.EMPTY_X509_CERTIFICATES));
    }

    public final SslContextBuilder keyManager(File serializable, File file, String string) {
        X509Certificate[] x509CertificateArray;
        try {
            x509CertificateArray = SslContext.toX509Certificates(serializable);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("File does not contain valid certificates: " + serializable, exception);
        }
        try {
            serializable = SslContext.toPrivateKey(file, string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("File does not contain valid private key: " + file, exception);
        }
        return this.keyManager((PrivateKey)serializable, string, x509CertificateArray);
    }

    public final SslContextBuilder keyManager(InputStream x509CertificateArray, InputStream object, String string) {
        try {
            x509CertificateArray = SslContext.toX509Certificates((InputStream)x509CertificateArray);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Input stream not contain valid certificates.", exception);
        }
        try {
            object = SslContext.toPrivateKey((InputStream)object, string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Input stream does not contain valid private key.", exception);
        }
        return this.keyManager((PrivateKey)object, string, x509CertificateArray);
    }

    public final SslContextBuilder keyManager(PrivateKey privateKey, String string, X509Certificate ... x509CertificateArray) {
        if (this.forServer) {
            ObjectUtil.checkNonEmpty((Object[])x509CertificateArray, (String)"keyCertChain");
            ObjectUtil.checkNotNull((Object)privateKey, (String)"key required for servers");
        }
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            this.keyCertChain = null;
        } else {
            X509Certificate[] x509CertificateArray2 = x509CertificateArray;
            int n = x509CertificateArray.length;
            for (int i = 0; i < n; ++i) {
                X509Certificate x509Certificate = x509CertificateArray2[i];
                ObjectUtil.checkNotNullWithIAE((Object)x509Certificate, (String)"cert");
            }
            this.keyCertChain = (X509Certificate[])x509CertificateArray.clone();
        }
        this.key = privateKey;
        this.keyPassword = string;
        this.keyManagerFactory = null;
        return this;
    }

    public final SslContextBuilder keyManager(PrivateKey privateKey, String string, Iterable<? extends X509Certificate> iterable) {
        return this.keyManager(privateKey, string, SslContextBuilder.toArray(iterable, EmptyArrays.EMPTY_X509_CERTIFICATES));
    }

    public final SslContextBuilder keyManager(KeyManagerFactory keyManagerFactory) {
        if (this.forServer) {
            ObjectUtil.checkNotNull((Object)keyManagerFactory, (String)"keyManagerFactory required for servers");
        }
        this.keyCertChain = null;
        this.key = null;
        this.keyPassword = null;
        this.keyManagerFactory = keyManagerFactory;
        return this;
    }

    public final SslContextBuilder keyManager(KeyManager keyManager) {
        if (this.forServer) {
            ObjectUtil.checkNotNull((Object)keyManager, (String)"keyManager required for servers");
        }
        this.keyManagerFactory = keyManager != null ? new KeyManagerFactoryWrapper(keyManager) : null;
        this.keyCertChain = null;
        this.key = null;
        this.keyPassword = null;
        return this;
    }

    public final SslContextBuilder ciphers(Iterable<String> iterable) {
        return this.ciphers(iterable, IdentityCipherSuiteFilter.INSTANCE);
    }

    public final SslContextBuilder ciphers(Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter) {
        this.cipherFilter = (CipherSuiteFilter)ObjectUtil.checkNotNull((Object)cipherSuiteFilter, (String)"cipherFilter");
        this.ciphers = iterable;
        return this;
    }

    public final SslContextBuilder applicationProtocolConfig(ApplicationProtocolConfig applicationProtocolConfig) {
        this.apn = applicationProtocolConfig;
        return this;
    }

    public final SslContextBuilder sessionCacheSize(long l) {
        this.sessionCacheSize = l;
        return this;
    }

    public final SslContextBuilder sessionTimeout(long l) {
        this.sessionTimeout = l;
        return this;
    }

    public final SslContextBuilder clientAuth(ClientAuth clientAuth) {
        this.clientAuth = (ClientAuth)((Object)ObjectUtil.checkNotNull((Object)((Object)clientAuth), (String)"clientAuth"));
        return this;
    }

    public final SslContextBuilder protocols(String ... stringArray) {
        this.protocols = stringArray == null ? null : (String[])stringArray.clone();
        return this;
    }

    public final SslContextBuilder protocols(Iterable<String> iterable) {
        return this.protocols(SslContextBuilder.toArray(iterable, EmptyArrays.EMPTY_STRINGS));
    }

    public final SslContextBuilder startTls(boolean bl) {
        this.startTls = bl;
        return this;
    }

    public final SslContextBuilder enableOcsp(boolean bl) {
        this.enableOcsp = bl;
        return this;
    }

    public final SslContextBuilder secureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public final SslContextBuilder endpointIdentificationAlgorithm(String string) {
        this.endpointIdentificationAlgorithm = string;
        return this;
    }

    public final SslContext build() {
        if (this.forServer) {
            return SslContext.newServerContextInternal(this.provider, this.sslContextProvider, this.trustCertCollection, this.trustManagerFactory, this.keyCertChain, this.key, this.keyPassword, this.keyManagerFactory, this.ciphers, this.cipherFilter, this.apn, this.sessionCacheSize, this.sessionTimeout, this.clientAuth, this.protocols, this.startTls, this.enableOcsp, this.secureRandom, this.keyStoreType, SslContextBuilder.toArray(this.options.entrySet(), EMPTY_ENTRIES));
        }
        return SslContext.newClientContextInternal(this.provider, this.sslContextProvider, this.trustCertCollection, this.trustManagerFactory, this.keyCertChain, this.key, this.keyPassword, this.keyManagerFactory, this.ciphers, this.cipherFilter, this.apn, this.protocols, this.sessionCacheSize, this.sessionTimeout, this.enableOcsp, this.secureRandom, this.keyStoreType, this.endpointIdentificationAlgorithm, SslContextBuilder.toArray(this.options.entrySet(), EMPTY_ENTRIES));
    }

    private static <T> T[] toArray(Iterable<? extends T> object, T[] TArray) {
        if (object == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            arrayList.add(e);
        }
        return arrayList.toArray(TArray);
    }
}

