/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0006\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u001a\u0010\n\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u000b\"\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\u0010\fJA\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\u0004\b\u0000\u0010\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u0002H\u000e\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0013J*\u0010\u0014\u001a\u00020\u00152\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\b\b\u0001\u0010\u0012\u001a\u00020\tJ,\u0010\u0016\u001a\u0004\u0018\u00010\u00152\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\b\b\u0001\u0010\u0012\u001a\u00020\tJ$\u0010\u0017\u001a\u0004\u0018\u00010\u00152\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00072\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00150\u001aJE\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u000b2\u0012\u0010\u001d\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00070\u001e2\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00150\u001aH\u0002\u00a2\u0006\u0002\u0010\u001fJ'\u0010 \u001a\u0004\u0018\u0001H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010!\u001a\u00020\u00152\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010#\u00a8\u0006$"}, d2={"Landroidx/compose/ui/text/platform/ReflectionUtil;", "", "<init>", "()V", "getDeclaredMethodOrNull", "Ljava/lang/reflect/Method;", "clazz", "Ljava/lang/Class;", "name", "", "parameters", "", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "getFieldValueOrNull", "T", "objectClass", "object", "fieldType", "fieldName", "(Ljava/lang/Class;Ljava/lang/Object;Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "getAssignableField", "Ljava/lang/reflect/Field;", "findAssignableField", "findFieldInHierarchy", "rootClass", "checker", "Ljava/util/function/Predicate;", "processInterfaces", "interfaces", "visited", "", "([Ljava/lang/Class;Ljava/util/Set;Ljava/util/function/Predicate;)Ljava/lang/reflect/Field;", "getFieldValue", "field", "instance", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)Ljava/lang/Object;", "ui-text"})
public final class ReflectionUtil {
    public static final ReflectionUtil INSTANCE = new ReflectionUtil();
    public static final int $stable;

    private ReflectionUtil() {
    }

    public final Method getDeclaredMethodOrNull(Class<?> genericDeclaration, String object, Class<?> ... classArray) {
        Intrinsics.checkNotNullParameter(genericDeclaration, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter(classArray, (String)"");
        try {
            genericDeclaration = genericDeclaration.getDeclaredMethod((String)object, Arrays.copyOf(classArray, classArray.length));
            object = genericDeclaration;
            ((Method)genericDeclaration).setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            genericDeclaration = null;
        }
        catch (InaccessibleObjectException inaccessibleObjectException) {
            genericDeclaration = null;
        }
        return genericDeclaration;
    }

    public final <T> T getFieldValueOrNull(Class<?> annotatedElement, Object object, Class<T> clazz, String string) {
        Intrinsics.checkNotNullParameter(annotatedElement, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        try {
            annotatedElement = this.getAssignableField((Class<?>)annotatedElement, clazz, string);
            annotatedElement = this.getFieldValue((Field)annotatedElement, object);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            annotatedElement = null;
        }
        return (T)annotatedElement;
    }

    public final Field getAssignableField(Class<?> clazz, Class<?> clazz2, String string) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Field field = this.findAssignableField(clazz, clazz2, string);
        if (field == null) {
            throw new NoSuchFieldException("Class: " + clazz + " fieldName: " + string + " fieldType: " + clazz2);
        }
        return field;
    }

    public final Field findAssignableField(Class<?> annotatedElement, Class<?> clazz, String string) {
        Intrinsics.checkNotNullParameter(annotatedElement, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        annotatedElement = this.findFieldInHierarchy((Class<?>)annotatedElement, arg_0 -> ReflectionUtil.findAssignableField$lambda$2(arg_0 -> ReflectionUtil.findAssignableField$lambda$1(string, clazz, arg_0), arg_0));
        return annotatedElement;
    }

    public final Field findFieldInHierarchy(Class<?> clazz, Predicate<? super Field> predicate) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Intrinsics.checkNotNullParameter(predicate, (String)"");
        try {
            for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                Iterator iterator = ArrayIteratorKt.iterator((Object[])clazz2.getDeclaredFields());
                while (iterator.hasNext()) {
                    Field field = (Field)iterator.next();
                    Intrinsics.checkNotNull((Object)field);
                    if (!predicate.test(field)) continue;
                    field.setAccessible(true);
                    return field;
                }
            }
        }
        catch (InaccessibleObjectException inaccessibleObjectException) {
            return null;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"");
        return this.processInterfaces(classArray, new HashSet(), predicate);
    }

    private final Field processInterfaces(Class<?>[] classArray, Set<? super Class<?>> set, Predicate<? super Field> predicate) {
        for (Class<?> clazz : classArray) {
            if (!set.add(clazz)) continue;
            Object object = ArrayIteratorKt.iterator((Object[])clazz.getDeclaredFields());
            while (object.hasNext()) {
                Field field = (Field)object.next();
                Intrinsics.checkNotNull((Object)field);
                if (!predicate.test(field)) continue;
                field.setAccessible(true);
                return field;
            }
            Class<?>[] classArray2 = clazz.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray2, (String)"");
            object = this.processInterfaces(classArray2, set, predicate);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    private final <T> T getFieldValue(Field object, Object object2) {
        try {
            object = ((Field)object).get(object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            object = null;
        }
        return (T)object;
    }

    private static final boolean findAssignableField$lambda$1(String string, Class clazz, Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"");
        return Intrinsics.areEqual((Object)string, (Object)field.getName()) && (clazz == null || clazz.isAssignableFrom(field.getType()));
    }

    private static final boolean findAssignableField$lambda$2(Function1 function1, Object object) {
        return (Boolean)function1.invoke(object);
    }
}

