/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.SplineBasedDecayKt;
import kotlin.Metadata;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c1\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/compose/animation/AndroidFlingSpline;", "", "<init>", "()V", "NbSamples", "", "SplinePositions", "", "SplineTimes", "flingPosition", "Landroidx/compose/animation/AndroidFlingSpline$FlingResult;", "time", "", "deceleration", "", "velocity", "friction", "FlingResult", "animation"})
public final class AndroidFlingSpline {
    public static final AndroidFlingSpline INSTANCE = new AndroidFlingSpline();
    private static final int NbSamples = 100;
    private static final float[] SplinePositions = new float[101];
    private static final float[] SplineTimes = new float[101];
    public static final int $stable;

    private AndroidFlingSpline() {
    }

    public final FlingResult flingPosition(float f) {
        f = RangesKt.coerceIn((float)f, (float)0.0f, (float)1.0f);
        int n = (int)(100.0f * f);
        float f2 = 1.0f;
        float f3 = 0.0f;
        if (n < 100) {
            f2 = (float)n / 100.0f;
            f3 = (float)(n + 1) / 100.0f;
            float f4 = SplinePositions[n];
            float f5 = SplinePositions[n + 1];
            f3 = (f5 - f4) / (f3 - f2);
            f2 = f4 + (f - f2) * f3;
        }
        return new FlingResult(f2, f3);
    }

    public final double deceleration(float f, float f2) {
        return Math.log((double)(0.35f * Math.abs(f)) / (double)f2);
    }

    static {
        SplineBasedDecayKt.access$computeSplineInfo(SplinePositions, SplineTimes, 100);
        $stable = 8;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Landroidx/compose/animation/AndroidFlingSpline$FlingResult;", "", "distanceCoefficient", "", "velocityCoefficient", "<init>", "(FF)V", "getDistanceCoefficient", "()F", "getVelocityCoefficient", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "animation"})
    public static final class FlingResult {
        private final float distanceCoefficient;
        private final float velocityCoefficient;
        public static final int $stable;

        public FlingResult(float f, float f2) {
            this.distanceCoefficient = f;
            this.velocityCoefficient = f2;
        }

        public final float getDistanceCoefficient() {
            return this.distanceCoefficient;
        }

        public final float getVelocityCoefficient() {
            return this.velocityCoefficient;
        }

        public final float component1() {
            return this.distanceCoefficient;
        }

        public final float component2() {
            return this.velocityCoefficient;
        }

        public final FlingResult copy(float f, float f2) {
            return new FlingResult(f, f2);
        }

        public static /* synthetic */ FlingResult copy$default(FlingResult flingResult, float f, float f2, int n, Object object) {
            if ((n & 1) != 0) {
                f = flingResult.distanceCoefficient;
            }
            if ((n & 2) != 0) {
                f2 = flingResult.velocityCoefficient;
            }
            return flingResult.copy(f, f2);
        }

        public final String toString() {
            return "FlingResult(distanceCoefficient=" + this.distanceCoefficient + ", velocityCoefficient=" + this.velocityCoefficient + ")";
        }

        public final int hashCode() {
            int n = Float.hashCode(this.distanceCoefficient);
            n = n * 31 + Float.hashCode(this.velocityCoefficient);
            return n;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof FlingResult)) {
                return false;
            }
            object = (FlingResult)object;
            if (Float.compare(this.distanceCoefficient, ((FlingResult)object).distanceCoefficient) != 0) {
                return false;
            }
            return Float.compare(this.velocityCoefficient, ((FlingResult)object).velocityCoefficient) == 0;
        }
    }
}

