/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.b;
import org.e.a.f;
import org.e.a.i;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaIdFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;

public class IQReplyFilter
implements StanzaFilter {
    private static final Logger LOGGER = Logger.getLogger(IQReplyFilter.class.getName());
    private final StanzaFilter iqAndIdFilter;
    private final OrFilter fromFilter;
    private final i to;
    private final f local;
    private final b server;
    private final String packetId;

    public IQReplyFilter(IQ object, XMPPConnection object2) {
        if (!object.isRequestIQ()) {
            throw new IllegalArgumentException("IQ must be a request IQ, i.e. of type 'get' or 'set'.");
        }
        this.to = ((Stanza)object).getTo();
        this.local = object2.getUser();
        if (this.local == null) {
            throw new IllegalArgumentException("Must have a local (user) JID set. Either you didn't configure one or you where not connected at least once");
        }
        this.server = object2.getXMPPServiceDomain();
        this.packetId = ((Stanza)object).getStanzaId();
        object2 = new OrFilter(IQTypeFilter.ERROR, IQTypeFilter.RESULT);
        object = new StanzaIdFilter((Stanza)object);
        this.iqAndIdFilter = new AndFilter(new StanzaFilter[]{object2, object});
        this.fromFilter = new OrFilter();
        this.fromFilter.addFilter(FromMatchesFilter.createFull(this.to));
        if (this.to == null) {
            this.fromFilter.addFilter(FromMatchesFilter.createBare((i)this.local));
            this.fromFilter.addFilter(FromMatchesFilter.createFull((i)this.server));
            return;
        }
        if (this.to.a((CharSequence)this.local.n())) {
            this.fromFilter.addFilter(FromMatchesFilter.createFull(null));
        }
    }

    @Override
    public boolean accept(Stanza stanza) {
        if (!this.iqAndIdFilter.accept(stanza)) {
            return false;
        }
        if (this.fromFilter.accept(stanza)) {
            return true;
        }
        String string = String.format("Rejected potentially spoofed reply to IQ-packet. Filter settings: packetId=%s, to=%s, local=%s, server=%s. Received packet with from=%s", this.packetId, this.to, this.local, this.server, stanza.getFrom());
        LOGGER.log(Level.WARNING, string, stanza);
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(": iqAndIdFilter (").append(this.iqAndIdFilter.toString()).append("), ");
        stringBuilder.append(": fromFilter (").append(this.fromFilter.toString()).append(')');
        return stringBuilder.toString();
    }
}

