/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public final class StandardExtensionElement
implements ExtensionElement {
    private final String name;
    private final String namespace;
    private final Map<String, String> attributes;
    private final String text;
    private final MultiMap<QName, StandardExtensionElement> elements;
    private XmlStringBuilder xmlCache;

    public StandardExtensionElement(String string, String string2) {
        this(string, string2, null, null, null);
    }

    private StandardExtensionElement(String string, String string2, Map<String, String> map, String string3, MultiMap<QName, StandardExtensionElement> multiMap) {
        this.name = StringUtils.requireNotNullNorEmpty(string, "Name must not be null nor empty");
        this.namespace = StringUtils.requireNotNullNorEmpty(string2, "Namespace must not be null nor empty");
        this.attributes = map == null ? Collections.emptyMap() : map;
        this.text = string3;
        this.elements = multiMap;
    }

    @Override
    public final String getElementName() {
        return this.name;
    }

    @Override
    public final String getNamespace() {
        return this.namespace;
    }

    public final String getAttributeValue(String string) {
        return this.attributes.get(string);
    }

    public final Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public final StandardExtensionElement getFirstElement(String object, String string) {
        if (this.elements == null) {
            return null;
        }
        object = new QName(string, (String)object);
        return this.elements.getFirst((QName)object);
    }

    public final StandardExtensionElement getFirstElement(String string) {
        return this.getFirstElement(string, this.namespace);
    }

    public final List<StandardExtensionElement> getElements(String object, String string) {
        if (this.elements == null) {
            return null;
        }
        object = new QName(string, (String)object);
        return this.elements.getAll((QName)object);
    }

    public final List<StandardExtensionElement> getElements(String string) {
        return this.getElements(string, this.namespace);
    }

    public final List<StandardExtensionElement> getElements() {
        if (this.elements == null) {
            return Collections.emptyList();
        }
        return this.elements.values();
    }

    public final String getText() {
        return this.text;
    }

    @Override
    public final XmlStringBuilder toXML(XmlEnvironment object) {
        if (this.xmlCache != null) {
            return this.xmlCache;
        }
        object = new XmlStringBuilder(this, (XmlEnvironment)object);
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            ((XmlStringBuilder)object).attribute(entry.getKey(), entry.getValue());
        }
        ((XmlStringBuilder)object).rightAngleBracket();
        if (this.text != null) {
            ((XmlStringBuilder)object).text(this.text);
        }
        if (this.elements != null) {
            for (Map.Entry<Object, Object> entry : this.elements.entrySet()) {
                ((XmlStringBuilder)object).append(((StandardExtensionElement)entry.getValue()).toXML(this.getNamespace()));
            }
        }
        ((XmlStringBuilder)object).closeElement(this);
        this.xmlCache = object;
        return object;
    }

    public static Builder builder(String string, String string2) {
        return new Builder(string, string2);
    }

    public static final class Builder {
        private final String name;
        private final String namespace;
        private Map<String, String> attributes;
        private String text;
        private MultiMap<QName, StandardExtensionElement> elements;

        private Builder(String string, String string2) {
            this.name = string;
            this.namespace = string2;
        }

        public final Builder addAttribute(String string, String string2) {
            StringUtils.requireNotNullNorEmpty(string, "Attribute name must be set");
            Objects.requireNonNull(string2, "Attribute value must be not null");
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, String>();
            }
            this.attributes.put(string, string2);
            return this;
        }

        public final Builder addAttributes(Map<String, String> map) {
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, String>(map.size());
            }
            this.attributes.putAll(map);
            return this;
        }

        public final Builder setText(String string) {
            this.text = Objects.requireNonNull(string, "Text must be not null");
            return this;
        }

        public final Builder addElement(StandardExtensionElement standardExtensionElement) {
            Objects.requireNonNull(standardExtensionElement, "Element must not be null");
            if (this.elements == null) {
                this.elements = new MultiMap();
            }
            QName qName = standardExtensionElement.getQName();
            this.elements.put(qName, standardExtensionElement);
            return this;
        }

        public final Builder addElement(String object, String string) {
            object = StandardExtensionElement.builder((String)object, this.namespace).setText(string).build();
            return this.addElement((StandardExtensionElement)object);
        }

        public final StandardExtensionElement build() {
            return new StandardExtensionElement(this.name, this.namespace, this.attributes, this.text, this.elements);
        }
    }
}

