/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.i;
import org.jivesoftware.smack.compress.packet.Compress;
import org.jivesoftware.smack.packet.EmptyResultIQ;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Session;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.StartTls;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.UnparsedIQ;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.StandardExtensionElementProvider;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.provider.Provider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.xml.SmackXmlParser;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class PacketParserUtils {
    private static final Logger LOGGER = Logger.getLogger(PacketParserUtils.class.getName());

    public static XmlPullParser getParserFor(String string) {
        return PacketParserUtils.getParserFor(new StringReader(string));
    }

    public static XmlPullParser getParserFor(InputStream closeable) {
        closeable = new InputStreamReader((InputStream)closeable, StandardCharsets.UTF_8);
        return SmackXmlParser.newXmlParser((Reader)closeable);
    }

    public static XmlPullParser getParserFor(Reader reader) {
        reader = SmackXmlParser.newXmlParser((Reader)reader);
        ParserUtils.forwardToStartElement((XmlPullParser)reader);
        return reader;
    }

    public static <S extends Stanza> S parseStanza(String string) {
        return (S)PacketParserUtils.parseStanza(PacketParserUtils.getParserFor(string), XmlEnvironment.EMPTY);
    }

    public static Stanza parseStanza(XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        String string;
        ParserUtils.assertAtStartTag(xmlPullParser);
        switch (string = xmlPullParser.getName()) {
            case "message": {
                return PacketParserUtils.parseMessage(xmlPullParser, xmlEnvironment);
            }
            case "iq": {
                return PacketParserUtils.parseIQ(xmlPullParser, xmlEnvironment);
            }
            case "presence": {
                return PacketParserUtils.parsePresence(xmlPullParser, xmlEnvironment);
            }
        }
        throw new IllegalArgumentException("Can only parse message, iq or presence, not " + string);
    }

    private static <SB extends StanzaBuilder<?>> SB parseCommonStanzaAttributes(StanzaBuilderSupplier<SB> stanzaBuilderSupplier, XmlPullParser object, XmlEnvironment xmlEnvironment) {
        String string = object.getAttributeValue("id");
        stanzaBuilderSupplier = stanzaBuilderSupplier.get(string);
        string = ParserUtils.getJidAttribute(object, "to");
        ((StanzaBuilder)((Object)stanzaBuilderSupplier)).to((i)string);
        string = ParserUtils.getJidAttribute(object, "from");
        ((StanzaBuilder)((Object)stanzaBuilderSupplier)).from((i)string);
        object = ParserUtils.getXmlLang(object, xmlEnvironment);
        ((StanzaBuilder)((Object)stanzaBuilderSupplier)).setLanguage((String)object);
        return (SB)stanzaBuilderSupplier;
    }

    public static Message parseMessage(XmlPullParser xmlPullParser) {
        return PacketParserUtils.parseMessage(xmlPullParser, XmlEnvironment.EMPTY);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Message parseMessage(XmlPullParser xmlPullParser, XmlEnvironment object) {
        ParserUtils.assertAtStartTag(xmlPullParser);
        assert (xmlPullParser.getName().equals("message"));
        XmlEnvironment xmlEnvironment = XmlEnvironment.from(xmlPullParser, (XmlEnvironment)object);
        int n = xmlPullParser.getDepth();
        object = PacketParserUtils.parseCommonStanzaAttributes(string -> StanzaBuilder.buildMessage(string), xmlPullParser, (XmlEnvironment)object);
        Object object2 = xmlPullParser.getAttributeValue("", "type");
        if (object2 != null) {
            ((MessageBuilder)object).ofType(Message.Type.fromString((String)object2));
        }
        block10: while (true) {
            object2 = xmlPullParser.next();
            block0 : switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$Event[object2.ordinal()]) {
                case 1: {
                    object2 = xmlPullParser.getName();
                    String string2 = xmlPullParser.getNamespace();
                    switch (object2) {
                        case "error": {
                            ((StanzaBuilder)object).setError(PacketParserUtils.parseError(xmlPullParser, xmlEnvironment));
                            break block0;
                        }
                    }
                    object2 = PacketParserUtils.parseExtensionElement((String)object2, string2, xmlPullParser, xmlEnvironment);
                    ((StanzaBuilder)object).addExtension((ExtensionElement)object2);
                    continue block10;
                }
                case 2: {
                    if (xmlPullParser.getDepth() == n) break block10;
                }
            }
        }
        return ((MessageBuilder)object).build();
    }

    public static String parseElementText(XmlPullParser xmlPullParser) {
        assert (xmlPullParser.getEventType() == XmlPullParser.Event.START_ELEMENT);
        XmlPullParser.Event event = xmlPullParser.next();
        if (event != XmlPullParser.Event.TEXT_CHARACTERS) {
            if (event == XmlPullParser.Event.END_ELEMENT) {
                return "";
            }
            throw new XmlPullParserException("Non-empty element tag not followed by text, while Mixed Content (XML 3.2.2) is disallowed");
        }
        String string = xmlPullParser.getText();
        event = xmlPullParser.next();
        if (event != XmlPullParser.Event.END_ELEMENT) {
            throw new XmlPullParserException("Non-empty element tag contains child-elements, while Mixed Content (XML 3.2.2) is disallowed");
        }
        return string;
    }

    public static CharSequence parseElement(XmlPullParser xmlPullParser) {
        return PacketParserUtils.parseElement(xmlPullParser, false);
    }

    public static CharSequence parseElement(XmlPullParser xmlPullParser, boolean bl) {
        assert (xmlPullParser.getEventType() == XmlPullParser.Event.START_ELEMENT);
        XmlPullParser xmlPullParser2 = xmlPullParser;
        return PacketParserUtils.parseContentDepth(xmlPullParser2, xmlPullParser2.getDepth(), bl);
    }

    public static CharSequence parseContentDepth(XmlPullParser xmlPullParser, int n) {
        return PacketParserUtils.parseContentDepth(xmlPullParser, n, false);
    }

    public static CharSequence parseContentDepth(XmlPullParser xmlPullParser, int n, boolean bl) {
        if (xmlPullParser.supportsRoundtrip()) {
            return PacketParserUtils.parseContentDepthWithRoundtrip(xmlPullParser, n);
        }
        return PacketParserUtils.parseContentDepthWithoutRoundtrip(xmlPullParser, n, bl);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static CharSequence parseContentDepthWithoutRoundtrip(XmlPullParser xmlPullParser, int n, boolean bl) {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
        XmlPullParser.Event event = xmlPullParser.getEventType();
        String string = null;
        boolean bl2 = false;
        while (true) {
            void var4_5;
            switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$Event[var4_5.ordinal()]) {
                case 1: {
                    void var4_9;
                    String string2;
                    if (bl2) {
                        xmlStringBuilder.rightAngleBracket();
                    } else {
                        bl2 = true;
                    }
                    xmlStringBuilder.halfOpenElement(xmlPullParser.getName());
                    if ((string == null || bl) && StringUtils.isNotEmpty((CharSequence)(string2 = xmlPullParser.getNamespace()))) {
                        xmlStringBuilder.attribute("xmlns", string2);
                        string = xmlPullParser.getName();
                    }
                    boolean bl3 = false;
                    while (var4_9 < xmlPullParser.getAttributeCount()) {
                        xmlStringBuilder.attribute(xmlPullParser.getAttributeName((int)var4_9), xmlPullParser.getAttributeValue((int)var4_9));
                        ++var4_9;
                    }
                    break;
                }
                case 2: {
                    if (bl2) {
                        xmlStringBuilder.closeEmptyElement();
                        bl2 = false;
                    } else {
                        xmlStringBuilder.closeElement(xmlPullParser.getName());
                    }
                    if (string != null && string.equals(xmlPullParser.getName())) {
                        string = null;
                    }
                    if (xmlPullParser.getDepth() > n) break;
                    return xmlStringBuilder;
                }
                case 3: {
                    if (bl2) {
                        bl2 = false;
                        xmlStringBuilder.rightAngleBracket();
                    }
                    xmlStringBuilder.escape(xmlPullParser.getText());
                }
            }
            XmlPullParser.Event event2 = xmlPullParser.next();
        }
    }

    private static XmlStringBuilder parseContentDepthWithRoundtrip(XmlPullParser xmlPullParser, int n) {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
        Object object = xmlPullParser.getEventType();
        boolean bl = false;
        block4: while (true) {
            switch (object) {
                case START_ELEMENT: {
                    bl = true;
                    object = xmlPullParser.getText();
                    xmlStringBuilder.append((CharSequence)object);
                    break;
                }
                case END_ELEMENT: {
                    CharSequence charSequence;
                    boolean bl2 = false;
                    if (bl) {
                        bl2 = true;
                        bl = false;
                    }
                    if (!bl2) {
                        charSequence = xmlPullParser.getText();
                        xmlStringBuilder.append(charSequence);
                    }
                    if (xmlPullParser.getDepth() > n) break;
                    break block4;
                }
                default: {
                    bl = false;
                    CharSequence charSequence = xmlPullParser.getText();
                    if (object == XmlPullParser.Event.TEXT_CHARACTERS) {
                        charSequence = StringUtils.escapeForXml(charSequence);
                    }
                    xmlStringBuilder.append(charSequence);
                }
            }
            object = xmlPullParser.next();
        }
        return xmlStringBuilder;
    }

    public static Presence parsePresence(XmlPullParser xmlPullParser) {
        return PacketParserUtils.parsePresence(xmlPullParser, XmlEnvironment.EMPTY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Presence parsePresence(XmlPullParser xmlPullParser, XmlEnvironment object) {
        ParserUtils.assertAtStartTag(xmlPullParser);
        int n = xmlPullParser.getDepth();
        XmlEnvironment xmlEnvironment = XmlEnvironment.from(xmlPullParser, (XmlEnvironment)object);
        object = PacketParserUtils.parseCommonStanzaAttributes(string -> StanzaBuilder.buildPresence(string), xmlPullParser, (XmlEnvironment)object);
        Object object2 = Presence.Type.available;
        String string2 = xmlPullParser.getAttributeValue("", "type");
        if (string2 != null && !string2.equals("")) {
            object2 = Presence.Type.fromString(string2);
        }
        ((PresenceBuilder)object).ofType((Presence.Type)((Object)object2));
        block18: while (true) {
            object2 = xmlPullParser.next();
            block1 : switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$Event[object2.ordinal()]) {
                case 1: {
                    object2 = xmlPullParser.getName();
                    string2 = xmlPullParser.getNamespace();
                    switch (object2) {
                        case "status": {
                            ((PresenceBuilder)object).setStatus(xmlPullParser.nextText());
                            break block1;
                        }
                        case "priority": {
                            object2 = ParserUtils.getByteAttributeFromNextText(xmlPullParser);
                            ((PresenceBuilder)object).setPriority((Byte)object2);
                            break block1;
                        }
                        case "show": {
                            object2 = xmlPullParser.nextText();
                            if (StringUtils.isNotEmpty((CharSequence)object2)) {
                                ((PresenceBuilder)object).setMode(Presence.Mode.fromString((String)object2));
                                break block1;
                            }
                            LOGGER.warning("Empty or null mode text in presence show element form " + object + "' which is invalid according to RFC6121 4.7.2.1");
                            break block1;
                        }
                        case "error": {
                            ((StanzaBuilder)object).setError(PacketParserUtils.parseError(xmlPullParser, xmlEnvironment));
                            break block1;
                        }
                    }
                    try {
                        object2 = PacketParserUtils.parseExtensionElement((String)object2, string2, xmlPullParser, xmlEnvironment);
                        ((StanzaBuilder)object).addExtension((ExtensionElement)object2);
                        break;
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.WARNING, "Failed to parse extension element in Presence stanza: " + object, exception);
                        continue block18;
                    }
                }
                case 2: {
                    if (xmlPullParser.getDepth() == n) break block18;
                }
            }
        }
        return ((PresenceBuilder)object).build();
    }

    public static IQ parseIQ(XmlPullParser xmlPullParser) {
        return PacketParserUtils.parseIQ(xmlPullParser, null);
    }

    public static IqData parseIqData(XmlPullParser object) {
        Object object2 = object.getAttributeValue("", "id");
        object2 = StanzaBuilder.buildIqData((String)object2);
        i i2 = ParserUtils.getJidAttribute(object, "to");
        ((StanzaBuilder)object2).to(i2);
        i2 = ParserUtils.getJidAttribute(object, "from");
        ((StanzaBuilder)object2).from(i2);
        object = object.getAttributeValue("", "type");
        object = IQ.Type.fromString((String)object);
        ((IqData)object2).ofType((IQ.Type)((Object)object));
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static IQ parseIQ(XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        ParserUtils.assertAtStartTag(xmlPullParser);
        int n = xmlPullParser.getDepth();
        XmlEnvironment xmlEnvironment2 = XmlEnvironment.from(xmlPullParser, xmlEnvironment);
        Object object = null;
        StanzaError stanzaError = null;
        IqData iqData = PacketParserUtils.parseIqData(xmlPullParser);
        block14: while (true) {
            Object object2 = xmlPullParser.next();
            block0 : switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$Event[object2.ordinal()]) {
                case 1: {
                    object2 = xmlPullParser.getName();
                    String string = xmlPullParser.getNamespace();
                    switch (object2) {
                        case "error": {
                            stanzaError = PacketParserUtils.parseError(xmlPullParser, xmlEnvironment2);
                            break block0;
                        }
                    }
                    object = ProviderManager.getIQProvider((String)object2, string);
                    if (object != null) {
                        object = ((IqProvider)object).parse(xmlPullParser, iqData, xmlEnvironment);
                        break;
                    }
                    object = new UnparsedIQ((String)object2, string, PacketParserUtils.parseElement(xmlPullParser));
                    continue block14;
                }
                case 2: {
                    if (xmlPullParser.getDepth() == n) break block14;
                }
            }
        }
        if (object == null) {
            switch (iqData.getType()) {
                case error: {
                    return ErrorIQ.builder(stanzaError, iqData).build();
                }
                case result: {
                    object = new EmptyResultIQ();
                    break;
                }
            }
        }
        ((Stanza)object).setStanzaId(iqData.getStanzaId());
        ((Stanza)object).setTo(iqData.getTo());
        ((Stanza)object).setFrom(iqData.getFrom());
        ((IQ)object).setType(iqData.getType());
        ((Stanza)object).setError(stanzaError);
        return object;
    }

    public static Collection<String> parseMechanisms(XmlPullParser xmlPullParser) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        while (!bl) {
            Object object = xmlPullParser.next();
            if (object == XmlPullParser.Event.START_ELEMENT) {
                object = xmlPullParser.getName();
                if (!object.equals("mechanism")) continue;
                arrayList.add(xmlPullParser.nextText());
                continue;
            }
            if (object != XmlPullParser.Event.END_ELEMENT || !xmlPullParser.getName().equals("mechanisms")) continue;
            bl = true;
        }
        return arrayList;
    }

    /*
     * Exception decompiling
     */
    public static Compress.Feature parseCompressionFeature(XmlPullParser var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CASE]], but top level block is 13[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map<String, String> parseDescriptiveTexts(XmlPullParser object, Map<String, String> map) {
        String string;
        if (map == null) {
            map = new HashMap<String, String>();
        }
        if ((string = ParserUtils.getXmlLang(object)) == null) {
            string = "";
        }
        object = object.nextText();
        object = map.put(string, (String)object);
        assert (object == null);
        return map;
    }

    public static StreamError parseStreamError(XmlPullParser xmlPullParser) {
        return PacketParserUtils.parseStreamError(xmlPullParser, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static StreamError parseStreamError(XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        int n = xmlPullParser.getDepth();
        ArrayList<ExtensionElement> arrayList = new ArrayList<ExtensionElement>();
        Map<String, String> map = null;
        StreamError.Condition condition = null;
        String string = null;
        xmlEnvironment = XmlEnvironment.from(xmlPullParser, xmlEnvironment);
        block16: while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String string2;
                    String string3 = xmlPullParser.getName();
                    block7 : switch (string2 = xmlPullParser.getNamespace()) {
                        case "urn:ietf:params:xml:ns:xmpp-streams": {
                            switch (string3) {
                                case "text": {
                                    map = PacketParserUtils.parseDescriptiveTexts(xmlPullParser, map);
                                    break block7;
                                }
                            }
                            condition = StreamError.Condition.fromString(string3);
                            string = xmlPullParser.nextText();
                            if (!string.isEmpty()) break block0;
                            string = null;
                            break block0;
                        }
                        default: {
                            PacketParserUtils.addExtensionElement(arrayList, xmlPullParser, string3, string2, xmlEnvironment);
                            break;
                        }
                    }
                    continue block16;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() == n) break block16;
                }
            }
        }
        return new StreamError(condition, string, map, arrayList);
    }

    public static StanzaError parseError(XmlPullParser xmlPullParser) {
        return PacketParserUtils.parseError(xmlPullParser, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static StanzaError parseError(XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        int n = xmlPullParser.getDepth();
        Map<String, String> map = null;
        xmlEnvironment = XmlEnvironment.from(xmlPullParser, xmlEnvironment);
        ArrayList<ExtensionElement> arrayList = new ArrayList<ExtensionElement>();
        StanzaError.Builder builder = StanzaError.getBuilder();
        builder.setType(StanzaError.Type.fromString(xmlPullParser.getAttributeValue("", "type")));
        builder.setErrorGenerator(xmlPullParser.getAttributeValue("", "by"));
        block16: while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String string;
                    String string2 = xmlPullParser.getName();
                    block7 : switch (string = xmlPullParser.getNamespace()) {
                        case "urn:ietf:params:xml:ns:xmpp-stanzas": {
                            switch (string2) {
                                case "text": {
                                    map = PacketParserUtils.parseDescriptiveTexts(xmlPullParser, map);
                                    break block7;
                                }
                            }
                            builder.setCondition(StanzaError.Condition.fromString(string2));
                            String string3 = xmlPullParser.nextText();
                            if (string3.isEmpty()) break block0;
                            builder.setConditionText(string3);
                            break block0;
                        }
                        default: {
                            PacketParserUtils.addExtensionElement(arrayList, xmlPullParser, string2, string, xmlEnvironment);
                            break;
                        }
                    }
                    continue block16;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() == n) break block16;
                }
            }
        }
        ((StanzaError.Builder)builder.setExtensions(arrayList)).setDescriptiveTexts(map);
        return builder.build();
    }

    public static ExtensionElement parseExtensionElement(String object, String string, XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        ParserUtils.assertAtStartTag(xmlPullParser);
        object = ProviderManager.getExtensionProvider((String)object, string);
        if (object != null) {
            return (ExtensionElement)((Provider)object).parse(xmlPullParser, xmlEnvironment);
        }
        return (ExtensionElement)StandardExtensionElementProvider.INSTANCE.parse(xmlPullParser, xmlEnvironment);
    }

    public static StartTls parseStartTlsFeature(XmlPullParser xmlPullParser) {
        ParserUtils.assertAtStartTag(xmlPullParser);
        assert (xmlPullParser.getNamespace().equals("urn:ietf:params:xml:ns:xmpp-tls"));
        int n = xmlPullParser.getDepth();
        boolean bl = false;
        block10: while (true) {
            Object object = xmlPullParser.next();
            switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$Event[object.ordinal()]) {
                case 1: {
                    switch (xmlPullParser.getName()) {
                        case "required": {
                            bl = true;
                        }
                    }
                    continue block10;
                }
                case 2: {
                    if (xmlPullParser.getDepth() == n) break block10;
                }
                default: {
                    continue block10;
                }
            }
            break;
        }
        ParserUtils.assertAtEndTag(xmlPullParser);
        return new StartTls(bl);
    }

    public static Session.Feature parseSessionFeature(XmlPullParser xmlPullParser) {
        ParserUtils.assertAtStartTag(xmlPullParser);
        int n = xmlPullParser.getDepth();
        boolean bl = false;
        block10: while (true) {
            Object object = xmlPullParser.next();
            switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$Event[object.ordinal()]) {
                case 1: {
                    switch (xmlPullParser.getName()) {
                        case "optional": {
                            bl = true;
                        }
                    }
                    continue block10;
                }
                case 2: {
                    if (xmlPullParser.getDepth() == n) break block10;
                }
                default: {
                    continue block10;
                }
            }
            break;
        }
        return new Session.Feature(bl);
    }

    public static void addExtensionElement(StanzaBuilder<?> stanzaBuilder, XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        ParserUtils.assertAtStartTag(xmlPullParser);
        XmlPullParser xmlPullParser2 = xmlPullParser;
        PacketParserUtils.addExtensionElement(stanzaBuilder, xmlPullParser2, xmlPullParser2.getName(), xmlPullParser.getNamespace(), xmlEnvironment);
    }

    public static void addExtensionElement(StanzaBuilder<?> stanzaBuilder, XmlPullParser object, String string, String string2, XmlEnvironment xmlEnvironment) {
        object = PacketParserUtils.parseExtensionElement(string, string2, object, xmlEnvironment);
        stanzaBuilder.addExtension((ExtensionElement)object);
    }

    public static void addExtensionElement(Stanza stanza, XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        ParserUtils.assertAtStartTag(xmlPullParser);
        XmlPullParser xmlPullParser2 = xmlPullParser;
        PacketParserUtils.addExtensionElement(stanza, xmlPullParser2, xmlPullParser2.getName(), xmlPullParser.getNamespace(), xmlEnvironment);
    }

    public static void addExtensionElement(Stanza stanza, XmlPullParser object, String string, String string2, XmlEnvironment xmlEnvironment) {
        object = PacketParserUtils.parseExtensionElement(string, string2, object, xmlEnvironment);
        stanza.addExtension((ExtensionElement)object);
    }

    public static void addExtensionElement(Collection<ExtensionElement> collection, XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        XmlPullParser xmlPullParser2 = xmlPullParser;
        PacketParserUtils.addExtensionElement(collection, xmlPullParser2, xmlPullParser2.getName(), xmlPullParser.getNamespace(), xmlEnvironment);
    }

    public static void addExtensionElement(Collection<ExtensionElement> collection, XmlPullParser object, String string, String string2, XmlEnvironment xmlEnvironment) {
        object = PacketParserUtils.parseExtensionElement(string, string2, object, xmlEnvironment);
        collection.add((ExtensionElement)object);
    }

    private static interface StanzaBuilderSupplier<SB extends StanzaBuilder<?>> {
        public SB get(String var1);
    }
}

