/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.LinesSequence;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u0017\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0087\b\u001a\u0017\u0010\u0000\u001a\u00020\u0005*\u00020\u00062\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0087\b\u001a\u001e\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\n\u001a\u0010\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r*\u00020\u0002\u001aB\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f*\u00020\u00022\u0018\u0010\u0010\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0011\u0012\u0004\u0012\u0002H\u000f0\nH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0002\u0010\u0012\u001a\r\u0010\u0013\u001a\u00020\u0014*\u00020\u000bH\u0087\b\u001a\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011*\u00020\u0001\u001a\n\u0010\u0016\u001a\u00020\u000b*\u00020\u0002\u001a\u001c\u0010\u0017\u001a\u00020\u0018*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00062\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u0017\u0010\u0016\u001a\u00020\u000b*\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0087\b\u001a\n\u0010\u001d\u001a\u00020\u001e*\u00020\u001a\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"buffered", "Ljava/io/BufferedReader;", "Ljava/io/Reader;", "bufferSize", "", "Ljava/io/BufferedWriter;", "Ljava/io/Writer;", "forEachLine", "", "action", "Lkotlin/Function1;", "", "readLines", "", "useLines", "T", "block", "Lkotlin/sequences/Sequence;", "(Ljava/io/Reader;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "reader", "Ljava/io/StringReader;", "lineSequence", "readText", "copyTo", "", "out", "Ljava/net/URL;", "charset", "Ljava/nio/charset/Charset;", "readBytes", "", "kotlin-stdlib"})
public final class TextStreamsKt {
    private static final BufferedReader buffered(Reader reader, int n) {
        Intrinsics.checkNotNullParameter(reader, "");
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader, n);
    }

    static /* synthetic */ BufferedReader buffered$default(Reader reader, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 8192;
        }
        Intrinsics.checkNotNullParameter(reader, "");
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader, n);
    }

    private static final BufferedWriter buffered(Writer writer, int n) {
        Intrinsics.checkNotNullParameter(writer, "");
        if (writer instanceof BufferedWriter) {
            return (BufferedWriter)writer;
        }
        return new BufferedWriter(writer, n);
    }

    static /* synthetic */ BufferedWriter buffered$default(Writer writer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 8192;
        }
        Intrinsics.checkNotNullParameter(writer, "");
        if (writer instanceof BufferedWriter) {
            return (BufferedWriter)writer;
        }
        return new BufferedWriter(writer, n);
    }

    public static final void forEachLine(Reader closeable, Function1<? super String, Unit> object) {
        Intrinsics.checkNotNullParameter(closeable, "");
        Intrinsics.checkNotNullParameter(object, "");
        Reader reader = closeable;
        closeable = reader;
        closeable = reader;
        closeable = reader instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, 8192);
        Throwable throwable = null;
        try {
            Object object2 = (BufferedReader)closeable;
            Sequence<String> sequence = TextStreamsKt.lineSequence((BufferedReader)object2);
            object2 = sequence;
            object2 = sequence;
            object2 = sequence.iterator();
            while (object2.hasNext()) {
                Object e = object2.next();
                object.invoke(e);
            }
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                CloseableKt.closeFinally(closeable, throwable);
                throw throwable3;
            }
        }
        CloseableKt.closeFinally(closeable, null);
        return;
    }

    public static final List<String> readLines(Reader reader) {
        Intrinsics.checkNotNullParameter(reader, "");
        ArrayList arrayList = new ArrayList();
        TextStreamsKt.forEachLine(reader, arg_0 -> TextStreamsKt.readLines$lambda$1(arrayList, arg_0));
        return arrayList;
    }

    public static final <T> T useLines(Reader closeable, Function1<? super Sequence<String>, ? extends T> object) {
        BufferedReader bufferedReader;
        Intrinsics.checkNotNullParameter(closeable, "");
        Intrinsics.checkNotNullParameter(object, "");
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, 8192);
        Throwable throwable = null;
        try {
            bufferedReader = (BufferedReader)closeable;
            bufferedReader = object.invoke(TextStreamsKt.lineSequence(bufferedReader));
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                InlineMarker.finallyStart(1);
                CloseableKt.closeFinally(closeable, throwable);
                InlineMarker.finallyEnd(1);
                throw throwable3;
            }
        }
        InlineMarker.finallyStart(1);
        CloseableKt.closeFinally(closeable, null);
        InlineMarker.finallyEnd(1);
        return (T)bufferedReader;
    }

    private static final StringReader reader(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        return new StringReader(string);
    }

    public static final Sequence<String> lineSequence(BufferedReader bufferedReader) {
        Intrinsics.checkNotNullParameter(bufferedReader, "");
        return SequencesKt.constrainOnce(new LinesSequence(bufferedReader));
    }

    public static final String readText(Reader reader) {
        Intrinsics.checkNotNullParameter(reader, "");
        StringWriter stringWriter = new StringWriter();
        TextStreamsKt.copyTo$default(reader, stringWriter, 0, 2, null);
        String string = stringWriter.toString();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    public static final long copyTo(Reader reader, Writer writer, int n) {
        Intrinsics.checkNotNullParameter(reader, "");
        Intrinsics.checkNotNullParameter(writer, "");
        long l = 0L;
        char[] cArray = new char[n];
        int n2 = reader.read(cArray);
        while (n2 >= 0) {
            writer.write(cArray, 0, n2);
            l += (long)n2;
            n2 = reader.read(cArray);
        }
        return l;
    }

    public static /* synthetic */ long copyTo$default(Reader reader, Writer writer, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        return TextStreamsKt.copyTo(reader, writer, n);
    }

    private static final String readText(URL object, Charset charset) {
        Intrinsics.checkNotNullParameter(object, "");
        Intrinsics.checkNotNullParameter(charset, "");
        object = TextStreamsKt.readBytes((URL)object);
        return new String((byte[])object, charset);
    }

    static /* synthetic */ String readText$default(URL uRL, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter(uRL, "");
        Intrinsics.checkNotNullParameter(charset, "");
        byte[] byArray = TextStreamsKt.readBytes(uRL);
        return new String(byArray, charset);
    }

    public static final byte[] readBytes(URL object) {
        Object object2;
        Intrinsics.checkNotNullParameter(object, "");
        object = ((URL)object).openStream();
        Throwable throwable = null;
        try {
            object2 = (InputStream)object;
            Intrinsics.checkNotNull(object2);
            object2 = ByteStreamsKt.readBytes((InputStream)object2);
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                CloseableKt.closeFinally((Closeable)object, throwable);
                throw throwable4;
            }
        }
        CloseableKt.closeFinally((Closeable)object, null);
        return object2;
    }

    private static final Unit readLines$lambda$1(ArrayList arrayList, String string) {
        Intrinsics.checkNotNullParameter(string, "");
        arrayList.add(string);
        return Unit.INSTANCE;
    }
}

