/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.ui.internal.InlineClassHelperKt;
import androidx.compose.ui.node.MyersDiffKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0086\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003J\u001e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0010J \u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J \u0010 \u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003H\u0002J\u0018\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006'"}, d2={"Landroidx/compose/ui/node/IntStack;", "", "initialCapacity", "", "<init>", "(I)V", "stack", "", "lastIndex", "get", "index", "size", "getSize", "()I", "resizeStack", "pushRange", "", "oldStart", "oldEnd", "newStart", "newEnd", "pushDiagonal", "x", "y", "pop", "isNotEmpty", "", "sortDiagonals", "quickSort", "start", "end", "elSize", "partition", "swapDiagonal", "i", "j", "compareDiagonal", "a", "b", "ui"})
final class IntStack {
    private int[] stack;
    private int lastIndex;

    public IntStack(int n2) {
        this.stack = new int[n2];
    }

    public final int get(int n2) {
        return this.stack[n2];
    }

    public final int getSize() {
        return this.lastIndex;
    }

    private final int[] resizeStack(int[] nArray) {
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length << 1);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"");
        nArray = nArray2;
        this.stack = nArray;
        return nArray;
    }

    public final void pushRange(int n2, int n3, int n4, int n5) {
        int n6 = this.lastIndex;
        int[] nArray = this.stack;
        if (n6 + 4 >= nArray.length) {
            nArray = this.resizeStack(nArray);
        }
        nArray[n6] = n2;
        nArray[n6 + 1] = n3;
        nArray[n6 + 2] = n4;
        nArray[n6 + 3] = n5;
        this.lastIndex = n6 + 4;
    }

    public final void pushDiagonal(int n2, int n3, int n4) {
        int n5 = this.lastIndex;
        int[] nArray = this.stack;
        if (n5 + 3 >= nArray.length) {
            nArray = this.resizeStack(nArray);
        }
        nArray[n5] = n2 + n4;
        nArray[n5 + 1] = n3 + n4;
        nArray[n5 + 2] = n4;
        this.lastIndex = n5 + 3;
    }

    public final int pop() {
        this.lastIndex += -1;
        return this.stack[this.lastIndex];
    }

    public final boolean isNotEmpty() {
        return this.lastIndex != 0;
    }

    public final void sortDiagonals() {
        int n2 = this.lastIndex;
        boolean bl = n2 % 3 == 0;
        if (!bl) {
            InlineClassHelperKt.throwIllegalStateException("Array size not a multiple of 3");
        }
        if (n2 > 3) {
            this.quickSort(0, n2 - 3, 3);
        }
    }

    private final void quickSort(int n2, int n3, int n4) {
        while (n2 < n3) {
            int n5 = this.partition(n2, n3, n4);
            this.quickSort(n2, n5 - n4, n4);
            n2 = n5 + n4;
        }
    }

    private final int partition(int n2, int n3, int n4) {
        int n5 = n2 - n4;
        while (n2 < n3) {
            if (this.compareDiagonal(n2, n3)) {
                this.swapDiagonal(n5 += n4, n2);
            }
            n2 += n4;
        }
        this.swapDiagonal(n5 + n4, n3);
        return n5 + n4;
    }

    private final void swapDiagonal(int n2, int n3) {
        int[] nArray = this.stack;
        MyersDiffKt.access$swap(this.stack, n2, n3);
        MyersDiffKt.access$swap(nArray, n2 + 1, n3 + 1);
        MyersDiffKt.access$swap(nArray, n2 + 2, n3 + 2);
    }

    private final boolean compareDiagonal(int n2, int n3) {
        int n4 = this.stack[n2];
        int[] nArray = this.stack;
        int n5 = nArray[n3];
        return n4 < n5 || n4 == n5 && nArray[n2 + 1] <= nArray[n3 + 1];
    }
}

