/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.spatial;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.node.DelegatableNode;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.spatial.RectList;
import androidx.compose.ui.spatial.RectManager;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntRect;
import androidx.compose.ui.unit.IntRectKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001BC\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0'J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0000J&\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0019J\u0006\u00100\u001a\u00020)J\u001d\u00101\u001a\u00020)2\u0006\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u0006\u00a2\u0006\u0004\b4\u00105J\u0013\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00109\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0010\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010!R\u0011\u0010$\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010!\u00a8\u0006:"}, d2={"Landroidx/compose/ui/spatial/RelativeLayoutBounds;", "", "topLeft", "", "bottomRight", "windowOffset", "Landroidx/compose/ui/unit/IntOffset;", "screenOffset", "windowSize", "viewToWindowMatrix", "Landroidx/compose/ui/graphics/Matrix;", "node", "Landroidx/compose/ui/node/DelegatableNode;", "<init>", "(JJJJJ[FLandroidx/compose/ui/node/DelegatableNode;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "[F", "positionInRoot", "getPositionInRoot-nOcc-ac", "()J", "positionInWindow", "getPositionInWindow-nOcc-ac", "positionInScreen", "getPositionInScreen-nOcc-ac", "width", "", "getWidth", "()I", "height", "getHeight", "boundsInRoot", "Landroidx/compose/ui/unit/IntRect;", "getBoundsInRoot", "()Landroidx/compose/ui/unit/IntRect;", "boundsInWindow", "getBoundsInWindow", "boundsInScreen", "getBoundsInScreen", "calculateOcclusions", "", "fractionVisibleIn", "", "viewport", "fractionVisibleInRect", "left", "top", "right", "bottom", "fractionVisibleInWindow", "fractionVisibleInWindowWithInsets", "topLeftInset", "bottomRightInset", "fractionVisibleInWindowWithInsets-E1MhUcY", "(JJ)F", "equals", "", "other", "hashCode", "ui"})
public final class RelativeLayoutBounds {
    private final long topLeft;
    private final long bottomRight;
    private final long windowOffset;
    private final long screenOffset;
    private final long windowSize;
    private final float[] viewToWindowMatrix;
    private final DelegatableNode node;
    public static final int $stable = 8;

    private RelativeLayoutBounds(long l2, long l3, long l4, long l5, long l6, float[] fArray, DelegatableNode delegatableNode) {
        Intrinsics.checkNotNullParameter((Object)delegatableNode, (String)"");
        this.topLeft = l2;
        this.bottomRight = l3;
        this.windowOffset = l4;
        this.screenOffset = l5;
        this.windowSize = l6;
        this.viewToWindowMatrix = fArray;
        this.node = delegatableNode;
    }

    public final long getPositionInRoot-nOcc-ac() {
        return IntOffset.constructor-impl((long)this.topLeft);
    }

    public final long getPositionInWindow-nOcc-ac() {
        int n2 = IntOffset.getX-impl((long)this.screenOffset) - IntOffset.getX-impl((long)this.windowOffset);
        int n3 = IntOffset.getY-impl((long)this.screenOffset) - IntOffset.getY-impl((long)this.windowOffset);
        long l2 = this.topLeft;
        int n4 = (int)(l2 >> 32);
        long l3 = this.topLeft;
        int n5 = (int)l3;
        int n6 = n4 + n2;
        int n7 = n5 + n3;
        return IntOffset.constructor-impl((long)((long)n6 << 32 | (long)n7 & 0xFFFFFFFFL));
    }

    public final long getPositionInScreen-nOcc-ac() {
        int n2 = IntOffset.getX-impl((long)this.screenOffset);
        int n3 = IntOffset.getY-impl((long)this.screenOffset);
        long l2 = this.topLeft;
        int n4 = (int)(l2 >> 32);
        long l3 = this.topLeft;
        int n5 = (int)l3;
        int n6 = n4 + n2;
        int n7 = n5 + n3;
        return IntOffset.constructor-impl((long)((long)n6 << 32 | (long)n7 & 0xFFFFFFFFL));
    }

    public final int getWidth() {
        long l2 = this.topLeft;
        int n2 = (int)(l2 >> 32);
        long l3 = this.bottomRight;
        int n3 = (int)(l3 >> 32);
        return n3 - n2;
    }

    public final int getHeight() {
        long l2 = this.topLeft;
        int n2 = (int)l2;
        long l3 = this.bottomRight;
        int n3 = (int)l3;
        return n3 - n2;
    }

    public final IntRect getBoundsInRoot() {
        long l2 = this.topLeft;
        int n2 = (int)(l2 >> 32);
        long l3 = this.topLeft;
        int n3 = (int)l3;
        long l4 = this.bottomRight;
        int n4 = (int)(l4 >> 32);
        long l5 = this.bottomRight;
        int n5 = (int)l5;
        return new IntRect(n2, n3, n4, n5);
    }

    public final IntRect getBoundsInWindow() {
        long l2 = this.topLeft;
        int n2 = (int)(l2 >> 32);
        long l3 = this.topLeft;
        int n3 = (int)l3;
        long l4 = this.bottomRight;
        int n4 = (int)(l4 >> 32);
        long l5 = this.bottomRight;
        int n5 = (int)l5;
        if (this.viewToWindowMatrix != null) {
            return IntRectKt.roundToIntRect((Rect)Matrix.map-impl((float[])this.viewToWindowMatrix, (Rect)new Rect((float)n2, (float)n3, (float)n4, (float)n5)));
        }
        int n6 = IntOffset.getX-impl((long)this.screenOffset) - IntOffset.getX-impl((long)this.windowOffset);
        int n7 = IntOffset.getY-impl((long)this.screenOffset) - IntOffset.getY-impl((long)this.windowOffset);
        return new IntRect(n2 + n6, n3 + n7, n4 + n6, n5 + n7);
    }

    public final IntRect getBoundsInScreen() {
        if (this.viewToWindowMatrix != null) {
            IntRect intRect = this.getBoundsInWindow();
            long l2 = this.windowOffset;
            return new IntRect(intRect.getLeft() + IntOffset.getX-impl((long)l2), intRect.getTop() + IntOffset.getY-impl((long)l2), intRect.getRight() + IntOffset.getX-impl((long)l2), intRect.getBottom() + IntOffset.getY-impl((long)l2));
        }
        long l3 = this.topLeft;
        int n2 = (int)(l3 >> 32);
        long l4 = this.topLeft;
        int n3 = (int)l4;
        long l5 = this.bottomRight;
        int n4 = (int)(l5 >> 32);
        long l6 = this.bottomRight;
        int n5 = (int)l6;
        int n6 = IntOffset.getX-impl((long)this.screenOffset);
        int n7 = IntOffset.getY-impl((long)this.screenOffset);
        return new IntRect(n2 + n6, n3 + n7, n4 + n6, n5 + n7);
    }

    public final List<IntRect> calculateOcclusions() {
        List list;
        RectManager rectManager = DelegatableNodeKt.requireOwner(this.node).getRectManager();
        int n2 = DelegatableNodeKt.requireLayoutNode(this.node).getSemanticsId();
        RectList rectList = rectManager.getRects();
        int n3 = rectList.indexOf(n2);
        if (n3 < 0) {
            return CollectionsKt.emptyList();
        }
        List list2 = list = CollectionsKt.createListBuilder();
        long[] lArray = rectList.items;
        int n4 = rectList.itemsSize;
        long l2 = lArray[n3];
        long l3 = lArray[n3 + 1];
        int n5 = 0;
        while (n5 < lArray.length - 2 && n5 < n4) {
            if (n5 == n3) {
                n5 += 3;
                continue;
            }
            long l4 = lArray[n5];
            long l5 = lArray[n5 + 1];
            long l6 = l3 - l4 - 0x100000001L | l5 - l2 - 0x100000001L;
            if ((l6 & 0x8000000080000000L) == 0L) {
                long l7 = lArray[n5 + 2];
                int n6 = (int)l7 & 0x3FFFFFF;
                int n7 = (int)l5;
                int n8 = (int)(l5 >> 32);
                int n9 = (int)l4;
                int n10 = (int)(l4 >> 32);
                if (rectManager.isTargetDrawnFirst$ui(n2, n6)) {
                    list2.add(new IntRect(n10, n9, n8, n7));
                }
            }
            n5 += 3;
        }
        return CollectionsKt.build((List)list);
    }

    public final float fractionVisibleIn(RelativeLayoutBounds relativeLayoutBounds) {
        Intrinsics.checkNotNullParameter((Object)relativeLayoutBounds, (String)"");
        long l2 = relativeLayoutBounds.topLeft;
        long l3 = relativeLayoutBounds.bottomRight;
        return this.fractionVisibleInRect((int)(l2 >> 32), (int)l2, (int)(l3 >> 32), (int)l3);
    }

    public final float fractionVisibleInRect(int n2, int n3, int n4, int n5) {
        long l2 = this.topLeft;
        int n6 = (int)(l2 >> 32);
        int n7 = Math.min(Math.max(n6, n2), n4);
        long l3 = this.topLeft;
        int n8 = (int)l3;
        int n9 = Math.min(Math.max(n8, n3), n5);
        long l4 = this.bottomRight;
        int n10 = (int)(l4 >> 32);
        int n11 = Math.max(Math.min(n10, n4), n2);
        long l5 = this.bottomRight;
        int n12 = (int)l5;
        int n13 = Math.max(Math.min(n12, n5), n3);
        int n14 = (n4 - n2) * (n5 - n3);
        n2 = (n10 - n6) * (n12 - n8);
        n3 = Math.max((n11 - n7) * (n13 - n9), 0);
        n2 = Math.min(n14, n2);
        return (float)n3 / (float)n2;
    }

    public final float fractionVisibleInWindow() {
        long l2 = this.windowSize;
        return this.fractionVisibleInRect(0, 0, (int)(l2 >> 32), (int)l2);
    }

    public final float fractionVisibleInWindowWithInsets-E1MhUcY(long l2, long l3) {
        long l4 = this.windowSize;
        int n2 = IntOffset.getX-impl((long)this.windowOffset);
        int n3 = IntOffset.getY-impl((long)this.windowOffset);
        return this.fractionVisibleInRect(n2 + IntOffset.getX-impl((long)l2), n3 + IntOffset.getY-impl((long)l2), n2 + (int)(l4 >> 32) - IntOffset.getX-impl((long)l3), n3 + (int)l4 - IntOffset.getY-impl((long)l3));
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RelativeLayoutBounds cfr_ignored_0 = (RelativeLayoutBounds)object;
        if (this.topLeft != ((RelativeLayoutBounds)object).topLeft) {
            return false;
        }
        if (this.bottomRight != ((RelativeLayoutBounds)object).bottomRight) {
            return false;
        }
        if (this.windowSize != ((RelativeLayoutBounds)object).windowSize) {
            return false;
        }
        if (!IntOffset.equals-impl0((long)this.windowOffset, (long)((RelativeLayoutBounds)object).windowOffset)) {
            return false;
        }
        if (!IntOffset.equals-impl0((long)this.screenOffset, (long)((RelativeLayoutBounds)object).screenOffset)) {
            return false;
        }
        float[] fArray = this.viewToWindowMatrix;
        float[] fArray2 = ((RelativeLayoutBounds)object).viewToWindowMatrix;
        if (!(fArray == null ? fArray2 == null : (fArray2 == null ? false : Matrix.equals-impl0((float[])fArray, (float[])fArray2)))) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.node, (Object)((RelativeLayoutBounds)object).node);
    }

    public final int hashCode() {
        int n2 = Long.hashCode(this.topLeft);
        n2 = n2 * 31 + Long.hashCode(this.bottomRight);
        n2 = n2 * 31 + Long.hashCode(this.windowSize);
        n2 = n2 * 31 + IntOffset.hashCode-impl((long)this.windowOffset);
        n2 = n2 * 31 + IntOffset.hashCode-impl((long)this.screenOffset);
        n2 = n2 * 31 + (this.viewToWindowMatrix != null ? Matrix.hashCode-impl((float[])this.viewToWindowMatrix) : 0);
        n2 = n2 * 31 + this.node.hashCode();
        return n2;
    }

    public /* synthetic */ RelativeLayoutBounds(long l2, long l3, long l4, long l5, long l6, float[] fArray, DelegatableNode delegatableNode, DefaultConstructorMarker defaultConstructorMarker) {
        this(l2, l3, l4, l5, l6, fArray, delegatableNode);
    }
}

