/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.os.OS;
import dorkbox.util.Sys;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\t\u00a8\u0006\f"}, d2={"Ldorkbox/util/LocationResolver;", "", "()V", "getDirectoryContents", "", "", "clazz", "Ljava/lang/Class;", "path", "(Ljava/lang/Class;Ljava/lang/String;)[Ljava/lang/String;", "Companion", "Root", "Utilities"})
public final class LocationResolver {
    public static final Companion Companion = new Companion(null);
    private static final String version = Sys.INSTANCE.getVersion();
    private static final Pattern SLASH_PATTERN = Pattern.compile("\\\\");

    public final String[] getDirectoryContents(Class<?> enumeration, String string) {
        Intrinsics.checkNotNullParameter(enumeration, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Object object = ((Class)((Object)enumeration)).getClassLoader().getResource(string);
        if (object != null && Intrinsics.areEqual((Object)((URL)object).getProtocol(), (Object)"file")) {
            String[] stringArray = new File(((URL)object).toURI()).list();
            Intrinsics.checkNotNull((Object)stringArray);
            return stringArray;
        }
        if (object == null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = ((Class)((Object)enumeration)).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
            object = stringBuilder.append(StringsKt.replace$default((String)string2, (String)".", (String)"/", (boolean)false, (int)4, null)).append(".class").toString();
            object = ((Class)((Object)enumeration)).getClassLoader().getResource((String)object);
        }
        URL uRL = object;
        Intrinsics.checkNotNull((Object)uRL);
        if (Intrinsics.areEqual((Object)uRL.getProtocol(), (Object)"jar")) {
            Object object2;
            String string3 = ((URL)object).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
            enumeration = string3;
            String string4 = ((URL)object).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
            int n = StringsKt.indexOf$default((CharSequence)string4, (String)"!", (int)0, (boolean)false, (int)6, null);
            String string5 = ((String)((Object)enumeration)).substring(5, n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"");
            Object object3 = string5;
            enumeration = new JarFile(URLDecoder.decode((String)object3, "UTF-8"));
            enumeration = ((JarFile)((Object)enumeration)).entries();
            object3 = new HashSet();
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement().getName();
                Intrinsics.checkNotNull((Object)object2);
                if (!StringsKt.startsWith$default((String)object2, (String)string, (boolean)false, (int)2, null)) continue;
                String string6 = ((String)object2).substring(string.length());
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"");
                object2 = string6;
                int n2 = StringsKt.indexOf$default((CharSequence)string6, (String)"/", (int)0, (boolean)false, (int)6, null);
                if (n2 >= 0) {
                    String string7 = ((String)object2).substring(0, n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"");
                    object2 = string7;
                }
                object3.add(object2);
            }
            object2 = (Collection)object3;
            Collection collection = object2;
            return object2.toArray(new String[0]);
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + object);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\b\u0002\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0087\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\u0007J\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\b\u0010\u001a\u001a\u00020\u0007H\u0002J\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0007J&\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 H\u0002J \u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\"\u001a\u00020\u000f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070$H\u0002J\u001e\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006'"}, d2={"Ldorkbox/util/LocationResolver$Companion;", "", "()V", "SLASH_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "version", "", "getVersion", "()Ljava/lang/String;", "get", "Ljava/io/File;", "clazz", "Ljava/lang/Class;", "getResource", "Ljava/net/URL;", "resourceName", "getResourceAsStream", "Ljava/io/InputStream;", "getResources", "Ljava/util/Enumeration;", "log", "", "message", "normalizePath", "path", "prefix", "searchResource", "visitDir", "root", "dir", "out", "", "visitRoot", "url", "resources", "", "visitZip", "jar", "Utilities"})
    public static final class Companion {
        private Companion() {
        }

        public final String getVersion() {
            return version;
        }

        private final void log(String string) {
            System.err.println(this.prefix() + string);
        }

        private final String normalizePath(String string) {
            string = SLASH_PATTERN.matcher(string).replaceAll("/");
            String string2 = URLDecoder.decode(string, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
            return string2;
        }

        public final File get(Class<?> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            object = ((Class)object).getProtectionDomain();
            object = ((ProtectionDomain)object).getCodeSource();
            URL uRL = ((CodeSource)object).getLocation();
            if (uRL == null) {
                return null;
            }
            object = uRL;
            try {
                String string = ((URL)object).getFile();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                object = new File(this.normalizePath(string)).getAbsoluteFile().getCanonicalFile();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("Unable to decode file path!", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to get canonical file path!", iOException);
            }
            return object;
        }

        public static /* synthetic */ File get$default(Companion companion, Class clazz, int n, Object object) {
            if ((n & 1) != 0) {
                clazz = LocationResolver.class;
            }
            return companion.get(clazz);
        }

        public final URL getResource(String string) {
            Serializable serializable;
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            try {
                string = this.normalizePath(string);
            }
            catch (IOException iOException) {
                serializable = iOException;
                iOException.printStackTrace();
            }
            serializable = null;
            Serializable serializable2 = new File(string);
            if (serializable2.canRead()) {
                try {
                    serializable = serializable2.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    serializable2 = malformedURLException;
                    malformedURLException.printStackTrace();
                }
            }
            if (serializable == null) {
                serializable = Thread.currentThread().getContextClassLoader().getResource(string);
            }
            if (serializable == null) {
                serializable = ClassLoader.getSystemResource(string);
            }
            if (serializable == null) {
                try {
                    this.searchResource(string);
                }
                catch (IOException iOException) {
                    serializable2 = iOException;
                    iOException.printStackTrace();
                }
            }
            return serializable;
        }

        public final Enumeration<URL> getResources(String string) {
            Enumeration<URL> enumeration;
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            try {
                string = this.normalizePath(string);
            }
            catch (IOException iOException) {
                enumeration = iOException;
                iOException.printStackTrace();
            }
            enumeration = null;
            try {
                File[] fileArray = new File(string);
                if (fileArray.canRead()) {
                    ArrayDeque<URL> arrayDeque = new ArrayDeque<URL>(4);
                    arrayDeque.add(fileArray.toURI().toURL());
                    if (fileArray.isDirectory() && (fileArray = fileArray.listFiles()) != null) {
                        int n = fileArray.length;
                        for (int i = 0; i < n; ++i) {
                            arrayDeque.add(fileArray[i].toURI().toURL());
                        }
                    }
                    enumeration = new Vector(arrayDeque).elements();
                }
                if (enumeration == null) {
                    enumeration = Thread.currentThread().getContextClassLoader().getResources(string);
                }
                if (enumeration == null) {
                    enumeration = ClassLoader.getSystemResources(string);
                }
                if (enumeration == null) {
                    this.searchResource(string);
                }
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                iOException.printStackTrace();
            }
            return enumeration;
        }

        public final InputStream getResourceAsStream(String string) {
            IOException iOException;
            Object object;
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            try {
                string = this.normalizePath(string);
            }
            catch (IOException iOException2) {
                object = iOException2;
                iOException2.printStackTrace();
            }
            object = null;
            if (new File(string).canRead()) {
                try {
                    object = new FileInputStream(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    iOException = fileNotFoundException;
                    fileNotFoundException.printStackTrace();
                }
            }
            if (object == null) {
                object = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
            }
            if (object == null) {
                object = ClassLoader.getSystemResourceAsStream(string);
            }
            if (object == null) {
                try {
                    this.searchResource(string);
                }
                catch (IOException iOException3) {
                    iOException = iOException3;
                    iOException3.printStackTrace();
                }
            }
            return object;
        }

        public final void searchResource(String string) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            try {
                string = this.normalizePath(string);
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
            }
            object = new ArrayList();
            URL[] uRLArray = Thread.currentThread().getContextClassLoader();
            if (uRLArray instanceof URLClassLoader) {
                uRLArray = ((URLClassLoader)uRLArray).getURLs();
                Intrinsics.checkNotNull((Object)uRLArray);
                for (URL uRL : uRLArray) {
                    Intrinsics.checkNotNull((Object)uRL);
                    object.add(new Root(uRL));
                }
                System.err.println();
                this.log("SEARCHING: \"" + string + '\"');
                for (int i = 1; i < 7; ++i) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Root root = (Root)iterator.next();
                        if (!root.search(string, i)) continue;
                        return;
                    }
                }
                this.log("FAILED: failed to find anything like");
                this.log("               \"" + string + '\"');
                this.log("         in all classpath entries:");
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Root root = (Root)iterator.next();
                    File file = root.getEntry();
                    if (file == null) continue;
                    this.log("               \"" + file.getAbsolutePath() + '\"');
                }
            } else {
                throw new IOException("Unable to search for '" + string + "' in the context classloader of type '" + uRLArray.getClass() + "'.  Please report this issue with as many specific details as possible (OS, Java version, application version");
            }
        }

        private final File visitRoot(URL object, List<String> list) {
            Object object2;
            if (!Intrinsics.areEqual((Object)((URL)object).getProtocol(), (Object)"file")) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            object = ((URL)object).getPath();
            if (OS.INSTANCE.isWindows()) {
                object2 = object;
                Intrinsics.checkNotNull((Object)object2);
                if (StringsKt.startsWith$default((String)object2, (String)"/", (boolean)false, (int)2, null)) {
                    object2 = object;
                    Intrinsics.checkNotNull((Object)object2);
                    String string = ((String)object2).substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                    object = string;
                }
            }
            if (!((File)(object2 = new File((String)object))).exists()) {
                this.log("failed to find classpath entry in filesystem: " + (String)object);
                return null;
            }
            if (((File)object2).isDirectory()) {
                Companion companion = this;
                String string = ((File)object2).getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                companion.visitDir(companion.normalizePath(string), (File)object2, (Collection<String>)list);
            } else {
                String string = ((File)object2).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                string2 = string3;
                if (StringsKt.endsWith$default((String)string3, (String)".zip", (boolean)false, (int)2, null)) {
                    this.visitZip((File)object2, (Collection<String>)list);
                } else if (StringsKt.endsWith$default((String)string2, (String)".jar", (boolean)false, (int)2, null)) {
                    this.visitZip((File)object2, (Collection<String>)list);
                } else {
                    this.log("unknown classpath entry type: " + (String)object);
                    return null;
                }
            }
            return object2;
        }

        private final void visitDir(String string, File fileArray, Collection<String> collection) {
            if ((fileArray = fileArray.listFiles()) != null) {
                for (File file : fileArray) {
                    if (file.isDirectory()) {
                        Intrinsics.checkNotNull((Object)file);
                        this.visitDir(string, file, collection);
                    }
                    String string2 = file.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                    String object = StringsKt.replace$default((String)string2, (char)'\\', (char)'/', (boolean)false, (int)4, null);
                    int n = string.length() + 1;
                    String string3 = object.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                    collection.add(string3);
                }
            }
        }

        private final void visitZip(File object, Collection<String> collection) {
            object = new ZipInputStream(new FileInputStream((File)object));
            while (((ZipInputStream)object).getNextEntry() != null) {
                ZipEntry zipEntry;
                String string = zipEntry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                collection.add(StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null));
            }
            ((ZipInputStream)object).close();
        }

        private final String prefix() {
            return "[" + LocationResolver.class.getSimpleName() + "] ";
        }

        public final File get() {
            return dorkbox.util.LocationResolver$Companion.get$default(this, null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Ldorkbox/util/LocationResolver$Root;", "", "entry", "Ljava/net/URL;", "(Ljava/net/URL;)V", "Ljava/io/File;", "getEntry", "()Ljava/io/File;", "resources", "", "", "getResources", "()Ljava/util/List;", "search", "", "path", "attempt", "", "Utilities"})
    private static final class Root {
        private final File entry;
        private final List<String> resources;

        public Root(URL uRL) {
            Intrinsics.checkNotNullParameter((Object)uRL, (String)"");
            this.resources = new ArrayList();
            this.entry = Companion.visitRoot(uRL, this.resources);
        }

        public final File getEntry() {
            return this.entry;
        }

        public final List<String> getResources() {
            return this.resources;
        }

        public final boolean search(String string, int n) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            try {
                string = Companion.normalizePath(string);
            }
            catch (IOException iOException) {
                IOException object = iOException;
                iOException.printStackTrace();
            }
            switch (n) {
                case 1: {
                    for (String string2 : this.resources) {
                        if (!Intrinsics.areEqual((Object)string, (Object)string2)) continue;
                        Companion.log("SUCCESS: found resource \"" + string + "\" in root: " + this.entry);
                        return true;
                    }
                    break;
                }
                case 2: {
                    for (String string3 : this.resources) {
                        String string4 = string;
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"");
                        String string5 = string4.toLowerCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"");
                        string4 = string3;
                        Locale locale2 = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"");
                        String string6 = string4.toLowerCase(locale2);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"");
                        if (!Intrinsics.areEqual((Object)string5, (Object)string6)) continue;
                        Companion.log("FOUND: similarly named resource:");
                        Companion.log("               \"" + string3 + '\"');
                        Companion.log("         in classpath entry:");
                        Companion.log("               \"" + this.entry + '\"');
                        Companion.log("         for access use:");
                        Companion.log("               getResourceAsStream(\"/" + string3 + "\");");
                        return true;
                    }
                    break;
                }
                case 3: {
                    for (String string7 : this.resources) {
                        String string8 = string;
                        String string9 = string7;
                        if (StringsKt.contains$default((CharSequence)string8, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string10 = string8;
                            String string11 = string10.substring(StringsKt.lastIndexOf$default((CharSequence)string10, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"");
                            string8 = string11;
                        }
                        if (StringsKt.contains$default((CharSequence)string9, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string12 = string9;
                            String string13 = string12.substring(StringsKt.lastIndexOf$default((CharSequence)string12, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"");
                            string9 = string13;
                        }
                        if (!Intrinsics.areEqual((Object)string8, (Object)string9)) continue;
                        Companion.log("FOUND: mislocated resource:");
                        Companion.log("               \"" + string7 + '\"');
                        Companion.log("         in classpath entry:");
                        Companion.log("               \"" + this.entry + '\"');
                        Companion.log("         for access use:");
                        Companion.log("               getResourceAsStream(\"/" + string7 + "\");");
                        return true;
                    }
                    break;
                }
                case 4: {
                    for (String string14 : this.resources) {
                        String string15;
                        String string16 = string;
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"");
                        Intrinsics.checkNotNullExpressionValue((Object)string16.toLowerCase(locale), (String)"");
                        string16 = string14;
                        Locale locale3 = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"");
                        String string17 = string16.toLowerCase(locale3);
                        Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"");
                        string16 = string17;
                        if (StringsKt.contains$default((CharSequence)string15, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string18 = string15;
                            String string19 = string18.substring(StringsKt.lastIndexOf$default((CharSequence)string18, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"");
                            string15 = string19;
                        }
                        if (StringsKt.contains$default((CharSequence)string16, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string20 = string16;
                            String string21 = string20.substring(StringsKt.lastIndexOf$default((CharSequence)string20, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string21, (String)"");
                            string16 = string21;
                        }
                        if (!Intrinsics.areEqual((Object)string15, (Object)string16)) continue;
                        Companion.log("FOUND: mislocated, similarly named resource:");
                        Companion.log("               \"" + string14 + '\"');
                        Companion.log("         in classpath entry:");
                        Companion.log("               \"" + this.entry + '\"');
                        Companion.log("         for access use:");
                        Companion.log("               getResourceAsStream(\"/" + string14 + "\");");
                        return true;
                    }
                    break;
                }
                case 5: {
                    for (String string22 : this.resources) {
                        String string23 = string;
                        String string24 = string22;
                        if (StringsKt.contains$default((CharSequence)string23, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string25 = string23;
                            String string26 = string25.substring(StringsKt.lastIndexOf$default((CharSequence)string25, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string26, (String)"");
                            string23 = string26;
                        }
                        if (StringsKt.contains$default((CharSequence)string24, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string27 = string24;
                            String string28 = string27.substring(StringsKt.lastIndexOf$default((CharSequence)string27, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string28, (String)"");
                            string24 = string28;
                        }
                        if (StringsKt.contains$default((CharSequence)string23, (CharSequence)".", (boolean)false, (int)2, null)) {
                            String string29 = string23.substring(0, StringsKt.lastIndexOf$default((CharSequence)string23, (char)'.', (int)0, (boolean)false, (int)6, null));
                            Intrinsics.checkNotNullExpressionValue((Object)string29, (String)"");
                            string23 = string29;
                        }
                        if (StringsKt.contains$default((CharSequence)string24, (CharSequence)".", (boolean)false, (int)2, null)) {
                            String string30 = string24.substring(0, StringsKt.lastIndexOf$default((CharSequence)string24, (char)'.', (int)0, (boolean)false, (int)6, null));
                            Intrinsics.checkNotNullExpressionValue((Object)string30, (String)"");
                            string24 = string30;
                        }
                        if (!Intrinsics.areEqual((Object)string23, (Object)string24)) continue;
                        Companion.log("FOUND: resource with different extension:");
                        Companion.log("               \"" + string22 + '\"');
                        Companion.log("         in classpath entry:");
                        Companion.log("               \"" + this.entry + '\"');
                        Companion.log("         for access use:");
                        Companion.log("               getResourceAsStream(\"/" + string22 + "\");");
                        return true;
                    }
                    break;
                }
                case 6: {
                    for (String string31 : this.resources) {
                        String string32;
                        String string33 = string;
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"");
                        Intrinsics.checkNotNullExpressionValue((Object)string33.toLowerCase(locale), (String)"");
                        string33 = string31;
                        Locale locale4 = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale4, (String)"");
                        String string34 = string33.toLowerCase(locale4);
                        Intrinsics.checkNotNullExpressionValue((Object)string34, (String)"");
                        string33 = string34;
                        if (StringsKt.contains$default((CharSequence)string32, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string35 = string32;
                            String string36 = string35.substring(StringsKt.lastIndexOf$default((CharSequence)string35, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string36, (String)"");
                            string32 = string36;
                        }
                        if (StringsKt.contains$default((CharSequence)string33, (CharSequence)"/", (boolean)false, (int)2, null)) {
                            String string37 = string33;
                            String string38 = string37.substring(StringsKt.lastIndexOf$default((CharSequence)string37, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string38, (String)"");
                            string33 = string38;
                        }
                        if (StringsKt.contains$default((CharSequence)string32, (CharSequence)".", (boolean)false, (int)2, null)) {
                            String string39 = string32.substring(0, StringsKt.lastIndexOf$default((CharSequence)string32, (char)'.', (int)0, (boolean)false, (int)6, null));
                            Intrinsics.checkNotNullExpressionValue((Object)string39, (String)"");
                            string32 = string39;
                        }
                        if (StringsKt.contains$default((CharSequence)string33, (CharSequence)".", (boolean)false, (int)2, null)) {
                            String string40 = string33.substring(0, StringsKt.lastIndexOf$default((CharSequence)string33, (char)'.', (int)0, (boolean)false, (int)6, null));
                            Intrinsics.checkNotNullExpressionValue((Object)string40, (String)"");
                            string33 = string40;
                        }
                        if (!Intrinsics.areEqual((Object)string32, (Object)string33)) continue;
                        Companion.log("FOUND: similarly named resource with different extension:");
                        Companion.log("               \"" + string31 + '\"');
                        Companion.log("         in classpath entry:");
                        Companion.log("               \"" + this.entry + '\"');
                        Companion.log("         for access use:");
                        Companion.log("               getResourceAsStream(\"/" + string31 + "\");");
                        return true;
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
            return false;
        }
    }
}

