/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.osx;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.CheckboxPeer;
import dorkbox.systemTray.ui.osx.AwtOsxMenu;
import dorkbox.systemTray.util.AwtAccessor;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.util.SwingUtil;
import java.awt.CheckboxMenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class AwtOsxMenuItemCheckbox
implements CheckboxPeer {
    private final AwtOsxMenu parent;
    private final CheckboxMenuItem _native = new CheckboxMenuItem();
    private volatile ItemListener callback;
    private volatile boolean isChecked = false;
    private final Object peerObj;

    AwtOsxMenuItemCheckbox(AwtOsxMenu awtOsxMenu) {
        this.parent = awtOsxMenu;
        awtOsxMenu._native.add(this._native);
        this.peerObj = AwtAccessor.getPeer(this._native);
    }

    @Override
    public void setEnabled(Checkbox checkbox) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setEnabled(checkbox.getEnabled()));
    }

    @Override
    public void setText(Checkbox checkbox) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setLabel(checkbox.getText()));
    }

    @Override
    public void setCallback(final Checkbox checkbox) {
        ActionListener actionListener;
        if (this.callback != null) {
            this._native.removeItemListener(this.callback);
        }
        if ((actionListener = checkbox.getCallback()) != null) {
            this.callback = new ItemListener(){
                final ActionListener cb;
                {
                    this.cb = checkbox.getCallback();
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    checkbox.setChecked(!AwtOsxMenuItemCheckbox.this.isChecked);
                    1 v0 = this;
                    EventDispatch.runLater(() -> {
                        try {
                            this.cb.actionPerformed(new ActionEvent(v0.checkbox, 1001, ""));
                            return;
                        }
                        catch (Throwable throwable) {
                            SystemTray.logger.error("Error calling menu checkbox entry {} click event.", (Object)v0.checkbox.getText(), (Object)throwable);
                            return;
                        }
                    });
                }
            };
            this._native.addItemListener(this.callback);
        }
    }

    @Override
    public void setShortcut(Checkbox checkbox) {
        int n = SwingUtil.INSTANCE.getVirtualKey(checkbox.getShortcut());
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setShortcut(new MenuShortcut(n)));
    }

    @Override
    public void setTooltip(Checkbox object) {
        object = ((Checkbox)object).getTooltip();
        if (this.peerObj != null && object != null) {
            SwingUtil.INSTANCE.invokeLater(() -> this.lambda$setTooltip$3((String)object));
        }
    }

    @Override
    public void setChecked(Checkbox checkbox) {
        boolean bl = checkbox.getChecked();
        if (bl != this.isChecked) {
            this.isChecked = bl;
            SwingUtil.INSTANCE.invokeLater(() -> this._native.setState(this.isChecked));
        }
    }

    @Override
    public void remove() {
        SwingUtil.INSTANCE.invokeLater(() -> {
            this._native.deleteShortcut();
            this._native.setEnabled(false);
            if (this.callback != null) {
                this._native.removeItemListener(this.callback);
                this.callback = null;
            }
            this.parent._native.remove(this._native);
            this._native.removeNotify();
        });
    }

    private /* synthetic */ void lambda$setTooltip$3(String string) {
        try {
            AwtAccessor.setToolTipText(this.peerObj, string);
            return;
        }
        catch (Exception exception) {
            SystemTray.logger.error("Unable to setTooltip for awt-osx menus.", (Throwable)exception);
            return;
        }
    }
}

