/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.os.OS;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.util.SizeAndScalingLinux;
import dorkbox.systemTray.util.SizeAndScalingMacOS;
import dorkbox.systemTray.util.SizeAndScalingWindows;
import dorkbox.util.SwingUtil;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;

public class SizeAndScaling {
    public static int TRAY_SIZE = 0;
    public static int TRAY_MENU_SIZE = 0;

    public static void initSizes(SystemTray.TrayType trayType) {
        SizeAndScaling.getTrayImageSize(trayType);
        SizeAndScaling.getMenuImageSize(trayType);
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Tray image size: {}", (Object)TRAY_SIZE);
            SystemTray.logger.debug("Tray menu image size: {}", (Object)TRAY_MENU_SIZE);
            if (OS.INSTANCE.isWindows()) {
                SystemTray.logger.debug("SystemDPI: " + SizeAndScalingWindows.SYSTEM_DPI);
                SystemTray.logger.debug("System Scale: " + SizeAndScalingWindows.SYSTEM_SCALE);
                return;
            }
            if (OS.INSTANCE.isLinux()) {
                SystemTray.logger.debug("SystemDPI: " + SizeAndScalingLinux.SYSTEM_DPI);
                SystemTray.logger.debug("System Scale: " + SizeAndScalingLinux.SYSTEM_SCALE);
                return;
            }
            if (OS.INSTANCE.isMacOsX()) {
                SystemTray.logger.debug("SystemDPI: " + SizeAndScalingMacOS.SYSTEM_DPI);
                SystemTray.logger.debug("System Scale: " + SizeAndScalingMacOS.SYSTEM_SCALE);
            }
        }
    }

    public static double getDpiScaleForMouseClick(int n, int n2) {
        if (OS.INSTANCE.isWindows()) {
            return SizeAndScalingWindows.getDpiScaleForMouseClick(n, n2);
        }
        return 1.0;
    }

    public static void getTrayImageSize(SystemTray.TrayType trayType) {
        if (TRAY_SIZE == 0) {
            TRAY_SIZE = OS.INSTANCE.isLinux() ? SizeAndScalingLinux.getTrayImageSize() : (OS.INSTANCE.isMacOsX() ? SizeAndScalingMacOS.getTrayImageSize() : (OS.INSTANCE.isWindows() ? SizeAndScalingWindows.getTrayImageSize(trayType) : 32));
        }
        if (TRAY_SIZE == 0) {
            TRAY_SIZE = 32;
        }
    }

    public static void getMenuImageSize(SystemTray.TrayType trayType) {
        if (TRAY_MENU_SIZE == 0) {
            if (OS.INSTANCE.isMacOsX()) {
                TRAY_MENU_SIZE = SizeAndScalingMacOS.getMenuImageSize();
                return;
            }
            if (trayType == SystemTray.TrayType.Swing || trayType == SystemTray.TrayType.WindowsNative) {
                if (OS.INSTANCE.isWindows()) {
                    TRAY_MENU_SIZE = SizeAndScalingWindows.getMenuImageSize();
                    return;
                }
                TRAY_MENU_SIZE = SizeAndScaling.getMenuImageSizeGeneric();
                return;
            }
            if (OS.INSTANCE.isLinux()) {
                TRAY_MENU_SIZE = SizeAndScalingLinux.getMenuImageSize();
                return;
            }
            TRAY_MENU_SIZE = 16;
        }
    }

    private static int getMenuImageSizeGeneric() {
        AtomicInteger atomicInteger = new AtomicInteger();
        SwingUtil.INSTANCE.invokeAndWaitQuietly(() -> {
            JMenuItem jMenuItem = new JMenuItem();
            if (SystemTray.SWING_UI != null) {
                jMenuItem.setUI(SystemTray.SWING_UI.getItemUI(jMenuItem, null));
            }
            int n = SwingUtil.INSTANCE.getLargestIconHeightForButton((AbstractButton)jMenuItem);
            atomicInteger.set(n);
        });
        return atomicInteger.get();
    }
}

