/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.ObjectMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 5*\u0012\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u0003*\u0004\b\u0001\u0010\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00040\u0005:\u00045678B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u001f\b\u0016\u0012\u0016\u0010\r\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u00010\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0016\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u001dH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0016J\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!J!\u0010\"\u001a\u0004\u0018\u00018\u00012\u0006\u0010#\u001a\u00028\u00002\b\u0010$\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010%J\u001a\u0010&\u001a\u00020\u001a2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u0017\u0010'\u001a\u0004\u0018\u00018\u00012\u0006\u0010#\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010(J\u0015\u0010)\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0017\u001a\u00020\b\u00a2\u0006\u0002\u0010*J\u0006\u0010+\u001a\u00020\u001aJ\"\u0010+\u001a\u00020\u001a2\u001a\u0010,\u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u00000-j\n\u0012\u0006\b\u0000\u0012\u00028\u0000`.J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\u0012H\u0014J\u0010\u00103\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u000104H\u0016R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Ldorkbox/collections/OrderedMap;", "K", "", "", "V", "Ldorkbox/collections/ObjectMap;", "()V", "initialCapacity", "", "(I)V", "loadFactor", "", "(IF)V", "map", "(Ldorkbox/collections/OrderedMap;)V", "keys_", "", "alter", "", "before", "after", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "alterIndex", "index", "(ILjava/lang/Object;)Z", "clear", "", "maximumCapacity", "entries", "Ldorkbox/collections/ObjectMap$Entries;", "keys", "Ldorkbox/collections/ObjectMap$Keys;", "orderedKeys", "", "put", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "putAll", "remove", "(Ljava/lang/Object;)Ljava/lang/Object;", "removeIndex", "(I)Ljava/lang/Object;", "sort", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "toString", "", "separator", "braces", "values", "Ldorkbox/collections/ObjectMap$Values;", "Companion", "OrderedMapEntries", "OrderedMapKeys", "OrderedMapValues", "Collections"})
public final class OrderedMap<K, V>
extends ObjectMap<K, V> {
    public static final Companion Companion = new Companion(null);
    private final List<K> keys_;
    public static final String version = "2.8";

    public OrderedMap() {
        this(51, 0.8f);
    }

    public OrderedMap(int n) {
        super(n, 0.0f, 2, null);
        this.keys_ = new ArrayList(n);
    }

    public OrderedMap(int n, float f) {
        super(n, f);
        this.keys_ = new ArrayList(n);
    }

    public OrderedMap(OrderedMap<? extends K, ? extends V> orderedMap) {
        Intrinsics.checkNotNullParameter(orderedMap, (String)"");
        super((ObjectMap)orderedMap);
        this.keys_ = new ArrayList(orderedMap.keys_);
    }

    public final void sort() {
        CollectionsKt.sort(this.keys_);
    }

    public final void sort(Comparator<? super K> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"");
        CollectionsKt.sortWith(this.keys_, comparator);
    }

    @Override
    public final V put(K object, V v) {
        Intrinsics.checkNotNullParameter(object, (String)"");
        int n = this.locateKey(object);
        if (n >= 0) {
            object = this.getValueTable()[n];
            this.getValueTable()[n] = v;
            return (V)object;
        }
        n = -(n + 1);
        this.getKeyTable()[n] = object;
        this.getValueTable()[n] = v;
        this.keys_.add(object);
        OrderedMap orderedMap = this;
        orderedMap.setMapSize(orderedMap.getMapSize() + 1);
        if (this.getMapSize() >= this.getThreshold()) {
            OrderedMap orderedMap2 = this;
            orderedMap2.resize(orderedMap2.getKeyTable().length << 1);
        }
        return null;
    }

    @Override
    public final void putAll(OrderedMap<K, V> orderedMap) {
        Intrinsics.checkNotNullParameter(orderedMap, (String)"");
        this.ensureCapacity(orderedMap.size());
        List<K> list = orderedMap.keys_;
        int n = orderedMap.keys_.size();
        for (int i = 0; i < n; ++i) {
            K k = list.get(i);
            Object v = orderedMap.get(k);
            Intrinsics.checkNotNull(v);
            ((ObjectMap)this).put(k, v);
        }
    }

    @Override
    public final V remove(Object object) {
        if (object == null) {
            return null;
        }
        this.keys_.remove(object);
        return super.remove(object);
    }

    public final V removeIndex(int n) {
        K k = this.keys_.remove(n);
        return super.remove(k);
    }

    public final boolean alter(K object, K k) {
        Intrinsics.checkNotNullParameter(object, (String)"");
        Intrinsics.checkNotNullParameter(k, (String)"");
        if (this.containsKey(k)) {
            return false;
        }
        int n = this.keys_.indexOf(object);
        if (n == -1) {
            return false;
        }
        if ((object = super.remove(object)) != null) {
            super.put(k, object);
        }
        this.keys_.set(n, k);
        return true;
    }

    public final boolean alterIndex(int n, K k) {
        Intrinsics.checkNotNullParameter(k, (String)"");
        if (n < 0 || n >= this.size() || this.containsKey(k)) {
            return false;
        }
        OrderedMap orderedMap = this;
        Object v = super.remove(orderedMap.keys_.get(n));
        if (v != null) {
            super.put(k, v);
        }
        this.keys_.set(n, k);
        return true;
    }

    @Override
    public final void clear(int n) {
        this.keys_.clear();
        super.clear(n);
    }

    @Override
    public final void clear() {
        this.keys_.clear();
        super.clear();
    }

    public final List<K> orderedKeys() {
        return this.keys_;
    }

    @Override
    public final ObjectMap.Entries<K, V> entries() {
        if (this.getAllocateIterators()) {
            Intrinsics.checkNotNull((Object)this);
            return new OrderedMapEntries(this);
        }
        if (this.getEntries1() == null) {
            Intrinsics.checkNotNull((Object)this);
            this.setEntries1(new OrderedMapEntries(this));
            this.setEntries2(new OrderedMapEntries(this));
        }
        ObjectMap.Entries entries = this.getEntries1();
        Intrinsics.checkNotNull(entries);
        if (!entries.getValid()) {
            ObjectMap.Entries entries2 = this.getEntries1();
            Intrinsics.checkNotNull(entries2);
            entries2.reset();
            ObjectMap.Entries entries3 = this.getEntries1();
            Intrinsics.checkNotNull(entries3);
            entries3.setValid(true);
            ObjectMap.Entries entries4 = this.getEntries2();
            Intrinsics.checkNotNull(entries4);
            entries4.setValid(false);
            ObjectMap.Entries entries5 = this.getEntries1();
            Intrinsics.checkNotNull(entries5);
            return entries5;
        }
        ObjectMap.Entries entries6 = this.getEntries2();
        Intrinsics.checkNotNull(entries6);
        entries6.reset();
        ObjectMap.Entries entries7 = this.getEntries2();
        Intrinsics.checkNotNull(entries7);
        entries7.setValid(true);
        ObjectMap.Entries entries8 = this.getEntries1();
        Intrinsics.checkNotNull(entries8);
        entries8.setValid(false);
        ObjectMap.Entries entries9 = this.getEntries2();
        Intrinsics.checkNotNull(entries9);
        return entries9;
    }

    @Override
    public final ObjectMap.Values<V> values() {
        if (this.getAllocateIterators()) {
            Intrinsics.checkNotNull((Object)this);
            return new OrderedMapValues(this);
        }
        if (this.getValues1() == null) {
            Intrinsics.checkNotNull((Object)this);
            this.setValues1(new OrderedMapValues(this));
            this.setValues2(new OrderedMapValues(this));
        }
        ObjectMap.Values values = this.getValues1();
        Intrinsics.checkNotNull(values);
        if (!values.getValid()) {
            ObjectMap.Values values2 = this.getValues1();
            Intrinsics.checkNotNull(values2);
            values2.reset();
            ObjectMap.Values values3 = this.getValues1();
            Intrinsics.checkNotNull(values3);
            values3.setValid(true);
            ObjectMap.Values values4 = this.getValues2();
            Intrinsics.checkNotNull(values4);
            values4.setValid(false);
            ObjectMap.Values values5 = this.getValues1();
            Intrinsics.checkNotNull(values5);
            return values5;
        }
        ObjectMap.Values values6 = this.getValues2();
        Intrinsics.checkNotNull(values6);
        values6.reset();
        ObjectMap.Values values7 = this.getValues2();
        Intrinsics.checkNotNull(values7);
        values7.setValid(true);
        ObjectMap.Values values8 = this.getValues1();
        Intrinsics.checkNotNull(values8);
        values8.setValid(false);
        ObjectMap.Values values9 = this.getValues2();
        Intrinsics.checkNotNull(values9);
        return values9;
    }

    @Override
    public final ObjectMap.Keys<K> keys() {
        if (this.getAllocateIterators()) {
            return new OrderedMapKeys(this);
        }
        if (this.getKeys1() == null) {
            this.setKeys1(new OrderedMapKeys(this));
            this.setKeys2(new OrderedMapKeys(this));
        }
        ObjectMap.Keys keys = this.getKeys1();
        Intrinsics.checkNotNull(keys);
        if (!keys.getValid()) {
            ObjectMap.Keys keys2 = this.getKeys1();
            Intrinsics.checkNotNull(keys2);
            keys2.reset();
            ObjectMap.Keys keys3 = this.getKeys1();
            Intrinsics.checkNotNull(keys3);
            keys3.setValid(true);
            ObjectMap.Keys keys4 = this.getKeys2();
            Intrinsics.checkNotNull(keys4);
            keys4.setValid(false);
            ObjectMap.Keys keys5 = this.getKeys1();
            Intrinsics.checkNotNull(keys5);
            return keys5;
        }
        ObjectMap.Keys keys6 = this.getKeys2();
        Intrinsics.checkNotNull(keys6);
        keys6.reset();
        ObjectMap.Keys keys7 = this.getKeys2();
        Intrinsics.checkNotNull(keys7);
        keys7.setValid(true);
        ObjectMap.Keys keys8 = this.getKeys1();
        Intrinsics.checkNotNull(keys8);
        keys8.setValid(false);
        ObjectMap.Keys keys9 = this.getKeys2();
        Intrinsics.checkNotNull(keys9);
        return keys9;
    }

    @Override
    protected final String toString(String string, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        if (this.size() == 0) {
            if (bl) {
                return "{}";
            }
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        if (bl) {
            stringBuilder.append('{');
        }
        List<K> list = this.keys_;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object object = list.get(i);
            if (i > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(object == this ? (Comparable)((Object)"(this)") : (Comparable)object);
            stringBuilder.append('=');
            object = this.get(object);
            stringBuilder.append((Object)(object == this ? "(this)" : object));
        }
        if (bl) {
            stringBuilder.append('}');
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        return string2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldorkbox/collections/OrderedMap$Companion;", "", "()V", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\u0012\b\u0002\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u0003*\u0004\b\u0003\u0010\u00042\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00040\u0005B\u001b\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u00030\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldorkbox/collections/OrderedMap$OrderedMapEntries;", "K", "", "", "V", "Ldorkbox/collections/ObjectMap$Entries;", "map", "Ldorkbox/collections/OrderedMap;", "(Ldorkbox/collections/OrderedMap;)V", "keys", "", "next", "Ldorkbox/collections/ObjectMap$Entry;", "remove", "", "reset", "Collections"})
    public static final class OrderedMapEntries<K, V>
    extends ObjectMap.Entries<K, V> {
        private final List<K> keys;

        public OrderedMapEntries(OrderedMap<K, V> orderedMap) {
            Intrinsics.checkNotNullParameter(orderedMap, (String)"");
            super(orderedMap);
            this.keys = ((OrderedMap)orderedMap).keys_;
        }

        @Override
        public final void reset() {
            this.setCurrentIndex(-1);
            this.setNextIndex(0);
            OrderedMapEntries orderedMapEntries = this;
            orderedMapEntries.setHasNext(orderedMapEntries.getMap().size() > 0);
        }

        @Override
        public final ObjectMap.Entry<K, V> next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            OrderedMapEntries orderedMapEntries = this;
            orderedMapEntries.setCurrentIndex(orderedMapEntries.getNextIndex());
            K k = this.keys.get(this.getNextIndex());
            if (this.getEntry$Collections() == null) {
                this.setEntry$Collections(new ObjectMap.Entry(k, this.getMap().get(k), this.getMap()));
            } else {
                ObjectMap.Entry entry = this.getEntry$Collections();
                Intrinsics.checkNotNull(entry);
                entry.setKey(k);
                ObjectMap.Entry entry2 = this.getEntry$Collections();
                Intrinsics.checkNotNull(entry2);
                entry2.setValue(this.getMap().get(k));
            }
            int n = this.getNextIndex();
            this.setNextIndex(n + 1);
            OrderedMapEntries orderedMapEntries2 = this;
            orderedMapEntries2.setHasNext(orderedMapEntries2.getNextIndex() < this.getMap().size());
            ObjectMap.Entry entry = this.getEntry$Collections();
            Intrinsics.checkNotNull(entry);
            return entry;
        }

        @Override
        public final void remove() {
            if (!(this.getCurrentIndex() >= 0)) {
                String string = "next must be called before remove.";
                throw new IllegalStateException(string.toString());
            }
            ObjectMap objectMap = this.getMap();
            ObjectMap.Entry entry = this.getEntry$Collections();
            Intrinsics.checkNotNull(entry);
            objectMap.remove(entry.getKey());
            int n = this.getNextIndex();
            this.setNextIndex(n + -1);
            this.setCurrentIndex(-1);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u0000*\u0012\b\u0002\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0017\u0012\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00028\u0002\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldorkbox/collections/OrderedMap$OrderedMapKeys;", "K", "", "", "Ldorkbox/collections/ObjectMap$Keys;", "map", "Ldorkbox/collections/OrderedMap;", "(Ldorkbox/collections/OrderedMap;)V", "keys", "", "next", "()Ljava/lang/Object;", "remove", "", "reset", "toArray", "", "()[Ljava/lang/Object;", "Collections"})
    public static final class OrderedMapKeys<K>
    extends ObjectMap.Keys<K> {
        private final List<K> keys;

        public OrderedMapKeys(OrderedMap<K, ?> orderedMap) {
            Intrinsics.checkNotNullParameter(orderedMap, (String)"");
            super((ObjectMap)orderedMap);
            this.keys = ((OrderedMap)orderedMap).keys_;
        }

        @Override
        public final void reset() {
            this.setCurrentIndex(-1);
            this.setNextIndex(0);
            OrderedMapKeys orderedMapKeys = this;
            orderedMapKeys.setHasNext(orderedMapKeys.getMap().size() > 0);
        }

        @Override
        public final K next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            K k = this.keys.get(this.getNextIndex());
            OrderedMapKeys orderedMapKeys = this;
            orderedMapKeys.setCurrentIndex(orderedMapKeys.getNextIndex());
            int n = this.getNextIndex();
            this.setNextIndex(n + 1);
            OrderedMapKeys orderedMapKeys2 = this;
            orderedMapKeys2.setHasNext(orderedMapKeys2.getNextIndex() < this.getMap().size());
            return k;
        }

        @Override
        public final void remove() {
            if (!(this.getCurrentIndex() >= 0)) {
                String string = "next must be called before remove.";
                throw new IllegalStateException(string.toString());
            }
            ObjectMap objectMap = this.getMap();
            Intrinsics.checkNotNull(objectMap);
            ((OrderedMap)objectMap).removeIndex(this.getCurrentIndex());
            OrderedMapKeys orderedMapKeys = this;
            orderedMapKeys.setNextIndex(orderedMapKeys.getCurrentIndex());
            this.setCurrentIndex(-1);
        }

        @Override
        public final K[] toArray() {
            int n = 0;
            int n2 = this.keys.size() - this.getNextIndex();
            Object[] objectArray = new Object[n2];
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNull(((ObjectMap.Keys)this).next());
            }
            return objectArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0002\b\u0003\u0012\u0006\u0012\u0004\u0018\u00018\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u0004\u0018\u00018\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0015\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldorkbox/collections/OrderedMap$OrderedMapValues;", "V", "Ldorkbox/collections/ObjectMap$Values;", "map", "Ldorkbox/collections/OrderedMap;", "(Ldorkbox/collections/OrderedMap;)V", "keys", "", "next", "()Ljava/lang/Object;", "remove", "", "reset", "toArray", "", "()[Ljava/lang/Object;", "Collections"})
    public static final class OrderedMapValues<V>
    extends ObjectMap.Values<V> {
        private final List<?> keys;

        public OrderedMapValues(OrderedMap<?, V> orderedMap) {
            Intrinsics.checkNotNullParameter(orderedMap, (String)"");
            super((ObjectMap)orderedMap);
            this.keys = ((OrderedMap)orderedMap).keys_;
        }

        @Override
        public final void reset() {
            this.setCurrentIndex(-1);
            this.setNextIndex(0);
            OrderedMapValues orderedMapValues = this;
            orderedMapValues.setHasNext(orderedMapValues.getMap().size() > 0);
        }

        @Override
        public final V next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            ObjectMap objectMap = this.getMap();
            Object obj = this.keys.get(this.getNextIndex());
            Intrinsics.checkNotNull(obj);
            Object v = objectMap.get(obj);
            OrderedMapValues orderedMapValues = this;
            orderedMapValues.setCurrentIndex(orderedMapValues.getNextIndex());
            int n = this.getNextIndex();
            this.setNextIndex(n + 1);
            OrderedMapValues orderedMapValues2 = this;
            orderedMapValues2.setHasNext(orderedMapValues2.getNextIndex() < this.getMap().size());
            return v;
        }

        @Override
        public final void remove() {
            if (!(this.getCurrentIndex() >= 0)) {
                String string = "next must be called before remove.";
                throw new IllegalStateException(string.toString());
            }
            ObjectMap objectMap = this.getMap();
            Intrinsics.checkNotNull(objectMap);
            ((OrderedMap)objectMap).removeIndex(this.getCurrentIndex());
            OrderedMapValues orderedMapValues = this;
            orderedMapValues.setNextIndex(orderedMapValues.getCurrentIndex());
            this.setCurrentIndex(-1);
        }

        @Override
        public final V[] toArray() {
            int n = 0;
            int n2 = this.keys.size() - this.getNextIndex();
            Object[] objectArray = new Object[n2];
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNull(((ObjectMap.Values)this).next());
            }
            return objectArray;
        }
    }
}

