/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.EventLoop;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.epoll.EpollChannelConfig;
import io.netty.channel.epoll.EpollDomainSocketChannelConfig;
import io.netty.channel.epoll.EpollEventLoop;
import io.netty.channel.epoll.EpollRecvByteAllocatorHandle;
import io.netty.channel.epoll.LinuxSocket;
import io.netty.channel.epoll.Native;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.Socket;
import io.netty.channel.unix.UnixChannel;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.UnresolvedAddressException;
import java.util.concurrent.TimeUnit;

abstract class AbstractEpollChannel
extends AbstractChannel
implements UnixChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    protected final LinuxSocket socket;
    private ChannelPromise connectPromise;
    private Future<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;
    private volatile SocketAddress local;
    private volatile SocketAddress remote;
    protected int flags = Native.EPOLLET;
    boolean inputClosedSeenErrorOnRead;
    boolean epollInReadyRunnablePending;
    protected volatile boolean active;

    AbstractEpollChannel(LinuxSocket linuxSocket) {
        this(null, linuxSocket, false);
    }

    AbstractEpollChannel(Channel channel, LinuxSocket linuxSocket, boolean bl) {
        super(channel);
        this.socket = (LinuxSocket)((Object)ObjectUtil.checkNotNull((Object)((Object)linuxSocket), (String)"fd"));
        this.active = bl;
        if (bl) {
            this.local = linuxSocket.localAddress();
            this.remote = linuxSocket.remoteAddress();
        }
    }

    AbstractEpollChannel(Channel channel, LinuxSocket linuxSocket, SocketAddress socketAddress) {
        super(channel);
        this.socket = (LinuxSocket)((Object)ObjectUtil.checkNotNull((Object)((Object)linuxSocket), (String)"fd"));
        this.active = true;
        this.remote = socketAddress;
        this.local = linuxSocket.localAddress();
    }

    static boolean isSoErrorZero(Socket socket) {
        try {
            return socket.getSoError() == 0;
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
    }

    protected void setFlag(int n) {
        if (!this.isFlagSet(n)) {
            this.flags |= n;
            this.modifyEvents();
        }
    }

    void clearFlag(int n) {
        if (this.isFlagSet(n)) {
            this.flags &= ~n;
            this.modifyEvents();
        }
    }

    boolean isFlagSet(int n) {
        return (this.flags & n) != 0;
    }

    public final FileDescriptor fd() {
        return this.socket;
    }

    public abstract EpollChannelConfig config();

    public boolean isActive() {
        return this.active;
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    protected void doClose() {
        this.active = false;
        this.inputClosedSeenErrorOnRead = true;
        try {
            EventLoop eventLoop = this.connectPromise;
            if (eventLoop != null) {
                eventLoop.tryFailure((Throwable)new ClosedChannelException());
                this.connectPromise = null;
            }
            if ((eventLoop = this.connectTimeoutFuture) != null) {
                eventLoop.cancel(false);
                this.connectTimeoutFuture = null;
            }
            if (this.isRegistered()) {
                eventLoop = this.eventLoop();
                if (eventLoop.inEventLoop()) {
                    this.doDeregister();
                } else {
                    eventLoop.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AbstractEpollChannel.this.doDeregister();
                                return;
                            }
                            catch (Throwable throwable) {
                                AbstractEpollChannel.this.pipeline().fireExceptionCaught(throwable);
                                return;
                            }
                        }
                    });
                }
            }
            return;
        }
        finally {
            this.socket.close();
        }
    }

    void resetCachedAddresses() {
        this.local = this.socket.localAddress();
        this.remote = this.socket.remoteAddress();
    }

    protected void doDisconnect() {
        this.doClose();
    }

    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof EpollEventLoop;
    }

    public boolean isOpen() {
        return this.socket.isOpen();
    }

    protected void doDeregister() {
        ((EpollEventLoop)this.eventLoop()).remove(this);
    }

    protected final void doBeginRead() {
        AbstractEpollUnsafe abstractEpollUnsafe = (AbstractEpollUnsafe)this.unsafe();
        ((AbstractEpollUnsafe)this.unsafe()).readPending = true;
        this.setFlag(Native.EPOLLIN);
        if (abstractEpollUnsafe.maybeMoreDataToRead) {
            abstractEpollUnsafe.executeEpollInReadyRunnable((ChannelConfig)this.config());
        }
    }

    final boolean shouldBreakEpollInReady(ChannelConfig channelConfig) {
        return this.socket.isInputShutdown() && (this.inputClosedSeenErrorOnRead || !AbstractEpollChannel.isAllowHalfClosure(channelConfig));
    }

    private static boolean isAllowHalfClosure(ChannelConfig channelConfig) {
        if (channelConfig instanceof EpollDomainSocketChannelConfig) {
            return ((EpollDomainSocketChannelConfig)channelConfig).isAllowHalfClosure();
        }
        return channelConfig instanceof SocketChannelConfig && ((SocketChannelConfig)channelConfig).isAllowHalfClosure();
    }

    /*
     * Enabled aggressive block sorting
     */
    final void clearEpollIn() {
        if (!this.isRegistered()) {
            this.flags &= ~Native.EPOLLIN;
            return;
        }
        EventLoop eventLoop = this.eventLoop();
        final AbstractEpollUnsafe abstractEpollUnsafe = (AbstractEpollUnsafe)this.unsafe();
        if (eventLoop.inEventLoop()) {
            abstractEpollUnsafe.clearEpollIn0();
            return;
        }
        eventLoop.execute(new Runnable(){

            @Override
            public void run() {
                if (!abstractEpollUnsafe.readPending && !AbstractEpollChannel.this.config().isAutoRead()) {
                    abstractEpollUnsafe.clearEpollIn0();
                }
            }
        });
    }

    private void modifyEvents() {
        if (this.isOpen() && this.isRegistered()) {
            ((EpollEventLoop)this.eventLoop()).modify(this);
        }
    }

    protected void doRegister() {
        this.epollInReadyRunnablePending = false;
        ((EpollEventLoop)this.eventLoop()).add(this);
    }

    protected abstract AbstractEpollUnsafe newUnsafe();

    protected final ByteBuf newDirectBuffer(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        return this.newDirectBuffer(byteBuf2, byteBuf2);
    }

    protected final ByteBuf newDirectBuffer(Object object, ByteBuf byteBuf) {
        int n = byteBuf.readableBytes();
        if (n == 0) {
            ReferenceCountUtil.release((Object)object);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator byteBufAllocator = this.alloc();
        if (byteBufAllocator.isDirectBufferPooled()) {
            return AbstractEpollChannel.newDirectBuffer0(object, byteBuf, byteBufAllocator, n);
        }
        ByteBuf byteBuf2 = ByteBufUtil.threadLocalDirectBuffer();
        if (byteBuf2 == null) {
            return AbstractEpollChannel.newDirectBuffer0(object, byteBuf, byteBufAllocator, n);
        }
        ByteBuf byteBuf3 = byteBuf;
        byteBuf2.writeBytes(byteBuf3, byteBuf3.readerIndex(), n);
        ReferenceCountUtil.safeRelease((Object)object);
        return byteBuf2;
    }

    private static ByteBuf newDirectBuffer0(Object object, ByteBuf byteBuf, ByteBufAllocator byteBufAllocator, int n) {
        byteBufAllocator = byteBufAllocator.directBuffer(n);
        ByteBuf byteBuf2 = byteBuf;
        byteBufAllocator.writeBytes(byteBuf2, byteBuf2.readerIndex(), n);
        ReferenceCountUtil.safeRelease((Object)object);
        return byteBufAllocator;
    }

    protected static void checkResolvable(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    protected final int doReadBytes(ByteBuf byteBuf) {
        int n;
        int n2 = byteBuf.writerIndex();
        this.unsafe().recvBufAllocHandle().attemptedBytesRead(byteBuf.writableBytes());
        if (byteBuf.hasMemoryAddress()) {
            n = this.socket.recvAddress(byteBuf.memoryAddress(), n2, byteBuf.capacity());
        } else {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = byteBuffer = byteBuf.internalNioBuffer(n2, byteBuf.writableBytes());
            n = this.socket.recv(byteBuffer2, byteBuffer2.position(), byteBuffer.limit());
        }
        if (n > 0) {
            byteBuf.writerIndex(n2 + n);
        }
        return n;
    }

    protected final int doWriteBytes(ChannelOutboundBuffer channelOutboundBuffer, ByteBuf object) {
        if (object.hasMemoryAddress()) {
            int n = this.socket.sendAddress(object.memoryAddress(), object.readerIndex(), object.writerIndex());
            if (n > 0) {
                channelOutboundBuffer.removeBytes((long)n);
                return 1;
            }
        } else {
            ByteBuffer byteBuffer;
            if (object.nioBufferCount() == 1) {
                ByteBuf byteBuf = object;
                byteBuffer = byteBuf.internalNioBuffer(byteBuf.readerIndex(), object.readableBytes());
            } else {
                byteBuffer = object.nioBuffer();
            }
            Object object2 = object = byteBuffer;
            int n = this.socket.send((ByteBuffer)object2, ((Buffer)object2).position(), ((Buffer)object).limit());
            if (n > 0) {
                Object object3 = object;
                ((ByteBuffer)object3).position(((Buffer)object3).position() + n);
                channelOutboundBuffer.removeBytes((long)n);
                return 1;
            }
        }
        return Integer.MAX_VALUE;
    }

    final long doWriteOrSendBytes(ByteBuf byteBuf, InetSocketAddress inetSocketAddress, boolean bl) {
        assert (!bl || inetSocketAddress != null) : "fastOpen requires a remote address";
        if (byteBuf.hasMemoryAddress()) {
            long l = byteBuf.memoryAddress();
            if (inetSocketAddress == null) {
                return this.socket.sendAddress(l, byteBuf.readerIndex(), byteBuf.writerIndex());
            }
            return this.socket.sendToAddress(l, byteBuf.readerIndex(), byteBuf.writerIndex(), inetSocketAddress.getAddress(), inetSocketAddress.getPort(), bl);
        }
        if (byteBuf.nioBufferCount() > 1) {
            IovArray iovArray = ((EpollEventLoop)this.eventLoop()).cleanIovArray();
            ByteBuf byteBuf2 = byteBuf;
            iovArray.add(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes());
            int n = iovArray.count();
            assert (n != 0);
            if (inetSocketAddress == null) {
                return this.socket.writevAddresses(iovArray.memoryAddress(0), n);
            }
            return this.socket.sendToAddresses(iovArray.memoryAddress(0), n, inetSocketAddress.getAddress(), inetSocketAddress.getPort(), bl);
        }
        ByteBuf byteBuf3 = byteBuf;
        ByteBuffer byteBuffer = byteBuf3.internalNioBuffer(byteBuf3.readerIndex(), byteBuf.readableBytes());
        if (inetSocketAddress == null) {
            ByteBuffer byteBuffer2 = byteBuffer;
            return this.socket.send(byteBuffer2, byteBuffer2.position(), byteBuffer.limit());
        }
        ByteBuffer byteBuffer3 = byteBuffer;
        return this.socket.sendTo(byteBuffer3, byteBuffer3.position(), byteBuffer.limit(), inetSocketAddress.getAddress(), inetSocketAddress.getPort(), bl);
    }

    protected void doBind(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            AbstractEpollChannel.checkResolvable((InetSocketAddress)socketAddress);
        }
        this.socket.bind(socketAddress);
        this.local = this.socket.localAddress();
    }

    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        boolean bl;
        InetSocketAddress inetSocketAddress;
        if (socketAddress2 instanceof InetSocketAddress) {
            AbstractEpollChannel.checkResolvable((InetSocketAddress)socketAddress2);
        }
        if ((inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null) != null) {
            AbstractEpollChannel.checkResolvable(inetSocketAddress);
        }
        if (this.remote != null) {
            throw new AlreadyConnectedException();
        }
        if (socketAddress2 != null) {
            this.socket.bind(socketAddress2);
        }
        if (bl = this.doConnect0(socketAddress)) {
            this.remote = inetSocketAddress == null ? socketAddress : UnixChannelUtil.computeRemoteAddr((InetSocketAddress)inetSocketAddress, (InetSocketAddress)this.socket.remoteAddress());
        }
        this.local = this.socket.localAddress();
        return bl;
    }

    boolean doConnect0(SocketAddress socketAddress) {
        boolean bl = false;
        try {
            boolean bl2 = this.socket.connect(socketAddress);
            if (!bl2) {
                this.setFlag(Native.EPOLLOUT);
            }
            bl = true;
            return bl2;
        }
        catch (Throwable throwable) {
            if (!bl) {
                this.doClose();
            }
            throw throwable;
        }
    }

    protected SocketAddress localAddress0() {
        return this.local;
    }

    protected SocketAddress remoteAddress0() {
        return this.remote;
    }

    protected abstract class AbstractEpollUnsafe
    extends AbstractChannel.AbstractUnsafe {
        boolean readPending;
        boolean maybeMoreDataToRead;
        private EpollRecvByteAllocatorHandle allocHandle;
        private final Runnable epollInReadyRunnable;

        protected AbstractEpollUnsafe() {
            super((AbstractChannel)AbstractEpollChannel.this);
            this.epollInReadyRunnable = new Runnable(){

                @Override
                public void run() {
                    AbstractEpollChannel.this.epollInReadyRunnablePending = false;
                    AbstractEpollUnsafe.this.epollInReady();
                }
            };
        }

        abstract void epollInReady();

        final void epollInBefore() {
            this.maybeMoreDataToRead = false;
        }

        final void epollInFinally(ChannelConfig channelConfig) {
            this.maybeMoreDataToRead = this.allocHandle.maybeMoreDataToRead();
            if (this.allocHandle.isReceivedRdHup() || this.readPending && this.maybeMoreDataToRead) {
                this.executeEpollInReadyRunnable(channelConfig);
                return;
            }
            if (!this.readPending && !channelConfig.isAutoRead()) {
                AbstractEpollChannel.this.clearEpollIn();
            }
        }

        final void executeEpollInReadyRunnable(ChannelConfig channelConfig) {
            if (AbstractEpollChannel.this.epollInReadyRunnablePending || !AbstractEpollChannel.this.isActive() || AbstractEpollChannel.this.shouldBreakEpollInReady(channelConfig)) {
                return;
            }
            AbstractEpollChannel.this.epollInReadyRunnablePending = true;
            AbstractEpollChannel.this.eventLoop().execute(this.epollInReadyRunnable);
        }

        final void epollRdHupReady() {
            this.recvBufAllocHandle().receivedRdHup();
            if (AbstractEpollChannel.this.isActive()) {
                this.epollInReady();
            } else {
                this.shutdownInput(true);
            }
            this.clearEpollRdHup();
        }

        private void clearEpollRdHup() {
            try {
                AbstractEpollChannel.this.clearFlag(Native.EPOLLRDHUP);
                return;
            }
            catch (IOException iOException) {
                AbstractEpollChannel.this.pipeline().fireExceptionCaught((Throwable)iOException);
                AbstractEpollUnsafe abstractEpollUnsafe = this;
                abstractEpollUnsafe.close(abstractEpollUnsafe.voidPromise());
                return;
            }
        }

        void shutdownInput(boolean bl) {
            if (!AbstractEpollChannel.this.socket.isInputShutdown()) {
                if (AbstractEpollChannel.isAllowHalfClosure((ChannelConfig)AbstractEpollChannel.this.config())) {
                    try {
                        AbstractEpollChannel.this.socket.shutdown(true, false);
                    }
                    catch (IOException iOException) {
                        this.fireEventAndClose(ChannelInputShutdownEvent.INSTANCE);
                        return;
                    }
                    catch (NotYetConnectedException notYetConnectedException) {}
                    this.clearEpollIn0();
                    AbstractEpollChannel.this.pipeline().fireUserEventTriggered((Object)ChannelInputShutdownEvent.INSTANCE);
                    return;
                }
                AbstractEpollUnsafe abstractEpollUnsafe = this;
                abstractEpollUnsafe.close(abstractEpollUnsafe.voidPromise());
                return;
            }
            if (!bl && !AbstractEpollChannel.this.inputClosedSeenErrorOnRead) {
                AbstractEpollChannel.this.inputClosedSeenErrorOnRead = true;
                AbstractEpollChannel.this.pipeline().fireUserEventTriggered((Object)ChannelInputShutdownReadComplete.INSTANCE);
            }
        }

        private void fireEventAndClose(Object object) {
            AbstractEpollChannel.this.pipeline().fireUserEventTriggered(object);
            AbstractEpollUnsafe abstractEpollUnsafe = this;
            abstractEpollUnsafe.close(abstractEpollUnsafe.voidPromise());
        }

        public EpollRecvByteAllocatorHandle recvBufAllocHandle() {
            if (this.allocHandle == null) {
                this.allocHandle = this.newEpollHandle((RecvByteBufAllocator.ExtendedHandle)super.recvBufAllocHandle());
            }
            return this.allocHandle;
        }

        EpollRecvByteAllocatorHandle newEpollHandle(RecvByteBufAllocator.ExtendedHandle extendedHandle) {
            return new EpollRecvByteAllocatorHandle(extendedHandle);
        }

        protected final void flush0() {
            if (!AbstractEpollChannel.this.isFlagSet(Native.EPOLLOUT)) {
                super.flush0();
            }
        }

        final void epollOutReady() {
            if (AbstractEpollChannel.this.connectPromise != null) {
                this.finishConnect();
                return;
            }
            if (!AbstractEpollChannel.this.socket.isOutputShutdown()) {
                super.flush0();
            }
        }

        protected final void clearEpollIn0() {
            assert (AbstractEpollChannel.this.eventLoop().inEventLoop());
            try {
                this.readPending = false;
                AbstractEpollChannel.this.clearFlag(Native.EPOLLIN);
                return;
            }
            catch (IOException iOException) {
                AbstractEpollChannel.this.pipeline().fireExceptionCaught((Throwable)iOException);
                AbstractEpollChannel.this.unsafe().close(AbstractEpollChannel.this.unsafe().voidPromise());
                return;
            }
        }

        public void connect(final SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            if (channelPromise.isDone() || !this.ensureOpen(channelPromise)) {
                return;
            }
            try {
                if (AbstractEpollChannel.this.connectPromise != null) {
                    throw new ConnectionPendingException();
                }
                boolean bl = AbstractEpollChannel.this.isActive();
                if (!AbstractEpollChannel.this.doConnect(socketAddress, socketAddress2)) {
                    AbstractEpollChannel.this.connectPromise = channelPromise;
                    AbstractEpollChannel.this.requestedRemoteAddress = socketAddress;
                    final int n = AbstractEpollChannel.this.config().getConnectTimeoutMillis();
                    if (n > 0) {
                        AbstractEpollChannel.this.connectTimeoutFuture = (Future)AbstractEpollChannel.this.eventLoop().schedule(new Runnable(){

                            @Override
                            public void run() {
                                ChannelPromise channelPromise = AbstractEpollChannel.this.connectPromise;
                                if (channelPromise != null && !channelPromise.isDone() && channelPromise.tryFailure((Throwable)new ConnectTimeoutException("connection timed out after " + n + " ms: " + socketAddress))) {
                                    AbstractEpollUnsafe.this.close(AbstractEpollUnsafe.this.voidPromise());
                                }
                            }
                        }, (long)n, TimeUnit.MILLISECONDS);
                    }
                    channelPromise.addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture channelFuture) {
                            if (channelFuture.isCancelled()) {
                                if (AbstractEpollChannel.this.connectTimeoutFuture != null) {
                                    AbstractEpollChannel.this.connectTimeoutFuture.cancel(false);
                                }
                                AbstractEpollChannel.this.connectPromise = null;
                                AbstractEpollUnsafe.this.close(AbstractEpollUnsafe.this.voidPromise());
                            }
                        }
                    });
                    return;
                }
                this.fulfillConnectPromise(channelPromise, bl);
            }
            catch (Throwable throwable) {
                this.closeIfClosed();
                channelPromise.tryFailure(this.annotateConnectException(throwable, socketAddress));
            }
        }

        private void fulfillConnectPromise(ChannelPromise channelPromise, boolean bl) {
            if (channelPromise == null) {
                return;
            }
            AbstractEpollChannel.this.active = true;
            boolean bl2 = AbstractEpollChannel.this.isActive();
            boolean bl3 = channelPromise.trySuccess();
            if (!bl && bl2) {
                AbstractEpollChannel.this.pipeline().fireChannelActive();
            }
            if (!bl3) {
                AbstractEpollUnsafe abstractEpollUnsafe = this;
                abstractEpollUnsafe.close(abstractEpollUnsafe.voidPromise());
            }
        }

        private void fulfillConnectPromise(ChannelPromise channelPromise, Throwable throwable) {
            if (channelPromise == null) {
                return;
            }
            channelPromise.tryFailure(throwable);
            this.closeIfClosed();
        }

        private void finishConnect() {
            assert (AbstractEpollChannel.this.eventLoop().inEventLoop());
            try {
                boolean bl = AbstractEpollChannel.this.isActive();
                if (!this.doFinishConnect()) {
                    return;
                }
                AbstractEpollUnsafe abstractEpollUnsafe = this;
                abstractEpollUnsafe.fulfillConnectPromise(abstractEpollUnsafe.AbstractEpollChannel.this.connectPromise, bl);
                return;
            }
            catch (Throwable throwable) {
                AbstractEpollUnsafe abstractEpollUnsafe = this;
                abstractEpollUnsafe.fulfillConnectPromise(abstractEpollUnsafe.AbstractEpollChannel.this.connectPromise, this.annotateConnectException(throwable, AbstractEpollChannel.this.requestedRemoteAddress));
                return;
            }
            finally {
                if (AbstractEpollChannel.this.connectTimeoutFuture != null) {
                    AbstractEpollChannel.this.connectTimeoutFuture.cancel(false);
                }
                AbstractEpollChannel.this.connectPromise = null;
            }
        }

        private boolean doFinishConnect() {
            if (AbstractEpollChannel.this.socket.finishConnect()) {
                AbstractEpollChannel.this.clearFlag(Native.EPOLLOUT);
                if (AbstractEpollChannel.this.requestedRemoteAddress instanceof InetSocketAddress) {
                    AbstractEpollChannel.this.remote = UnixChannelUtil.computeRemoteAddr((InetSocketAddress)((InetSocketAddress)AbstractEpollChannel.this.requestedRemoteAddress), (InetSocketAddress)AbstractEpollChannel.this.socket.remoteAddress());
                }
                AbstractEpollChannel.this.requestedRemoteAddress = null;
                return true;
            }
            AbstractEpollChannel.this.setFlag(Native.EPOLLOUT);
            return false;
        }
    }
}

