/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.exposed.sql.ColumnType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\rH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/exposed/sql/DecimalColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Ljava/math/BigDecimal;", "precision", "", "scale", "(II)V", "getPrecision", "()I", "getScale", "equals", "", "other", "", "hashCode", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "sqlType", "", "valueFromDB", "value", "Companion", "exposed-core"})
public final class DecimalColumnType
extends ColumnType<BigDecimal> {
    public static final Companion Companion = new Companion(null);
    private final int precision;
    private final int scale;
    private static final DecimalColumnType INSTANCE = new DecimalColumnType(MathContext.DECIMAL64.getPrecision(), 20);

    public DecimalColumnType(int n, int n2) {
        super(false, 1, null);
        this.precision = n;
        this.scale = n2;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final int getScale() {
        return this.scale;
    }

    @Override
    public final String sqlType() {
        return "DECIMAL(" + this.precision + ", " + this.scale + ')';
    }

    @Override
    public final Object readObject(ResultSet resultSet, int n) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"");
        return resultSet.getObject(n);
    }

    @Override
    public final BigDecimal valueFromDB(Object object) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Object object2 = object;
        if (object2 instanceof BigDecimal) {
            bigDecimal = (BigDecimal)object;
        } else if (object2 instanceof Double) {
            if (Double.isNaN(((Number)object).doubleValue())) {
                throw new SQLException("Unexpected value of type Double: NaN of " + Reflection.getOrCreateKotlinClass(object.getClass()).getQualifiedName());
            }
            bigDecimal = new BigDecimal(String.valueOf(((Number)object).doubleValue()));
        } else if (object2 instanceof Float) {
            if (Float.isNaN(((Number)object).floatValue())) {
                throw new IllegalStateException(("Unexpected value of type Float: NaN of " + Reflection.getOrCreateKotlinClass(object.getClass()).getQualifiedName()).toString());
            }
            bigDecimal = new BigDecimal(String.valueOf(((Number)object).floatValue()));
        } else if (object2 instanceof Long) {
            BigDecimal bigDecimal2 = BigDecimal.valueOf(((Number)object).longValue());
            bigDecimal = bigDecimal2;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"");
        } else if (object2 instanceof Integer) {
            BigDecimal bigDecimal3 = BigDecimal.valueOf(((Number)object).intValue());
            bigDecimal = bigDecimal3;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"");
        } else if (object2 instanceof Short) {
            BigDecimal bigDecimal4 = BigDecimal.valueOf(((Number)object).shortValue());
            bigDecimal = bigDecimal4;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"");
        } else {
            throw new IllegalStateException(("Unexpected value of type Decimal: " + object + " of " + Reflection.getOrCreateKotlinClass(object.getClass()).getQualifiedName()).toString());
        }
        object = bigDecimal.setScale(this.scale, RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
        return object;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        Object object2 = object;
        if (!Intrinsics.areEqual(this.getClass(), object2 != null ? object2.getClass() : null)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)object);
        DecimalColumnType cfr_ignored_0 = (DecimalColumnType)object;
        if (this.precision != ((DecimalColumnType)object).precision) {
            return false;
        }
        return this.scale == ((DecimalColumnType)object).scale;
    }

    @Override
    public final int hashCode() {
        int n = super.hashCode();
        n = n * 31 + this.precision;
        n = n * 31 + this.scale;
        return n;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/DecimalColumnType$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/DecimalColumnType;", "getINSTANCE$exposed_core", "()Lorg/jetbrains/exposed/sql/DecimalColumnType;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public final DecimalColumnType getINSTANCE$exposed_core() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

