/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2PushPromiseFrame;
import io.netty.handler.codec.http2.Http2StreamFrame;

public final class DefaultHttp2PushPromiseFrame
implements Http2PushPromiseFrame {
    private Http2FrameStream pushStreamFrame;
    private final Http2Headers http2Headers;
    private Http2FrameStream streamFrame;
    private final int padding;
    private final int promisedStreamId;

    public DefaultHttp2PushPromiseFrame(Http2Headers http2Headers) {
        this(http2Headers, 0);
    }

    public DefaultHttp2PushPromiseFrame(Http2Headers http2Headers, int n) {
        this(http2Headers, n, -1);
    }

    DefaultHttp2PushPromiseFrame(Http2Headers http2Headers, int n, int n2) {
        this.http2Headers = http2Headers;
        this.padding = n;
        this.promisedStreamId = n2;
    }

    @Override
    public final Http2StreamFrame pushStream(Http2FrameStream http2FrameStream) {
        this.pushStreamFrame = http2FrameStream;
        return this;
    }

    @Override
    public final Http2FrameStream pushStream() {
        return this.pushStreamFrame;
    }

    @Override
    public final Http2Headers http2Headers() {
        return this.http2Headers;
    }

    @Override
    public final int padding() {
        return this.padding;
    }

    @Override
    public final int promisedStreamId() {
        if (this.pushStreamFrame != null) {
            return this.pushStreamFrame.id();
        }
        return this.promisedStreamId;
    }

    @Override
    public final Http2PushPromiseFrame stream(Http2FrameStream http2FrameStream) {
        this.streamFrame = http2FrameStream;
        return this;
    }

    @Override
    public final Http2FrameStream stream() {
        return this.streamFrame;
    }

    @Override
    public final String name() {
        return "PUSH_PROMISE_FRAME";
    }

    public final String toString() {
        return "DefaultHttp2PushPromiseFrame{pushStreamFrame=" + this.pushStreamFrame + ", http2Headers=" + this.http2Headers + ", streamFrame=" + this.streamFrame + ", padding=" + this.padding + '}';
    }
}

