/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2UnknownFrame;
import io.netty.util.internal.StringUtil;

public final class DefaultHttp2UnknownFrame
extends DefaultByteBufHolder
implements Http2UnknownFrame {
    private final byte frameType;
    private final Http2Flags flags;
    private Http2FrameStream stream;

    public DefaultHttp2UnknownFrame(byte by, Http2Flags http2Flags) {
        this(by, http2Flags, Unpooled.EMPTY_BUFFER);
    }

    public DefaultHttp2UnknownFrame(byte by, Http2Flags http2Flags, ByteBuf byteBuf) {
        super(byteBuf);
        this.frameType = by;
        this.flags = http2Flags;
    }

    @Override
    public final Http2FrameStream stream() {
        return this.stream;
    }

    @Override
    public final DefaultHttp2UnknownFrame stream(Http2FrameStream http2FrameStream) {
        this.stream = http2FrameStream;
        return this;
    }

    @Override
    public final byte frameType() {
        return this.frameType;
    }

    @Override
    public final Http2Flags flags() {
        return this.flags;
    }

    @Override
    public final String name() {
        return "UNKNOWN";
    }

    @Override
    public final DefaultHttp2UnknownFrame copy() {
        DefaultHttp2UnknownFrame defaultHttp2UnknownFrame = this;
        return defaultHttp2UnknownFrame.replace(defaultHttp2UnknownFrame.content().copy());
    }

    @Override
    public final DefaultHttp2UnknownFrame duplicate() {
        DefaultHttp2UnknownFrame defaultHttp2UnknownFrame = this;
        return defaultHttp2UnknownFrame.replace(defaultHttp2UnknownFrame.content().duplicate());
    }

    @Override
    public final DefaultHttp2UnknownFrame retainedDuplicate() {
        DefaultHttp2UnknownFrame defaultHttp2UnknownFrame = this;
        return defaultHttp2UnknownFrame.replace(defaultHttp2UnknownFrame.content().retainedDuplicate());
    }

    @Override
    public final DefaultHttp2UnknownFrame replace(ByteBuf byteBuf) {
        return new DefaultHttp2UnknownFrame(this.frameType, this.flags, byteBuf).stream(this.stream);
    }

    @Override
    public final DefaultHttp2UnknownFrame retain() {
        super.retain();
        return this;
    }

    @Override
    public final DefaultHttp2UnknownFrame retain(int n) {
        super.retain(n);
        return this;
    }

    public final String toString() {
        return StringUtil.simpleClassName((Object)this) + "(frameType=" + this.frameType + ", stream=" + this.stream + ", flags=" + this.flags + ", content=" + this.contentToString() + ')';
    }

    @Override
    public final DefaultHttp2UnknownFrame touch() {
        super.touch();
        return this;
    }

    @Override
    public final DefaultHttp2UnknownFrame touch(Object object) {
        super.touch(object);
        return this;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof DefaultHttp2UnknownFrame)) {
            return false;
        }
        Http2FrameStream http2FrameStream = ((DefaultHttp2UnknownFrame)(object = (DefaultHttp2UnknownFrame)object)).stream();
        return (this.stream == http2FrameStream || http2FrameStream != null && http2FrameStream.equals(this.stream)) && this.flags.equals(((DefaultHttp2UnknownFrame)object).flags()) && this.frameType == ((DefaultHttp2UnknownFrame)object).frameType() && super.equals(object);
    }

    public final int hashCode() {
        int n = super.hashCode();
        n = n * 31 + this.frameType;
        n = n * 31 + this.flags.hashCode();
        if (this.stream != null) {
            n = n * 31 + this.stream.hashCode();
        }
        return n;
    }
}

