/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.HostsFileEntries;
import io.netty.resolver.HostsFileEntriesProvider;
import java.io.File;
import java.io.Reader;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HostsFileParser {
    public static HostsFileEntries parseSilently() {
        return HostsFileParser.hostsFileEntries(HostsFileEntriesProvider.parser().parseSilently());
    }

    public static HostsFileEntries parseSilently(Charset ... charsetArray) {
        return HostsFileParser.hostsFileEntries(HostsFileEntriesProvider.parser().parseSilently(charsetArray));
    }

    public static HostsFileEntries parse() {
        return HostsFileParser.hostsFileEntries(HostsFileEntriesProvider.parser().parse());
    }

    public static HostsFileEntries parse(File file) {
        return HostsFileParser.hostsFileEntries(HostsFileEntriesProvider.parser().parse(file, new Charset[0]));
    }

    public static HostsFileEntries parse(File file, Charset ... charsetArray) {
        return HostsFileParser.hostsFileEntries(HostsFileEntriesProvider.parser().parse(file, charsetArray));
    }

    public static HostsFileEntries parse(Reader reader) {
        return HostsFileParser.hostsFileEntries(HostsFileEntriesProvider.parser().parse(reader));
    }

    private HostsFileParser() {
    }

    private static HostsFileEntries hostsFileEntries(HostsFileEntriesProvider hostsFileEntriesProvider) {
        if (hostsFileEntriesProvider == HostsFileEntriesProvider.EMPTY) {
            return HostsFileEntries.EMPTY;
        }
        return new HostsFileEntries(HostsFileParser.toMapWithSingleValue(hostsFileEntriesProvider.ipv4Entries()), HostsFileParser.toMapWithSingleValue(hostsFileEntriesProvider.ipv6Entries()));
    }

    private static Map<String, ?> toMapWithSingleValue(Map<String, List<InetAddress>> object) {
        HashMap hashMap = new HashMap(object.size());
        for (Map.Entry entry : object.entrySet()) {
            List list = (List)entry.getValue();
            if (list.isEmpty()) continue;
            hashMap.put(entry.getKey(), list.get(0));
        }
        return hashMap;
    }
}

