/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.model.ReceiverModel;
import ch.qos.logback.classic.net.ReceiverBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.OptionHelper;

public class ReceiverModelHandler
extends ModelHandlerBase {
    private ReceiverBase receiver;
    private boolean inError;

    public ReceiverModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new ReceiverModelHandler(context);
    }

    protected Class<ReceiverModel> getSupportedModelClass() {
        return ReceiverModel.class;
    }

    public void handle(ModelInterpretationContext modelInterpretationContext, Model object) {
        object = (ReceiverModel)((Object)object);
        if (OptionHelper.isNullOrEmptyOrAllSpaces((String)(object = object.getClassName()))) {
            this.addError("Missing class name for receiver. ");
            this.inError = true;
            return;
        }
        object = modelInterpretationContext.getImport((String)object);
        try {
            this.addInfo("About to instantiate receiver of type [" + (String)object + "]");
            this.receiver = (ReceiverBase)((Object)OptionHelper.instantiateByClassName((String)object, ReceiverBase.class, (Context)((ContextAwareBase)this).context));
            this.receiver.setContext(((ContextAwareBase)this).context);
            modelInterpretationContext.pushObject((Object)this.receiver);
            return;
        }
        catch (Exception exception) {
            this.inError = true;
            this.addError("Could not create a receiver of type [" + (String)object + "].", exception);
            throw new ModelHandlerException((Throwable)exception);
        }
    }

    public void postHandle(ModelInterpretationContext modelInterpretationContext, Model object) {
        if (this.inError) {
            return;
        }
        object = modelInterpretationContext.peekObject();
        if (object != this.receiver) {
            this.addWarn("The object at the of the stack is not the receiver pushed earlier.");
            return;
        }
        modelInterpretationContext.popObject();
        this.addInfo("Registering receiver with context.");
        modelInterpretationContext.getContext().register((LifeCycle)this.receiver);
        this.receiver.start();
    }
}

