/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.model.RootLoggerModel;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.OptionHelper;

public class RootLoggerModelHandler
extends ModelHandlerBase {
    Logger root;
    boolean inError = false;

    public RootLoggerModelHandler(Context context) {
        super(context);
    }

    public static RootLoggerModelHandler makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new RootLoggerModelHandler(context);
    }

    protected Class<RootLoggerModel> getSupportedModelClass() {
        return RootLoggerModel.class;
    }

    public void handle(ModelInterpretationContext modelInterpretationContext, Model object) {
        this.inError = false;
        object = (RootLoggerModel)((Object)object);
        LoggerContext loggerContext = (LoggerContext)((ContextAwareBase)this).context;
        this.root = loggerContext.getLogger("ROOT");
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)(object = modelInterpretationContext.subst(object.getLevel())))) {
            object = Level.toLevel((String)object);
            this.addInfo("Setting level of ROOT logger to " + String.valueOf(object));
            this.root.setLevel((Level)object);
        }
        modelInterpretationContext.pushObject((Object)this.root);
    }

    public void postHandle(ModelInterpretationContext modelInterpretationContext, Model object) {
        if (this.inError) {
            return;
        }
        object = modelInterpretationContext.peekObject();
        if (object != this.root) {
            this.addWarn("The object [" + String.valueOf(object) + "] on the top the of the stack is not the root logger");
            return;
        }
        modelInterpretationContext.popObject();
    }
}

