/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpMessage;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostBodyUtil;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InternalAttribute;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;

public class HttpPostRequestEncoder
implements ChunkedInput<HttpContent> {
    private static final Map.Entry[] percentEncodings = new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Pattern, String>(Pattern.compile("\\*"), "%2A"), new AbstractMap.SimpleImmutableEntry<Pattern, String>(Pattern.compile("\\+"), "%20"), new AbstractMap.SimpleImmutableEntry<Pattern, String>(Pattern.compile("~"), "%7E")};
    private final HttpDataFactory factory;
    private final HttpRequest request;
    private final Charset charset;
    private boolean isChunked;
    private final List<InterfaceHttpData> bodyListDatas;
    final List<InterfaceHttpData> multipartHttpDatas;
    private final boolean isMultipart;
    String multipartDataBoundary;
    String multipartMixedBoundary;
    private boolean headerFinalized;
    private final EncoderMode encoderMode;
    private boolean isLastChunk;
    private boolean isLastChunkSent;
    private FileUpload currentFileUpload;
    private boolean duringMixedMode;
    private long globalBodySize;
    private long globalProgress;
    private ListIterator<InterfaceHttpData> iterator;
    private ByteBuf currentBuffer;
    private InterfaceHttpData currentData;
    private boolean isKey = true;

    public HttpPostRequestEncoder(HttpRequest httpRequest, boolean bl) {
        this(new DefaultHttpDataFactory(16384L), httpRequest, bl, HttpConstants.DEFAULT_CHARSET, EncoderMode.RFC1738);
    }

    public HttpPostRequestEncoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, boolean bl) {
        this(httpDataFactory, httpRequest, bl, HttpConstants.DEFAULT_CHARSET, EncoderMode.RFC1738);
    }

    public HttpPostRequestEncoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, boolean bl, Charset charset, EncoderMode encoderMode) {
        this.request = (HttpRequest)ObjectUtil.checkNotNull((Object)httpRequest, (String)"request");
        this.charset = (Charset)ObjectUtil.checkNotNull((Object)charset, (String)"charset");
        this.factory = (HttpDataFactory)ObjectUtil.checkNotNull((Object)httpDataFactory, (String)"factory");
        if (HttpMethod.TRACE.equals(httpRequest.method())) {
            throw new ErrorDataEncoderException("Cannot create a Encoder if request is a TRACE");
        }
        this.bodyListDatas = new ArrayList<InterfaceHttpData>();
        this.isLastChunk = false;
        this.isLastChunkSent = false;
        this.isMultipart = bl;
        this.multipartHttpDatas = new ArrayList<InterfaceHttpData>();
        this.encoderMode = encoderMode;
        if (this.isMultipart) {
            this.initDataMultipart();
        }
    }

    public void cleanFiles() {
        this.factory.cleanRequestHttpData(this.request);
    }

    public boolean isMultipart() {
        return this.isMultipart;
    }

    private void initDataMultipart() {
        this.multipartDataBoundary = HttpPostRequestEncoder.getNewMultipartDelimiter();
    }

    private void initMixedMultipart() {
        this.multipartMixedBoundary = HttpPostRequestEncoder.getNewMultipartDelimiter();
    }

    private static String getNewMultipartDelimiter() {
        return Long.toHexString(PlatformDependent.threadLocalRandom().nextLong());
    }

    public List<InterfaceHttpData> getBodyListAttributes() {
        return this.bodyListDatas;
    }

    public void setBodyHttpDatas(List<InterfaceHttpData> object) {
        ObjectUtil.checkNotNull(object, (String)"datas");
        this.globalBodySize = 0L;
        this.bodyListDatas.clear();
        this.currentFileUpload = null;
        this.duringMixedMode = false;
        this.multipartHttpDatas.clear();
        object = object.iterator();
        while (object.hasNext()) {
            InterfaceHttpData interfaceHttpData = (InterfaceHttpData)object.next();
            this.addBodyHttpData(interfaceHttpData);
        }
    }

    public void addBodyAttribute(String object, String string) {
        string = string != null ? string : "";
        object = this.factory.createAttribute(this.request, (String)ObjectUtil.checkNotNull((Object)object, (String)"name"), string);
        this.addBodyHttpData((InterfaceHttpData)object);
    }

    public void addBodyFileUpload(String string, File file, String string2, boolean bl) {
        this.addBodyFileUpload(string, file.getName(), file, string2, bl);
    }

    public void addBodyFileUpload(String object, String string, File file, String string2, boolean bl) {
        ObjectUtil.checkNotNull((Object)object, (String)"name");
        ObjectUtil.checkNotNull((Object)file, (String)"file");
        if (string == null) {
            string = "";
        }
        String string3 = string2;
        String string4 = null;
        if (string2 == null) {
            string3 = bl ? "text/plain" : "application/octet-stream";
        }
        if (!bl) {
            string4 = HttpPostBodyUtil.TransferEncodingMechanism.BINARY.value();
        }
        object = this.factory.createFileUpload(this.request, (String)object, string, string3, string4, null, file.length());
        try {
            object.setContent(file);
        }
        catch (IOException iOException) {
            throw new ErrorDataEncoderException(iOException);
        }
        this.addBodyHttpData((InterfaceHttpData)object);
    }

    public void addBodyFileUploads(String string, File[] fileArray, String[] stringArray, boolean[] blArray) {
        if (fileArray.length != stringArray.length && fileArray.length != blArray.length) {
            throw new IllegalArgumentException("Different array length");
        }
        for (int i = 0; i < fileArray.length; ++i) {
            this.addBodyFileUpload(string, fileArray[i], stringArray[i], blArray[i]);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addBodyHttpData(InterfaceHttpData var1_1) {
        block25: {
            block28: {
                block26: {
                    block27: {
                        if (this.headerFinalized) {
                            throw new ErrorDataEncoderException("Cannot add value once finalized");
                        }
                        this.bodyListDatas.add((InterfaceHttpData)ObjectUtil.checkNotNull((Object)var1_1, (String)"data"));
                        if (!this.isMultipart) {
                            if (var1_1 instanceof Attribute) {
                                var2_2 = (Attribute)var1_1;
                                try {
                                    var3_6 = this.encodeAttribute(var2_2.getName(), this.charset);
                                    var4_11 = this.encodeAttribute(var2_2.getValue(), this.charset);
                                    var4_11 = this.factory.createAttribute(this.request, var3_6, (String)var4_11);
                                    this.multipartHttpDatas.add((InterfaceHttpData)var4_11);
                                    this.globalBodySize += (long)(var4_11.getName().length() + 1) + var4_11.length() + 1L;
                                }
                                catch (IOException var3_7) {
                                    throw new ErrorDataEncoderException(var3_7);
                                }
                            } else if (var1_1 instanceof FileUpload) {
                                var2_3 = (FileUpload)var1_1;
                                var3_8 = this.encodeAttribute(var2_3.getName(), this.charset);
                                var4_12 = this.encodeAttribute(var2_3.getFilename(), this.charset);
                                var4_12 = this.factory.createAttribute(this.request, var3_8, (String)var4_12);
                                this.multipartHttpDatas.add((InterfaceHttpData)var4_12);
                                this.globalBodySize += (long)(var4_12.getName().length() + 1) + var4_12.length() + 1L;
                            }
                            return;
                        }
                        if (var1_1 instanceof Attribute) {
                            if (this.duringMixedMode) {
                                var2_4 = new InternalAttribute(this.charset);
                                var2_4.addValue("\r\n--" + this.multipartMixedBoundary + "--");
                                this.multipartHttpDatas.add(var2_4);
                                this.multipartMixedBoundary = null;
                                this.currentFileUpload = null;
                                this.duringMixedMode = false;
                            }
                            var2_4 = new InternalAttribute(this.charset);
                            if (!this.multipartHttpDatas.isEmpty()) {
                                var2_4.addValue("\r\n");
                            }
                            var2_4.addValue("--" + this.multipartDataBoundary + "\r\n");
                            var3_9 = (Attribute)var1_1;
                            var2_4.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.FORM_DATA + "; " + HttpHeaderValues.NAME + "=\"" + var3_9.getName() + "\"\r\n");
                            var2_4.addValue(HttpHeaderNames.CONTENT_LENGTH + ": " + var3_9.length() + "\r\n");
                            var4_13 = var3_9.getCharset();
                            if (var4_13 != null) {
                                var2_4.addValue(HttpHeaderNames.CONTENT_TYPE + ": text/plain" + "; " + HttpHeaderValues.CHARSET + '=' + var4_13.name() + "\r\n");
                            }
                            var2_4.addValue("\r\n");
                            this.multipartHttpDatas.add(var2_4);
                            this.multipartHttpDatas.add(var1_1);
                            this.globalBodySize += var3_9.length() + (long)var2_4.size();
                            return;
                        }
                        if (!(var1_1 instanceof FileUpload)) break block25;
                        var2_5 = (FileUpload)var1_1;
                        var3_10 = new InternalAttribute(this.charset);
                        if (!this.multipartHttpDatas.isEmpty()) {
                            var3_10.addValue("\r\n");
                        }
                        if (!this.duringMixedMode) break block26;
                        if (this.currentFileUpload == null || !this.currentFileUpload.getName().equals(var2_5.getName())) break block27;
                        var4_14 = true;
                        break block28;
                    }
                    var3_10.addValue("--" + this.multipartMixedBoundary + "--");
                    this.multipartHttpDatas.add(var3_10);
                    this.multipartMixedBoundary = null;
                    var3_10 = new InternalAttribute(this.charset);
                    var3_10.addValue("\r\n");
                    ** GOTO lbl-1000
                }
                if (this.encoderMode != EncoderMode.HTML5 && this.currentFileUpload != null && this.currentFileUpload.getName().equals(var2_5.getName())) {
                    this.initMixedMultipart();
                    var4_15 = (InternalAttribute)this.multipartHttpDatas.get(this.multipartHttpDatas.size() - 2);
                    this.globalBodySize -= (long)var4_15.size();
                    var5_17 = new StringBuilder(139 + this.multipartDataBoundary.length() + (this.multipartMixedBoundary.length() << 1) + var2_5.getFilename().length() + var2_5.getName().length()).append("--").append(this.multipartDataBoundary).append("\r\n").append((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION).append(": ").append((CharSequence)HttpHeaderValues.FORM_DATA).append("; ").append((CharSequence)HttpHeaderValues.NAME).append("=\"").append(var2_5.getName()).append("\"\r\n").append((CharSequence)HttpHeaderNames.CONTENT_TYPE).append(": ").append((CharSequence)HttpHeaderValues.MULTIPART_MIXED).append("; ").append((CharSequence)HttpHeaderValues.BOUNDARY).append('=').append(this.multipartMixedBoundary).append("\r\n\r\n--").append(this.multipartMixedBoundary).append("\r\n").append((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION).append(": ").append((CharSequence)HttpHeaderValues.ATTACHMENT);
                    if (!var2_5.getFilename().isEmpty()) {
                        var5_17.append("; ").append((CharSequence)HttpHeaderValues.FILENAME).append("=\"").append(this.currentFileUpload.getFilename()).append('\"');
                    }
                    var5_17.append("\r\n");
                    var4_15.setValue(var5_17.toString(), 1);
                    var4_15.setValue("", 2);
                    this.globalBodySize += (long)var4_15.size();
                    var4_14 = true;
                    this.duringMixedMode = true;
                } else lbl-1000:
                // 2 sources

                {
                    var4_14 = false;
                    this.currentFileUpload = var2_5;
                    this.duringMixedMode = false;
                }
            }
            if (var4_14) {
                var3_10.addValue("--" + this.multipartMixedBoundary + "\r\n");
                if (var2_5.getFilename().isEmpty()) {
                    var3_10.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.ATTACHMENT + "\r\n");
                } else {
                    var3_10.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.ATTACHMENT + "; " + HttpHeaderValues.FILENAME + "=\"" + var2_5.getFilename() + "\"\r\n");
                }
            } else {
                var3_10.addValue("--" + this.multipartDataBoundary + "\r\n");
                if (var2_5.getFilename().isEmpty()) {
                    var3_10.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.FORM_DATA + "; " + HttpHeaderValues.NAME + "=\"" + var2_5.getName() + "\"\r\n");
                } else {
                    var3_10.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.FORM_DATA + "; " + HttpHeaderValues.NAME + "=\"" + var2_5.getName() + "\"; " + HttpHeaderValues.FILENAME + "=\"" + var2_5.getFilename() + "\"\r\n");
                }
            }
            var3_10.addValue(HttpHeaderNames.CONTENT_LENGTH + ": " + var2_5.length() + "\r\n");
            var3_10.addValue(HttpHeaderNames.CONTENT_TYPE + ": " + var2_5.getContentType());
            var4_16 = var2_5.getContentTransferEncoding();
            if (var4_16 != null && var4_16.equals(HttpPostBodyUtil.TransferEncodingMechanism.BINARY.value())) {
                var3_10.addValue("\r\n" + HttpHeaderNames.CONTENT_TRANSFER_ENCODING + ": " + HttpPostBodyUtil.TransferEncodingMechanism.BINARY.value() + "\r\n\r\n");
            } else if (var2_5.getCharset() != null) {
                var3_10.addValue("; " + HttpHeaderValues.CHARSET + '=' + var2_5.getCharset().name() + "\r\n\r\n");
            } else {
                var3_10.addValue("\r\n\r\n");
            }
            this.multipartHttpDatas.add(var3_10);
            this.multipartHttpDatas.add(var1_1);
            this.globalBodySize += var2_5.length() + (long)var3_10.size();
        }
    }

    public HttpRequest finalizeRequest() {
        Object object;
        Object object2;
        if (!this.headerFinalized) {
            if (this.isMultipart) {
                object2 = new InternalAttribute(this.charset);
                if (this.duringMixedMode) {
                    ((InternalAttribute)object2).addValue("\r\n--" + this.multipartMixedBoundary + "--");
                }
                ((InternalAttribute)object2).addValue("\r\n--" + this.multipartDataBoundary + "--\r\n");
                this.multipartHttpDatas.add((InterfaceHttpData)object2);
                this.multipartMixedBoundary = null;
                this.currentFileUpload = null;
                this.duringMixedMode = false;
                this.globalBodySize += (long)((InternalAttribute)object2).size();
            }
        } else {
            throw new ErrorDataEncoderException("Header already encoded");
        }
        this.headerFinalized = true;
        object2 = this.request.headers();
        Object object3 = ((HttpHeaders)object2).getAll((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        Object object4 = ((HttpHeaders)object2).getAll((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        if (object3 != null) {
            ((HttpHeaders)object2).remove((CharSequence)HttpHeaderNames.CONTENT_TYPE);
            object = object3.iterator();
            while (object.hasNext()) {
                String string = object.next();
                object3 = string.toLowerCase();
                if (((String)object3).startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString()) || ((String)object3).startsWith(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.toString())) continue;
                ((HttpHeaders)object2).add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)string);
            }
        }
        if (this.isMultipart) {
            object = HttpHeaderValues.MULTIPART_FORM_DATA + "; " + HttpHeaderValues.BOUNDARY + '=' + this.multipartDataBoundary;
            ((HttpHeaders)object2).add((CharSequence)HttpHeaderNames.CONTENT_TYPE, object);
        } else {
            ((HttpHeaders)object2).add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
        }
        long l = this.globalBodySize;
        if (!this.isMultipart) {
            --l;
        }
        this.iterator = this.multipartHttpDatas.listIterator();
        ((HttpHeaders)object2).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(l));
        if (l > 8096L || this.isMultipart) {
            this.isChunked = true;
            if (object4 != null) {
                ((HttpHeaders)object2).remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object4 = object3.next();
                    if (HttpHeaderValues.CHUNKED.contentEqualsIgnoreCase((CharSequence)object4)) continue;
                    ((HttpHeaders)object2).add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, object4);
                }
            }
            HttpUtil.setTransferEncodingChunked(this.request, true);
            return new WrappedHttpRequest(this.request);
        }
        object3 = this.nextChunk();
        if (this.request instanceof FullHttpRequest) {
            object4 = (FullHttpRequest)this.request;
            object2 = object3.content();
            if (object4.content() != object2) {
                object4.content().clear().writeBytes((ByteBuf)object2);
                object2.release();
            }
            return object4;
        }
        return new WrappedFullHttpRequest(this.request, (HttpContent)object3);
    }

    public boolean isChunked() {
        return this.isChunked;
    }

    private String encodeAttribute(String string, Charset charset) {
        if (string == null) {
            return "";
        }
        try {
            string = URLEncoder.encode(string, charset.name());
            if (this.encoderMode == EncoderMode.RFC3986) {
                Map.Entry[] entryArray = percentEncodings;
                int n = percentEncodings.length;
                for (int i = 0; i < n; ++i) {
                    Map.Entry entry = entryArray[i];
                    String string2 = (String)entry.getValue();
                    string = ((Pattern)entry.getKey()).matcher(string).replaceAll(string2);
                }
            }
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ErrorDataEncoderException(charset.name(), unsupportedEncodingException);
        }
    }

    private ByteBuf fillByteBuf() {
        int n = this.currentBuffer.readableBytes();
        if (n > 8096) {
            return this.currentBuffer.readRetainedSlice(8096);
        }
        ByteBuf byteBuf = this.currentBuffer;
        this.currentBuffer = null;
        return byteBuf;
    }

    private HttpContent encodeNextChunkMultipart(int n) {
        ByteBuf byteBuf;
        if (this.currentData == null) {
            return null;
        }
        if (this.currentData instanceof InternalAttribute) {
            byteBuf = ((InternalAttribute)this.currentData).toByteBuf();
            this.currentData = null;
        } else {
            try {
                byteBuf = ((HttpData)this.currentData).getChunk(n);
            }
            catch (IOException iOException) {
                throw new ErrorDataEncoderException(iOException);
            }
            if (byteBuf.capacity() == 0) {
                this.currentData = null;
                return null;
            }
        }
        this.currentBuffer = this.currentBuffer == null ? byteBuf : Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.currentBuffer, byteBuf});
        if (this.currentBuffer.readableBytes() < 8096) {
            this.currentData = null;
            return null;
        }
        byteBuf = this.fillByteBuf();
        return new DefaultHttpContent(byteBuf);
    }

    private HttpContent encodeNextChunkUrlEncoded(int n) {
        ByteBuf byteBuf;
        String string;
        if (this.currentData == null) {
            return null;
        }
        int n2 = n;
        if (this.isKey) {
            string = this.currentData.getName();
            byteBuf = Unpooled.wrappedBuffer((byte[])string.getBytes(this.charset));
            this.isKey = false;
            this.currentBuffer = this.currentBuffer == null ? Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{byteBuf, Unpooled.wrappedBuffer((byte[])"=".getBytes(this.charset))}) : Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.currentBuffer, byteBuf, Unpooled.wrappedBuffer((byte[])"=".getBytes(this.charset))});
            n2 = n - (byteBuf.readableBytes() + 1);
            if (this.currentBuffer.readableBytes() >= 8096) {
                byteBuf = this.fillByteBuf();
                return new DefaultHttpContent(byteBuf);
            }
        }
        try {
            byteBuf = ((HttpData)this.currentData).getChunk(n2);
        }
        catch (IOException iOException) {
            throw new ErrorDataEncoderException(iOException);
        }
        string = null;
        if (byteBuf.readableBytes() < n2) {
            this.isKey = true;
            Object object = string = this.iterator.hasNext() ? Unpooled.wrappedBuffer((byte[])"&".getBytes(this.charset)) : null;
        }
        if (byteBuf.capacity() == 0) {
            this.currentData = null;
            if (this.currentBuffer == null) {
                if (string == null) {
                    return null;
                }
                this.currentBuffer = string;
            } else if (string != null) {
                this.currentBuffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.currentBuffer, string});
            }
            if (this.currentBuffer.readableBytes() >= 8096) {
                byteBuf = this.fillByteBuf();
                return new DefaultHttpContent(byteBuf);
            }
            return null;
        }
        this.currentBuffer = this.currentBuffer == null ? (string != null ? Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{byteBuf, string}) : byteBuf) : (string != null ? Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.currentBuffer, byteBuf, string}) : Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.currentBuffer, byteBuf}));
        if (this.currentBuffer.readableBytes() < 8096) {
            this.currentData = null;
            this.isKey = true;
            return null;
        }
        byteBuf = this.fillByteBuf();
        return new DefaultHttpContent(byteBuf);
    }

    public void close() {
    }

    @Deprecated
    public HttpContent readChunk(ChannelHandlerContext channelHandlerContext) {
        return this.readChunk(channelHandlerContext.alloc());
    }

    public HttpContent readChunk(ByteBufAllocator object) {
        if (this.isLastChunkSent) {
            return null;
        }
        object = this.nextChunk();
        this.globalProgress += (long)object.content().readableBytes();
        return object;
    }

    private HttpContent nextChunk() {
        if (this.isLastChunk) {
            this.isLastChunkSent = true;
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        int n = this.calculateRemainingSize();
        if (n <= 0) {
            ByteBuf byteBuf = this.fillByteBuf();
            return new DefaultHttpContent(byteBuf);
        }
        if (this.currentData != null) {
            HttpContent httpContent = this.isMultipart ? this.encodeNextChunkMultipart(n) : this.encodeNextChunkUrlEncoded(n);
            if (httpContent != null) {
                return httpContent;
            }
            n = this.calculateRemainingSize();
        }
        if (!this.iterator.hasNext()) {
            return this.lastChunk();
        }
        while (n > 0 && this.iterator.hasNext()) {
            this.currentData = this.iterator.next();
            HttpContent httpContent = this.isMultipart ? this.encodeNextChunkMultipart(n) : this.encodeNextChunkUrlEncoded(n);
            if (httpContent == null) {
                n = this.calculateRemainingSize();
                continue;
            }
            return httpContent;
        }
        return this.lastChunk();
    }

    private int calculateRemainingSize() {
        int n = 8096;
        if (this.currentBuffer != null) {
            n = 8096 - this.currentBuffer.readableBytes();
        }
        return n;
    }

    private HttpContent lastChunk() {
        this.isLastChunk = true;
        if (this.currentBuffer == null) {
            this.isLastChunkSent = true;
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        ByteBuf byteBuf = this.currentBuffer;
        this.currentBuffer = null;
        return new DefaultHttpContent(byteBuf);
    }

    public boolean isEndOfInput() {
        return this.isLastChunkSent;
    }

    public long length() {
        if (this.isMultipart) {
            return this.globalBodySize;
        }
        return this.globalBodySize - 1L;
    }

    public long progress() {
        return this.globalProgress;
    }

    private static final class WrappedFullHttpRequest
    extends WrappedHttpRequest
    implements FullHttpRequest {
        private final HttpContent content;

        private WrappedFullHttpRequest(HttpRequest httpRequest, HttpContent httpContent) {
            super(httpRequest);
            this.content = httpContent;
        }

        @Override
        public final FullHttpRequest setProtocolVersion(HttpVersion httpVersion) {
            super.setProtocolVersion(httpVersion);
            return this;
        }

        @Override
        public final FullHttpRequest setMethod(HttpMethod httpMethod) {
            super.setMethod(httpMethod);
            return this;
        }

        @Override
        public final FullHttpRequest setUri(String string) {
            super.setUri(string);
            return this;
        }

        @Override
        public final FullHttpRequest copy() {
            WrappedFullHttpRequest wrappedFullHttpRequest = this;
            return wrappedFullHttpRequest.replace(wrappedFullHttpRequest.content().copy());
        }

        @Override
        public final FullHttpRequest duplicate() {
            WrappedFullHttpRequest wrappedFullHttpRequest = this;
            return wrappedFullHttpRequest.replace(wrappedFullHttpRequest.content().duplicate());
        }

        @Override
        public final FullHttpRequest retainedDuplicate() {
            WrappedFullHttpRequest wrappedFullHttpRequest = this;
            return wrappedFullHttpRequest.replace(wrappedFullHttpRequest.content().retainedDuplicate());
        }

        @Override
        public final FullHttpRequest replace(ByteBuf object) {
            object = new DefaultFullHttpRequest(this.protocolVersion(), this.method(), this.uri(), (ByteBuf)object);
            ((DefaultHttpMessage)object).headers().set(this.headers());
            ((DefaultFullHttpRequest)object).trailingHeaders().set(this.trailingHeaders());
            return object;
        }

        @Override
        public final FullHttpRequest retain(int n) {
            this.content.retain(n);
            return this;
        }

        @Override
        public final FullHttpRequest retain() {
            this.content.retain();
            return this;
        }

        @Override
        public final FullHttpRequest touch() {
            this.content.touch();
            return this;
        }

        @Override
        public final FullHttpRequest touch(Object object) {
            this.content.touch(object);
            return this;
        }

        public final ByteBuf content() {
            return this.content.content();
        }

        @Override
        public final HttpHeaders trailingHeaders() {
            if (this.content instanceof LastHttpContent) {
                return ((LastHttpContent)this.content).trailingHeaders();
            }
            return EmptyHttpHeaders.INSTANCE;
        }

        public final int refCnt() {
            return this.content.refCnt();
        }

        public final boolean release() {
            return this.content.release();
        }

        public final boolean release(int n) {
            return this.content.release(n);
        }
    }

    private static class WrappedHttpRequest
    implements HttpRequest {
        private final HttpRequest request;

        WrappedHttpRequest(HttpRequest httpRequest) {
            this.request = httpRequest;
        }

        @Override
        public HttpRequest setProtocolVersion(HttpVersion httpVersion) {
            this.request.setProtocolVersion(httpVersion);
            return this;
        }

        @Override
        public HttpRequest setMethod(HttpMethod httpMethod) {
            this.request.setMethod(httpMethod);
            return this;
        }

        @Override
        public HttpRequest setUri(String string) {
            this.request.setUri(string);
            return this;
        }

        @Override
        public HttpMethod getMethod() {
            return this.request.method();
        }

        @Override
        public HttpMethod method() {
            return this.request.method();
        }

        @Override
        public String getUri() {
            return this.request.uri();
        }

        @Override
        public String uri() {
            return this.request.uri();
        }

        @Override
        public HttpVersion getProtocolVersion() {
            return this.request.protocolVersion();
        }

        @Override
        public HttpVersion protocolVersion() {
            return this.request.protocolVersion();
        }

        @Override
        public HttpHeaders headers() {
            return this.request.headers();
        }

        public DecoderResult decoderResult() {
            return this.request.decoderResult();
        }

        @Override
        @Deprecated
        public DecoderResult getDecoderResult() {
            return this.request.getDecoderResult();
        }

        public void setDecoderResult(DecoderResult decoderResult) {
            this.request.setDecoderResult(decoderResult);
        }
    }

    public static class ErrorDataEncoderException
    extends Exception {
        private static final long serialVersionUID = 5020247425493164465L;

        public ErrorDataEncoderException() {
        }

        public ErrorDataEncoderException(String string) {
            super(string);
        }

        public ErrorDataEncoderException(Throwable throwable) {
            super(throwable);
        }

        public ErrorDataEncoderException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static enum EncoderMode {
        RFC1738,
        RFC3986,
        HTML5;

    }
}

