/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocket00FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.internal.PlatformDependent;
import java.net.URI;
import java.nio.ByteBuffer;

public class WebSocketClientHandshaker00
extends WebSocketClientHandshaker {
    private ByteBuf expectedChallengeResponseBytes;

    public WebSocketClientHandshaker00(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n) {
        this(uRI, webSocketVersion, string, httpHeaders, n, 10000L);
    }

    public WebSocketClientHandshaker00(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n, long l) {
        this(uRI, webSocketVersion, string, httpHeaders, n, l, false);
    }

    WebSocketClientHandshaker00(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n, long l, boolean bl) {
        this(uRI, webSocketVersion, string, httpHeaders, n, l, bl, true);
    }

    WebSocketClientHandshaker00(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n, long l, boolean bl, boolean bl2) {
        super(uRI, webSocketVersion, string, httpHeaders, n, l, bl, bl2);
    }

    @Override
    protected FullHttpRequest newHandshakeRequest() {
        int n = WebSocketUtil.randomNumber(1, 12);
        int n2 = WebSocketUtil.randomNumber(1, 12);
        int n3 = Integer.MAX_VALUE / n;
        int n4 = Integer.MAX_VALUE / n2;
        n3 = WebSocketUtil.randomNumber(0, n3);
        n4 = WebSocketUtil.randomNumber(0, n4);
        int n5 = n3 * n;
        int n6 = n4 * n2;
        String string = Integer.toString(n5);
        String string2 = Integer.toString(n6);
        string = WebSocketClientHandshaker00.insertRandomCharacters(string);
        string2 = WebSocketClientHandshaker00.insertRandomCharacters(string2);
        string = WebSocketClientHandshaker00.insertSpaces(string, n);
        string2 = WebSocketClientHandshaker00.insertSpaces(string2, n2);
        byte[] byArray = WebSocketUtil.randomBytes(8);
        Object object = ByteBuffer.allocate(4);
        ((ByteBuffer)object).putInt(n3);
        Object object2 = ((ByteBuffer)object).array();
        object = ByteBuffer.allocate(4);
        ((ByteBuffer)object).putInt(n4);
        object = ((ByteBuffer)object).array();
        Object object3 = new byte[16];
        System.arraycopy(object2, 0, object3, 0, 4);
        System.arraycopy(object, 0, object3, 4, 4);
        System.arraycopy(byArray, 0, object3, 8, 8);
        this.expectedChallengeResponseBytes = Unpooled.wrappedBuffer((byte[])WebSocketUtil.md5((byte[])object3));
        object = this.uri();
        DefaultFullHttpRequest defaultFullHttpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.upgradeUrl((URI)object), Unpooled.wrappedBuffer((byte[])byArray));
        object2 = defaultFullHttpRequest;
        object3 = defaultFullHttpRequest.headers();
        if (this.customHeaders != null) {
            ((HttpHeaders)object3).add(this.customHeaders);
            if (!((HttpHeaders)object3).contains((CharSequence)HttpHeaderNames.HOST)) {
                ((HttpHeaders)object3).set((CharSequence)HttpHeaderNames.HOST, (Object)WebSocketClientHandshaker00.websocketHostValue((URI)object));
            }
        } else {
            ((HttpHeaders)object3).set((CharSequence)HttpHeaderNames.HOST, (Object)WebSocketClientHandshaker00.websocketHostValue((URI)object));
        }
        ((HttpHeaders)object3).set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY1, (Object)string).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY2, (Object)string2);
        if (this.generateOriginHeader && !((HttpHeaders)object3).contains((CharSequence)HttpHeaderNames.ORIGIN)) {
            ((HttpHeaders)object3).set((CharSequence)HttpHeaderNames.ORIGIN, (Object)WebSocketClientHandshaker00.websocketOriginValue((URI)object));
        }
        if ((object = this.expectedSubprotocol()) != null && !((String)object).isEmpty()) {
            ((HttpHeaders)object3).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, object);
        }
        ((HttpHeaders)object3).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)byArray.length);
        return object2;
    }

    @Override
    protected void verify(FullHttpResponse fullHttpResponse) {
        Object object = fullHttpResponse.status();
        if (!HttpResponseStatus.SWITCHING_PROTOCOLS.equals(object)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response getStatus: " + object, fullHttpResponse);
        }
        object = fullHttpResponse.headers();
        String string = ((HttpHeaders)object).get((CharSequence)HttpHeaderNames.UPGRADE);
        if (!HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase((CharSequence)string)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response upgrade: " + string, fullHttpResponse);
        }
        if (!((HttpHeaders)object).containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE, true)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response connection: " + ((HttpHeaders)object).get((CharSequence)HttpHeaderNames.CONNECTION), fullHttpResponse);
        }
        object = fullHttpResponse.content();
        if (!object.equals((Object)this.expectedChallengeResponseBytes)) {
            throw new WebSocketClientHandshakeException("Invalid challenge", fullHttpResponse);
        }
    }

    private static String insertRandomCharacters(String string) {
        int n;
        int n2 = WebSocketUtil.randomNumber(1, 12);
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            n = PlatformDependent.threadLocalRandom().nextInt(126) + 33;
            if ((33 >= n || n >= 47) && (58 >= n || n >= 126)) continue;
            cArray[n3] = (char)n;
            ++n3;
        }
        for (n = 0; n < n2; ++n) {
            n3 = WebSocketUtil.randomNumber(0, string.length());
            String string2 = string.substring(0, n3);
            string = string.substring(n3);
            string = string2 + cArray[n] + string;
        }
        return string;
    }

    private static String insertSpaces(String string, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = WebSocketUtil.randomNumber(1, string.length() - 1);
            String string2 = string.substring(0, n2);
            string = string.substring(n2);
            string = string2 + ' ' + string;
        }
        return string;
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket00FrameDecoder(this.maxFramePayloadLength());
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket00FrameEncoder();
    }

    @Override
    public WebSocketClientHandshaker00 setForceCloseTimeoutMillis(long l) {
        super.setForceCloseTimeoutMillis(l);
        return this;
    }
}

