/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.handler.codec.spdy.SpdyFrame;
import io.netty.handler.codec.spdy.SpdyHeaders;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyHttpHeaders;
import io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.netty.handler.codec.spdy.SpdyStreamStatus;
import io.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SpdyHttpDecoder
extends MessageToMessageDecoder<SpdyFrame> {
    private final int spdyVersion;
    private final int maxContentLength;
    private final Map<Integer, FullHttpMessage> messageMap;
    private final HttpHeadersFactory headersFactory;
    private final HttpHeadersFactory trailersFactory;

    public SpdyHttpDecoder(SpdyVersion spdyVersion, int n) {
        this(spdyVersion, n, new HashMap<Integer, FullHttpMessage>(), DefaultHttpHeadersFactory.headersFactory(), DefaultHttpHeadersFactory.trailersFactory());
    }

    @Deprecated
    public SpdyHttpDecoder(SpdyVersion spdyVersion, int n, boolean bl) {
        this(spdyVersion, n, new HashMap<Integer, FullHttpMessage>(), bl);
    }

    protected SpdyHttpDecoder(SpdyVersion spdyVersion, int n, Map<Integer, FullHttpMessage> map) {
        this(spdyVersion, n, map, DefaultHttpHeadersFactory.headersFactory(), DefaultHttpHeadersFactory.trailersFactory());
    }

    @Deprecated
    protected SpdyHttpDecoder(SpdyVersion spdyVersion, int n, Map<Integer, FullHttpMessage> map, boolean bl) {
        this(spdyVersion, n, map, DefaultHttpHeadersFactory.headersFactory().withValidation(bl), DefaultHttpHeadersFactory.trailersFactory().withValidation(bl));
    }

    protected SpdyHttpDecoder(SpdyVersion spdyVersion, int n, Map<Integer, FullHttpMessage> map, HttpHeadersFactory httpHeadersFactory, HttpHeadersFactory httpHeadersFactory2) {
        this.spdyVersion = ((SpdyVersion)((Object)ObjectUtil.checkNotNull((Object)((Object)spdyVersion), (String)"version"))).version();
        this.maxContentLength = ObjectUtil.checkPositive((int)n, (String)"maxContentLength");
        this.messageMap = map;
        this.headersFactory = httpHeadersFactory;
        this.trailersFactory = httpHeadersFactory2;
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        for (Map.Entry<Integer, FullHttpMessage> entry : this.messageMap.entrySet()) {
            ReferenceCountUtil.safeRelease((Object)entry.getValue());
        }
        this.messageMap.clear();
        super.channelInactive(channelHandlerContext);
    }

    protected FullHttpMessage putMessage(int n, FullHttpMessage fullHttpMessage) {
        return this.messageMap.put(n, fullHttpMessage);
    }

    protected FullHttpMessage getMessage(int n) {
        return this.messageMap.get(n);
    }

    protected FullHttpMessage removeMessage(int n) {
        return this.messageMap.remove(n);
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, SpdyFrame spdyFrame, List<Object> list) {
        block32: {
            if (spdyFrame instanceof SpdySynStreamFrame) {
                block31: {
                    int n = (spdyFrame = (SpdySynStreamFrame)spdyFrame).streamId();
                    if (SpdyCodecUtil.isServerId(n)) {
                        int n2 = spdyFrame.associatedStreamId();
                        if (n2 == 0) {
                            DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n, SpdyStreamStatus.INVALID_STREAM);
                            channelHandlerContext.writeAndFlush((Object)defaultSpdyRstStreamFrame);
                            return;
                        }
                        if (spdyFrame.isLast()) {
                            DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n, SpdyStreamStatus.PROTOCOL_ERROR);
                            channelHandlerContext.writeAndFlush((Object)defaultSpdyRstStreamFrame);
                            return;
                        }
                        if (spdyFrame.isTruncated()) {
                            DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n, SpdyStreamStatus.INTERNAL_ERROR);
                            channelHandlerContext.writeAndFlush((Object)defaultSpdyRstStreamFrame);
                            return;
                        }
                        try {
                            FullHttpRequest fullHttpRequest = SpdyHttpDecoder.createHttpRequest((SpdyHeadersFrame)spdyFrame, channelHandlerContext.alloc());
                            fullHttpRequest.headers().setInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID, n);
                            fullHttpRequest.headers().setInt((CharSequence)SpdyHttpHeaders.Names.ASSOCIATED_TO_STREAM_ID, n2);
                            fullHttpRequest.headers().setInt((CharSequence)SpdyHttpHeaders.Names.PRIORITY, spdyFrame.priority());
                            list.add(fullHttpRequest);
                            break block31;
                        }
                        catch (Throwable throwable) {
                            DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n, SpdyStreamStatus.PROTOCOL_ERROR);
                            channelHandlerContext.writeAndFlush((Object)defaultSpdyRstStreamFrame);
                            break block32;
                        }
                    }
                    if (spdyFrame.isTruncated()) {
                        DefaultSpdySynReplyFrame defaultSpdySynReplyFrame = new DefaultSpdySynReplyFrame(n);
                        defaultSpdySynReplyFrame.setLast(true);
                        SpdyHeaders spdyHeaders = defaultSpdySynReplyFrame.headers();
                        spdyHeaders.setInt(SpdyHeaders.HttpNames.STATUS, HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE.code());
                        spdyHeaders.setObject(SpdyHeaders.HttpNames.VERSION, HttpVersion.HTTP_1_0);
                        channelHandlerContext.writeAndFlush((Object)defaultSpdySynReplyFrame);
                        return;
                    }
                    try {
                        FullHttpRequest fullHttpRequest = SpdyHttpDecoder.createHttpRequest((SpdyHeadersFrame)spdyFrame, channelHandlerContext.alloc());
                        fullHttpRequest.headers().setInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID, n);
                        if (spdyFrame.isLast()) {
                            list.add(fullHttpRequest);
                            break block31;
                        }
                        this.putMessage(n, fullHttpRequest);
                        break block32;
                    }
                    catch (Throwable throwable) {
                        DefaultSpdySynReplyFrame defaultSpdySynReplyFrame = new DefaultSpdySynReplyFrame(n);
                        defaultSpdySynReplyFrame.setLast(true);
                        SpdyHeaders spdyHeaders = defaultSpdySynReplyFrame.headers();
                        spdyHeaders.setInt(SpdyHeaders.HttpNames.STATUS, HttpResponseStatus.BAD_REQUEST.code());
                        spdyHeaders.setObject(SpdyHeaders.HttpNames.VERSION, HttpVersion.HTTP_1_0);
                        channelHandlerContext.writeAndFlush((Object)defaultSpdySynReplyFrame);
                    }
                }
                return;
            }
            if (spdyFrame instanceof SpdySynReplyFrame) {
                block33: {
                    spdyFrame = (SpdySynReplyFrame)spdyFrame;
                    int n = spdyFrame.streamId();
                    if (spdyFrame.isTruncated()) {
                        DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n, SpdyStreamStatus.INTERNAL_ERROR);
                        channelHandlerContext.writeAndFlush((Object)defaultSpdyRstStreamFrame);
                        return;
                    }
                    try {
                        FullHttpResponse fullHttpResponse = this.createHttpResponse((SpdyHeadersFrame)spdyFrame, channelHandlerContext.alloc());
                        fullHttpResponse.headers().setInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID, n);
                        if (spdyFrame.isLast()) {
                            HttpUtil.setContentLength(fullHttpResponse, 0L);
                            list.add(fullHttpResponse);
                            break block33;
                        }
                        this.putMessage(n, fullHttpResponse);
                        break block32;
                    }
                    catch (Throwable throwable) {
                        DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n, SpdyStreamStatus.PROTOCOL_ERROR);
                        channelHandlerContext.writeAndFlush((Object)defaultSpdyRstStreamFrame);
                    }
                }
                return;
            }
            if (spdyFrame instanceof SpdyHeadersFrame) {
                int n = (spdyFrame = (SpdyHeadersFrame)spdyFrame).streamId();
                FullHttpMessage fullHttpMessage = this.getMessage(n);
                if (fullHttpMessage == null) {
                    if (SpdyCodecUtil.isServerId(n)) {
                        if (spdyFrame.isTruncated()) {
                            DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n, SpdyStreamStatus.INTERNAL_ERROR);
                            channelHandlerContext.writeAndFlush((Object)defaultSpdyRstStreamFrame);
                            return;
                        }
                        try {
                            fullHttpMessage = this.createHttpResponse((SpdyHeadersFrame)spdyFrame, channelHandlerContext.alloc());
                            fullHttpMessage.headers().setInt((CharSequence)SpdyHttpHeaders.Names.STREAM_ID, n);
                            if (!spdyFrame.isLast()) {
                                this.putMessage(n, fullHttpMessage);
                                return;
                            }
                            HttpUtil.setContentLength(fullHttpMessage, 0L);
                            list.add(fullHttpMessage);
                        }
                        catch (Throwable throwable) {
                            DefaultSpdyRstStreamFrame defaultSpdyRstStreamFrame = new DefaultSpdyRstStreamFrame(n, SpdyStreamStatus.PROTOCOL_ERROR);
                            channelHandlerContext.writeAndFlush((Object)defaultSpdyRstStreamFrame);
                        }
                    }
                    return;
                }
                if (!spdyFrame.isTruncated()) {
                    Iterator iterator = spdyFrame.headers().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        fullHttpMessage.headers().add((CharSequence)entry.getKey(), entry.getValue());
                    }
                }
                if (spdyFrame.isLast()) {
                    FullHttpMessage fullHttpMessage2 = fullHttpMessage;
                    HttpUtil.setContentLength(fullHttpMessage2, fullHttpMessage2.content().readableBytes());
                    this.removeMessage(n);
                    list.add(fullHttpMessage);
                }
                return;
            }
            if (spdyFrame instanceof SpdyDataFrame) {
                int n = (spdyFrame = (SpdyDataFrame)spdyFrame).streamId();
                FullHttpMessage fullHttpMessage = this.getMessage(n);
                if (fullHttpMessage == null) {
                    return;
                }
                ByteBuf byteBuf = fullHttpMessage.content();
                if (byteBuf.readableBytes() > this.maxContentLength - spdyFrame.content().readableBytes()) {
                    this.removeMessage(n);
                    throw new TooLongFrameException("HTTP content length exceeded " + this.maxContentLength + " bytes: " + spdyFrame.content().readableBytes());
                }
                ByteBuf byteBuf2 = spdyFrame.content();
                int n3 = byteBuf2.readableBytes();
                ByteBuf byteBuf3 = byteBuf2;
                byteBuf.writeBytes(byteBuf3, byteBuf3.readerIndex(), n3);
                if (spdyFrame.isLast()) {
                    HttpUtil.setContentLength(fullHttpMessage, byteBuf.readableBytes());
                    this.removeMessage(n);
                    list.add(fullHttpMessage);
                }
                return;
            }
            if (spdyFrame instanceof SpdyRstStreamFrame) {
                spdyFrame = (SpdyRstStreamFrame)spdyFrame;
                int n = spdyFrame.streamId();
                this.removeMessage(n);
            }
        }
    }

    private static FullHttpRequest createHttpRequest(SpdyHeadersFrame object, ByteBufAllocator byteBufAllocator) {
        Object object2 = object.headers();
        Object object3 = HttpMethod.valueOf(object2.getAsString((CharSequence)SpdyHeaders.HttpNames.METHOD));
        CharSequence charSequence = object2.getAsString((CharSequence)SpdyHeaders.HttpNames.PATH);
        HttpVersion httpVersion = HttpVersion.valueOf(object2.getAsString((CharSequence)SpdyHeaders.HttpNames.VERSION));
        object2.remove((Object)SpdyHeaders.HttpNames.METHOD);
        object2.remove((Object)SpdyHeaders.HttpNames.PATH);
        object2.remove((Object)SpdyHeaders.HttpNames.VERSION);
        boolean bl = true;
        byteBufAllocator = byteBufAllocator.buffer();
        try {
            object3 = new DefaultFullHttpRequest(httpVersion, (HttpMethod)object3, (String)charSequence, (ByteBuf)byteBufAllocator);
            object2.remove((Object)SpdyHeaders.HttpNames.SCHEME);
            charSequence = (CharSequence)object2.get((Object)SpdyHeaders.HttpNames.HOST);
            object2.remove((Object)SpdyHeaders.HttpNames.HOST);
            object3.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)charSequence);
            object = object.headers().iterator();
            while (object.hasNext()) {
                object2 = (Map.Entry)object.next();
                object3.headers().add((CharSequence)object2.getKey(), object2.getValue());
            }
            HttpUtil.setKeepAlive((HttpMessage)object3, true);
            object3.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            bl = false;
            object = object3;
            return object;
        }
        catch (Throwable throwable) {
            if (bl) {
                byteBufAllocator.release();
            }
            throw throwable;
        }
    }

    private FullHttpResponse createHttpResponse(SpdyHeadersFrame object, ByteBufAllocator byteBufAllocator) {
        SpdyHeaders spdyHeaders = object.headers();
        Object object2 = HttpResponseStatus.parseLine((CharSequence)spdyHeaders.get(SpdyHeaders.HttpNames.STATUS));
        Object object3 = HttpVersion.valueOf(spdyHeaders.getAsString((CharSequence)SpdyHeaders.HttpNames.VERSION));
        spdyHeaders.remove(SpdyHeaders.HttpNames.STATUS);
        spdyHeaders.remove(SpdyHeaders.HttpNames.VERSION);
        boolean bl = true;
        byteBufAllocator = byteBufAllocator.buffer();
        try {
            object2 = new DefaultFullHttpResponse((HttpVersion)object3, (HttpResponseStatus)object2, (ByteBuf)byteBufAllocator, this.headersFactory, this.trailersFactory);
            object = object.headers().iterator();
            while (object.hasNext()) {
                object3 = (Map.Entry)object.next();
                object2.headers().add((CharSequence)object3.getKey(), object3.getValue());
            }
            HttpUtil.setKeepAlive((HttpMessage)object2, true);
            object2.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            object2.headers().remove((CharSequence)HttpHeaderNames.TRAILER);
            bl = false;
            object = object2;
            return object;
        }
        catch (Throwable throwable) {
            if (bl) {
                byteBufAllocator.release();
            }
            throw throwable;
        }
    }
}

