/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf;

import com.formdev.flatlaf.FlatDefaultsAddon;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.util.ColorFunctions;
import com.formdev.flatlaf.util.DerivedColor;
import com.formdev.flatlaf.util.GrayFilter;
import com.formdev.flatlaf.util.HSLColor;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.SoftCache;
import com.formdev.flatlaf.util.StringUtils;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;

class UIDefaultsLoader {
    private static final String TYPE_PREFIX = "{";
    private static final String TYPE_PREFIX_END = "}";
    private static final String VARIABLE_PREFIX = "@";
    private static final String PROPERTY_PREFIX = "$";
    private static final String OPTIONAL_PREFIX = "?";
    private static final String WILDCARD_PREFIX = "*.";
    static final String KEY_VARIABLES = "FlatLaf.internal.variables";
    private static int parseColorDepth;
    private static Map<String, ColorUIResource> systemColorCache;
    private static final SoftCache<String, Object> fontCache;
    private static final ValueType[] tempResultValueType;
    private static Map<Class<?>, ValueType> javaValueTypes;
    private static Map<String, ValueType> knownValueTypes;

    UIDefaultsLoader() {
    }

    static void loadDefaultsFromProperties(Class<?> clazz, List<FlatDefaultsAddon> list, Properties properties, boolean bl, UIDefaults uIDefaults) {
        ArrayList arrayList = new ArrayList();
        while (FlatLaf.class.isAssignableFrom(clazz)) {
            arrayList.add(0, clazz);
            clazz = clazz.getSuperclass();
        }
        UIDefaultsLoader.loadDefaultsFromProperties(arrayList, list, properties, bl, uIDefaults);
    }

    /*
     * WARNING - void declaration
     */
    static void loadDefaultsFromProperties(List<Class<?>> object, List<FlatDefaultsAddon> object222, Properties properties, boolean bl, UIDefaults uIDefaults) {
        try {
            Object object2;
            Object object3;
            Object object8;
            Object object9;
            Object object10;
            List<Object> list;
            systemColorCache = FlatLaf.getSystemColorGetter() != null ? new HashMap() : null;
            Properties properties2 = new Properties();
            Object object11 = object.iterator();
            while (object11.hasNext()) {
                list = (Class)object11.next();
                object10 = "/" + ((Class)((Object)list)).getName().replace('.', '/') + ".properties";
                object9 = ((Class)((Object)list)).getResourceAsStream((String)object10);
                try {
                    if (object9 == null) continue;
                    properties2.load((InputStream)object9);
                }
                finally {
                    if (object9 == null) continue;
                    ((InputStream)object9).close();
                }
            }
            object11 = object222.iterator();
            while (object11.hasNext()) {
                list = (FlatDefaultsAddon)object11.next();
                object10 = object.iterator();
                while (object10.hasNext()) {
                    object9 = (Class)object10.next();
                    object8 = ((FlatDefaultsAddon)((Object)list)).getDefaults((Class<?>)object9);
                    try {
                        if (object8 == null) continue;
                        properties2.load((InputStream)object8);
                    }
                    finally {
                        if (object8 == null) continue;
                        ((InputStream)object8).close();
                    }
                }
            }
            object11 = new ArrayList();
            list = object222.iterator();
            while (list.hasNext()) {
                object10 = (FlatDefaultsAddon)list.next();
                object9 = object10.getClass().getClassLoader();
                if (object11.contains(object9)) continue;
                object11.add(object9);
            }
            list = FlatLaf.getCustomDefaultsSources();
            int n = list != null ? list.size() : 0;
            for (int i = 0; i < n; ++i) {
                object8 = list.get(i);
                if (object8 instanceof String && i + 1 < n) {
                    ClassLoader classLoader;
                    object222 = (String)object8;
                    if ((classLoader = (ClassLoader)list.get(++i)) != null && !object11.contains(classLoader)) {
                        object11.add(classLoader);
                    }
                    object222 = ((String)object222).replace('.', '/');
                    if (classLoader == null) {
                        ClassLoader classLoader2 = FlatLaf.class.getClassLoader();
                    }
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        void var11_27;
                        object3 = (Class)iterator.next();
                        object2 = (String)object222 + '/' + UIDefaultsLoader.simpleClassName(object3) + ".properties";
                        InputStream inputStream = var11_27.getResourceAsStream((String)object2);
                        try {
                            if (inputStream == null) continue;
                            properties2.load(inputStream);
                        }
                        finally {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                    }
                    continue;
                }
                if (object8 instanceof URL) {
                    object222 = (URL)object8;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Class clazz = (Class)iterator.next();
                        object3 = new URL(object222 + UIDefaultsLoader.simpleClassName(clazz) + ".properties");
                        try {
                            object2 = ((URL)object3).openStream();
                            try {
                                properties2.load((InputStream)object2);
                            }
                            finally {
                                if (object2 == null) continue;
                                ((InputStream)object2).close();
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                    }
                    continue;
                }
                if (!(object8 instanceof File)) continue;
                object222 = (File)object8;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Class clazz = (Class)iterator.next();
                    object3 = new File((File)object222, UIDefaultsLoader.simpleClassName(clazz) + ".properties");
                    if (!((File)object3).isFile()) continue;
                    object2 = new FileInputStream((File)object3);
                    try {
                        properties2.load((InputStream)object2);
                    }
                    finally {
                        ((InputStream)object2).close();
                    }
                }
            }
            if (properties != null) {
                properties2.putAll((Map<?, ?>)properties);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object object222 : properties2.keySet()) {
                String string2 = (String)object222;
                if (!string2.startsWith("[") || !string2.startsWith("[win]") && !string2.startsWith("[mac]") && !string2.startsWith("[linux]") && !string2.startsWith("[light]") && !string2.startsWith("[dark]")) continue;
                arrayList.add(string2);
            }
            if (!arrayList.isEmpty()) {
                object8 = bl ? "[dark]" : "[light]";
                for (String string3 : arrayList) {
                    if (!string3.startsWith((String)object8)) continue;
                    properties2.put(string3.substring(((String)object8).length()), properties2.remove(string3));
                }
                object222 = SystemInfo.isWindows ? "[win]" : (SystemInfo.isMacOS ? "[mac]" : (SystemInfo.isLinux ? "[linux]" : "[unknown]"));
                for (String string4 : arrayList) {
                    object3 = properties2.remove(string4);
                    if (!string4.startsWith((String)object222)) continue;
                    properties2.put(string4.substring(((String)object222).length()), object3);
                }
            }
            object8 = new HashMap<String, String>();
            object222 = properties2.entrySet().iterator();
            while (object222.hasNext()) {
                Map.Entry entry = (Map.Entry)object222.next();
                String string5 = (String)entry.getKey();
                if (!string5.startsWith(WILDCARD_PREFIX)) continue;
                ((HashMap)object8).put(string5.substring(2), (String)entry.getValue());
                object222.remove();
            }
            for (Object k : uIDefaults.keySet()) {
                String string6;
                int n2;
                if (!(k instanceof String) || properties2.containsKey(k) || (n2 = ((String)k).lastIndexOf(46)) < 0 || (string6 = (String)((HashMap)object8).get(object2 = ((String)k).substring(n2 + 1))) == null) continue;
                properties2.put(k, string6);
            }
            Function<String, String> function = string -> properties2.getProperty((String)string);
            Function<String, String> function2 = string -> UIDefaultsLoader.resolveValue(string, object72);
            HashMap<Object, String> hashMap = new HashMap<Object, String>(50);
            for (Map.Entry entry : properties2.entrySet()) {
                object8 = (String)entry.getKey();
                if (((String)object8).startsWith(VARIABLE_PREFIX)) {
                    hashMap.put(object8, (String)entry.getValue());
                    continue;
                }
                object = (String)entry.getValue();
                try {
                    object = UIDefaultsLoader.resolveValue((String)object, function);
                    Object object4 = object8;
                    uIDefaults.put(object4, UIDefaultsLoader.parseValue((String)object4, (String)object, null, null, function2, (List<ClassLoader>)object11));
                }
                catch (RuntimeException runtimeException) {
                    UIDefaultsLoader.logParseError((String)object8, (String)object, runtimeException, true);
                }
            }
            uIDefaults.put(KEY_VARIABLES, hashMap);
            systemColorCache = null;
            return;
        }
        catch (IOException iOException) {
            LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to load properties files.", iOException);
            return;
        }
    }

    static String simpleClassName(Class<?> object) {
        object = ((Class)object).getName();
        return ((String)object).substring(((String)object).lastIndexOf(46) + 1);
    }

    static void logParseError(String string, String string2, RuntimeException runtimeException, boolean bl) {
        string = "FlatLaf: Failed to parse: '" + string + '=' + string2 + '\'';
        if (bl) {
            LoggingFacade.INSTANCE.logSevere(string, runtimeException);
            return;
        }
        LoggingFacade.INSTANCE.logConfig(string, runtimeException);
    }

    static String resolveValue(String string, Function<String, String> function) {
        while (true) {
            String string2;
            String string3 = string = string.trim();
            if (string.startsWith(PROPERTY_PREFIX)) {
                string = string.substring(1);
            } else if (!string.startsWith(VARIABLE_PREFIX)) {
                return string;
            }
            boolean bl = false;
            if (string.startsWith(OPTIONAL_PREFIX)) {
                string = string.substring(1);
                bl = true;
            }
            if ((string2 = function.apply(string)) == null) {
                if (bl) {
                    return "null";
                }
                throw new IllegalArgumentException("variable or property '" + string + "' not found");
            }
            if (string2.equals(string3)) {
                throw new IllegalArgumentException("endless recursion in variable or property '" + string + "'");
            }
            string = string2;
        }
    }

    static String resolveValueFromUIManager(String object) {
        Object object2;
        Object object3;
        while (((String)object).startsWith(VARIABLE_PREFIX)) {
            object3 = (Map)UIManager.get(KEY_VARIABLES);
            object2 = object3 != null ? (String)object3.get(object) : null;
            if (object2 == null) {
                throw new IllegalArgumentException("variable '" + (String)object + "' not found");
            }
            object = object2;
        }
        if (!((String)object).startsWith(PROPERTY_PREFIX)) {
            return object;
        }
        object3 = ((String)object).substring(1);
        object2 = UIManager.get(object3);
        if (object2 == null) {
            throw new IllegalArgumentException("property '" + (String)object3 + "' not found");
        }
        if (object2 instanceof Color) {
            object = (Color)object2;
            int n = ((Color)object).getRGB() & 0xFFFFFF;
            int n2 = ((Color)object).getAlpha();
            if (n2 != 255) {
                return String.format("#%06x%02x", n, n2);
            }
            return String.format("#%06x", n);
        }
        throw new IllegalArgumentException("property value type '" + object2.getClass().getName() + "' not supported in references");
    }

    static Object parseValue(String string2, String string3, Class<?> clazz) {
        return UIDefaultsLoader.parseValue(string2, string3, clazz, null, string -> string, Collections.emptyList());
    }

    static Object parseValue(String string, String string2, Class<?> clazz, ValueType[] valueTypeArray, Function<String, String> function, List<ClassLoader> list) {
        Object object;
        while (true) {
            if (valueTypeArray == null) {
                valueTypeArray = tempResultValueType;
            }
            if (string.startsWith("[style]")) {
                valueTypeArray[0] = ValueType.STRING;
                return string2;
            }
            if ((string2 = string2.trim()).equals("null") || string2.isEmpty()) {
                valueTypeArray[0] = ValueType.NULL;
                return null;
            }
            if (!string2.startsWith("if(") || !string2.endsWith(")")) break;
            object = UIDefaultsLoader.splitFunctionParams(string2.substring(3, string2.length() - 1), ',');
            if (object.size() != 3) {
                throw UIDefaultsLoader.newMissingParametersException(string2);
            }
            boolean bl = UIDefaultsLoader.parseCondition((String)object.get(0), function, list);
            String string3 = (String)object.get(bl ? 1 : 2);
            string2 = function.apply(string3);
        }
        object = ValueType.UNKNOWN;
        if (clazz != null) {
            if (javaValueTypes == null) {
                javaValueTypes = new HashMap();
                javaValueTypes.put(String.class, ValueType.STRING);
                javaValueTypes.put(Boolean.TYPE, ValueType.BOOLEAN);
                javaValueTypes.put(Boolean.class, ValueType.BOOLEAN);
                javaValueTypes.put(Character.TYPE, ValueType.CHARACTER);
                javaValueTypes.put(Character.class, ValueType.CHARACTER);
                javaValueTypes.put(Integer.TYPE, ValueType.INTEGER);
                javaValueTypes.put(Integer.class, ValueType.INTEGER);
                javaValueTypes.put(Float.TYPE, ValueType.FLOAT);
                javaValueTypes.put(Float.class, ValueType.FLOAT);
                javaValueTypes.put(Border.class, ValueType.BORDER);
                javaValueTypes.put(Icon.class, ValueType.ICON);
                javaValueTypes.put(Insets.class, ValueType.INSETS);
                javaValueTypes.put(Dimension.class, ValueType.DIMENSION);
                javaValueTypes.put(Color.class, ValueType.COLOR);
                javaValueTypes.put(Font.class, ValueType.FONT);
            }
            if ((object = javaValueTypes.get(clazz)) == null) {
                throw new IllegalArgumentException("unsupported value type '" + clazz.getName() + "'");
            }
            if (object == ValueType.STRING && string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
        } else {
            int n;
            switch (string2) {
                case "false": {
                    valueTypeArray[0] = ValueType.BOOLEAN;
                    return Boolean.FALSE;
                }
                case "true": {
                    valueTypeArray[0] = ValueType.BOOLEAN;
                    return Boolean.TRUE;
                }
            }
            if (string2.startsWith("lazy(") && string2.endsWith(")")) {
                valueTypeArray[0] = ValueType.LAZY;
                String string4 = StringUtils.substringTrimmed(string2, 5, string2.length() - 1);
                return uIDefaults -> UIDefaultsLoader.lazyUIManagerGet(string4);
            }
            if (string2.startsWith("#")) {
                object = ValueType.COLOR;
            } else if (string2.startsWith(TYPE_PREFIX) && (n = string2.indexOf(TYPE_PREFIX_END)) != -1) {
                try {
                    String string5 = string2.substring(1, n);
                    object = ValueType.valueOf(string5.toUpperCase(Locale.ENGLISH));
                    string2 = string2.substring(n + 1);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (object == ValueType.UNKNOWN) {
                if (knownValueTypes == null) {
                    knownValueTypes = new HashMap<String, ValueType>();
                    knownValueTypes.put("activeCaptionBorder", ValueType.COLOR);
                    knownValueTypes.put("inactiveCaptionBorder", ValueType.COLOR);
                    knownValueTypes.put("windowBorder", ValueType.COLOR);
                    knownValueTypes.put("SplitPane.dividerSize", ValueType.INTEGER);
                    knownValueTypes.put("SplitPaneDivider.gripDotSize", ValueType.INTEGER);
                    knownValueTypes.put("dividerSize", ValueType.INTEGER);
                    knownValueTypes.put("gripDotSize", ValueType.INTEGER);
                    knownValueTypes.put("TabbedPane.closeCrossPlainSize", ValueType.FLOAT);
                    knownValueTypes.put("TabbedPane.closeCrossFilledSize", ValueType.FLOAT);
                    knownValueTypes.put("closeCrossPlainSize", ValueType.FLOAT);
                    knownValueTypes.put("closeCrossFilledSize", ValueType.FLOAT);
                    knownValueTypes.put("Table.intercellSpacing", ValueType.DIMENSION);
                    knownValueTypes.put("intercellSpacing", ValueType.DIMENSION);
                }
                object = knownValueTypes.getOrDefault(string, ValueType.UNKNOWN);
            }
            if (object == ValueType.UNKNOWN) {
                if (string.endsWith("UI")) {
                    object = ValueType.STRING;
                } else if (string.endsWith("Color") || string.endsWith("ground") && (string.endsWith(".background") || string.endsWith("Background") || string.equals("background") || string.endsWith(".foreground") || string.endsWith("Foreground") || string.equals("foreground"))) {
                    object = ValueType.COLOR;
                } else if (string.endsWith(".font") || string.endsWith("Font") || string.equals("font")) {
                    object = ValueType.FONT;
                } else if (string.endsWith(".border") || string.endsWith("Border") || string.equals("border")) {
                    object = ValueType.BORDER;
                } else if (string.endsWith(".icon") || string.endsWith("Icon") || string.equals("icon")) {
                    object = ValueType.ICON;
                } else if (string.endsWith(".margin") || string.equals("margin") || string.endsWith(".padding") || string.equals("padding") || string.endsWith("Margins") || string.endsWith("Insets")) {
                    object = ValueType.INSETS;
                } else if (string.endsWith("Size")) {
                    object = ValueType.DIMENSION;
                } else if (string.endsWith("Width") || string.endsWith("Height")) {
                    object = ValueType.INTEGERORFLOAT;
                } else if (string.endsWith("Char")) {
                    object = ValueType.CHARACTER;
                } else if (string.endsWith("grayFilter")) {
                    object = ValueType.GRAYFILTER;
                }
            }
        }
        valueTypeArray[0] = object;
        switch (object) {
            case STRING: {
                return string2;
            }
            case BOOLEAN: {
                return UIDefaultsLoader.parseBoolean(string2);
            }
            case CHARACTER: {
                return UIDefaultsLoader.parseCharacter(string2);
            }
            case INTEGER: {
                return UIDefaultsLoader.parseInteger(string2);
            }
            case INTEGERORFLOAT: {
                return UIDefaultsLoader.parseIntegerOrFloat(string2);
            }
            case FLOAT: {
                return UIDefaultsLoader.parseFloat(string2);
            }
            case BORDER: {
                return UIDefaultsLoader.parseBorder(string2, function, list);
            }
            case ICON: {
                return UIDefaultsLoader.parseInstance(string2, function, list);
            }
            case INSETS: {
                return UIDefaultsLoader.parseInsets(string2);
            }
            case DIMENSION: {
                return UIDefaultsLoader.parseDimension(string2);
            }
            case COLOR: {
                return UIDefaultsLoader.parseColorOrFunction(string2, function);
            }
            case FONT: {
                return UIDefaultsLoader.parseFont(string2);
            }
            case SCALEDINTEGER: {
                return UIDefaultsLoader.parseScaledInteger(string2);
            }
            case SCALEDFLOAT: {
                return UIDefaultsLoader.parseScaledFloat(string2);
            }
            case SCALEDINSETS: {
                return UIDefaultsLoader.parseScaledInsets(string2);
            }
            case SCALEDDIMENSION: {
                return UIDefaultsLoader.parseScaledDimension(string2);
            }
            case INSTANCE: {
                return UIDefaultsLoader.parseInstance(string2, function, list);
            }
            case CLASS: {
                return UIDefaultsLoader.parseClass(string2, list);
            }
            case GRAYFILTER: {
                return UIDefaultsLoader.parseGrayFilter(string2);
            }
        }
        if (string2.startsWith("\"") && string2.endsWith("\"")) {
            valueTypeArray[0] = ValueType.STRING;
            return string2.substring(1, string2.length() - 1);
        }
        if (string2.startsWith("#") || string2.endsWith(")")) {
            Object object2 = UIDefaultsLoader.parseColorOrFunction(string2, function);
            valueTypeArray[0] = object2 != null ? ValueType.COLOR : ValueType.NULL;
            return object2;
        }
        char c = string2.charAt(0);
        if (c >= '0' && c <= '9' || c == '-' || c == '+' || c == '.') {
            try {
                Integer n = UIDefaultsLoader.parseInteger(string2);
                valueTypeArray[0] = ValueType.INTEGER;
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Float f = UIDefaultsLoader.parseFloat(string2);
                    valueTypeArray[0] = ValueType.FLOAT;
                    return f;
                }
                catch (NumberFormatException numberFormatException2) {}
            }
        }
        valueTypeArray[0] = ValueType.STRING;
        return string2;
    }

    private static boolean parseCondition(String object, Function<String, String> function, List<ClassLoader> list) {
        try {
            object = UIDefaultsLoader.parseValue("", function.apply((String)object), null, null, function, list);
            return object != null && !object.equals(Boolean.FALSE) && !object.equals(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private static Object parseBorder(String object, Function<String, String> function, List<ClassLoader> list) {
        if (((String)object).indexOf(44) >= 0) {
            list = UIDefaultsLoader.splitFunctionParams((String)object, ',');
            object = UIDefaultsLoader.parseInsets((String)object);
            function = list.size() >= 5 ? (ColorUIResource)UIDefaultsLoader.parseColorOrFunction(function.apply((String)list.get(4)), function) : null;
            float f = list.size() >= 6 && !((String)list.get(5)).isEmpty() ? UIDefaultsLoader.parseFloat((String)list.get(5)).floatValue() : 1.0f;
            int n = list.size() >= 7 ? UIDefaultsLoader.parseInteger((String)list.get(6)) : 0;
            return arg_0 -> UIDefaultsLoader.lambda$parseBorder$4(function, (Insets)object, f, n, arg_0);
        }
        return UIDefaultsLoader.parseInstance((String)object, function, list);
    }

    private static Object parseInstance(String string, Function<String, String> function, List<ClassLoader> list) {
        return object2 -> {
            try {
                if (string.indexOf(44) >= 0) {
                    object2 = UIDefaultsLoader.splitFunctionParams(string, ',');
                    String string2 = object2.get(0);
                    list = UIDefaultsLoader.findClass(string2, list);
                    list = list.getDeclaredConstructors();
                    if ((list = UIDefaultsLoader.invokeConstructorOrStaticMethod(list, (List<String>)((Object)object2), function)) != null) {
                        return list;
                    }
                    String string3 = string;
                    LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to instantiate '" + string2 + "': no constructor found for parameters '" + string3.substring(string3.indexOf(45)) + "'.", null);
                    return null;
                }
                return UIDefaultsLoader.findClass(string, list).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to instantiate '" + string + "'.", exception);
                return null;
            }
        };
    }

    private static Object parseClass(String string, List<ClassLoader> list) {
        return uIDefaults -> {
            try {
                return UIDefaultsLoader.findClass(string, list);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to find class '" + string + "'.", classNotFoundException);
                return null;
            }
        };
    }

    private static Class<?> findClass(String string, List<ClassLoader> object) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            object = object.iterator();
            while (object.hasNext()) {
                ClassLoader classLoader = (ClassLoader)object.next();
                try {
                    return classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                }
            }
            throw classNotFoundException;
        }
    }

    private static Insets parseInsets(String string) {
        List<String> list = StringUtils.split(string, ',', true, false);
        try {
            return new InsetsUIResource(Integer.parseInt(list.get(0)), Integer.parseInt(list.get(1)), Integer.parseInt(list.get(2)), Integer.parseInt(list.get(3)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("invalid insets '" + string + "'");
        }
    }

    private static Dimension parseDimension(String string) {
        List<String> list = StringUtils.split(string, ',', true, false);
        try {
            return new DimensionUIResource(Integer.parseInt(list.get(0)), Integer.parseInt(list.get(1)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("invalid size '" + string + "'");
        }
    }

    private static Object parseColorOrFunction(String string, Function<String, String> function) {
        if (string.endsWith(")")) {
            return UIDefaultsLoader.parseColorFunctions(string, function);
        }
        return UIDefaultsLoader.parseColor(string);
    }

    static ColorUIResource parseColor(String string) {
        int n = UIDefaultsLoader.parseColorRGBA(string);
        if ((n & 0xFF000000) == -16777216) {
            return new ColorUIResource(n);
        }
        return new ColorUIResource(new Color(n, true));
    }

    static int parseColorRGBA(String string) {
        int n;
        int n2;
        int n3;
        int n4 = string.length();
        if (n4 != 4 && n4 != 5 && n4 != 7 && n4 != 9 || string.charAt(0) != '#') {
            throw UIDefaultsLoader.newInvalidColorException(string);
        }
        int n5 = 0;
        for (n3 = 1; n3 < n4; ++n3) {
            n2 = string.charAt(n3);
            if (n2 >= 48 && n2 <= 57) {
                n = n2 - 48;
            } else if (n2 >= 97 && n2 <= 102) {
                n = n2 - 97 + 10;
            } else if (n2 >= 65 && n2 <= 70) {
                n = n2 - 65 + 10;
            } else {
                throw UIDefaultsLoader.newInvalidColorException(string);
            }
            n5 = n5 << 4 | n;
        }
        if (n4 <= 5) {
            n3 = n5 & 0xF000;
            n2 = n5 & 0xF00;
            n = n5 & 0xF0;
            int n6 = n5 & 0xF;
            n5 = n3 << 16 | n3 << 12 | n2 << 12 | n2 << 8 | n << 8 | n << 4 | n6 << 4 | n6;
        }
        if (n4 == 4 || n4 == 7) {
            return 0xFF000000 | n5;
        }
        return n5 >> 8 & 0xFFFFFF | (n5 & 0xFF) << 24;
    }

    private static IllegalArgumentException newInvalidColorException(String string) {
        return new IllegalArgumentException("invalid color '" + string + "'");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object parseColorFunctions(String object, Function<String, String> function) {
        int n = ((String)object).indexOf(40);
        if (n < 0) {
            throw new IllegalArgumentException("missing opening parenthesis in function '" + (String)object + "'");
        }
        String string = StringUtils.substringTrimmed((String)object, 0, n);
        List<String> list = UIDefaultsLoader.splitFunctionParams(((String)object).substring(n + 1, ((String)object).length() - 1), ',');
        if (list.isEmpty()) {
            throw UIDefaultsLoader.newMissingParametersException((String)object);
        }
        if (parseColorDepth > 100) {
            throw new IllegalArgumentException("endless recursion in color function '" + (String)object + "'");
        }
        ++parseColorDepth;
        try {
            int n2 = -1;
            switch (string.hashCode()) {
                case 3357: {
                    if (!string.equals("if")) break;
                    n2 = 0;
                    break;
                }
                case -1561144716: {
                    if (!string.equals("systemColor")) break;
                    n2 = 1;
                    break;
                }
                case 112845: {
                    if (!string.equals("rgb")) break;
                    n2 = 2;
                    break;
                }
                case 3498292: {
                    if (!string.equals("rgba")) break;
                    n2 = 3;
                    break;
                }
                case 103617: {
                    if (!string.equals("hsl")) break;
                    n2 = 4;
                    break;
                }
                case 3212224: {
                    if (!string.equals("hsla")) break;
                    n2 = 5;
                    break;
                }
                case 170546239: {
                    if (!string.equals("lighten")) break;
                    n2 = 6;
                    break;
                }
                case -1338968417: {
                    if (!string.equals("darken")) break;
                    n2 = 7;
                    break;
                }
                case -2114203985: {
                    if (!string.equals("saturate")) break;
                    n2 = 8;
                    break;
                }
                case 1839974960: {
                    if (!string.equals("desaturate")) break;
                    n2 = 9;
                    break;
                }
                case -1282132831: {
                    if (!string.equals("fadein")) break;
                    n2 = 10;
                    break;
                }
                case -1091405998: {
                    if (!string.equals("fadeout")) break;
                    n2 = 11;
                    break;
                }
                case 3135100: {
                    if (!string.equals("fade")) break;
                    n2 = 12;
                    break;
                }
                case 3536962: {
                    if (!string.equals("spin")) break;
                    n2 = 13;
                    break;
                }
                case 1455237928: {
                    if (!string.equals("changeHue")) break;
                    n2 = 14;
                    break;
                }
                case 229314466: {
                    if (!string.equals("changeSaturation")) break;
                    n2 = 15;
                    break;
                }
                case 424179357: {
                    if (!string.equals("changeLightness")) break;
                    n2 = 16;
                    break;
                }
                case -1682408562: {
                    if (!string.equals("changeAlpha")) break;
                    n2 = 17;
                    break;
                }
                case 108124: {
                    if (!string.equals("mix")) break;
                    n2 = 18;
                    break;
                }
                case 3560187: {
                    if (!string.equals("tint")) break;
                    n2 = 19;
                    break;
                }
                case 109399597: {
                    if (!string.equals("shade")) break;
                    n2 = 20;
                    break;
                }
                case -566947070: {
                    if (!string.equals("contrast")) break;
                    n2 = 21;
                    break;
                }
                case 3423444: {
                    if (!string.equals("over")) break;
                    n2 = 22;
                    break;
                }
            }
            switch (n2) {
                case 0: {
                    object = UIDefaultsLoader.parseColorIf((String)object, list, function);
                    return object;
                }
                case 1: {
                    object = UIDefaultsLoader.parseColorSystemColor((String)object, list, function);
                    return object;
                }
                case 2: {
                    object = UIDefaultsLoader.parseColorRgbOrRgba(false, list, function);
                    return object;
                }
                case 3: {
                    object = UIDefaultsLoader.parseColorRgbOrRgba(true, list, function);
                    return object;
                }
                case 4: {
                    object = UIDefaultsLoader.parseColorHslOrHsla(false, list);
                    return object;
                }
                case 5: {
                    object = UIDefaultsLoader.parseColorHslOrHsla(true, list);
                    return object;
                }
                case 6: {
                    object = UIDefaultsLoader.parseColorHSLIncreaseDecrease(2, true, list, function);
                    return object;
                }
                case 7: {
                    object = UIDefaultsLoader.parseColorHSLIncreaseDecrease(2, false, list, function);
                    return object;
                }
                case 8: {
                    object = UIDefaultsLoader.parseColorHSLIncreaseDecrease(1, true, list, function);
                    return object;
                }
                case 9: {
                    object = UIDefaultsLoader.parseColorHSLIncreaseDecrease(1, false, list, function);
                    return object;
                }
                case 10: {
                    object = UIDefaultsLoader.parseColorHSLIncreaseDecrease(3, true, list, function);
                    return object;
                }
                case 11: {
                    object = UIDefaultsLoader.parseColorHSLIncreaseDecrease(3, false, list, function);
                    return object;
                }
                case 12: {
                    object = UIDefaultsLoader.parseColorFade(list, function);
                    return object;
                }
                case 13: {
                    object = UIDefaultsLoader.parseColorSpin(list, function);
                    return object;
                }
                case 14: {
                    object = UIDefaultsLoader.parseColorChange(0, list, function);
                    return object;
                }
                case 15: {
                    object = UIDefaultsLoader.parseColorChange(1, list, function);
                    return object;
                }
                case 16: {
                    object = UIDefaultsLoader.parseColorChange(2, list, function);
                    return object;
                }
                case 17: {
                    object = UIDefaultsLoader.parseColorChange(3, list, function);
                    return object;
                }
                case 18: {
                    object = UIDefaultsLoader.parseColorMix(null, list, function);
                    return object;
                }
                case 19: {
                    object = UIDefaultsLoader.parseColorMix("#fff", list, function);
                    return object;
                }
                case 20: {
                    object = UIDefaultsLoader.parseColorMix("#000", list, function);
                    return object;
                }
                case 21: {
                    object = UIDefaultsLoader.parseColorContrast(list, function);
                    return object;
                }
                case 22: {
                    object = UIDefaultsLoader.parseColorOver(list, function);
                    return object;
                }
            }
            throw new IllegalArgumentException("unknown color function '" + (String)object + "'");
        }
        finally {
            --parseColorDepth;
        }
    }

    private static Object parseColorIf(String string, List<String> list, Function<String, String> function) {
        if (list.size() != 3) {
            throw UIDefaultsLoader.newMissingParametersException(string);
        }
        boolean bl = UIDefaultsLoader.parseCondition(list.get(0), function, Collections.emptyList());
        String string2 = list.get(bl ? 1 : 2);
        return UIDefaultsLoader.parseColorOrFunction(function.apply(string2), function);
    }

    private static Object parseColorSystemColor(String object, List<String> list, Function<String, String> function) {
        if (list.size() <= 0) {
            throw UIDefaultsLoader.newMissingParametersException((String)object);
        }
        object = UIDefaultsLoader.getSystemColor(list.get(0));
        if (object != null) {
            return object;
        }
        object = list.size() > 1 ? list.get(1) : "";
        if (((String)object).equals("null") || ((String)object).isEmpty()) {
            return null;
        }
        return UIDefaultsLoader.parseColorOrFunction(function.apply((String)object), function);
    }

    private static ColorUIResource getSystemColor(String string) {
        Function<String, Color> function = FlatLaf.getSystemColorGetter();
        if (function == null) {
            return null;
        }
        if (systemColorCache != null && systemColorCache.containsKey(string)) {
            return systemColorCache.get(string);
        }
        Function<String, Color> function2 = function = (function = function.apply(string)) != null ? new ColorUIResource((Color)((Object)function)) : null;
        if (systemColorCache != null) {
            systemColorCache.put(string, (ColorUIResource)((Object)function));
        }
        return function;
    }

    private static ColorUIResource parseColorRgbOrRgba(boolean bl, List<String> list, Function<String, String> object) {
        int n;
        if (bl && list.size() == 2) {
            String string = list.get(0);
            int n2 = UIDefaultsLoader.parseInteger(list.get(1), 0, 255, true);
            object = (ColorUIResource)UIDefaultsLoader.parseColorOrFunction(object.apply((String)string), object);
            return new ColorUIResource(new Color((n2 & 0xFF) << 24 | ((Color)object).getRGB() & 0xFFFFFF, true));
        }
        int n3 = UIDefaultsLoader.parseInteger(list.get(0), 0, 255, true);
        int n4 = UIDefaultsLoader.parseInteger(list.get(1), 0, 255, true);
        int n5 = UIDefaultsLoader.parseInteger(list.get(2), 0, 255, true);
        int n6 = n = bl ? UIDefaultsLoader.parseInteger(list.get(3), 0, 255, true) : 255;
        if (bl) {
            return new ColorUIResource(new Color(n3, n4, n5, n));
        }
        return new ColorUIResource(n3, n4, n5);
    }

    private static ColorUIResource parseColorHslOrHsla(boolean bl, List<String> object) {
        float[] fArray;
        int n = UIDefaultsLoader.parseInteger((String)fArray.get(0), 0, 360, false);
        int n2 = UIDefaultsLoader.parsePercentage((String)fArray.get(1));
        int n3 = UIDefaultsLoader.parsePercentage((String)fArray.get(2));
        int n4 = bl ? UIDefaultsLoader.parsePercentage((String)fArray.get(3)) : 100;
        fArray = new float[]{n, n2, n3};
        return new ColorUIResource(HSLColor.toRGB(fArray, (float)n4 / 100.0f));
    }

    private static Object parseColorHSLIncreaseDecrease(int n, boolean bl, List<String> object, Function<String, String> function) {
        String string = object.get(0);
        int n2 = UIDefaultsLoader.parsePercentage(object.get(1));
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (object.size() > 2) {
            object = object.get(2);
            bl2 = ((String)object).contains("relative");
            bl3 = ((String)object).contains("autoInverse");
            bl4 = ((String)object).contains("lazy");
            bl5 = ((String)object).contains("derived");
            if (bl5 && !((String)object).contains("noAutoInverse")) {
                bl3 = true;
            }
        }
        object = new ColorFunctions.HSLIncreaseDecrease(n, bl, n2, bl2, bl3);
        if (bl4) {
            return arg_0 -> UIDefaultsLoader.lambda$parseColorHSLIncreaseDecrease$7(string, (ColorFunctions.ColorFunction)object, arg_0);
        }
        return UIDefaultsLoader.parseFunctionBaseColor(string, (ColorFunctions.ColorFunction)object, bl5, function);
    }

    private static Object parseColorFade(List<String> object, Function<String, String> function) {
        String string = object.get(0);
        int n = UIDefaultsLoader.parsePercentage(object.get(1));
        boolean bl = false;
        boolean bl2 = false;
        if (object.size() > 2) {
            object = object.get(2);
            bl = ((String)object).contains("derived");
            bl2 = ((String)object).contains("lazy");
        }
        object = new ColorFunctions.Fade(n);
        if (bl2) {
            return arg_0 -> UIDefaultsLoader.lambda$parseColorFade$8(string, (ColorFunctions.ColorFunction)object, arg_0);
        }
        return UIDefaultsLoader.parseFunctionBaseColor(string, (ColorFunctions.ColorFunction)object, bl, function);
    }

    private static Object parseColorSpin(List<String> object, Function<String, String> function) {
        String string = object.get(0);
        int n = UIDefaultsLoader.parseInteger(object.get(1));
        boolean bl = false;
        if (object.size() > 2) {
            object = object.get(2);
            bl = ((String)object).contains("derived");
        }
        object = new ColorFunctions.HSLIncreaseDecrease(0, true, n, false, false);
        return UIDefaultsLoader.parseFunctionBaseColor(string, (ColorFunctions.ColorFunction)object, bl, function);
    }

    private static Object parseColorChange(int n, List<String> object, Function<String, String> function) {
        String string = object.get(0);
        int n2 = n == 0 ? UIDefaultsLoader.parseInteger(object.get(1)) : UIDefaultsLoader.parsePercentage(object.get(1));
        boolean bl = false;
        if (object.size() > 2) {
            object = object.get(2);
            bl = ((String)object).contains("derived");
        }
        object = new ColorFunctions.HSLChange(n, n2);
        return UIDefaultsLoader.parseFunctionBaseColor(string, (ColorFunctions.ColorFunction)object, bl, function);
    }

    private static Object parseColorMix(String string, List<String> list, Function<String, String> function) {
        int n = 0;
        if (string == null) {
            string = list.get(0);
        }
        int n2 = ++n;
        String string2 = list.get(n2);
        int n3 = list.size() > ++n ? UIDefaultsLoader.parsePercentage(list.get(n)) : 50;
        ColorUIResource colorUIResource = (ColorUIResource)UIDefaultsLoader.parseColorOrFunction(function.apply(string2), function);
        if (colorUIResource == null) {
            return null;
        }
        ColorFunctions.Mix mix = new ColorFunctions.Mix(colorUIResource, n3);
        return UIDefaultsLoader.parseFunctionBaseColor(string, mix, false, function);
    }

    private static Object parseColorContrast(List<String> list, Function<String, String> function) {
        Object object = list.get(0);
        String string = list.get(1);
        String string2 = list.get(2);
        int n = list.size() > 3 ? UIDefaultsLoader.parsePercentage(list.get(3)) : 43;
        if ((object = (ColorUIResource)UIDefaultsLoader.parseColorOrFunction(function.apply((String)object), function)) == null) {
            return null;
        }
        String string3 = ColorFunctions.luma((Color)object) * 100.0f < (float)n ? string2 : string;
        return UIDefaultsLoader.parseColorOrFunction(function.apply(string3), function);
    }

    private static ColorUIResource parseColorOver(List<String> object, Function<String, String> function) {
        Object object2 = object.get(0);
        object = object.get(1);
        if ((object2 = (ColorUIResource)UIDefaultsLoader.parseColorOrFunction(function.apply((String)object2), function)) == null || ((Color)object2).getAlpha() == 255) {
            return object2;
        }
        ColorUIResource colorUIResource = new ColorUIResource(((Color)object2).getRGB());
        if ((object = (ColorUIResource)UIDefaultsLoader.parseColorOrFunction(function.apply((String)object), function)) == null) {
            return colorUIResource;
        }
        float f = (float)((Color)object2).getAlpha() / 255.0f;
        return new ColorUIResource(ColorFunctions.mix(colorUIResource, (Color)object, f));
    }

    private static Object parseFunctionBaseColor(String colorFunctionArray, ColorFunctions.ColorFunction colorFunction, boolean bl, Function<String, String> object) {
        String string = object.apply((String)colorFunctionArray);
        if ((object = (ColorUIResource)UIDefaultsLoader.parseColorOrFunction(string, object)) == null) {
            return null;
        }
        Color color = ColorFunctions.applyFunctions((Color)object, colorFunction);
        if (bl) {
            if (object instanceof DerivedColor && string == colorFunctionArray) {
                ColorFunctions.ColorFunction[] colorFunctionArray2 = ((DerivedColor)object).getFunctions();
                colorFunctionArray = new ColorFunctions.ColorFunction[colorFunctionArray2.length + 1];
                System.arraycopy(colorFunctionArray2, 0, colorFunctionArray, 0, colorFunctionArray2.length);
                colorFunctionArray[colorFunctionArray2.length] = colorFunction;
            } else {
                colorFunctionArray = new ColorFunctions.ColorFunction[]{colorFunction};
            }
            return new DerivedColor(color, colorFunctionArray);
        }
        return new ColorUIResource(color);
    }

    private static Object parseFont(String string) {
        Object object = fontCache.get(string);
        if (object != null) {
            return object;
        }
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        float f = 0.0f;
        List<String> list = null;
        String string2 = null;
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(33, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.whitespaceChars(44, 44);
        streamTokenizer.quoteChar(34);
        streamTokenizer.quoteChar(39);
        try {
            block20: while (streamTokenizer.nextToken() != -1) {
                String string3;
                switch (string3 = streamTokenizer.sval) {
                    case "normal": {
                        n = 0;
                        continue block20;
                    }
                    case "bold": {
                        if (n == -1) {
                            n = 0;
                        }
                        n |= 1;
                        continue block20;
                    }
                    case "italic": {
                        if (n == -1) {
                            n = 0;
                        }
                        n |= 2;
                        continue block20;
                    }
                    case "+bold": {
                        n2 |= 1;
                        continue block20;
                    }
                    case "-bold": {
                        n2 |= 0x10000;
                        continue block20;
                    }
                    case "+italic": {
                        n2 |= 2;
                        continue block20;
                    }
                    case "-italic": {
                        n2 |= 0x20000;
                        continue block20;
                    }
                }
                char c = string3.charAt(0);
                if (Character.isDigit(c) || c == '+' || c == '-') {
                    if (n3 != 0 || n4 != 0 || f != 0.0f) {
                        throw new IllegalArgumentException("size specified more than once in '" + string + "'");
                    }
                    if (c == '+' || c == '-') {
                        n4 = UIDefaultsLoader.parseInteger(string3);
                        continue;
                    }
                    if (string3.endsWith("%")) {
                        f = (float)UIDefaultsLoader.parseInteger(string3.substring(0, string3.length() - 1)).intValue() / 100.0f;
                        continue;
                    }
                    n3 = UIDefaultsLoader.parseInteger(string3);
                    continue;
                }
                if (c == '$') {
                    if (string2 != null) {
                        throw new IllegalArgumentException("baseFontKey specified more than once in '" + string + "'");
                    }
                    string2 = string3.substring(1);
                    continue;
                }
                if (list == null) {
                    list = Collections.singletonList(string3);
                    continue;
                }
                if (list.size() == 1) {
                    list = new ArrayList<String>(list);
                }
                list.add(string3);
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        if (n != -1 && n2 != 0) {
            throw new IllegalArgumentException("can not mix absolute style (e.g. 'bold') with derived style (e.g. '+italic') in '" + string + "'");
        }
        if (n2 != 0) {
            if (n2 & true && (n2 & 0x10000) != 0) {
                throw new IllegalArgumentException("can not use '+bold' and '-bold' in '" + string + "'");
            }
            if ((n2 & 2) != 0 && (n2 & 0x20000) != 0) {
                throw new IllegalArgumentException("can not use '+italic' and '-italic' in '" + string + "'");
            }
        }
        FlatLaf.ActiveFont activeFont = new FlatLaf.ActiveFont(string2, list, n, n2, n3, n4, f);
        fontCache.put(string, activeFont);
        return activeFont;
    }

    private static int parsePercentage(String string) {
        int n;
        if (!string.endsWith("%")) {
            throw new NumberFormatException("invalid percentage '" + string + "'");
        }
        try {
            n = Integer.parseInt(string.substring(0, string.length() - 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("invalid percentage '" + string + "'");
        }
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException("percentage out of range (0-100%) '" + string + "'");
        }
        return n;
    }

    private static Boolean parseBoolean(String string) {
        switch (string) {
            case "false": {
                return Boolean.FALSE;
            }
            case "true": {
                return Boolean.TRUE;
            }
        }
        throw new IllegalArgumentException("invalid boolean '" + string + "'");
    }

    private static Character parseCharacter(String string) {
        if (string.length() != 1) {
            throw new IllegalArgumentException("invalid character '" + string + "'");
        }
        return Character.valueOf(string.charAt(0));
    }

    private static Integer parseInteger(String string, int n, int n2, boolean bl) {
        if (bl && string.endsWith("%")) {
            int n3 = UIDefaultsLoader.parsePercentage(string);
            return n2 * n3 / 100;
        }
        Integer n3 = UIDefaultsLoader.parseInteger(string);
        if (n3 < n || n3 > n2) {
            throw new NumberFormatException("integer '" + string + "' out of range (" + n + '-' + n2 + ')');
        }
        return n3;
    }

    private static Integer parseInteger(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("invalid integer '" + string + "'");
        }
    }

    private static Number parseIntegerOrFloat(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Float.valueOf(Float.parseFloat(string));
            }
            catch (NumberFormatException numberFormatException2) {
                throw new NumberFormatException("invalid integer or float '" + string + "'");
            }
        }
    }

    private static Float parseFloat(String string) {
        try {
            return Float.valueOf(Float.parseFloat(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("invalid float '" + string + "'");
        }
    }

    private static UIDefaults.ActiveValue parseScaledInteger(String string) {
        int n = UIDefaultsLoader.parseInteger(string);
        return uIDefaults -> UIScale.scale(n);
    }

    private static UIDefaults.ActiveValue parseScaledFloat(String string) {
        float f = UIDefaultsLoader.parseFloat(string).floatValue();
        return uIDefaults -> Float.valueOf(UIScale.scale(f));
    }

    private static UIDefaults.ActiveValue parseScaledInsets(String object) {
        object = UIDefaultsLoader.parseInsets((String)object);
        return arg_0 -> UIDefaultsLoader.lambda$parseScaledInsets$11((Insets)object, arg_0);
    }

    private static UIDefaults.ActiveValue parseScaledDimension(String object) {
        object = UIDefaultsLoader.parseDimension((String)object);
        return arg_0 -> UIDefaultsLoader.lambda$parseScaledDimension$12((Dimension)object, arg_0);
    }

    private static Object parseGrayFilter(String string) {
        List<String> list = StringUtils.split(string, ',', true, false);
        try {
            int n = Integer.parseInt(list.get(0));
            int n2 = Integer.parseInt(list.get(1));
            int n3 = Integer.parseInt(list.get(2));
            return uIDefaults -> new GrayFilter(n, n2, n3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("invalid gray filter '" + string + "'");
        }
    }

    private static List<String> splitFunctionParams(String string, char c) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            char c2 = string.charAt(i);
            if (c2 == '(') {
                ++n;
                continue;
            }
            if (c2 == ')') {
                --n;
                continue;
            }
            if (n != 0 || c2 != c) continue;
            arrayList.add(StringUtils.substringTrimmed(string, n2, i));
            n2 = i + 1;
        }
        String string2 = StringUtils.substringTrimmed(string, n2);
        if (!string2.isEmpty() || !arrayList.isEmpty()) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    private static Object invokeConstructorOrStaticMethod(Executable[] executableArray, List<String> list, Function<String, String> function) {
        executableArray = (Executable[])executableArray.clone();
        Arrays.sort(executableArray, (classArray, classArray2) -> {
            if ((classArray = classArray.getParameterTypes()).length != (classArray2 = classArray2.getParameterTypes()).length) {
                return ((Class<?>[])classArray).length - ((Class<?>[])classArray2).length;
            }
            for (int i = 0; i < ((Class<?>[])classArray).length; ++i) {
                Class<?> clazz = classArray[i];
                Class<?> clazz2 = classArray2[i];
                if (clazz == clazz2) continue;
                if (clazz == String.class) {
                    return 2;
                }
                if (clazz2 == String.class) {
                    return -2;
                }
                if (clazz == Integer.TYPE) {
                    return -1;
                }
                if (clazz2 != Integer.TYPE) continue;
                return 1;
            }
            return 0;
        });
        for (Executable executable : executableArray) {
            Object[] objectArray;
            if (executable.getParameterCount() != list.size() - 1 || (objectArray = UIDefaultsLoader.parseMethodParams(executable.getParameterTypes(), list, function)) == null) continue;
            if (executable instanceof Constructor) {
                return ((Constructor)executable).newInstance(objectArray);
            }
            return ((Method)executable).invoke(null, objectArray);
        }
        return null;
    }

    private static Object[] parseMethodParams(Class<?>[] classArray, List<String> list, Function<String, String> function) {
        Object[] objectArray = new Object[classArray.length];
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                Class<?> clazz = classArray[i];
                String string = list.get(i + 1);
                if (clazz == String.class) {
                    objectArray[i] = string;
                    continue;
                }
                if (clazz == Boolean.TYPE) {
                    objectArray[i] = UIDefaultsLoader.parseBoolean(string);
                    continue;
                }
                if (clazz == Integer.TYPE) {
                    objectArray[i] = UIDefaultsLoader.parseInteger(string);
                    continue;
                }
                if (clazz == Float.TYPE) {
                    objectArray[i] = UIDefaultsLoader.parseFloat(string);
                    continue;
                }
                if (clazz == Color.class) {
                    objectArray[i] = UIDefaultsLoader.parseColorOrFunction(function.apply(string), function);
                    continue;
                }
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        return objectArray;
    }

    static Object lazyUIManagerGet(String string) {
        Object object;
        boolean bl = false;
        if (string.startsWith(OPTIONAL_PREFIX)) {
            string = string.substring(1);
            bl = true;
        }
        if ((object = UIManager.get(string)) == null && !bl) {
            LoggingFacade.INSTANCE.logSevere("FlatLaf: '" + string + "' not found in UI defaults.", null);
        }
        return object;
    }

    private static IllegalArgumentException newMissingParametersException(String string) {
        return new IllegalArgumentException("missing parameters in function '" + string + "'");
    }

    private static /* synthetic */ Object lambda$parseScaledDimension$12(Dimension dimension, UIDefaults uIDefaults) {
        return UIScale.scale(dimension);
    }

    private static /* synthetic */ Object lambda$parseScaledInsets$11(Insets insets, UIDefaults uIDefaults) {
        return UIScale.scale(insets);
    }

    private static /* synthetic */ Object lambda$parseColorFade$8(String object, ColorFunctions.ColorFunction colorFunction, UIDefaults uIDefaults) {
        if ((object = UIDefaultsLoader.lazyUIManagerGet((String)object)) instanceof Color) {
            return new ColorUIResource(ColorFunctions.applyFunctions((Color)object, colorFunction));
        }
        return null;
    }

    private static /* synthetic */ Object lambda$parseColorHSLIncreaseDecrease$7(String object, ColorFunctions.ColorFunction colorFunction, UIDefaults uIDefaults) {
        if ((object = UIDefaultsLoader.lazyUIManagerGet((String)object)) instanceof Color) {
            return new ColorUIResource(ColorFunctions.applyFunctions((Color)object, colorFunction));
        }
        return null;
    }

    private static /* synthetic */ Object lambda$parseBorder$4(ColorUIResource colorUIResource, Insets insets, float f, int n, UIDefaults uIDefaults) {
        if (colorUIResource != null) {
            return new FlatLineBorder(insets, colorUIResource, f, n);
        }
        return new FlatEmptyBorder(insets);
    }

    static {
        fontCache = new SoftCache();
        tempResultValueType = new ValueType[1];
    }

    static enum ValueType {
        UNKNOWN,
        STRING,
        BOOLEAN,
        CHARACTER,
        INTEGER,
        INTEGERORFLOAT,
        FLOAT,
        BORDER,
        ICON,
        INSETS,
        DIMENSION,
        COLOR,
        FONT,
        SCALEDINTEGER,
        SCALEDFLOAT,
        SCALEDINSETS,
        SCALEDDIMENSION,
        INSTANCE,
        CLASS,
        GRAYFILTER,
        NULL,
        LAZY;

    }
}

