/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.util.StringUtils;
import com.formdev.flatlaf.util.SystemInfo;
import java.beans.PropertyChangeListener;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class FlatStylingSupport {
    public static Object getStyle(JComponent jComponent) {
        return jComponent.getClientProperty("FlatLaf.style");
    }

    public static Object getStyleClass(JComponent jComponent) {
        return jComponent.getClientProperty("FlatLaf.styleClass");
    }

    static boolean hasStyleProperty(JComponent jComponent) {
        return FlatStylingSupport.getStyle(jComponent) != null || FlatStylingSupport.getStyleClass(jComponent) != null;
    }

    public static Object getResolvedStyle(JComponent object, String string) {
        Object object2 = FlatStylingSupport.getStyle((JComponent)object);
        object = FlatStylingSupport.getStyleClass((JComponent)object);
        object = FlatStylingSupport.getStyleForClasses(object, string);
        return FlatStylingSupport.joinStyles(object, object2);
    }

    public static Object getStyleForClasses(Object object, String string) {
        if (object == null) {
            return null;
        }
        if (object instanceof String && ((String)object).indexOf(32) >= 0) {
            object = StringUtils.split((String)object, ' ', true, true);
        }
        if (object instanceof String) {
            return FlatStylingSupport.getStyleForClass(((String)object).trim(), string);
        }
        if (object instanceof String[]) {
            Object object2 = null;
            for (String string2 : (String[])object) {
                object2 = FlatStylingSupport.joinStyles(object2, FlatStylingSupport.getStyleForClass(string2, string));
            }
            return object2;
        }
        if (object instanceof List) {
            Object object3 = null;
            for (Object e : (List)object) {
                object3 = FlatStylingSupport.joinStyles(object3, FlatStylingSupport.getStyleForClass((String)e, string));
            }
            return object3;
        }
        return null;
    }

    private static Object getStyleForClass(String string, String string2) {
        return FlatStylingSupport.joinStyles(UIManager.get("[style]." + string), UIManager.get("[style]" + string2 + '.' + string));
    }

    public static Object joinStyles(Object hashMap, Object map) {
        if (hashMap == null) {
            return map;
        }
        if (map == null) {
            return hashMap;
        }
        if (hashMap instanceof String && map instanceof String) {
            return hashMap + "; " + map;
        }
        Map<String, Object> map2 = hashMap instanceof String ? FlatStylingSupport.parse((String)((Object)hashMap)) : (Map<String, Object>)hashMap;
        if (map2 == null) {
            return map;
        }
        if ((map = map instanceof String ? FlatStylingSupport.parse((String)((Object)map)) : (Map<String, Object>)map) == null) {
            return hashMap;
        }
        hashMap = new HashMap<String, Object>(map2);
        hashMap.putAll(map);
        return hashMap;
    }

    public static String concatStyles(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        return string + "; " + string2;
    }

    public static Map<String, Object> parseAndApply(Map<String, Object> object, Object object2, BiFunction<String, Object, Object> biFunction) {
        if (object != null) {
            for (Map.Entry entry : object.entrySet()) {
                biFunction.apply((String)entry.getKey(), entry.getValue());
            }
        }
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof String) {
            object = (String)object2;
            if (StringUtils.isTrimmedEmpty((String)object)) {
                return null;
            }
            return FlatStylingSupport.applyStyle(FlatStylingSupport.parse((String)object), biFunction);
        }
        if (object2 instanceof Map) {
            object = (Map)object2;
            return FlatStylingSupport.applyStyle((Map<String, Object>)object, biFunction);
        }
        return null;
    }

    private static Map<String, Object> applyStyle(Map<String, Object> object, BiFunction<String, Object, Object> biFunction) {
        if (object.isEmpty()) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry entry : object.entrySet()) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (string.startsWith("[")) {
                if (!(SystemInfo.isWindows && string.startsWith("[win]") || SystemInfo.isMacOS && string.startsWith("[mac]") || SystemInfo.isLinux && string.startsWith("[linux]") || string.startsWith("[light]") && !FlatLaf.isLafDark()) && (!string.startsWith("[dark]") || !FlatLaf.isLafDark())) continue;
                String string2 = string;
                string = string2.substring(string2.indexOf(93) + 1);
            }
            Object object2 = biFunction.apply(string, v);
            hashMap.put(string, object2);
        }
        return hashMap;
    }

    public static Map<String, Object> parse(String object) {
        if (object == null || StringUtils.isTrimmedEmpty((String)object)) {
            return null;
        }
        LinkedHashMap<String, Object> linkedHashMap = null;
        for (String string : StringUtils.split((String)object, ';', true, true)) {
            int n = string.indexOf(58);
            if (n < 0) {
                throw new IllegalArgumentException("missing colon in '" + string + "'");
            }
            String string2 = StringUtils.substringTrimmed(string, 0, n);
            String string3 = StringUtils.substringTrimmed(string, n + 1);
            if (string2.isEmpty()) {
                throw new IllegalArgumentException("missing key in '" + string + "'");
            }
            if (string3.isEmpty()) {
                throw new IllegalArgumentException("missing value in '" + string + "'");
            }
            if (linkedHashMap == null) {
                linkedHashMap = new LinkedHashMap<String, Object>();
            }
            String string4 = string2;
            linkedHashMap.put(string4, FlatStylingSupport.parseValue(string4, string3));
        }
        return linkedHashMap;
    }

    private static Object parseValue(String string, String string2) {
        if (string2.startsWith("$")) {
            return UIManager.get(string2.substring(1));
        }
        if (string.startsWith("[")) {
            String string3 = string;
            string = string3.substring(string3.indexOf(93) + 1);
        }
        return FlatLaf.parseDefaultsValue(string, string2, null);
    }

    public static Object applyToAnnotatedObject(Object object2, String string, Object object3) {
        String string2 = FlatStylingSupport.keyToFieldName(string);
        return FlatStylingSupport.applyToField(object2, string2, string, object3, object -> (object = ((Field)object).getAnnotation(Styleable.class)) != null && object.dot() == (string2 != string));
    }

    private static String keyToFieldName(String string) {
        int n = string.indexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n) + Character.toUpperCase(string.charAt(n + 1)) + string.substring(n + 2);
    }

    static Object applyToField(Object object, String string, String string2, Object object2) {
        return FlatStylingSupport.applyToField(object, string, string2, object2, null);
    }

    private static Object applyToField(Object object, String string, String string2, Object object2, Predicate<Field> predicate) {
        Object object3;
        Class<?> clazz = object.getClass();
        do {
            try {
                object3 = clazz.getDeclaredField(string);
                if (predicate == null || predicate.test((Field)object3)) {
                    return FlatStylingSupport.applyToField((Field)object3, object, object2, false);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {}
            object3 = (StyleableField[])clazz.getAnnotationsByType(StyleableField.class);
            int n = ((StyleableField[])object3).length;
            for (int i = 0; i < n; ++i) {
                StyleableField styleableField = object3[i];
                if (!string2.equals(styleableField.key())) continue;
                return FlatStylingSupport.applyToField(FlatStylingSupport.getStyleableField(styleableField), object, object2, true);
            }
            if ((clazz = clazz.getSuperclass()) != null) continue;
            throw new UnknownStyleException(string2);
        } while (predicate == null || !((String)(object3 = clazz.getName())).startsWith("java.") && !((String)object3).startsWith("javax."));
        throw new UnknownStyleException(string2);
    }

    private static Object applyToField(Field field, Object object, Object object2, boolean bl) {
        FlatStylingSupport.checkValidField(field);
        if (bl && object instanceof StyleableLookupProvider) {
            try {
                MethodHandles.Lookup lookup = ((StyleableLookupProvider)object).getLookupForStyling();
                Object object3 = lookup.unreflectGetter(field).invoke(object);
                lookup.unreflectSetter(field).invoke(object, FlatStylingSupport.convertToEnum(object2, field.getType()));
                return object3;
            }
            catch (Throwable throwable) {
                throw FlatStylingSupport.newFieldAccessFailed(field, throwable);
            }
        }
        try {
            field.setAccessible(true);
            Object object4 = field.get(object);
            field.set(object, FlatStylingSupport.convertToEnum(object2, field.getType()));
            return object4;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw FlatStylingSupport.newFieldAccessFailed(field, illegalAccessException);
        }
    }

    private static Object getFieldValue(Field field, Object object, boolean bl) {
        FlatStylingSupport.checkValidField(field);
        if (bl && object instanceof StyleableLookupProvider) {
            try {
                MethodHandles.Lookup lookup = ((StyleableLookupProvider)object).getLookupForStyling();
                return lookup.unreflectGetter(field).invoke(object);
            }
            catch (Throwable throwable) {
                throw FlatStylingSupport.newFieldAccessFailed(field, throwable);
            }
        }
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw FlatStylingSupport.newFieldAccessFailed(field, illegalAccessException);
        }
    }

    private static IllegalArgumentException newFieldAccessFailed(Field field, Throwable throwable) {
        return new IllegalArgumentException("failed to access field '" + field.getDeclaringClass().getName() + "." + field.getName() + "'", throwable);
    }

    private static void checkValidField(Field field) {
        if (!FlatStylingSupport.isValidField(field)) {
            throw new IllegalArgumentException("field '" + field.getDeclaringClass().getName() + "." + field.getName() + "' is final or static");
        }
    }

    private static boolean isValidField(Field field) {
        int n = field.getModifiers();
        return (n & 0x18) == 0 && !field.isSynthetic();
    }

    private static Field getStyleableField(StyleableField styleableField) {
        String string = styleableField.fieldName();
        if (string.isEmpty()) {
            string = styleableField.key();
        }
        try {
            return styleableField.cls().getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException("field '" + styleableField.cls().getName() + "." + string + "' not found", noSuchFieldException);
        }
    }

    private static Object applyToProperty(Object object, String string, Object object2) {
        Class<?> clazz = object.getClass();
        String string2 = FlatStylingSupport.buildMethodName("get", string);
        String string3 = FlatStylingSupport.buildMethodName("set", string);
        try {
            Method method;
            try {
                method = clazz.getMethod(string2, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = clazz.getMethod(FlatStylingSupport.buildMethodName("is", string), new Class[0]);
            }
            Method method2 = clazz.getMethod(string3, method.getReturnType());
            Object object3 = method.invoke(object, new Object[0]);
            method2.invoke(object, FlatStylingSupport.convertToEnum(object2, method.getReturnType()));
            return object3;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new UnknownStyleException(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("failed to invoke property methods '" + clazz.getName() + "." + string2 + "()' or '" + string3 + "(...)'", exception);
        }
    }

    private static String buildMethodName(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        char[] cArray = new char[n + n2];
        string.getChars(0, n, cArray, 0);
        string2.getChars(0, n2, cArray, n);
        cArray[n] = Character.toUpperCase(cArray[n]);
        return new String(cArray);
    }

    private static Object convertToEnum(Object object, Class<?> clazz) {
        if (Enum.class.isAssignableFrom(clazz) && object instanceof String) {
            try {
                object = Enum.valueOf(clazz, (String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("unknown enum value '" + object + "' in enum '" + clazz.getName() + "'", illegalArgumentException);
            }
        }
        return object;
    }

    public static Object applyToAnnotatedObjectOrComponent(Object object, Object object2, String string, Object object3) {
        try {
            return FlatStylingSupport.applyToAnnotatedObject(object, string, object3);
        }
        catch (UnknownStyleException unknownStyleException) {
            try {
                if (object2 != null) {
                    return FlatStylingSupport.applyToProperty(object2, string, object3);
                }
            }
            catch (UnknownStyleException unknownStyleException2) {}
            throw unknownStyleException;
        }
    }

    static Object applyToAnnotatedObjectOrBorder(Object object, String string, Object object2, JComponent jComponent, AtomicBoolean atomicBoolean) {
        try {
            return FlatStylingSupport.applyToAnnotatedObject(object, string, object2);
        }
        catch (UnknownStyleException unknownStyleException) {
            Border border = jComponent.getBorder();
            if (border instanceof StyleableBorder) {
                if (atomicBoolean.get()) {
                    border = FlatStylingSupport.cloneBorder(border);
                    jComponent.setBorder(border);
                    atomicBoolean.set(false);
                }
                try {
                    return ((StyleableBorder)((Object)border)).applyStyleProperty(string, object2);
                }
                catch (UnknownStyleException unknownStyleException2) {}
            }
            try {
                return FlatStylingSupport.applyToProperty(jComponent, string, object2);
            }
            catch (UnknownStyleException unknownStyleException3) {
                throw unknownStyleException;
            }
        }
    }

    static PropertyChangeListener createPropertyChangeListener(JComponent jComponent, Runnable runnable, PropertyChangeListener propertyChangeListener) {
        return propertyChangeEvent -> {
            if (propertyChangeListener != null) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
            switch (propertyChangeEvent.getPropertyName()) {
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    runnable.run();
                    jComponent.revalidate();
                    jComponent.repaint();
                }
            }
        };
    }

    static Border cloneBorder(Border object) {
        object = object.getClass();
        try {
            return (Border)((Class)object).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("failed to clone border '" + ((Class)object).getName() + "'", exception);
        }
    }

    static Icon cloneIcon(Icon object) {
        object = object.getClass();
        try {
            return (Icon)((Class)object).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("failed to clone icon '" + ((Class)object).getName() + "'", exception);
        }
    }

    public static Map<String, Class<?>> getAnnotatedStyleableInfos(Object object) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(object, null);
    }

    public static Map<String, Class<?>> getAnnotatedStyleableInfos(Object object, Border border) {
        StyleableInfosMap styleableInfosMap = new StyleableInfosMap();
        FlatStylingSupport.collectAnnotatedStyleableInfos(object, styleableInfosMap);
        FlatStylingSupport.collectStyleableInfos(border, styleableInfosMap);
        return styleableInfosMap;
    }

    /*
     * WARNING - void declaration
     */
    public static void collectAnnotatedStyleableInfos(Object clazz, Map<String, Class<?>> map) {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        clazz = clazz.getClass();
        do {
            Object object2;
            Object object3;
            for (Field field : clazz.getDeclaredFields()) {
                void var6_10;
                if (!FlatStylingSupport.isValidField(field) || (object3 = field.getAnnotation(Styleable.class)) == null) continue;
                object2 = field.getName();
                Class<?> clazz2 = field.getType();
                if (hashSet.contains(object2)) continue;
                hashSet.add(object2);
                if (object3.dot()) {
                    int n = ((String)object2).length();
                    for (int i = 0; i < n; ++i) {
                        if (!Character.isUpperCase(((String)object2).charAt(i))) continue;
                        object2 = ((String)object2).substring(0, i) + '.' + Character.toLowerCase(((String)object2).charAt(i)) + ((String)object2).substring(i + 1);
                        break;
                    }
                }
                if (object3.type() != Void.class) {
                    Class<?> clazz3 = object3.type();
                }
                map.put((String)object2, (Class<?>)var6_10);
            }
            object = (StyleableField[])clazz.getAnnotationsByType(StyleableField.class);
            int n = ((StyleableField[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object4 = object[i];
                object3 = object4.key();
                if (hashSet.contains(object3)) continue;
                hashSet.add(object3);
                object2 = FlatStylingSupport.getStyleableField((StyleableField)object4);
                map.put((String)object3, ((Field)object2).getType());
            }
            if ((clazz = clazz.getSuperclass()) != null) continue;
            return;
        } while (!((String)(object = clazz.getName())).startsWith("java.") && !((String)object).startsWith("javax."));
    }

    public static void collectStyleableInfos(Border border, Map<String, Class<?>> map) {
        if (border instanceof StyleableBorder) {
            map.putAll(((StyleableBorder)((Object)border)).getStyleableInfos());
        }
    }

    public static void putAllPrefixKey(Map<String, Class<?>> map, String string, Map<String, Class<?>> object) {
        for (Map.Entry entry : object.entrySet()) {
            map.put(string.concat((String)entry.getKey()), (Class)entry.getValue());
        }
    }

    public static Object getAnnotatedStyleableValue(Object object, String string) {
        Object object2;
        String string2 = FlatStylingSupport.keyToFieldName(string);
        Class<?> clazz = object.getClass();
        do {
            try {
                object2 = clazz.getDeclaredField(string2);
                Styleable styleable = ((Field)object2).getAnnotation(Styleable.class);
                if (styleable != null) {
                    if (styleable.dot() != (string2 != string)) {
                        throw new IllegalArgumentException("'Styleable.dot' on field '" + string2 + "' does not match key '" + string + "'");
                    }
                    if (styleable.type() != Void.class) {
                        throw new IllegalArgumentException("'Styleable.type' on field '" + string2 + "' not supported");
                    }
                    return FlatStylingSupport.getFieldValue((Field)object2, object, false);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {}
            object2 = (StyleableField[])clazz.getAnnotationsByType(StyleableField.class);
            int n = ((StyleableField[])object2).length;
            for (int i = 0; i < n; ++i) {
                StyleableField styleableField = object2[i];
                if (!string.equals(styleableField.key())) continue;
                return FlatStylingSupport.getFieldValue(FlatStylingSupport.getStyleableField(styleableField), object, true);
            }
            if ((clazz = clazz.getSuperclass()) != null) continue;
            return null;
        } while (!((String)(object2 = clazz.getName())).startsWith("java.") && !((String)object2).startsWith("javax."));
        return null;
    }

    public static Object getAnnotatedStyleableValue(Object object, Border object2, String string) {
        if (object2 instanceof StyleableBorder && (object2 = ((StyleableBorder)object2).getStyleableValue(string)) != null) {
            return object2;
        }
        return FlatStylingSupport.getAnnotatedStyleableValue(object, string);
    }

    static class StyleableInfosMap<K, V>
    extends LinkedHashMap<K, V> {
        StyleableInfosMap() {
        }

        @Override
        public V put(K k, V v) {
            if ((v = super.put(k, v)) != null) {
                throw new IllegalArgumentException("duplicate key '" + k + "'");
            }
            return v;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> object) {
            for (Map.Entry entry : object.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public static class UnknownStyleException
    extends IllegalArgumentException {
        public UnknownStyleException(String string) {
            super(string);
        }

        @Override
        public String getMessage() {
            return "unknown style '" + super.getMessage() + "'";
        }
    }

    public static interface StyleableLookupProvider {
        public MethodHandles.Lookup getLookupForStyling();
    }

    public static interface StyleableBorder {
        public Object applyStyleProperty(String var1, Object var2);

        public Map<String, Class<?>> getStyleableInfos();

        public Object getStyleableValue(String var1);
    }

    public static interface StyleableUI {
        public Map<String, Class<?>> getStyleableInfos(JComponent var1);

        public Object getStyleableValue(JComponent var1, String var2);
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface StyleableFields {
        public StyleableField[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Repeatable(value=StyleableFields.class)
    public static @interface StyleableField {
        public Class<?> cls();

        public String key();

        public String fieldName() default "";
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Styleable {
        public boolean dot() default false;

        public Class<?> type() default Void.class;
    }
}

