/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatTitlePane;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;

public class FlatToolBarUI
extends BasicToolBarUI
implements FlatStylingSupport.StyleableUI,
FlatTitlePane.TitleBarCaptionHitTest {
    @FlatStylingSupport.Styleable
    protected boolean focusableButtons;
    @FlatStylingSupport.Styleable
    protected boolean arrowKeysOnlyNavigation;
    @FlatStylingSupport.Styleable
    protected int hoverButtonGroupArc;
    @FlatStylingSupport.Styleable
    protected Color hoverButtonGroupBackground;
    @FlatStylingSupport.Styleable
    protected Insets borderMargins;
    @FlatStylingSupport.Styleable
    protected Color gripColor;
    @FlatStylingSupport.Styleable
    protected Integer separatorWidth;
    @FlatStylingSupport.Styleable
    protected Color separatorColor;
    private FocusTraversalPolicy focusTraversalPolicy;
    private Boolean oldFloatable;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatToolBarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installFocusTraversalPolicy();
        this.installStyle();
        if (!this.focusableButtons) {
            this.setButtonsFocusable(false);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        if (!this.focusableButtons) {
            this.setButtonsFocusable(true);
        }
        this.uninstallFocusTraversalPolicy();
        this.oldStyleValues = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.focusableButtons = UIManager.getBoolean("ToolBar.focusableButtons");
        this.arrowKeysOnlyNavigation = UIManager.getBoolean("ToolBar.arrowKeysOnlyNavigation");
        this.hoverButtonGroupArc = UIManager.getInt("ToolBar.hoverButtonGroupArc");
        this.hoverButtonGroupBackground = UIManager.getColor("ToolBar.hoverButtonGroupBackground");
        if (!UIManager.getBoolean("ToolBar.floatable")) {
            this.oldFloatable = this.toolBar.isFloatable();
            this.toolBar.setFloatable(false);
            return;
        }
        this.oldFloatable = null;
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.hoverButtonGroupBackground = null;
        if (this.oldFloatable != null) {
            this.toolBar.setFloatable(this.oldFloatable);
            this.oldFloatable = null;
        }
    }

    @Override
    protected RootPaneContainer createFloatingWindow(JToolBar object) {
        object = super.createFloatingWindow((JToolBar)object);
        object.getRootPane().putClientProperty("Window.style", "small");
        return object;
    }

    @Override
    protected ContainerListener createToolBarContListener() {
        return new BasicToolBarUI.ToolBarContListener(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                super.componentAdded(containerEvent);
                if (!FlatToolBarUI.this.focusableButtons) {
                    FlatToolBarUI.this.setButtonFocusable(containerEvent.getChild(), false);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                super.componentRemoved(containerEvent);
                if (!FlatToolBarUI.this.focusableButtons) {
                    FlatToolBarUI.this.setButtonFocusable(containerEvent.getChild(), true);
                }
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyListener() {
        return FlatStylingSupport.createPropertyChangeListener(this.toolBar, this::installStyle, super.createPropertyListener());
    }

    protected void installStyle() {
        try {
            FlatToolBarUI flatToolBarUI = this;
            flatToolBarUI.applyStyle(FlatStylingSupport.getResolvedStyle(flatToolBarUI.toolBar, "ToolBar"));
            return;
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
            return;
        }
    }

    protected void applyStyle(Object object) {
        boolean bl = this.focusableButtons;
        boolean bl2 = this.arrowKeysOnlyNavigation;
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
        if (this.focusableButtons != bl) {
            FlatToolBarUI flatToolBarUI = this;
            flatToolBarUI.setButtonsFocusable(flatToolBarUI.focusableButtons);
        }
        if (this.arrowKeysOnlyNavigation != bl2 || this.focusableButtons != bl) {
            if (this.arrowKeysOnlyNavigation) {
                this.installFocusTraversalPolicy();
                return;
            }
            this.uninstallFocusTraversalPolicy();
        }
    }

    protected Object applyStyleProperty(String string, Object object) {
        FlatToolBarUI flatToolBarUI = this;
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(flatToolBarUI, flatToolBarUI.toolBar, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    protected void setButtonsFocusable(boolean bl) {
        for (Component component : this.toolBar.getComponents()) {
            this.setButtonFocusable(component, bl);
        }
    }

    private void setButtonFocusable(Component component, boolean bl) {
        if (component instanceof AbstractButton && bl != component.isFocusable()) {
            component.setFocusable(bl);
        }
    }

    protected void installFocusTraversalPolicy() {
        if (!this.arrowKeysOnlyNavigation || !this.focusableButtons || this.toolBar.getFocusTraversalPolicy() != null) {
            return;
        }
        this.focusTraversalPolicy = this.createFocusTraversalPolicy();
        if (this.focusTraversalPolicy != null) {
            this.toolBar.setFocusTraversalPolicy(this.focusTraversalPolicy);
            this.toolBar.setFocusTraversalPolicyProvider(true);
        }
    }

    protected void uninstallFocusTraversalPolicy() {
        if (this.focusTraversalPolicy != null && this.toolBar.getFocusTraversalPolicy() == this.focusTraversalPolicy) {
            this.toolBar.setFocusTraversalPolicy(null);
            this.toolBar.setFocusTraversalPolicyProvider(false);
        }
        this.focusTraversalPolicy = null;
    }

    protected FocusTraversalPolicy createFocusTraversalPolicy() {
        return new FlatToolBarFocusTraversalPolicy();
    }

    @Override
    protected void navigateFocusedComp(int n) {
        block9: {
            Component component;
            int n2 = this.toolBar.getComponentCount();
            if (this.focusedCompIndex < 0 || this.focusedCompIndex >= n2) {
                return;
            }
            switch (n) {
                case 3: 
                case 5: {
                    n = 1;
                    break;
                }
                case 1: 
                case 7: {
                    n = -1;
                    break;
                }
                default: {
                    return;
                }
            }
            int n3 = this.focusedCompIndex;
            do {
                if ((n3 += n) < 0) {
                    n3 = n2 - 1;
                } else if (n3 >= n2) {
                    n3 = 0;
                }
                if (n3 == this.focusedCompIndex) break block9;
            } while (!FlatToolBarUI.canBeFocusOwner(component = this.toolBar.getComponentAtIndex(n3)));
            component.requestFocus();
            return;
        }
    }

    private static boolean canBeFocusOwner(Component serializable) {
        if (!(serializable != null && ((Component)serializable).isEnabled() && ((Component)serializable).isVisible() && ((Component)serializable).isDisplayable() && ((Component)serializable).isFocusable())) {
            return false;
        }
        if (serializable instanceof JComboBox) {
            serializable = (JComboBox)serializable;
            return ((JComboBox)serializable).getUI().isFocusTraversable((JComboBox<?>)serializable);
        }
        if (serializable instanceof JComponent) {
            for (serializable = ((JComponent)serializable).getInputMap(0); serializable != null && ((InputMap)serializable).size() == 0; serializable = ((InputMap)serializable).getParent()) {
            }
            if (serializable == null) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void setBorderToRollover(Component component) {
    }

    @Override
    protected void setBorderToNonRollover(Component component) {
    }

    @Override
    protected void setBorderToNormal(Component component) {
    }

    @Override
    protected void installRolloverBorders(JComponent jComponent) {
    }

    @Override
    protected void installNonRolloverBorders(JComponent jComponent) {
    }

    @Override
    protected void installNormalBorders(JComponent jComponent) {
    }

    @Override
    protected Border createRolloverBorder() {
        return null;
    }

    @Override
    protected Border createNonRolloverBorder() {
        return null;
    }

    @Override
    public void setOrientation(int n) {
        Insets insets;
        Insets insets2;
        if (n != this.toolBar.getOrientation() && !(insets2 = new Insets(insets.left, insets.top, insets.right, insets.bottom)).equals(insets = this.toolBar.getMargin())) {
            this.toolBar.setMargin(insets2);
        }
        super.setOrientation(n);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        this.paintButtonGroup(graphics);
    }

    protected void paintButtonGroup(Graphics graphics) {
        Object[] objectArray;
        boolean bl;
        if (this.hoverButtonGroupBackground == null) {
            return;
        }
        ButtonGroup buttonGroup = null;
        Object object = this.toolBar.getComponents();
        boolean bl2 = ((Component[])object).length;
        for (bl = false; !(bl >= bl2 || (objectArray = object[bl]) instanceof AbstractButton && ((AbstractButton)objectArray).getModel().isRollover() && (buttonGroup = this.getButtonGroup((AbstractButton)objectArray)) != null); bl += 1) {
        }
        if (buttonGroup == null) {
            return;
        }
        object = new ArrayList();
        Object object2 = buttonGroup.getElements();
        while (object2.hasMoreElements()) {
            AbstractButton abstractButton = object2.nextElement();
            if (abstractButton.getParent() != this.toolBar) continue;
            ((ArrayList)object).add(abstractButton.getBounds());
        }
        bl = this.toolBar.getOrientation() == 0;
        ((ArrayList)object).sort((rectangle, rectangle2) -> {
            if (bl) {
                return rectangle.x - rectangle2.x;
            }
            return rectangle.y - rectangle2.y;
        });
        objectArray = FlatUIUtils.setRenderingHints(graphics);
        graphics.setColor(FlatUIUtils.deriveColor(this.hoverButtonGroupBackground, this.toolBar.getBackground()));
        int n = UIScale.scale(10);
        object2 = null;
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            Rectangle rectangle3 = (Rectangle)object.next();
            if (object2 == null) {
                object2 = rectangle3;
                continue;
            }
            if (bl ? ((Rectangle)object2).x + ((Rectangle)object2).width + n >= rectangle3.x : ((Rectangle)object2).y + ((Rectangle)object2).height + n >= rectangle3.y) {
                object2 = ((Rectangle)object2).union(rectangle3);
                continue;
            }
            FlatUIUtils.paintComponentBackground((Graphics2D)graphics, ((Rectangle)object2).x, ((Rectangle)object2).y, ((Rectangle)object2).width, ((Rectangle)object2).height, 0.0f, UIScale.scale(this.hoverButtonGroupArc));
            object2 = rectangle3;
        }
        if (object2 != null) {
            FlatUIUtils.paintComponentBackground((Graphics2D)graphics, ((Rectangle)object2).x, ((Rectangle)object2).y, ((Rectangle)object2).width, ((Rectangle)object2).height, 0.0f, UIScale.scale(this.hoverButtonGroupArc));
        }
        FlatUIUtils.resetRenderingHints(graphics, objectArray);
    }

    protected void repaintButtonGroup(AbstractButton object) {
        if (this.hoverButtonGroupBackground == null) {
            return;
        }
        if ((object = this.getButtonGroup((AbstractButton)object)) == null) {
            return;
        }
        Rectangle rectangle = null;
        object = ((ButtonGroup)object).getElements();
        while (object.hasMoreElements()) {
            AbstractButton abstractButton = (AbstractButton)object.nextElement();
            Container container = abstractButton.getParent();
            if (container != this.toolBar) continue;
            rectangle = rectangle != null ? rectangle.union(abstractButton.getBounds()) : abstractButton.getBounds();
        }
        if (rectangle != null) {
            this.toolBar.repaint(rectangle);
        }
    }

    private ButtonGroup getButtonGroup(AbstractButton itemSelectable) {
        if ((itemSelectable = itemSelectable.getModel()) instanceof DefaultButtonModel) {
            return ((DefaultButtonModel)itemSelectable).getGroup();
        }
        return null;
    }

    @Override
    public Boolean isTitleBarCaptionAt(int n, int n2) {
        return null;
    }

    protected class FlatToolBarFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        protected FlatToolBarFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            if (!(component instanceof AbstractButton)) {
                return super.getComponentAfter(container, component);
            }
            while ((component = super.getComponentAfter(container, component)) != null) {
                if (component instanceof AbstractButton) continue;
                return component;
            }
            return null;
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            if (!(component instanceof AbstractButton)) {
                return super.getComponentBefore(container, component);
            }
            while ((component = super.getComponentBefore(container, component)) != null) {
                if (component instanceof AbstractButton) continue;
                return component;
            }
            return null;
        }

        @Override
        public Component getFirstComponent(Container container) {
            return this.getRecentComponent(container, true);
        }

        @Override
        public Component getLastComponent(Container container) {
            return this.getRecentComponent(container, false);
        }

        private Component getRecentComponent(Container container, boolean bl) {
            if (FlatToolBarUI.this.focusedCompIndex >= 0 && FlatToolBarUI.this.focusedCompIndex < FlatToolBarUI.this.toolBar.getComponentCount()) {
                return FlatToolBarUI.this.toolBar.getComponent(FlatToolBarUI.this.focusedCompIndex);
            }
            if (bl) {
                return super.getFirstComponent(container);
            }
            return super.getLastComponent(container);
        }
    }
}

