/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.Zstd;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public final class ZstdDecoder
extends ByteToMessageDecoder {
    private final MutableByteBufInputStream inputStream;
    private ZstdInputStreamNoFinalizer zstdIs;
    private State currentState;

    public ZstdDecoder() {
        try {
            Zstd.ensureAvailability();
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(throwable);
        }
        this.inputStream = new MutableByteBufInputStream();
        this.currentState = State.DECOMPRESS_DATA;
    }

    @Override
    protected final void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            if (this.currentState == State.CORRUPTED) {
                ByteBuf byteBuf2 = byteBuf;
                byteBuf2.skipBytes(byteBuf2.readableBytes());
                return;
            }
            int n = byteBuf.readableBytes();
            this.inputStream.current = byteBuf;
            byteBuf = null;
            try {
                int n2;
                do {
                    if (byteBuf == null) {
                        byteBuf = channelHandlerContext.alloc().heapBuffer(n << 1);
                    }
                    while ((n2 = byteBuf.writeBytes((InputStream)this.zstdIs, byteBuf.writableBytes())) != -1 && byteBuf.isWritable()) {
                    }
                    if (!byteBuf.isReadable()) continue;
                    list.add(byteBuf);
                    byteBuf = null;
                } while (n2 != -1);
            }
            finally {
                if (byteBuf != null) {
                    byteBuf.release();
                }
            }
            return;
        }
        catch (Exception exception) {
            this.currentState = State.CORRUPTED;
            throw new DecompressionException(exception);
        }
        finally {
            this.inputStream.current = null;
        }
    }

    public final void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        super.handlerAdded(channelHandlerContext);
        this.zstdIs = new ZstdInputStreamNoFinalizer((InputStream)this.inputStream);
        this.zstdIs.setContinuous(true);
    }

    @Override
    protected final void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        try {
            ZstdDecoder.closeSilently((Closeable)this.zstdIs);
            return;
        }
        finally {
            super.handlerRemoved0(channelHandlerContext);
        }
    }

    private static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    private static final class MutableByteBufInputStream
    extends InputStream {
        ByteBuf current;

        private MutableByteBufInputStream() {
        }

        @Override
        public final int read() {
            if (this.current == null || !this.current.isReadable()) {
                return -1;
            }
            return this.current.readByte() & 0xFF;
        }

        @Override
        public final int read(byte[] byArray, int n, int n2) {
            int n3 = this.available();
            if (n3 == 0) {
                return -1;
            }
            n2 = Math.min(n3, n2);
            this.current.readBytes(byArray, n, n2);
            return n2;
        }

        @Override
        public final int available() {
            if (this.current == null) {
                return 0;
            }
            return this.current.readableBytes();
        }
    }

    private static enum State {
        DECOMPRESS_DATA,
        CORRUPTED;

    }
}

